<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require  APPPATH . '/libraries/ElearningForma2PlusController.php';
require  APPPATH. '/libraries/ExportData.php';


/**
 * Class : Documentsign
 * Documentsign Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 14 Jully 2020
 */
class Documentsign extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('documentsign_model');
        $this->load->model('membres_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Document sign'; 

        $data['results'] = $this->documentsign_model->getDocsByAdmin();
        $this->loadViews("admin/documentsign/list", $this->global, $data , NULL);
    } 

    public function del($idDoc){
        if (isset($idDoc) && $idDoc != NULL) {
            $infoDocs = $this->documentsign_model->getDocToSignById($idDoc)->result();
            foreach ($infoDocs as $res) {
                if (is_file(RP_GROUPES."GRP".$res->groupe."/documentsign/".$res->fichier)) {
                    unlink(RP_GROUPES."GRP".$res->groupe."/documentsign/".$res->fichier);
                }
            }
            $this->documentsign_model->delete($idDoc);
            $this->index();
        }
    }

    public function sendmailsms($idDoc){
        if (isset($_POST) && $_POST['envoi_mail'] != '') {
            # code...
        }
        else{
            $this->formSendMailSms($idDoc);
        }
    }
    public function formSendMailSms($idDoc){

    }

}

?>