<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require  APPPATH . '/libraries/ElearningForma2PlusController.php';
require  APPPATH. '/libraries/ExportData.php';


/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 re
 * @version : 1.1
 * @since : 22 November 2018
 */
class ExpressionDatabank extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('databankExpression_Model');
        $this->load->model('membres_model');
        $this->load->library('pagination'); 
        $this->isLoggedIn();   
        $this->form_validation->set_error_delimiters($this->config->item('error_prefix'), $this->config->item('error_suffix'));
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Forma2+'; 
        $data['expressions'] = $this->databankExpression_Model->readExpressionAdmin();
        $data['langage'] = $this->databankExpression_Model->getListLangage();
        $data['membres'] = $this->membres_model->filtrer('', $type=ADMIN, $statut = '2');
        $data['environnement_usage'] = array();
        $categories_params = "/prototypes/themes";
        $categories_environnementUsage = "/prototypes/environnement-usage";
        $list_categories = $this->httpRequest($categories_params);
        $list_environnement_usage = $this->httpRequest($categories_environnementUsage);
        if(!empty($list_categories['data_exec'])){
            $data['category'] = json_decode($list_categories['data_exec']);
        }
        if(!empty($list_environnement_usage['data_exec'])){
            $data['environnement_usage'] = json_decode($list_environnement_usage['data_exec']);
        }

        $this->loadViews("admin/databank/list", $this->global, $data , NULL);
    }  

    public function export(){
        if($_POST['json']){
            $data = json_decode($_POST['json']);             
            
            $exporter = new ExportDataExcel('browser', 'Export_expression.xls');
            $exporter->initialize();
            $exporter->addRow(array("Owner", "Origin", "Langage cible", "Cible", "Creation date")); 
           foreach($data as $keys => $value){
                $rows[$keys] = $value;

                foreach($rows as $key => $val){
                    $row[$key][0] = $val[0];
                    $row[$key][1] = $val[1];
                    $row[$key][2] = $val[2];
                    $row[$key][3] = $val[3];
                    $row[$key][4] = $val[6];
                }
                $exporter->addRow($row[$keys]);
            }
            $exporter->finalize() ;
        } 
    }

    public function delete(){
        if (isset($_POST['id'])) {
            $id   =  $_POST['id'];
            $this->databankExpression_Model->deleteExpression($id);
            echo $id;
        }
        
    }

    public function add()
    {
        if (isset($_POST)) {
            $idTraineer = NULL;
            if($this->isTuteurConnet()){
                $idTraineer = $this->session->userdata('GUSERID');
            }
            $additional_data = array(
                'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible'],
                'date_creation'                   => date("Y-m-d H:i:s"),
                'user_create'                     => $this->session->userdata('GUSERID'),
                'id_tuteur'                       => isset($idTraineer) ? $this->session->userdata('GUSERID') : NULL,
            );


            $this->databankExpression_Model->addExpression($additional_data);
            echo "OK";
        }


    }

    public function validate(){
        if (isset($_POST)) {
            $additional_data = array(
                'producer_validation'             => $this->session->userdata ('GUSERID'),
                'valide'                          => 1,
                'date_validation'                 => time()
            );
            $this->databankExpression_Model->editExpression($_POST['id'],$additional_data);
            $ret = array(
                'producteur' => $this->membres_model->Request('prenom',$this->session->userdata ('GUSERID')).' '.$this->membres_model->Request('nom',$this->session->userdata ('GUSERID')),
                'date_validation' => date('Y-m-d'),
                'status' => 'Yes',
            );
            echo json_encode($ret);
        }
    }

    public function edit()
    {
        if (isset($_POST)) {
            $idCat = '';
            /*verifions l'existance du theme si c'est uyn theme bddl*/
            if (isset($_POST['exist_theme']) && $_POST['exist_theme'] == "exist") {
                $idCat = $_POST['id_theme'];            
            }
            elseif (isset($_POST['exist_theme']) && $_POST['exist_theme'] == "verif") {
                
                $theme_exist = $this->databankExpression_Model->getExistCatByIntituleAndGroup($_POST['intitle_theme'],$this->membres_model->Request('id_groupe',$_POST['dataExpression']['owner_expression']));
                
                if ($theme_exist >= 1) {
                    $idCat = $_POST['id_theme'];    
                }
                else{
                    $dataCat = array (
                        'intitule' => $_POST['intitle_theme'],
                        'id_groupe' => $this->membres_model->Request('id_groupe',$_POST['dataExpression']['owner_expression']),
                        'description' => ''
                    );

                    $idCat = $this->databankExpression_Model->addCategory($dataCat);
                }
            }
            else{
                $idCat = $_POST['id_theme'];
            }


            $additional_data = array(
                'id_category'                     => $idCat,
                'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible'],
                'environnement_usage'             => $_POST['dataExpression']['environnement_usage'],
                'producer_validation'             => $_POST['dataExpression']['producer_validation']
            );
            $this->databankExpression_Model->editExpression($_POST['dataExpression']['idExpression'],$additional_data);
            echo '##'.$idCat.'##'.utf8_encode($this->databankExpression_Model->RequestCat('intitule',$idCat));
        }
    }

    public function httpRequest($params)
    {
        $bddlUrl = get_instance()->config->item('bddl_api').$params;

           $response['request'] = $bddlUrl;

        $ch = curl_init($bddlUrl);
        if (! $ch) {
            die( "Cannot allocate a new PHP-CURL handle" );
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response['data_exec'] = curl_exec($ch);
        $response['data_error'] = curl_error($ch);
        curl_close($ch);

        return $response;
    }

    public function getCatExpression(){
        if (isset($_POST['id'])) {
            $OPTION = '<option>Select theme</option>';
            $id_groupe = $this->membres_model->Request('id_groupe',$this->databankExpression_Model->Request('id_stagiaire',$_POST['id']));
            $allCat = $this->databankExpression_Model->getCategoryByIdGroup($id_groupe);
            foreach ($allCat as $c) {
                if ($c->intitule != '') {
                    if ($c->id == $_POST['theme_cuurent']) {
                        $OPTION .= '<option selected="selected" value="'.$c->id.'">'.$c->intitule.'</option>';
                    }
                    else{
                        $OPTION .= '<option value="'.$c->id.'">'.$c->intitule.'</option>';
                    }
                }
            }
            echo $OPTION;
        }
    }

}

?>