<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Groupes extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('niveau_model');
        $this->load->model('societe_model');
        $this->load->model('groupes_model');
        $this->load->model('admin_model');
        $this->load->model('sessions_model');
        $this->load->model('bddl_model');
        $this->isLoggedIn();   
    }
     
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Groups members';
        $this->load->library('pagination');
        $searchText = $this->input->post('searchText');
        $data['searchText'] = $searchText;  
        if (isset($_GET['idmembres'])) {
           $data['traineeGroupes'] = $this->makeArray($this->groupes_model->readGroupStagiaire($_GET['idmembres']));  
        }

        $count = $this->groupes_model->readCountfiltrer($searchText);
        $returns = $this->paginationCompress ("listesGroupes/", $count, 18 );
        
        $data['groupes'] = $this->groupes_model->filtrer($searchText,$returns["page"], $returns["segment"]);  
  
        $this->loadViews("admin/groupe/liste",$this->global, $data, NULL);
    } 

    public function list()
    {
        $this->global['pageTitle'] = 'E-learning : Groups members';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('code', 'Code', '');
        $this->form_validation->set_rules('directory', 'Create a directory', '');
        $this->form_validation->set_rules('glossary', 'Glossary online', '');
        if($this->form_validation->run() == TRUE){
            $code = '';
            $idGroupe = $this->groupes_model->getMaxIdGroupes() + 1;
            if ( trim($this->input->post('code')) == '' ) {
                $code = 'G'.($idGroupe < 10 ? '0'.$idGroupe : $idGroupe) ;
            }
            $data = array(
                'id_groupe' => $idGroupe,
                'name' => $this->input->post('name'),
                'code' => $code,
                'id_tuteur' => 0,
                'repertoire' => 'GRP'.$idGroupe,
                'glossaireenligne' => $this->input->post('glossary'),
                'date_modif' => time(),
            );
            $this->groupes_model->addlistgrp($data);
            if ($this->input->post('directory')) {
                // code...
            }
        }
        $this->load->library('pagination');
        $searchText = $this->input->post('searchText');
        $data['searchText'] = $searchText;  
        if (isset($_GET['idmembres'])) {
           $data['traineeGroupes'] = $this->makeArray($this->groupes_model->readGroupStagiaire($_GET['idmembres']));  
        }

        $count = $this->groupes_model->readCountfiltrer($searchText);
        $returns = $this->paginationCompress ("managegroups/", $count, 18 );        
        $data['groupes'] = $this->groupes_model->filtrer($searchText,$returns["page"], $returns["segment"]);  
  
        $this->loadViews("admin/groupe/list",$this->global, $data, NULL);
    }

    public function removegroup(){
        if (isset($_GET['idmembres']) && $_GET['usertype'] == 0) {
            $data = array(
                'id_groupe' => NULL
                );
            $this->membres_model->update($_GET['idmembres'],$data);
            $this->admin_model->supprimerStagiaireGroupe($_GET['idmembres'], $_GET['idgroupes']);
            
        }
        else{ // supprimer un groupe dans le portefeuille d'un prof
            $this->admin_model->supprimerStagiairePortefeuille($_GET['idmembres'], $_GET['idgroupes']);
        }

        if (isset($_GET['ret']) && $_GET['ret'] == 'edit') {
            redirect('editmembers?id='.$_GET['idmembres'].'&type=0', 'refresh');
        }
        else{
            redirect('listesGroupes?idmembres='.$_GET['idmembres'], 'refresh');
        }

    }

    public function remove(){
        if (isset($_GET['idmembres'])) {
            $data = array(
                'id_groupe' => NULL
                );
            $this->membres_model->update($_GET['idmembres'],$data);
            
        }
        if (isset($_GET['idgroupes'])) {
            $data = array(
                'id_groupe' => $_GET['idgroupes']
            );
            $this->admin_model->supprimerStagiaireGroupe($_GET['idmembres'], $_GET['idgroupes']);
        }
        if (isset($_GET['ret']) && $_GET['ret'] == 'edit') {
            redirect('editmembers?id='.$_GET['idmembres'].'&type=0', 'refresh');
        }
        else{
            redirect('listesGroupes?idmembres='.$_GET['idmembres'], 'refresh');
        }

    }

    public function addtutor(){
        if (isset($_GET['id_groupes'])) {
            $this->membres_model->addUserCreate($_GET['id_groupes'],$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif($_GET['id_groupes'],$this->session->userdata ('GUSERID'));

            $this->admin_model->ajouterTuteurGroupe($_GET['tutorid'],$_GET['id_groupes']);
            redirect('tutorlist?id_groupes='.$_GET['id_groupes'], 'refresh');
        }
    }
    public function tutorlist(){
        if (isset($_GET['id_groupes'])) {
            $this->global['pageTitle']    = 'E-learning : Edition Groups';
            $this->load->library('pagination');
            $data['searchText'] = $this->input->post('searchText');
            $data['id_groupes']   = $_GET['id_groupes'];   
            $data['tutorInGroup'] = $this->makeArray($this->membres_model->GetTuteur($_GET['id_groupes']));    
            $data['tutorResults'] = $this->membres_model->adminFilter(TUTEUR,2,$data['searchText']); 
            $this->loadViews("admin/members/tutorlist",$this->global, $data, NULL);
        }
    }

    public function removetutor(){
        if (isset($_GET['id_groupes'])) {
            $this->groupes_model->delTuteur($_GET['id_groupes'],$_GET['id_tuteur']);
            if (isset($_GET['fenetre']) && $_GET['fenetre'] == 'popup') {
                redirect('tutorlist?id_groupes='.$_GET['id_groupes'], 'refresh');
            }
            else{
                redirect('editgroupes?id='.$_GET['id_groupes'], 'refresh');
            }
        }
    }
    public function edit(){
        if((isset($_POST['prototype']) || isset($_POST['glossaire_en_ligne']) || isset($_POST['creation_pad'])) && isset($_POST['id_groupes'])){
            //$glossaire_en_ligne = $_POST['glossaire_en_ligne'];
            //$creation_pad       = $_POST['creation_pad'];
            $prototype          = isset($_POST['prototype']) ? implode(',', $_POST['prototype']) : null;
            $date   = getdate() ;
            $date   = $date["0"];
            $data = array(
                'prototype'  => $prototype,
                'date_modif' => $date
            );
            $dataL = array(
                'glossaireenligne'  => $_POST['glossaire_en_ligne'] == 'on' ? 1 : 0,
                'date_modif' => $date
            );
            $this->groupes_model->updatelistgrp($_POST['id_groupes'],$dataL); 
            $this->groupes_model->updategrp($_POST['id_groupes'],$data); 
            $this->membres_model->addUserCreate($_POST['id_groupes'],$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif($_POST['id_groupes'],$this->session->userdata ('GUSERID'));

            redirect('editgroupes?id='.$_POST['id_groupes'], 'refresh');
        }

        if (isset($_GET['id'])) {
            $this->global['pageTitle']   = 'E-learning : Edition Groups';
            $del                         = base_url().'delete-session-groupe?action=del_item&id='.$_GET['id'];
            $data['groupes']             = $this->groupes_model->readGroupe($_GET['id']);  
            $data['glossaireenligne']    = $this->groupes_model->checkGlossaireEnligne($_GET['id']);  
            $formationResult             = $this->formations_model->read($_GET['id'],$this->groupes_model->RequestByGrpLimit1('id_membres',$_GET['id']));  
            

            $data['sessionsGroupesAdmin'] = $this->ListSessionGroupeAdminDelV3($formationResult, $del,0,'',$_GET['id']); 
            //$data['atelier_thematique'] = $this->groupes_model->Atelier($_GET['id']); 
            $data['atelier_thematique']   = ''; 
            $data['allprototype']         = $this->bddl_model->getAllPrototypeAcess(); 
            $data['prototypebygroup']     = $this->groupes_model->readPrototypeGroupe($_GET['id']); 
            $data['stagiaires']           = $this->groupes_model->Members($_GET['id']); 
            $data['tuteurs']              = $this->membres_model->GetTuteur($_GET['id']); 
            $data['groupeId']             = $_GET['id']; 
            $this->loadViews("admin/groupe/edit",$this->global, $data, NULL);
        }
    }

    public function deleteSession(){
        if (isset($_GET['id'])) {
            $this->admin_model->supprimerItemFormation(
                    $this->groupes_model->RequestByGrp('id_membres',$_GET['id']),
                    $_GET['sequence_id'],
                    $_GET['locs'],
                    $_GET['module_id'],
                    $_GET['locm'],
                    $_GET['parcours_id'],
                    $_GET['locp'],
                    $_GET['id']
                ); 
            redirect('editgroupes?id='.$_GET['id'], 'refresh');
        }
    }

    public function updategrpmembers(){
        if (isset($_GET['idgroupes'])) {
            $this->admin_model->ajouterStagiaireGroupe($_GET['idmembres'], $_GET['idgroupes']);
            $this->membres_model->addUserCreate($_GET['idmembres'],$this->session->userdata ('GUSERID'));
            $this->membres_model->addUserModif($_GET['idmembres'],$this->session->userdata ('GUSERID'));
        }
        redirect('listesGroupes?idmembres='.$_GET['idmembres'], 'refresh');
    }
   
}

?>