<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
require APPPATH . '/core/File.php';

/**
 * Class : Download
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Donwload extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->load->model('content_corporate_library_soc_model');         
        global $max_caracteres;
        global $rep;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Download manager';        
  
    }

    public function download($action,$id){
        switch ($action) {
            /*case 'planning' :
                $dir = $ClsGroupe->Directory($idg);
              
                $file = RP_GROUPES.$dir.'/'.$ClsGroupe->Planning($idg) ;
                $nom = ExtractFileName($file);
                break;
            case 'webmail_inbox'  :
            case 'webmail_outbox'  :
                $cmd = (ACTION == 'webmail_inbox')?CMD_WM_INBOX:CMD_WM_OUTBOX;
                $ret = $ClsWebMail->ReadMessage(ID,$cmd);
                $dir = $ClsGroupe->Directory($ret['groupe']);
                $file = RP_GROUPES.$dir.'/messages/'.$ret['fichier'] ;
                 $nom = ExtractFileName($file);
                break;*/
            case 'document' :
                $ret = $this->document_model->Read($id);
                if ($ret['groupe'] != 0) {
                    $dir = $this->groupes_model->getRepertoireGrp($ret['groupe']);
                    foreach ($dir as $directory) {
                        $file = RP_GROUPES.$directory->repertoire.'/'.$ret['file'] ;
                        $clsFile = new File();
                        $nom = $clsFile->ExtractFileName($file);
                        $flag = $clsFile->ext_autorise($nom);
                    }
                }
                else{
                    $dir = 'GRP'.$ret['prop'];
                    $file = RP_GROUPES.$dir.'/'.$ret['file'] ;
                    $clsFile = new File();
                    $nom = $clsFile->ExtractFileName($file);
                    $flag = $clsFile->ext_autorise($nom);
                }
                
                break;
            case 'docstosign' :
                $ret = $this->documentsign_model->Read($id);
                $dir = $this->groupes_model->getRepertoireGrp($ret['groupe']);
                foreach ($dir as $directory) {
                    $file = RP_GROUPES.$directory->repertoire.'/'.$ret['file'] ;
                    $file = RP_GROUPES.$directory->repertoire.'/doctosign/'.$ret['file'];
                    //$file = RP_GROUPES.$dir.'/doctosign/sg'.$ret['prop'].'/signed_'.htmlspecialchars($ret['file']) ;
                    $clsFile = new File();
                    $nom = $clsFile->ExtractFileName($file);
                    $flag = $clsFile->ext_autorise($nom);
                }                
                break;
            case 'library' :
                $ret = $this->todolist_model->ReadDataLibrary($id);
                $file=  RP_GROUPES."GRPT".$ret['user_create'].'/documentTodo/'.$ret['file'];
                $clsFile = new File();
                $nom = $clsFile->ExtractFileName($file);
                $flag = $clsFile->ext_autorise($nom);                
                break;
            case 'librarysoc' :
                $ret = $this->content_corporate_library_soc_model->getById($id);
                $file=  RP_SOCIETE."SOCIETE".$this->session->userdata ('IDSOCIETE').'/'.$ret['file'];
                $clsFile = new File();
                $nom = $clsFile->ExtractFileName($file);
                $flag = $clsFile->ext_autorise($nom);                
                break;
            case 'communityLibraryForma2plus' :
                $ret = $this->Content_community_library_forma2plus_model->getById($id);
                $file=  RP_GROUPES."GRPCOMMUNITYF2PLUS/".$ret[0]->link;
                $clsFile = new File();
                $nom = $clsFile->ExtractFileName($file);
                $flag = $clsFile->ext_autorise($nom);                
                break;
            /*case 'todoList' :
                $ret = $ClsDocument->ReadNewSeq(ID);    
                //die($ret['groupe']);      
                $dir = $ClsGroupe->Directory($ret['groupe']);
                $file = RP_GROUPES.$dir.'/'.$ret['file'] ;
                //die($file);
                $nom = ExtractFileName($file);
                break;*/
            default :
                die("Erreur ! ");
                break;
        }

        if ($flag===false) {
            switch(strrchr(basename($nom), ".")) {
            case ".gz": $type = "application/x-gzip"; break;
            case ".tgz": $type = "application/x-gzip"; break;
            case ".zip": $type = "application/zip"; break;
            case ".pdf": $type = "application/pdf"; break;
            case ".png": $type = "image/png"; break;
            case ".gif": $type = "image/gif"; break;
            case ".jpg": $type = "image/jpeg"; break;
            case ".txt": $type = "text/plain"; break;
            case ".htm": $type = "text/html"; break;
            case ".html": $type = "text/html"; break;
            default: $type = "application/octet-stream"; break;
            }

            header("Content-disposition: attachment; filename=$nom");
            header("Content-Type: application/force-download");
            header("Content-Transfer-Encoding: $type\n"); // Surtout ne pas enlever le \n
            header("Content-Length: ".filesize($file));
            header("Pragma: no-cache");
            header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0, public");
            header("Expires: 0");
            readfile($file) or die("Le fichier spécifié est introuvable.");
            exit;
        } 
        else {
            // flag vaut true, le fichier est "valide", c'est donc le serveur web qui va décider de
            // télécharger (ou non) le fichier
            $http = str_replace(RP_MAIN, HTTP_MAIN, $file);
            header("Pragma: no-cache");
            header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
            header("Expires: 0");            
            header("Location: ".$http."");

            exit;
        }
    }

   

}

?>