<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Module extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('matieres_model');        
        $this->load->model('sessions_model');
        $this->load->model('formations_model');
        $this->load->model('domaines_model');
        $this->load->model('admin_model');
        $this->isLoggedIn();   
        
    }
  
    public function index(){
    }

    public function listByAjax(){
        $id_ref = -1 ;
        $HTML = '';
        if (isset($_POST['idDomaine'])) {
            $moduleArray = $this->modules_model->readByDomaineAjax(0);       
            $HTML .= '<input type="hidden" class="totalSeq" value="'.$moduleArray['cnt'].'">';
            $HTML .= '<li><span>None</span><ul class="materialmenu">';
            for ($i=0; $i < $moduleArray['cnt']; $i++) { 
                $actionItemsModules = '';
                if ($this->formations_model->ItemIsValid($moduleArray[$i]['id'],-1,TYPE_MODULE,$this->session->userdata ('STAGIAIREGRP'),1) >= 1)  {
                    $HTML .= '<li class="sequence-link" '.$actionItemsModules.'><span class="moduleName">'.htmlentities($moduleArray[$i]['titre']).'</span>';
                }
                else{
                    $HTML .= '<li class="sequence-link"><span class="moduleName"><a class="btn-add-module-items-session" onclick="addModuleItemSession(this,'.$moduleArray[$i]['id'].');"><i class="glyphicon glyphicon-plus-sign glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;</a>'.htmlentities($moduleArray[$i]['titre']).'</span>';
                }
                $HTML .= '</li>';
            }
            $HTML .= '</ul></li>';
        }

        $domaineArray = $this->domaines_model->read(-1);
        for ($y=0; $y < $domaineArray['cnt']; $y++) { 
            $moduleArray = $this->modules_model->readByDomaineAjax($domaineArray[$y]['id']); 
            $HTML .= '<li><span>'.$domaineArray[$y]['name'].'</span><ul class="materialmenu">';
            for ($ii=0; $ii < $moduleArray['cnt']; $ii++) { 
                $name_mat = $this->matieres_model->read($moduleArray[$ii]['matiere_id']) ;

                if ($moduleArray[$ii]['matiere_id'] != $id_ref ) {

                    $name = $moduleArray[$ii]['matiere_id']==0?'Anone':$name_mat['name'];
                    $id_ref = $moduleArray[$ii]['matiere_id'] ;
                    $HTML .= '<li class="sequence-link openmodule"><span class="moduleName"><a class=" btn-open-parcours" onclick="openModulesInMatiere(this,'.$moduleArray[$ii]['matiere_id'].');"><i class="glyphicon glyphicon-eye-open glyphicon-open-module"></i>&nbsp;&nbsp;</a>'.htmlentities($name).'</span>';

                    /*$HTML .= '<ul class="materialmenu">';
                    $mods = $this->modules_model->getByDomaineMatiere($domaineArray[$y]['id'],$moduleArray[$ii]['matiere_id']);                   

                    for ($y=0; $y < $mods['cnt']; $y++) {
                        $HTML .= '<li class="sequence-link><span class="moduleName">'.htmlentities($mods[$y]['titre']).'</span>';
                        $HTML .= '</li>';
                    }
                    $HTML .= '</ul>';*/

                    $HTML .= '</li>';
                }
            }

            $HTML .= '</ul></li>';
        }
        echo $HTML;
    }

    public function getListByMatiere(){
        $HTML = '<ul>';
        if (isset($_POST['idMatiere'])) {
            $arrayList = $this->modules_model->getByIdMariere($_POST['idMatiere']);
            foreach ($arrayList as $mod) {
                if ($this->formations_model->ItemIsValid($mod->module_id,-1,TYPE_MODULE,$this->session->userdata ('STAGIAIREGRP'),1) >= 1)  {
                    $HTML .='<li class="branch" style=""><span class="moduleName">'.htmlentities($mod->module_titre).'</span></li>';
                }
                else{
                    $HTML .='<li class="branch" style=""><a class="btn-add-module-items-session" onclick="addModuleItemSession(this,'.$mod->module_id.');"><i class="glyphicon glyphicon-plus-sign glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;</a><span class="moduleName">'.htmlentities($mod->module_titre).'</span></li>';
                }
            }
        }
        $HTML .= '</ul>';
        echo $HTML;
    }

    public function addItemsFormation(){
        if (isset($_POST['idModule']) && $this->isTuteurConnet()) {
            echo $this->admin_model->ajouterModuleFormation($this->session->userdata ('STAGIAIREID'),0,1,$_POST['idModule'],1,0,1,$this->session->userdata ('STAGIAIREGRP'));
        }
        else{
            echo $this->admin_model->ajouterModuleFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupeId']),0,1,$_POST['idModule'],1,0,1,$_POST['groupeId']);
        }
    }

    public function delItemsFormation(){
        if (isset($_POST['module_id'])) {
           echo $this->admin_model->supprimerItemFormation(-1,-1,1,$_POST['module_id'],1,$_POST['parcours_id'],1,$_POST['groupe_id']);
        }
    }

}

?>