<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Picture
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 13 Feborary 2024
 */
class Picture extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();  
        $this->load->model('Picture_model');
        $this->tracking_type = 253;  
    }

    public function index(){   
        $this->global['pageTitle']           = 'E-learning : '.$this->lang->line('training_my_audio');
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $idStagiaire                         = '';
        $idGroupe                            = '';
        $view                                = '';

        if($this->isTuteurConnet()){
            $idStagiaire                     = $this->session->userdata('STAGIAIREID');
            $idGroupe                        = $this->session->userdata('STAGIAIREGRP');
            $this->global['groupe']          = $idGroupe;
            $view                            = 'tutor/picture/list';
        }   
        else{
            $idStagiaire                     = $this->session->userdata('GUSERID');
            $idGroupe                        = $this->session->userdata('GROUPE');
            $view                            = 'trainee/picture/list';
        }

        if (isset($_GET['file'])) {
            $data['currentFileResults']      = $this->Picture_model->getById($_GET['file']);
            $current_month                   = isset($data['currentFileResults'][0]->creation_date) ? $data['currentFileResults'][0]->creation_date : '';
            if (isset($current_month) && $current_month != '') {
                $data['current_month'] = $current_month;
                $data['currentDistinctDateCreateFileResults'] = $this->Picture_model->getAllDistinctByDateCreateAndTraineeFileDifferent($_GET['file'],$data['currentFileResults'][0]->creation_date, $idStagiaire);
            }
            
        }
        //var_dump($data);
        //die();

        $data['allResults']                  = $this->Picture_model->getAllByTrainee($idStagiaire);
        $data['allResutlDistinctDateCreate'] = $this->Picture_model->getAllDistinctDateCreate($idStagiaire);
        $data['allResutlDistinctCategory']   = $this->Picture_model->getAllDistinctCategory($idStagiaire);
        $data['idStagiaire']                 = $idStagiaire;
        $data['idGroupe']                    = $idGroupe;
        $this->loadViews($view, $this->global,$data, NULL);
    }

}

?>