<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Dashbord extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn(); 
        $this->tracking_type = 18;  
        $this->load->library('user_agent');  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('dashboard');
        $this->global['groupe'] = $this->session->userdata ('GROUPE'); 
        $data['mobileDetect'] = $this->agent->is_mobile();
        $data['notoficationsResult'] = $this->Notification_model->getByGroupe($this->session->userdata ('GROUPE'));
        $monthMaxResult = $this->newsletter_model->getActualMonth();
        $data['maxMonthId'] = $monthMaxResult[0]->id;
        $data['maxMonthCeateDate'] = date('d-m-Y',strtotime($monthMaxResult[0]->created));
        $data['nlRequestNotif'] = $this->Notification_model->getMaxDataByCriteria('newsletter',$this->session->userdata('GROUPE'));
        $data['nbConnexion'] = $this->membres_model->Request('nbconnexion',$this->session->userdata ('GUSERID'));

        $dataLastActivity = array(
            'last_activity' => $this->lang->line('dashboard')
        );
        $this->updateLastActivity($dataLastActivity);
        
        $this->loadViews("trainee/dashboard", $this->global, $data , NULL);
    }


    public function getStatCnx(){
        $statcnx   = $this->stat_model->elearningF2plusStat($this->session->userdata ('GUSERID'));
        /*$dataStat['totaltime']                           = $statcnx['totaltime'];
        $dataStat['totalTimeConnexion']                  = $statcnx['totalTimeConnexion'];
        $dataStat['totalTimeConnexionBefore']            = $statcnx['totalTimeConnexionBefore'];
        $dataStat['totalTimeConnexionYear']              = $statcnx['totalTimeConnexionYear']; */ 

        echo "##".$statcnx['totaltime']."##".$statcnx['totalTimeConnexion']."##".$statcnx['totalTimeConnexionBefore']."##".$statcnx['totalTimeConnexionYear'];
    }

    
    

    function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
}

?>