<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Newsletter extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        //$this->isLoggedIn();   
        $this->load->helper('url');
        $this->load->library('pagination');
        $this->load->model('Newsletter_nl_themes');
        $this->load->model('Newsletter_nl_articles_nl_themes');
        
        $this->tracking_type = 6; 
        $this->sequence_id_default=10086;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        if (isset($_GET['id'])) {
            $data['articleResult']          = $this->newsletter_model->getArticle($_GET['id']);
            $data['termeResult']            = $this->newsletter_model->getTerme($_GET['id']);
            $data['themeResutlt']           = $this->Newsletter_nl_articles_nl_themes->getAllByArticle($_GET['id']);
            $data['themesResutlts']         = $this->Newsletter_nl_themes->getAllByArticle($_GET['id']);

        }

        $allResultCategory = $this->Newsletter_nl_themes->getAll();
        $i = 1;
        $categoryResult = array();
        foreach ($allResultCategory as $c) {
            $tanslateName = '';
            switch ($this->convert_utf8($c->name)) {
                case 'Politics':
                    $tanslateName = $this->lang->line('cat_politics');
                    break;
                case 'Health':
                    $tanslateName = $this->lang->line('cat_health');
                    break;
                case 'Business & Economy':
                    $tanslateName = $this->lang->line('cat_economy');
                    break;
                case 'Society':
                    $tanslateName = $this->lang->line('cat_society');
                    break;
                case 'Sport':
                    $tanslateName = $this->lang->line('cat_sport');
                    break;
                case 'Travel':
                    $tanslateName = $this->lang->line('cat_travel');
                    break;
                case 'Art & Culture':
                    $tanslateName = $this->lang->line('cat_art_culture');
                    break;
                case 'Lifestyle':
                    $tanslateName = $this->lang->line('cat_lifestyle');
                    break;
                case 'Environment':
                    $tanslateName = $this->lang->line('cat_environment');
                    break;
                case 'Technology':
                    $tanslateName = $this->lang->line('cat_technology');
                    break;
                
                default:
                    // code...
                    break;
            }

            $themeImage = '';
            switch ($this->convert_utf8($c->name)) {
                case 'Politics':
                    $themeImage = 'Politics';
                    break;
                case 'Health':
                    $themeImage = 'Health';
                    break;
                case 'Business & Economy':
                    $themeImage = 'Economy';
                    break;
                case 'Society':
                    $themeImage = 'Society';
                    break;
                case 'Sport':
                    $themeImage = 'Sport';
                    break;
                case 'Travel':
                    $themeImage = 'Travel';
                    break;
                case 'Art & Culture':
                    $themeImage = 'Culture';
                    break;
                case 'Lifestyle':
                    $themeImage = 'Lifestyle';
                    break;
                case 'Environment':
                    $themeImage = 'Livestock';
                    break;
                case 'Technology':
                    $themeImage = 'Technology';
                    break;
                
                default:
                    // code...
                    break;
            }
            $categoryResult[$i]  = array(
                $tanslateName, 
                'assets/themes/other/images/'.$themeImage.'.jpg', 
                $this->convert_utf8($c->name),
                $c->id
            );
           $i++;
        }

        $data['categoryResult'] = isset($categoryResult) ? $categoryResult : null;
        $dateNow = date('d-m-Y');
        $monthMaxResult = $this->newsletter_model->getActualMonth();
        $monthId = $monthMaxResult[0]->id;
        $dateCreate = date('d-m-Y',strtotime($monthMaxResult[0]->created));

        $resultNotificationNl = $this->Notification_model->getMaxDataByCriteria('newsletter',$this->session->userdata('GROUPE'));
        if (count($resultNotificationNl) >= 1) {
            foreach($resultNotificationNl as $notif){
                $data_update_notification = array(
                    'id_data'    => $monthId,
                    'date_create'=> $dateCreate,
                    'access'=> true
                );
                $this->Notification_model->update($notif->id,$data_update_notification);
            }
        }
        elseif(isset($monthId) && isset($dateCreate) && $monthId != '' && $dateCreate != ''){            
            $data_notification = array(
                'id_tuteur'  => NULL,
                'id_groupe'  => $this->session->userdata('GROUPE'),
                'data_type'  => 'newsletter',
                'id_data'    => $monthId,
                'date_create'=> $dateCreate,
                'access'=> true
            );
            $this->Notification_model->add($data_notification);
        }

        if (isset($_GET['user_el']) && $_GET['user_el'] != '') {
            $result = $this->login_model->loginMe($this->membres_model->Request('login',$_GET['user_el']), $this->membres_model->Request('password',$_GET['user_el']));
          
            if(count($result) > 0)
            {
              foreach ($result as $res)
              {
                if ($res->mode_acces == '2') {
                    if ($res->type==0) {
                        $role = STAGIAIRE;
                    }
                    elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                        $role = TUTEUR;                            
                    }
                    elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                        $role = TUTEUR;                            
                    }
                    elseif ($res->type==4) {
                       $role = MANAGER;                            
                    }
                    elseif ($res->type==2) {
                       $role = ADMIN;                            
                    } 
                    else{
                        $role = ROLEAUTRES;
                    }
                    $CNX = $this->connexion_model->newconnexion($res->id);

                    $sessionArray = array('GUSERID'=>$res->id,
                        'GEXTRANETID'              =>$res->extranet_id,
                        'GUSER'                    =>$res->prenom." ".$res->nom,
                        'GUSERLOGIN'               =>$res->login,
                        'GUSERTYPE'                =>$res->type,
                        'BAR'                      =>$res->acces_bar,
                        'MODE_ACCES'               =>$res->mode_acces,
                        'GROUPE'                   =>$res->id_groupe,
                        'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                        'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                        'TYPE'                     =>$res->type,
                        'ROLE'                     =>$role,
                        'CNX'                      =>$CNX,
                        'SOCIETE'                  =>$res->description,
                        'PDP'                      =>$res->nom_photo,
                        'isLoggedIn'               => TRUE
                    );
                                
                    $this->session->set_userdata($sessionArray);
                    
                }
                elseif (!empty($res->date_fin_acces)) {
                    if($res->date_fin_acces+((24*3600)+(60*60)+60) <= time()) {
                        $this->session->set_flashdata('error', 'Votre date d\'accès à la plateforme est expiré');                
                        redirect('/login');

                    }
                    else{
                        if ($res->type==0) {
                            $role = STAGIAIRE;
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                            $role = TUTEUR;                            
                        }
                        elseif ($res->type==4) {
                           $role = MANAGER;                            
                        }
                        elseif ($res->type==2) {
                           $role = ADMIN;                            
                        } 
                        else{
                            $role = ROLEAUTRES;
                        }
                        $CNX = $this->connexion_model->newconnexion($res->id);

                        $sessionArray = array('GUSERID'=>$res->id,
                            'GEXTRANETID'              =>$res->extranet_id,
                            'GUSERLOGIN'               =>$res->login,
                            'GUSER'                    =>$res->prenom." ".$res->nom,
                            'GUSERTYPE'                =>$res->type,
                            'BAR'                      =>$res->acces_bar,
                            'MODE_ACCES'               =>$res->mode_acces,
                            'GROUPE'                   =>$res->id_groupe,
                            'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                            'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                            'TYPE'                     =>$res->type,
                            'ROLE'                     =>$role,
                            'CNX'                      =>$CNX,
                            'SOCIETE'                  =>$res->description,
                            'PDP'                      =>$res->nom_photo,
                            'isLoggedIn'               => TRUE
                        );
                    }

                }
                else{                      

                    if ($res->type==0) {
                        $role = STAGIAIRE;
                    }
                    elseif ($res->type==3 && $res->tuteur_entreprise==0) {
                        $role = TUTEUR;                            
                    }
                    elseif ($res->type==3 && $res->tuteur_entreprise==1) {
                        $role = TUTEUR;                            
                    }
                    elseif ($res->type==4) {
                       $role = MANAGER;                            
                    }
                    elseif ($res->type==2) {
                       $role = ADMIN;                            
                    } 
                    else{
                        $role = ROLEAUTRES;
                    }
                    $CNX = $this->connexion_model->newconnexion($res->id);

                    $sessionArray = array('GUSERID'=>$res->id,
                        'GEXTRANETID'              =>$res->extranet_id,
                        'GUSER'                    =>$res->prenom." ".$res->nom,
                        'GUSERLOGIN'               =>$res->login,
                        'GUSERTYPE'                =>$res->type,
                        'BAR'                      =>$res->acces_bar,
                        'MODE_ACCES'               =>$res->mode_acces,
                        'GROUPE'                   =>$res->id_groupe,
                        'ACCES_FONCTIONS_ADMIN'    =>$res->acces_fonctions_admin,
                        'TUTEUR_ENTREPRISE'        =>$res->tuteur_entreprise,
                        'TYPE'                     =>$res->type,
                        'ROLE'                     =>$role,
                        'CNX'                      =>$CNX,
                        'SOCIETE'                  =>$res->description,
                        'PDP'                      =>$res->nom_photo,
                        'isLoggedIn'               => TRUE
                    );
                }
                $this->isLoggedIn();  
                if (isset($_GET['id-art'])) {
                  $this->loadTrackingEl($_GET['id-art'],0,$this->tracking_type);
                }
                else{
                  $this->loadTrackingEl($this->sequence_id_default,0,$this->tracking_type);
                }
                
                if (isset($_GET['id'])) {
                    $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id']);
                }
                elseif (isset($_GET['id-art'])) {
                    $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id-art']);
                }
                else{
                    $this->global['pageTitle']  = 'E-learning : Newsletter';
                }

                $data['statPrg'] =  $this->stat_prg_model->getSatCat($this->session->userdata ('GUSERID'))->result();           
                $data['classification_favoris']   = $this->classificationFavoris_Model->getClassTuteurByTrainee($this->session->userdata ('GROUPE')); 
                $this->loadViews("trainee/newsletter/home", $this->global,$data, NULL );
              }
            }
            else
            {
                $this->session->set_flashdata('error', 'Email or password mismatch');
                
                redirect('/login');
            }
        }
        else{
            $this->isLoggedIn();  
            if (isset($_GET['id-art'])) {
              $this->loadTrackingEl(0,$_GET['id-art'],$this->tracking_type);
            }
            else{
              $this->loadTrackingEl($this->sequence_id_default,0,$this->tracking_type);
            }
            if (isset($_GET['id'])) {
                $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id']);
            }
            elseif (isset($_GET['id-art'])) {
                $this->global['pageTitle']  = 'E-learning : Newsletter - '.$this->newsletter_model->Request('article',$_GET['id-art']);
            }
            else{
                $this->global['pageTitle']  = 'E-learning : Newsletter';
            }

            $data['statPrg'] =  $this->stat_prg_model->getSatCat($this->session->userdata ('GUSERID'))->result();           
            $data['classification_favoris']   = $this->classificationFavoris_Model->getClassTuteurByTrainee($this->session->userdata ('GROUPE')); 
            
            $this->loadViews("trainee/newsletter/home", $this->global,$data, NULL );
        }
    }

    public function getArticle(){ 
      if ($_POST['module_id']) {
        $this->loadTrackingEl($_POST['module_id'],0,$this->tracking_type);
      } 
     
      $html = "<br>";
      $html .='<div class="loader-nl"></div>';
      $html .='<div class="container-cat-article">';    
      if (isset($_POST)) {          
        $rowno=0;
        $rowperpage = 12;
 
        if($rowno != 0){
          $rowno = ($rowno-1) * $rowperpage;
        }
        $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
        $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
           
        // Pagination Configuration
        $config['base_url'] = current_url();
        $config['use_page_numbers'] = TRUE;
        $config['full_tag_open']    = '<div class="pagging text-center"><nav><ul class="pagination">';
        $config['full_tag_close']   = '</ul></nav></div>';
        $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
        $config['num_tag_close']    = '</span></li>';
        $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
        $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['next_tag_close']  = '<span aria-hidden="true"></span></span></li>';
        $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['prev_tag_close']  = '</span></li>';
        $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
        $config['first_tag_close'] = '</span></li>';
        $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['last_tag_close']  = '</span></li>';
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Previous';

        $config['total_rows'] = $allcount;
        $config['per_page'] = $rowperpage;
        $this->pagination->initialize($config);
        $pagination = $this->pagination->create_links_nl();
        $data['result'] = $article;
        $data['row'] = $rowno;

        if ($allcount >= 1) {
            $html .='<div class="row">';
                $html .='<div class="col-xs-12">';
                    $html .='<div class="col-xs-8">';
                        $html .='<h4 class="title-cat">Category : '.$_POST['theme'].'</h4><br>';
                    $html .='</div>';
                    $html .='<div class="col-xs-4">';  
                        $html .='<a class="btn btn-primary" href="#" onClick="gotoparentsList();">Previous</a>';                
                    $html .='</div>';
                $html .='</div>';
            $html .='<div class="col-xs-12">';
            foreach ($article as $res) {
                $thumb = $this->utilities_model->getthumbNL($res->ID);
                if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                   $img  = base_url()."groupes/ACTIVITES/".$thumb;
                }
                else{
                    $img  = base_url()."groupes/default.png";
                }
                $suite = "";
                $nb_word = strlen(htmlentities($res->article));

                $nb_restant = $nb_word - 40;
                $original_text =  substr(htmlentities($res->article),0,40);
                if ($nb_restant >= 1) {
                    $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                }
                else{
                    $suite .= "";
                }
                $html .='<div class="col-md-2 col-6">
                  <div class="container-image hovereffect" style="height:auto !important;">';
                  $html .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$img.'">';            
                     
                      $html .='<div class="overlay">'; 
                          $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                              /*$html .='<a style="#" href="" class="btn link-action-nl" title="Add">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Ajouter-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; */
                              $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                              $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                                  $html .=' <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" data-article="'.$res->article.'" data-id="'.$res->ID.'" data-module="'.$res->theme.'" data-sequence="'.$res->nl_monthnewsletter_id.'" class="btn link-action-nl" title="Add in favorite" onclick="addArtFav(this);">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl img-favorite-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl btn-add-favorite" title="Access to the video">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl img-video-nl">'; 
                              $html .='</a>'; 
                      
                          $html .='</div>'; 
                          $html .='<div style="float: left !important;">'; 
                              $html .='<a href="'.base_url().'read-data?id='.$res->ID.'" class="btn link-loop-article" title="Access the article">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                              $html .='</a>'; 
                          $html .='</div>'; 
                      $html .='</div>'; 
                      $html .='</div>'; 
                      $html .='<div class="legend title-vignette"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   
                  $html .='</div>'; 

            }
            $html .='</div>'; 
        }
        else{
          $html .='';
          $html .='<div class="text-center col-xs-12">
            <ul class="pagination">
              <li><h2>Nothing Found.</h2></li>     
            </ul>
          </div>';
        }

      }
      $html .='</div> <div class="modal fade modal_elearning" id="modal_elearning" role="dialog">
      <div class="modal-dialog">
      
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Add your comment from this <span class="data-intitule-header"></span></h4>
          </div>
          <div class="modal-body">
            <p class="error-saisie"></p>
            <input type="hidden" name="data-id" class="data-id">
            <input type="hidden" name="data-intitule" class="data-intitule">
            <input type="hidden" name="data-type" class="data-type" value="nl_article">
            <div class="content-comment-todo"></div>
            <textarea class="form-control data-comment" name="data-comment" rows="10" placeholder="Add your comment"></textarea>
          </div>
          <div class="modal-footer">
            <a type="button" class="btn btn-primary btn-save-comment btn-save-comment-art btn-action-el-ok" onclick="saveArtCom(this);">Add</a>
            <button type="button" class="btn btn-default btn-close-modal btn-action-el-cancel" data-dismiss="modal">Close</button>
          </div>
        </div>
        
      </div>
      <input type="hidden" name="url-stat-article" class="url-stat-article" value="'.base_url().'stat-article">
      <input type="hidden" class="clsvaluepage" value="newsletter">';
      $html .='</div></div>';
      $html .='<div class="row"><div class="col-xs-12"><div class="pagging text-center">
                      <nav>
                      <ul class="pagination pagination-lg">                          
                        '.$pagination.'
                      </ul>
                      </nav>
                    </div>
                  </div>
                </div>';
      echo "html_artcile".$html."html_artcile".json_encode($data);

    }
    public function getArticlePage(){        
        $html = "";
   
        $html .='<div class="container-cat-article">';    
        if (isset($_POST)) {
          if ($_POST['rowno'] != "") {
            $rowno=$_POST['rowno'];
          }
          else{
            $rowno=0;
          }
          $rowperpage = 5;
   
          if($rowno != 0){
            $rowno = ($rowno-1) * $rowperpage;
          }
          $allcount = $this->newsletter_model->getCntArticleWithTheme($_POST['theme'])->num_rows();
          $article  = $this->newsletter_model->getArticleWithTheme($_POST['theme'],$rowperpage, $rowno)->result();
         

          if ($allcount >= 1) {
            
              foreach ($article as $res) {
                  $thumb = $this->utilities_model->getthumbNL($res->ID);
                  if ($thumb != "" && is_file(REP_ACTIVITY_SEQUENCE.$thumb)) {
                     $img  = base_url()."groupes/ACTIVITES/".$thumb;
                  }
                  else{
                      $img  = base_url()."groupes/default.png";
                  }
                  $suite = "";
                  $nb_word = strlen(htmlentities($res->article));

                  $nb_restant = $nb_word - 40;
                  $original_text =  substr(htmlentities($res->article),0,40);
                  if ($nb_restant >= 1) {
                      $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                  }
                  else{
                      $suite .= "";
                  }

                  $html .='<div class="column container-image hovereffect">';            
                      $html .='<img class="image-timthumb" title="" alt="Avatar" src="'.$img.'">';            
                      $html .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                      $html .='<div class="overlay">'; 
                          $html .='<div class="btn-group-vertical" style="float: right !important;">'; 
                        
                              $html .='<input type="hidden" class="idCat" value="'.$res->ID.'">';
                              $html .='<a href="#" class="btn link-action-nl btn-add-comment"  onclick="addArtComm(this);" title="Add comment">'; 
                                 $html .=' <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl" title="Add in favorite" onclick="addArtFav(this);">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; 

                              $html .='<a href="#" class="btn link-action-nl btn-add-favorite" title="Access to the video">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Video-vignette-Normal.png" width="40%" class="image-action-nl">'; 
                              $html .='</a>'; 
                      
                          $html .='</div>'; 
                          $html .='<div style="float: left !important;">'; 
                              $html .='<a href="'.base_url().'read-data?id='.$res->ID.'" class="btn link-loop-article" title="Access the article">'; 
                                  $html .='<img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                              $html .='</a>'; 
                          $html .='</div>'; 
                      $html .='</div>'; 
                  $html .='</div>'; 

              }
              
          }
          else{
              $html .='<div class="text-center col-xs-12">
                          <ul class="pagination">
                              <li><h2>Nothing Found.</h2></li>     
                          </ul>
                      </div>';
              
          }

        }
        $html .='</div>';    
       
        echo "html_artcile".$html;

    }

    public function addStat(){
        if (isset($_POST)) {
            $data = array('id_membres'    => $this->session->userdata ('GUSERID'), 
                          'user_create'   => $this->session->userdata ('GUSERID'), 
                          'id_prg'        => $_POST['id'],
                          'intitule'      => $_POST['intitule'],
                          'status'        => $_POST['status'],
                          'type'          => $_POST['type'],
                          'commentaire'   => $_POST['comment'],
                          'module_id'     => (isset($_POST['module_id']) && is_int($_POST['module_id']) ) ? $_POST['module_id'] : NULL,
                          'date_creation' => time()
                         );


            $ret = $this->stat_prg_model->add($data);
            echo '##'.$ret;
        }

    }

}

?>


  
  
  