<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Todolist extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->width      = "1200";
        $this->height     = "1280";
        $this->date       = time();
        $this->tracking_type = 2;
        $this->idNewSequence = 0;
    }
    
    /**
     * This function used to load the first screen of the user
     */
   
    public function index()
    {
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("traineeTodoList", $this->global, NULL , NULL);
    }
 
    public function todoListing()
    {
        if (isset($_GET['load-content']) && isset($_GET['id'])) {
            $this->loadTrackingEl($_GET['id'],$this->todolist_model->Request('num_sequence',$_GET['id']),$this->tracking_type,$this->todolist_model->Request('historique_cours',$_GET['id']));
        }
        else{
            $this->loadTrackingEl(0,0,$this->tracking_type);
        }

        $this->global['pageTitle'] = 'E-learning : Forma2+';
        $this->global['groupe'] = $this->session->userdata ('GROUPE');
        $searchText = $this->input->post('searchText');
        $data['searchText'] = $searchText;  
              

        $this->global['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata('GUSERID'),$this->session->userdata ('GROUPE'));
        $data['allTutorResult'] = $this->groupes_model->getALLTutor($this->session->userdata ('GROUPE'));
        $data['allDateFromTodo'] = $this->todolist_model->getByAllDateIdGroup($this->session->userdata ('GROUPE'));
        if (isset($_GET['pr']) && isset($_GET['action']) && $_GET['action'] == 'ch_tr') {
            $data['historiqcours'] = $this->coursHistorik_model->getByIdGroupAndTutor($this->session->userdata ('GROUPE'),$_GET['pr']);
        }
        else{
            $data['historiqcours'] = $this->coursHistorik_model->getByIdGroup($this->session->userdata ('GROUPE'));
        }
        $this->Notification_model->deleteByIdDataTypeAndGroupe('todo',$this->session->userdata ('GROUPE'));
        $this->Notification_model->deleteByIdDataTypeAndGroupe('page_todo',$this->session->userdata ('GROUPE'));
        $this->Notification_model->deleteByIdDataTypeAndGroupe('article_todo',$this->session->userdata ('GROUPE'));
        $this->loadViews("trainee/todolist/index", $this->global,$data, NULL );
    }
    public function viewTodo(){
        $this->global['pageTitle']  = 'E-learning : Todo';
        $linkIfram = '';
      
        if (isset($_GET)) {        
            $id                       = $_GET['id'];
            $this->loadTrackingEl($this->todolist_model->Request('historique_cours',$id),$id,$this->tracking_type);
            $id_new_seq  = $this->todolist_model->Request('num_sequence',$id);
            $id_groupe  = $this->todolist_model->Request('id_groupe',$id);
            $this->global['linkIframFinal'] = $this->getEmbedUrlFromTodo($id_new_seq);
            $data['totoData']       = $this->todolist_model->ReadTrainingProg($id);
            $this->loadViews("trainee/todolist/read", $this->global,$data, NULL );
        }

    }

    public function scan($id,$type){
        $getInfoNewSequence = $this->todolist_model->getInfoNewSequence($id);
        foreach($getInfoNewSequence as $s){
            //if is a doc word or pdf file
            if ($s->type == 2) {
                //verify file exist
                $current_file =  RP_GROUPES."GRPT".$s->user_create.'/documentTodo/'.$s->link;
                
                $file_old      =  RP_GRP_OLD."GRPT".$s->user_create.'/documentTodo/'.$s->link;
            
                //copy the file in new app
                copy($file_old, $current_file);

                $ext            = explode(".", $s->link);

                if ($ext[1]=="pdf") {
                    $urlF          = base_url().'groupes/GRPT'.$s->user_create.'/documentTodo/'.$s->link;
                }
                else{
                    $urlF   = base_url().'groupes/index.php?link=GRPT'.$s->user_create.'___documentTodo___'.$s->link;
                }


                $ourpage = $urlF;
            }
            
            else{ //if is a link
                $ourpage = $s->link;
            }
           

            $docTodoTuteur      =  RP_GROUPES."GRPT".$s->user_create.'/THUMBNAIL'.$s->user_create.'';

            $thumbnailFile = "thumbnail_".time().'_'.$s->user_create.'.png';
      
            if ( ! is_dir($docTodoTuteur) ) {
                mkdir($docTodoTuteur, 0777,true);
            }         
          

            $thumb = $this->generateThumbnail($ourpage,$this->width,$this->height,$docTodoTuteur."/".$thumbnailFile);

            if ($s->type == 2) {
                $this->todolist_model->updatelink($id,$thumbnailFile);
            }
            else{
                $this->todolist_model->updatelinks($id,$thumbnailFile,$this->detecturl($ourpage));
            }
         
            //echo 'detect : '.$this->detecturl($ourpage);
       
        }
  
    }

    /*addtracking function*/
    public function addtracking($todoid){        
        $this->loadTrackingEl($todoid,0,1);

    }

    /*addtracking function*/
    public function updatetracking(){
        $trackingid = $this->input->post('trackingmaxloaded');
        $this->tracking_model->Update($trackingid);

    }

    /*addtracking function*/
    public function getMaxIdTracking(){
        $trackingidMax = $this->tracking_model->getMaxIdTracking();
        echo "####".$trackingidMax;

    }

    public function copier_fichier($fichier, $dest) {

        $name =  basename($dest);
        $extension = $this->check_docs_extension($fichier['name']);
        if ($extension) {        
            if ( is_uploaded_file($fichier['tmp_name']) ) {
         
                @move_uploaded_file($fichier['tmp_name'],$dest) ;
                return($name);
            } else {
                die('erreur tmp_file -> '.$fichier['error']);
                return(false) ;
            }
        }
    }

    public function check_docs_extension($docs){

        $docs_extentions = array("pdf","doc","docx",'xls','xlsx','png','jpg','gpeg');

        $docs_parts = explode(".",$docs);

        $docs_end_part = end($docs_parts);

        if(in_array($docs_end_part,$docs_extentions ) == true){

            return true;


        }else{

            return false;
        }


    }

    public function addDoc($idNewSequence){

        $this->loadTrackingEl(0,0,$this->tracking_type);
        if (isset($_FILES['filedoc'])) {
            $filedoc = $_FILES['filedoc'];
          
            $files['fichier']    = isset($_FILES['filedoc'])?$_FILES['filedoc']:'';

            if ( isset($files['fichier']['name']) && strlen($files['fichier']['name'])>0 && $files['fichier']['size']>0 ) {
                $repDocTodoStagiaire=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoStagiaire) ) {
                    mkdir($repDocTodoStagiaire, 0777,true);
                } 
                $ext            = explode(".", $files['fichier']['name']);
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                $server_fichier = $this->copier_fichier( $files['fichier'],$repDocTodoStagiaire."/".$filename);

                if ($ext[1]=="pdf") {
                    $urlF          = base_url().'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$filename;
                }
                else{
                    $urlF   = base_url().'groupes/index.php?link=GRPT'.$this->session->userdata('GUSERID').'___documentTodo___'.$filename;
                }
                $filesdb        = $filename;  

                $docTodoStagiaire      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
             
                $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                if ( ! is_dir($docTodoStagiaire) ) {
                    mkdir($docTodoStagiaire, 0777,true);
                }         
                $thumb = $this->generateThumbnail($urlF,$this->width,$this->height,$docTodoStagiaire."/".$thumbnailFile);
                if ($thumb) {
                    $date = getdate() ;
                    $infoUpdateLink = array('thumbnail_file'=>$thumbnailFile,'link'=>$filesdb,'date_create'=>$date[0]); 
                    $this->todolist_model->updateNewSequence($idNewSequence,$infoUpdateLink);
                    $this->addTodoList($idNewSequence);
                }

            }
        }
    }

    public function add(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $retour     = "";
        if (isset($_POST['dataLink'])) {
            $type    = $_POST['dataLink']['type-todo'];
            $Title   = $_POST['dataLink']['title'];
            $comment = $_POST['dataLink']['comment'];  

            if (isset($_POST['dataLink']['link'])) {
                $link    = $_POST['dataLink']['link'];
            }

            if ($type == 0) {
                $urlF    = $link;
                $filesdb = $link;

                $docTodoStagiaire      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
             
                $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                if ( ! is_dir($docTodoStagiaire) ) {
                    mkdir($docTodoStagiaire, 0777,true);
                }         

                $thumb = $this->generateThumbnail($urlF,$this->width,$this->height,$docTodoStagiaire."/".$thumbnailFile);

                if($thumb){
                    $linkInfo = array('titre'=>$Title, 'link'=>$filesdb,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'),"thumbnail_file"=>$thumbnailFile,"ifrmaccess"=>$this->detecturl($urlF)); 
                    $idNewLink = $this->todolist_model->addnewlink($linkInfo);
                    $this->addTodoList($idNewLink);
                    $retour     = "1";

                }
                else{
                    $retour     = "2";
                }
            }
            else{
                $linkInfo = array('titre'=>$Title, 'link'=>"Prov",'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'),"thumbnail_file"=>"Prov"); 
                $retour = $this->todolist_model->addnewlink($linkInfo);
                $this->idNewSequence = $retour;
            }
        }
        else{
            $retour = 'no data';
        }

        echo $retour;
    }

    public function addTodoList($idNews){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->todolist_model->addTodo($idNews,$this->session->userdata ('GROUPE'));
    }


    public function addDocsOrLinkInTodo(){
        if (isset($_POST['id-cours-historik']) && $_POST['typedocselect'] == 2) {

            $urlF       = "";
            $type       = $_POST['typedocselect'];
            $Title      = $_POST['Title'];
                      
            $comment    = $_POST['comment'];
            $type       = $_POST['typedocselect'];

            $width      = "1200";
            $height     = "1280";


            $files   = isset($_FILES['filedoc'])?$_FILES['filedoc']:'';
            if ( isset($files['name']) && strlen($files['name'])>0 && $files['size']>0 ) {
                $repDocTodoTuteur=  RP_GROUPES."GRP".$this->session->userdata('GROUPE').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $files['name']);
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                $server_fichier = $this->copier_fichier($files,$repDocTodoTuteur."/".$filename);
                if ($server_fichier != '') {
                    $dataInfoNewDoc = array('titre'=>$Title, 'link'=>$filename,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID')); 
                    $idNewLink = $this->todolist_model->addnewlink($dataInfoNewDoc);
                    $urlF = "https://docs.google.com/gview?url=".base_url().'groupes/GRP'.$this->session->userdata('GROUPE').'/documentTodo/'.$filename."&amp;embedded=true";

                    $docTodoTuteur      =  RP_GROUPES."GRP".$this->session->userdata('GROUPE').'/THUMBNAIL'.$this->session->userdata('GROUPE').'';
                 
                    $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                    if ( ! is_dir($docTodoTuteur) ) {
                        mkdir($docTodoTuteur, 0777,true);
                    }         

                    $thumb = $this->generateThumbnail($urlF,$width,$height,$docTodoTuteur."/".$thumbnailFile); 
                    if($thumb){

                        $dataUpdate = array(
                            "thumbnail_file"=>$thumbnailFile
                        );
                        $this->todolist_model->updateNewSequence($idNewLink,$dataUpdate);
                    }
                    echo 'todo'.$this->todolist_model->addTodo($idNewLink,$this->session->userdata ('GROUPE'),$_POST['id-cours-historik']);
                }
            }
        }
        elseif ($_POST['dataDocOrLink']) {
            
            $urlF       = "";
            $type       = $_POST['dataDocOrLink']['typedocselect'];
            $Title      = $_POST['dataDocOrLink']['Title'];
                      
            $comment    = $_POST['dataDocOrLink']['comment'];
            $type       = $_POST['dataDocOrLink']['typedocselect'];
            $link       = $_POST['dataDocOrLink']['link'];  

            $width      = "1200";
            $height     = "1280";


            $urlF    = $link;
            $filesdb = $link;
             
            if (isset($urlF) && $urlF != '') {
                $dataInfo = array('titre'=>$Title, 'link'=>$filesdb,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'),"ifrmaccess"=>$this->detecturl($urlF));
                $idNewLink = $this->todolist_model->addnewlink($dataInfo);

                $docTodoTuteur      =  RP_GROUPES."GRP".$this->session->userdata('GROUPE').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
             
                $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                if ( ! is_dir($docTodoTuteur) ) {
                    mkdir($docTodoTuteur, 0777,true);
                }         

                $thumb = $this->generateThumbnail($urlF,$width,$height,$docTodoTuteur."/".$thumbnailFile);    
                

                if($thumb){

                    $dataUpdate = array(
                        "thumbnail_file"=>$thumbnailFile
                    );
                    $this->todolist_model->updateNewSequence($idNewLink,$dataUpdate);
                }
                echo 'todo'.$this->todolist_model->addTodo($idNewLink,$this->session->userdata ('GROUPE'),$_POST['dataDocOrLink']['id-cours-historik']);
            }
        }
        else{

        }
    }

    public function getAllDocsAndLink(){
        $TODO = '';
        $LinkAndDocs = '';
        $optionTodo = '';
        $optionLinkAndDocs = '';

        if (isset($_POST['idHistorikCours'])) {
            $todoExist = $this->todolist_model->TrainingProgTuteurInUserCreateAndGrp($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));

            $TODO .= '<ul class="todolistmenu">';
            foreach ($todoExist as $t) {
                if ($t->historique_cours == $_POST['idHistorikCours']) {
                    $TODO .= '<li>';
                        $TODO .= '<a href="#" class="btn btn-add-in-cours text-docs-and-link"><i class="glyphicon glyphicon-minus-sign glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;'.htmlentities($t->sequence).'</a>';
                    $TODO .= '</li>';
                }
                else{
                    $TODO .= '<li>';
                        $TODO .= '<a href="#" class="btn btn-add-in-cours text-docs-and-link" onclick="addTodoInCoursHistorik(this,'.$t->id_plan_de_travail.','.$_POST['idHistorikCours'].');"><i class="glyphicon glyphicon-plus-sign glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;'.htmlentities($t->sequence).'</a>';
                    $TODO .= '</li>';
                }

                $optionTodo .= '<option data-id="'.$t->id_plan_de_travail.'" value="'.htmlentities($t->sequence).'">';
            }
            $TODO .= '</ul>';
        }

        $LinkAndDocs .= '<ul class="linkanddocsmenu">';
            
        $linkdocs = $this->todolist_model->getAllLinkAndDocNotInTodo($this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
        foreach ($linkdocs as $ld) {
            $existPlandeW = $this->todolist_model->existPlandeW($_POST['idHistorikCours'],$ld->id,$this->session->userdata ('GROUPE'));
            if ($existPlandeW >= 1) {
                $LinkAndDocs .= '<li>';
                    $LinkAndDocs .= '<a href="#" class="btn btn-add-in-cours" onclick="removeInTraineePeriod(this,'.$ld->id.','.$_POST['idHistorikCours'].');"><i class="glyphicon glyphicon-remove-sign glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;'.htmlentities($ld->titre).'</a>';
                $LinkAndDocs .= '</li>';
                $optionLinkAndDocs .= '<option data-id="'.$ld->id.'" value="'.htmlentities($ld->titre).'">';
            }
            else{
                $LinkAndDocs .= '<li>';
                    $LinkAndDocs .= '<a href="#" class="btn btn-add-in-cours" onclick="addDocsLinkInCoursHistorik(this,'.$ld->id.','.$_POST['idHistorikCours'].');"><i class="glyphicon glyphicon-plus-sign glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;'.htmlentities($ld->titre).'</a>';
                $LinkAndDocs .= '</li>';
                $optionLinkAndDocs .= '<option data-id="'.$ld->id.'" value="'.htmlentities($ld->titre).'">';
            }
        }
        $LinkAndDocs .= '</ul>';

        echo $LinkAndDocs.'##'.$TODO.'##'.$optionTodo.'##'.$optionLinkAndDocs;
    }

    public function removeInTraineePeriod(){
        if (isset($_POST['idHisorikC']) && isset($_POST['idNewseq'])) {
            echo 'todo'.$this->todolist_model->updateCoursHistoriqueByIdSequence($_POST['idNewseq'],$this->session->userdata ('GROUPE'),$_POST['idHisorikC']);
        }
    }

    public function addTraineeTodo(){
        if (isset($_POST['idHisorikC'])) {
            echo 'todo'.$this->todolist_model->addTodo($_POST['idNewseq'],$this->session->userdata ('GROUPE'),$_POST['idHisorikC']);
        }
        else{
            $id = $this->input->post('id');
            echo 'todo'.$this->todolist_model->addTodo($id,$this->session->userdata ('GROUPE'));
        }
  
    }


    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }
}

?>