<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Stacnx
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 21 Décembre 2020
 */
class Statcnx extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : Stat connexion';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');

        $searchText = $this->input->post('searchText');

        $count      = $this->membres_model->CountGanesha2011_getstats($searchText,$this->session->userdata ('STAGIAIREID'));
        $returns    = $this->paginationCompress ( "trainee-todo-in-tutor/", $count,12);
        $data['statsResult'] = $this->membres_model->Ganesha2011_getstats($this->session->userdata ('STAGIAIREID'),$searchText, $returns["page"], $returns["segment"]);
        $this->loadViews("tutor/stat/list", $this->global,$data, NULL );
    }

    public function detail($event,$traineeId){
        $this->global['pageTitle'] = 'E-learning : Stat connexion';
        if (isset($event) && $event != NULL) {
            $this->load->library('pagination');
            switch ($event) {
                case 1:
                    $data['title_stats']   = "Time Connection Global";
                    $data['detail']        = 1;
                    $count                 = $this->stat_model->getCountTimeCnxGlobal($traineeId);
                    $returns               = $this->paginationCompress ( "tutor-detail-cnx/".$event."/".$traineeId."/", $count, 8 );
                    $data['statcnx']       = $this->stat_model->getTimeCnxGlobal($traineeId,$returns["page"], $returns["segment"]);
                    break;
                case 2:
                    $data['title_stats']   = "Connection time for the month";
                    $data['detail']        = 2;
                    $count              = $this->stat_model->getCountTimeCnxForMonth($traineeId);
                    $returns = $this->paginationCompress ( "tutor-detail-cnx/".$event."/".$traineeId."/", $count, 8 );
                    $data['statcnx']       = $this->stat_model->getTimeCnxForMonth($traineeId,$returns["page"], $returns["segment"]);


                    break;
                case 3:
                    $data['title_stats']   = "Connection time for the month before";
                    $data['detail']        = 3;
                   
                    $count   = $this->stat_model->getCountTimeCnxForMonthBefore($traineeId);
                    $returns = $this->paginationCompress ( "tutor-detail-cnx/".$event."/".$traineeId."/", $count, 8 );
                    $data['statcnx']       = $this->stat_model->getTimeCnxForMonthBefore($traineeId,$returns["page"], $returns["segment"]);

                    break;
                case 4:
                    $data['title_stats']   = "Connection time for the year";
                    $data['detail']        = 4;
                    $count   = $this->stat_model->getCountTimeCnxForYear($traineeId);
                    $returns = $this->paginationCompress ("tutor-detail-cnx/".$event."/".$traineeId."/", $count, 8 );
                    $data['statcnx']       = $this->stat_model->getTimeCnxForYear($traineeId,$returns["page"], $returns["segment"]);
                    
                    break;
                
                default:
                    # code...
                    break;
            }
        }

        $this->loadViews("tutor/stat/views", $this->global, $data , NULL);
    }
}

?>