<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/automl/v1beta1/io.proto

namespace Google\Cloud\AutoMl\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Output configuration for ModelExport Action.
 *
 * Generated from protobuf message <code>google.cloud.automl.v1beta1.ModelExportOutputConfig</code>
 */
class ModelExportOutputConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js",
     *      "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite", "tf_saved_model", "tf_js".
     * *  For Video Classification cloud,
     *      "tf_saved_model".
     * *  For Video Object Tracking cloud,
     *      "tf_saved_model".
     * *  For Video Object Tracking mobile-versatile-1:
     *      "tflite", "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Video Object Tracking mobile-coral-versatile-1:
     *      "tflite", "edgetpu_tflite", "docker".
     * *  For Video Object Tracking mobile-coral-low-latency-1:
     *      "tflite", "edgetpu_tflite", "docker".
     * *  For Video Object Tracking mobile-jetson-versatile-1:
     *      "tf_saved_model", "docker".
     * *  For Tables:
     *      "docker".
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *           be used in the browser and in Node.js using JavaScript.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     *
     * Generated from protobuf field <code>string model_format = 4;</code>
     */
    private $model_format = '';
    /**
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     *
     * Generated from protobuf field <code>map<string, string> params = 2;</code>
     */
    private $params;
    protected $destination;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AutoMl\V1beta1\GcsDestination $gcs_destination
     *           The Google Cloud Storage location where the model is to be written to.
     *           This location may only be set for the following model formats:
     *             "tflite", "edgetpu_tflite", "tf_saved_model", "tf_js", "core_ml".
     *            Under the directory given as the destination a new one with name
     *            "model-export-<model-display-name>-<timestamp-of-export-call>",
     *            where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *            will be created. Inside the model and any of its supporting files
     *            will be written.
     *     @type \Google\Cloud\AutoMl\V1beta1\GcrDestination $gcr_destination
     *           The GCR location where model image is to be pushed to. This location
     *           may only be set for the following model formats:
     *             "docker".
     *           The model image will be created under the given URI.
     *     @type string $model_format
     *           The format in which the model must be exported. The available, and default,
     *           formats depend on the problem and model type (if given problem and type
     *           combination doesn't have a format listed, it means its models are not
     *           exportable):
     *           *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *                  mobile-high-accuracy-1:
     *                "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js",
     *                "docker".
     *           *  For Image Classification mobile-core-ml-low-latency-1,
     *                  mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *                "core_ml" (default).
     *           *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *                  mobile-high-accuracy-1:
     *                "tflite", "tf_saved_model", "tf_js".
     *           *  For Video Classification cloud,
     *                "tf_saved_model".
     *           *  For Video Object Tracking cloud,
     *                "tf_saved_model".
     *           *  For Video Object Tracking mobile-versatile-1:
     *                "tflite", "edgetpu_tflite", "tf_saved_model", "docker".
     *           *  For Video Object Tracking mobile-coral-versatile-1:
     *                "tflite", "edgetpu_tflite", "docker".
     *           *  For Video Object Tracking mobile-coral-low-latency-1:
     *                "tflite", "edgetpu_tflite", "docker".
     *           *  For Video Object Tracking mobile-jetson-versatile-1:
     *                "tf_saved_model", "docker".
     *           *  For Tables:
     *                "docker".
     *           Formats description:
     *           * tflite - Used for Android mobile devices.
     *           * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                              devices.
     *           * tf_saved_model - A tensorflow model in SavedModel format.
     *           * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *                     be used in the browser and in Node.js using JavaScript.
     *           * docker - Used for Docker containers. Use the params field to customize
     *                      the container. The container is verified to work correctly on
     *                      ubuntu 16.04 operating system. See more at
     *                      [containers
     *           quickstart](https:
     *           //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     *           * core_ml - Used for iOS mobile devices.
     *     @type array|\Google\Protobuf\Internal\MapField $params
     *           Additional model-type and format specific parameters describing the
     *           requirements for the to be exported model files, any string must be up to
     *           25000 characters long.
     *            * For `docker` format:
     *               `cpu_architecture` - (string) "x86_64" (default).
     *               `gpu_architecture` - (string) "none" (default), "nvidia".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Automl\V1Beta1\Io::initOnce();
        parent::__construct($data);
    }

    /**
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "tf_saved_model", "tf_js", "core_ml".
     *  Under the directory given as the destination a new one with name
     *  "model-export-<model-display-name>-<timestamp-of-export-call>",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     *
     * Generated from protobuf field <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     * @return \Google\Cloud\AutoMl\V1beta1\GcsDestination|null
     */
    public function getGcsDestination()
    {
        return $this->readOneof(1);
    }

    public function hasGcsDestination()
    {
        return $this->hasOneof(1);
    }

    /**
     * The Google Cloud Storage location where the model is to be written to.
     * This location may only be set for the following model formats:
     *   "tflite", "edgetpu_tflite", "tf_saved_model", "tf_js", "core_ml".
     *  Under the directory given as the destination a new one with name
     *  "model-export-<model-display-name>-<timestamp-of-export-call>",
     *  where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     *  will be created. Inside the model and any of its supporting files
     *  will be written.
     *
     * Generated from protobuf field <code>.google.cloud.automl.v1beta1.GcsDestination gcs_destination = 1;</code>
     * @param \Google\Cloud\AutoMl\V1beta1\GcsDestination $var
     * @return $this
     */
    public function setGcsDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AutoMl\V1beta1\GcsDestination::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     *
     * Generated from protobuf field <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     * @return \Google\Cloud\AutoMl\V1beta1\GcrDestination|null
     */
    public function getGcrDestination()
    {
        return $this->readOneof(3);
    }

    public function hasGcrDestination()
    {
        return $this->hasOneof(3);
    }

    /**
     * The GCR location where model image is to be pushed to. This location
     * may only be set for the following model formats:
     *   "docker".
     * The model image will be created under the given URI.
     *
     * Generated from protobuf field <code>.google.cloud.automl.v1beta1.GcrDestination gcr_destination = 3;</code>
     * @param \Google\Cloud\AutoMl\V1beta1\GcrDestination $var
     * @return $this
     */
    public function setGcrDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AutoMl\V1beta1\GcrDestination::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js",
     *      "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite", "tf_saved_model", "tf_js".
     * *  For Video Classification cloud,
     *      "tf_saved_model".
     * *  For Video Object Tracking cloud,
     *      "tf_saved_model".
     * *  For Video Object Tracking mobile-versatile-1:
     *      "tflite", "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Video Object Tracking mobile-coral-versatile-1:
     *      "tflite", "edgetpu_tflite", "docker".
     * *  For Video Object Tracking mobile-coral-low-latency-1:
     *      "tflite", "edgetpu_tflite", "docker".
     * *  For Video Object Tracking mobile-jetson-versatile-1:
     *      "tf_saved_model", "docker".
     * *  For Tables:
     *      "docker".
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *           be used in the browser and in Node.js using JavaScript.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     *
     * Generated from protobuf field <code>string model_format = 4;</code>
     * @return string
     */
    public function getModelFormat()
    {
        return $this->model_format;
    }

    /**
     * The format in which the model must be exported. The available, and default,
     * formats depend on the problem and model type (if given problem and type
     * combination doesn't have a format listed, it means its models are not
     * exportable):
     * *  For Image Classification mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite" (default), "edgetpu_tflite", "tf_saved_model", "tf_js",
     *      "docker".
     * *  For Image Classification mobile-core-ml-low-latency-1,
     *        mobile-core-ml-versatile-1, mobile-core-ml-high-accuracy-1:
     *      "core_ml" (default).
     * *  For Image Object Detection mobile-low-latency-1, mobile-versatile-1,
     *        mobile-high-accuracy-1:
     *      "tflite", "tf_saved_model", "tf_js".
     * *  For Video Classification cloud,
     *      "tf_saved_model".
     * *  For Video Object Tracking cloud,
     *      "tf_saved_model".
     * *  For Video Object Tracking mobile-versatile-1:
     *      "tflite", "edgetpu_tflite", "tf_saved_model", "docker".
     * *  For Video Object Tracking mobile-coral-versatile-1:
     *      "tflite", "edgetpu_tflite", "docker".
     * *  For Video Object Tracking mobile-coral-low-latency-1:
     *      "tflite", "edgetpu_tflite", "docker".
     * *  For Video Object Tracking mobile-jetson-versatile-1:
     *      "tf_saved_model", "docker".
     * *  For Tables:
     *      "docker".
     * Formats description:
     * * tflite - Used for Android mobile devices.
     * * edgetpu_tflite - Used for [Edge TPU](https://cloud.google.com/edge-tpu/)
     *                    devices.
     * * tf_saved_model - A tensorflow model in SavedModel format.
     * * tf_js - A [TensorFlow.js](https://www.tensorflow.org/js) model that can
     *           be used in the browser and in Node.js using JavaScript.
     * * docker - Used for Docker containers. Use the params field to customize
     *            the container. The container is verified to work correctly on
     *            ubuntu 16.04 operating system. See more at
     *            [containers
     * quickstart](https:
     * //cloud.google.com/vision/automl/docs/containers-gcs-quickstart)
     * * core_ml - Used for iOS mobile devices.
     *
     * Generated from protobuf field <code>string model_format = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setModelFormat($var)
    {
        GPBUtil::checkString($var, True);
        $this->model_format = $var;

        return $this;
    }

    /**
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     *
     * Generated from protobuf field <code>map<string, string> params = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Additional model-type and format specific parameters describing the
     * requirements for the to be exported model files, any string must be up to
     * 25000 characters long.
     *  * For `docker` format:
     *     `cpu_architecture` - (string) "x86_64" (default).
     *     `gpu_architecture` - (string) "none" (default), "nvidia".
     *
     * Generated from protobuf field <code>map<string, string> params = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParams($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->params = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}

