<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Cloud\Build\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Location of the source in a Google Cloud Source Repository.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.RepoSource</code>
 */
class RepoSource extends \Google\Protobuf\Internal\Message
{
    /**
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     */
    private $project_id = '';
    /**
     * Name of the Cloud Source Repository.
     *
     * Generated from protobuf field <code>string repo_name = 2;</code>
     */
    private $repo_name = '';
    /**
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     *
     * Generated from protobuf field <code>string dir = 7;</code>
     */
    private $dir = '';
    /**
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     *
     * Generated from protobuf field <code>bool invert_regex = 8;</code>
     */
    private $invert_regex = false;
    /**
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     *
     * Generated from protobuf field <code>map<string, string> substitutions = 9;</code>
     */
    private $substitutions;
    protected $revision;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project_id
     *           ID of the project that owns the Cloud Source Repository. If omitted, the
     *           project ID requesting the build is assumed.
     *     @type string $repo_name
     *           Name of the Cloud Source Repository.
     *     @type string $branch_name
     *           Regex matching branches to build.
     *           The syntax of the regular expressions accepted is the syntax accepted by
     *           RE2 and described at https://github.com/google/re2/wiki/Syntax
     *     @type string $tag_name
     *           Regex matching tags to build.
     *           The syntax of the regular expressions accepted is the syntax accepted by
     *           RE2 and described at https://github.com/google/re2/wiki/Syntax
     *     @type string $commit_sha
     *           Explicit commit SHA to build.
     *     @type string $dir
     *           Directory, relative to the source root, in which to run the build.
     *           This must be a relative path. If a step's `dir` is specified and is an
     *           absolute path, this value is ignored for that step's execution.
     *     @type bool $invert_regex
     *           Only trigger a build if the revision regex does NOT match the revision
     *           regex.
     *     @type array|\Google\Protobuf\Internal\MapField $substitutions
     *           Substitutions to use in a triggered build.
     *           Should only be used with RunBuildTrigger
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct($data);
    }

    /**
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Name of the Cloud Source Repository.
     *
     * Generated from protobuf field <code>string repo_name = 2;</code>
     * @return string
     */
    public function getRepoName()
    {
        return $this->repo_name;
    }

    /**
     * Name of the Cloud Source Repository.
     *
     * Generated from protobuf field <code>string repo_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRepoName($var)
    {
        GPBUtil::checkString($var, True);
        $this->repo_name = $var;

        return $this;
    }

    /**
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     *
     * Generated from protobuf field <code>string branch_name = 3;</code>
     * @return string
     */
    public function getBranchName()
    {
        return $this->readOneof(3);
    }

    public function hasBranchName()
    {
        return $this->hasOneof(3);
    }

    /**
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     *
     * Generated from protobuf field <code>string branch_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setBranchName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     *
     * Generated from protobuf field <code>string tag_name = 4;</code>
     * @return string
     */
    public function getTagName()
    {
        return $this->readOneof(4);
    }

    public function hasTagName()
    {
        return $this->hasOneof(4);
    }

    /**
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     *
     * Generated from protobuf field <code>string tag_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setTagName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Explicit commit SHA to build.
     *
     * Generated from protobuf field <code>string commit_sha = 5;</code>
     * @return string
     */
    public function getCommitSha()
    {
        return $this->readOneof(5);
    }

    public function hasCommitSha()
    {
        return $this->hasOneof(5);
    }

    /**
     * Explicit commit SHA to build.
     *
     * Generated from protobuf field <code>string commit_sha = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setCommitSha($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     *
     * Generated from protobuf field <code>string dir = 7;</code>
     * @return string
     */
    public function getDir()
    {
        return $this->dir;
    }

    /**
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     *
     * Generated from protobuf field <code>string dir = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDir($var)
    {
        GPBUtil::checkString($var, True);
        $this->dir = $var;

        return $this;
    }

    /**
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     *
     * Generated from protobuf field <code>bool invert_regex = 8;</code>
     * @return bool
     */
    public function getInvertRegex()
    {
        return $this->invert_regex;
    }

    /**
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     *
     * Generated from protobuf field <code>bool invert_regex = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setInvertRegex($var)
    {
        GPBUtil::checkBool($var);
        $this->invert_regex = $var;

        return $this;
    }

    /**
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     *
     * Generated from protobuf field <code>map<string, string> substitutions = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getSubstitutions()
    {
        return $this->substitutions;
    }

    /**
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     *
     * Generated from protobuf field <code>map<string, string> substitutions = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setSubstitutions($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->substitutions = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getRevision()
    {
        return $this->whichOneof("revision");
    }

}

