<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/metastore/v1/metastore_federation.proto

namespace Google\Cloud\Metastore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for CreateFederation.
 *
 * Generated from protobuf message <code>google.cloud.metastore.v1.CreateFederationRequest</code>
 */
class CreateFederationRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The relative resource name of the location in which to create a federation
     * service, in the following form:
     * `projects/{project_number}/locations/{location_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The ID of the metastore federation, which is used as the final
     * component of the metastore federation's name.
     * This value must be between 2 and 63 characters long inclusive, begin with a
     * letter, end with a letter or number, and consist of alpha-numeric
     * ASCII characters or hyphens.
     *
     * Generated from protobuf field <code>string federation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $federation_id = '';
    /**
     * Required. The Metastore Federation to create. The `name` field is
     * ignored. The ID of the created metastore federation must be
     * provided in the request's `federation_id` field.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1.Federation federation = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $federation = null;
    /**
     * Optional. A request ID. Specify a unique request ID to allow the server to ignore the
     * request if it has completed. The server will ignore subsequent requests
     * that provide a duplicate request ID for at least 60 minutes after the first
     * request.
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $request_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The relative resource name of the location in which to create a federation
     *           service, in the following form:
     *           `projects/{project_number}/locations/{location_id}`.
     *     @type string $federation_id
     *           Required. The ID of the metastore federation, which is used as the final
     *           component of the metastore federation's name.
     *           This value must be between 2 and 63 characters long inclusive, begin with a
     *           letter, end with a letter or number, and consist of alpha-numeric
     *           ASCII characters or hyphens.
     *     @type \Google\Cloud\Metastore\V1\Federation $federation
     *           Required. The Metastore Federation to create. The `name` field is
     *           ignored. The ID of the created metastore federation must be
     *           provided in the request's `federation_id` field.
     *     @type string $request_id
     *           Optional. A request ID. Specify a unique request ID to allow the server to ignore the
     *           request if it has completed. The server will ignore subsequent requests
     *           that provide a duplicate request ID for at least 60 minutes after the first
     *           request.
     *           For example, if an initial request times out, followed by another request
     *           with the same request ID, the server ignores the second request to prevent
     *           the creation of duplicate commitments.
     *           The request ID must be a valid
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     *           A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Metastore\V1\MetastoreFederation::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The relative resource name of the location in which to create a federation
     * service, in the following form:
     * `projects/{project_number}/locations/{location_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The relative resource name of the location in which to create a federation
     * service, in the following form:
     * `projects/{project_number}/locations/{location_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The ID of the metastore federation, which is used as the final
     * component of the metastore federation's name.
     * This value must be between 2 and 63 characters long inclusive, begin with a
     * letter, end with a letter or number, and consist of alpha-numeric
     * ASCII characters or hyphens.
     *
     * Generated from protobuf field <code>string federation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getFederationId()
    {
        return $this->federation_id;
    }

    /**
     * Required. The ID of the metastore federation, which is used as the final
     * component of the metastore federation's name.
     * This value must be between 2 and 63 characters long inclusive, begin with a
     * letter, end with a letter or number, and consist of alpha-numeric
     * ASCII characters or hyphens.
     *
     * Generated from protobuf field <code>string federation_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setFederationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->federation_id = $var;

        return $this;
    }

    /**
     * Required. The Metastore Federation to create. The `name` field is
     * ignored. The ID of the created metastore federation must be
     * provided in the request's `federation_id` field.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1.Federation federation = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Metastore\V1\Federation|null
     */
    public function getFederation()
    {
        return $this->federation;
    }

    public function hasFederation()
    {
        return isset($this->federation);
    }

    public function clearFederation()
    {
        unset($this->federation);
    }

    /**
     * Required. The Metastore Federation to create. The `name` field is
     * ignored. The ID of the created metastore federation must be
     * provided in the request's `federation_id` field.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1.Federation federation = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Metastore\V1\Federation $var
     * @return $this
     */
    public function setFederation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Metastore\V1\Federation::class);
        $this->federation = $var;

        return $this;
    }

    /**
     * Optional. A request ID. Specify a unique request ID to allow the server to ignore the
     * request if it has completed. The server will ignore subsequent requests
     * that provide a duplicate request ID for at least 60 minutes after the first
     * request.
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. A request ID. Specify a unique request ID to allow the server to ignore the
     * request if it has completed. The server will ignore subsequent requests
     * that provide a duplicate request ID for at least 60 minutes after the first
     * request.
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

