<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class CategoryExpression_model extends CI_Model
{
   
    public function __construct(){
        
        parent::__construct();
        $this->table    = 'category_expression';
    }

    public function add($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);       
        $id = $this->db->insert_id(); 
        $this->db->trans_complete();
        return $id;
    }


    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function getCategoryByIdGroup($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table); 
        $this->db->where('id_groupe', $idGroup);
        //$this->db->order_by('id', 'DESC');
        $this->db->order_by('intitule', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }


    public function RequestCat($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestByNameAndGrp($field,$name,$groupe) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('intitule', $name);
        $this->db->where('id_groupe', $groupe);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

   
     
}

?>
