<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Content_corporate_library_soc_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table = 'content_corporate_library_soc';             
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getById($id) {
        
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();         
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  
                $ret['titre']   = $res->titre;
                $ret['comment'] = $res->commentaire ;
                $ret['date_create']    = $res->date_create ;
                $ret['file']    = $res->link ;
                $ret['user_create']      = $res->user_create ;
                $ret['id_corporate_library_soc']      = $res->id_corporate_library_soc ;
                return($ret) ;
            }
        }
        return(false);
    }
    public function getResultById($id) {
        
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();         
        return $query->result()  ;   
    }
    public function deleteByIdCorporateLibrary($id_corporate_library_soc){
        $this->db->where('id_corporate_library_soc', $id_corporate_library_soc);
        $this->db->delete($this->table);
    }
    public function getByIdLibraryCorporate($idLibCorp) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_corporate_library_soc', $idLibCorp);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    
}

?>
