
<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Sequence_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
     
        $this->load->model('membres_model');
        $this->load->model('utilities_model');        
        $this->load->model('modules_model');        
        $this->load->model('chapitres_model');        
        $this->table     ='list_sequence'; 
        $this->table_seq = 'sequence';
        $this->table_trp = 'plan_de_travail';    
        $this->table_track = 'tracking';    
        $this->table_mat = 'matiere';    
        $this->table_f = 'formation';    
        $this->table_mod = 'list_module';    
        $this->table_module = 'module';    
    }

    public function getByModule($module){
        $this->db->select('l.*');
        $this->db->from($this->table.' as l');
        $this->db->join($this->table_module.' as m','m.sequence_id=l.sequence_id','inner');
        $this->db->where('m.module_id', $module);
        $this->db->group_by('m.ordre');
        $query = $this->db->get();
        return $query->result()  ; 
    }

    public function Request($field,$idSequence) {

        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('sequence_id', $idSequence);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    public function RequestSeqByIdAndNumero($field,$idSequence,$numero) {

        $this->db->select($field);
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idSequence);
        $this->db->where('numero', $numero);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getNextNumBySequence($idSequence) {

        $this->db->select('MAX(numero) as numeroMax');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idSequence);
        $query = $this->db->get();
        $result = $query->result();
        $ret = '';
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->numeroMax + 1;
            }
        }       
        return($ret);
    }


    public function getPavetSequenceHautByParcours($GROUPE,$GUSERID,$PAVESEQUENCE,$PARCOURS) {
        $ret = array();

        $this->db->select('lm.module_id, lm.module_titre as MODULE');
        $this->db->from('formation as f');
        $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
        $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
        $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
        $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
        $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
        $this->db->where('groupe_id', $GROUPE);
        $this->db->where('domaine.domaine_id', $PAVESEQUENCE);        
        $this->db->where('lp.parcours_id', $PARCOURS);        
        $this->db->group_by('lm.module_id', '');
        $this->db->order_by('f.ordre', '');
        $this->db->order_by('lp.parcours_titre', '');
        $this->db->order_by('lm.module_titre', '');
        $this->db->order_by('domaine.name', '');
        $this->db->order_by('matiere.name', '');
        
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;  

        foreach ($result as $res){ 
            
            $ret['module'][$res->MODULE][]=array(
                'idg'=>$GROUPE,
                'MODULENAME'=>$res->MODULE,
                'module_id'=>$res->module_id
            );               

        }       
                
        return $ret;
    }

    public function getPavetSequenceHaut($GROUPE,$GUSERID,$PAVESEQUENCE) {
        $ret = array();

        $this->db->select('lm.module_id, lm.module_titre as MODULE');
        $this->db->from('formation as f');
        $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
        $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
        $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
        $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
        $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
        $this->db->where('groupe_id', $GROUPE);
        $this->db->where('domaine.domaine_id', $PAVESEQUENCE);        
        $this->db->group_by('lm.module_id', '');
        $this->db->order_by('f.ordre', '');
        $this->db->order_by('lp.parcours_titre', '');
        $this->db->order_by('lm.module_titre', '');
        $this->db->order_by('domaine.name', '');
        $this->db->order_by('matiere.name', '');
        
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;  

        foreach ($result as $res){ 
            
            $ret['module'][$res->MODULE][]=array(
                'idg'=>$GROUPE,
                'MODULENAME'=>$res->MODULE,
                'module_id'=>$res->module_id
            );               

        }       
                
        return $ret;
    }

    /*public function getLinksByIdGroup($idg){
        $this->db->select('*');
        $this->db->from($this->table_seq.' as s');
        $this->db->join($this->table_f.' as f','f.sequence_id=s.id_sequence','inner');
        $this->db->where('f.groupe_id', $idg);
        $this->db->where('s.titre !=', 'support');
        $this->db->where('s.link !=', '');
        $this->db->group_by('f.sequence_id');
        $query = $this->db->get();
        return $query->result()  ; 
    }*/

    /*public function getLinksByIdGroup($idg){
        $ret2 = array();
        $i    = 0;
        $ii   = 0;
        $iii  = 0;
        $moduleResult = $this->modules_model->getByIGroupe($idg);
        foreach ($moduleResult as $m) {
            $listSequenceResult = $this->getListSequenceByGroupAndModule($idg,$m->module_id);
            foreach ($listSequenceResult as $resl) {
                $sequenceResult = $this->chapitres_model->readSequenceById($resl->sequence_id);
                foreach ($sequenceResult as $res) {
                    $ret2[$i]['titre']             =  $res->titre ;
                    $ret2[$i]['numero']            =  $res->numero ;
                    $ret2[$i]['link']              =  $res->link;
                    $ret2[$i]['norme']             =  $res->norme ;
                    $ret2[$i]['type']              =  $res->type;
                    $ret2[$i]['niveau']            =  $res->niveau;
                    $ret2[$i]['prerequis']         =  $res->prerequis;
                    $ret2[$i]['id_scorm']          =  $res->id_scorm ;
                    $ret2[$i]['description']       =  $res->description;
                    $ret2[$i]['regroupe']          =  $res->regroupe ;
                    $ret2[$i]['mastery']           =  $res->mastery ;
                    $ret2[$i]['thumbnail_file']    =  $res->thumbnail_file ;
                    $ret2[$i]['id_sequence']       =  $res->id_sequence ;
                    $ret2[$i]['ifrmaccess']        =  $res->ifrmaccess ;
                    $ret2[$i]['final_url']         =  $res->final_url ;
                    $ret2[$i]['status_url']        =  $res->status_url ;
                    $i++ ;
                }
                //$ii++ ;
            }
            //$iii++ ;
        }
        return $ret2;
    }*/
    public function getLinksByIdGroupIdDomaine($idg,$idDomaine){
        $ret2        = array();
        $module_id   = array();
        $sequence_id = array();
        $i    = 0;
        $ii   = 0;
        $iii  = 0;
        $moduleResult = $this->modules_model->getByIGroupeIdDomaine($idg,$idDomaine);
        foreach ($moduleResult as $m) {
            $module_id[$i]   = $m->module_id;
            $i++;
        }
        if (is_array($module_id) && !empty($module_id)) {
            $sequenceResult = $this->getListSequenceByGroupAndModuleArray($idg,$module_id);
            foreach ($sequenceResult as $seq) {
                $sequence_id[$ii]   = $seq->sequence_id;
                $ii++;
            }
        }

        if (is_array($sequence_id) && !empty($sequence_id)) {
            $sequenceResult = $this->chapitres_model->readSequenceByArrayIdSequence($sequence_id);
            foreach ($sequenceResult as $res) {
                $ret2[$iii]['titre']             =  $res->titre ;
                $ret2[$iii]['numero']            =  $res->numero ;
                $ret2[$iii]['link']              =  $res->link;
                $ret2[$iii]['norme']             =  $res->norme ;
                $ret2[$iii]['type']              =  $res->type;
                $ret2[$iii]['niveau']            =  $res->niveau;
                $ret2[$iii]['prerequis']         =  $res->prerequis;
                $ret2[$iii]['id_scorm']          =  $res->id_scorm ;
                $ret2[$iii]['description']       =  $res->description;
                $ret2[$iii]['regroupe']          =  $res->regroupe ;
                $ret2[$iii]['mastery']           =  $res->mastery ;
                $ret2[$iii]['thumbnail_file']    =  $res->thumbnail_file ;
                $ret2[$iii]['id_sequence']       =  $res->id_sequence ;
                $ret2[$iii]['ifrmaccess']        =  $res->ifrmaccess ;
                $ret2[$iii]['final_url']         =  $res->final_url ;
                $ret2[$iii]['status_url']        =  $res->status_url ;
                $iii++ ;
            }
        }
        return $ret2;
    }

    public function getListSequenceByGroupAndModuleArray($idg,$moduleArray){
        $this->db->select('ls.*');
        $this->db->from($this->table_f.' as f');
        $this->db->join($this->table_mod.' as lm','`lm`.`module_id`=`f`.`module_id`','left');
        $this->db->join($this->table.' as ls','`ls`.`sequence_id`=`f`.`sequence_id`','left');
        $this->db->where('f.groupe_id', $idg);
        $this->db->where_in('lm.module_id', $moduleArray);
        $this->db->group_by('ls.sequence_id,ls.sequence_titre,ls.domaine_id,ls.matiere_id');
        $query = $this->db->get();
        return $query->result()  ; 
    }


    public function getPavetSequenceHauts($MODULENAME,$GROUPE,$MODULEID,$PAVE) {

        $ret = array();
        $this->db->select('*,domaine.name as DOMAINE, matiere.name as MATIERE,ls.code, lp.parcours_titre as PARCOURS, ls.sequence_titre as SEQUENCE, ls.sequence_objectifs as OBJECTIFS, ls.user_create as user_create');
        $this->db->from('formation as f');
        $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
        $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
        $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
        $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
        $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
        $this->db->where('groupe_id', $GROUPE);
        $this->db->where('lm.module_id', $MODULEID);  
        if ($PAVE != 4) {
            $this->db->group_by('f.sequence_id');
        }      
        $this->db->order_by('f.ordre', 'asc');
        $this->db->order_by('lp.parcours_titre', 'asc');
        $this->db->order_by('lm.module_titre', 'asc');
        $this->db->order_by('domaine.name', 'asc');
        $this->db->order_by('matiere.name', 'asc');
        
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;        
        foreach ($query->result() as $res0){
            if ($res0->parcours_id=='') {
                $parcours = "ANNY";
            }
            else{
                $parcours = $res0->parcours_id;
            }
            $ret['module'][$MODULENAME][]=array(
                'sequence_id'=> $res0->sequence_id,
                'locs'=>$res0->locs,
                'module_id'=>$res0->module_id,
                'user_create'=>$res0->user_create,
                'code'=>$res0->code,
                'locm'=>$res0->locm,
                'parcours_id'=>$res0->parcours_id,
                'locp'=>$res0->locp,
                'sequence_url'=>HTTP_GANESHA.'sommaire/viewDetail/'.$this->session->userdata ('CNX').'/'.$res0->sequence_id.'/'.$res0->locs.'/'.$res0->module_id.'/'.$res0->locm.'/'.$parcours.'/'.$res0->locp,
                'sequence_name'=>$res0->SEQUENCE,
                'sequence_objectifs'=>$res0->OBJECTIFS,
                'parcours_name'=>$res0->PARCOURS
            );

        }   
        $ret['module'][$MODULENAME]['count_sequence']=$query->num_rows();

             
        return($ret);
    }
    public function getPavetSequenceHautsSearch($MODULENAME,$GROUPE,$MODULEID,$PAVE,$KEY) {

        $ret = array();
        $this->db->select('*,domaine.name as DOMAINE, matiere.name as MATIERE,ls.code, lp.parcours_titre as PARCOURS, ls.sequence_titre as SEQUENCE');
        $this->db->from('formation as f');
        $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
        $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
        $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
        $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
        $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
        $this->db->where('groupe_id', $GROUPE);
        $this->db->where('lm.module_id', $MODULEID); 
        if(!empty($KEY)) {
            $likeCriteria = "(ls.sequence_titre  LIKE '%".$KEY."%')";
            $this->db->where($likeCriteria);
        } 
        if ($PAVE != 4) {
            $this->db->group_by('f.sequence_id');
        }      
        $this->db->order_by('f.ordre', 'asc');
        $this->db->order_by('lp.parcours_titre', 'asc');
        $this->db->order_by('lm.module_titre', 'asc');
        $this->db->order_by('domaine.name', 'asc');
        $this->db->order_by('matiere.name', 'asc');
        
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;        
        foreach ($query->result() as $res0){
            if ($res0->parcours_id=='') {
                $parcours = "ANNY";
            }
            else{
                $parcours = $res0->parcours_id;
            }
            $ret['module'][$MODULENAME][]=array(
            'sequence_id'=> $res0->sequence_id,
            'locs'=>$res0->locs,
            'module_id'=>$res0->module_id,
            'code'=>$res0->code,
            'locm'=>$res0->locm,
            'parcours_id'=>$res0->parcours_id,
            'locp'=>$res0->locp,
            'sequence_url'=>HTTP_GANESHA.'sommaire/viewDetail/'.$this->session->userdata ('CNX').'/'.$res0->sequence_id.'/'.$res0->locs.'/'.$res0->module_id.'/'.$res0->locm.'/'.$parcours.'/'.$res0->locp,
            'sequence_name'=>$res0->SEQUENCE,
            'parcours_name'=>$res0->PARCOURS);

        }   
        $ret['module'][$MODULENAME]['count_sequence']=$query->num_rows();

             
        return($ret);
    }
    public function getPavetSequenceHautsSearchById($MODULENAME,$GROUPE,$MODULEID,$PAVE,$ID) {

        $ret = array();
        $this->db->select('*,domaine.name as DOMAINE, matiere.name as MATIERE,ls.code, lp.parcours_titre as PARCOURS, ls.sequence_titre as SEQUENCE');
        $this->db->from('formation as f');
        $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
        $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
        $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
        $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
        $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
        $this->db->where('groupe_id', $GROUPE);
        $this->db->where('lm.module_id', $MODULEID);  
        $this->db->where('ls.sequence_id', $ID);  
        if ($PAVE != 4) {
            $this->db->group_by('f.sequence_id');
        }      
        $this->db->order_by('f.ordre', 'asc');
        $this->db->order_by('lp.parcours_titre', 'asc');
        $this->db->order_by('lm.module_titre', 'asc');
        $this->db->order_by('domaine.name', 'asc');
        $this->db->order_by('matiere.name', 'asc');
        
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;        
        foreach ($query->result() as $res0){
            if ($res0->parcours_id=='') {
                $parcours = "ANNY";
            }
            else{
                $parcours = $res0->parcours_id;
            }
            $ret['module'][$MODULENAME][]=array(
            'sequence_id'=> $res0->sequence_id,
            'locs'=>$res0->locs,
            'module_id'=>$res0->module_id,
            'code'=>$res0->code,
            'locm'=>$res0->locm,
            'parcours_id'=>$res0->parcours_id,
            'locp'=>$res0->locp,
            'sequence_url'=>HTTP_GANESHA.'sommaire/viewDetail/'.$this->session->userdata ('CNX').'/'.$res0->sequence_id.'/'.$res0->locs.'/'.$res0->module_id.'/'.$res0->locm.'/'.$parcours.'/'.$res0->locp,
            'sequence_name'=>$res0->SEQUENCE,
            'parcours_name'=>$res0->PARCOURS);

        }   
        $ret['module'][$MODULENAME]['count_sequence']=$query->num_rows();

             
        return($ret);
    }

    public function swapNumeroChapitre($idm,$num1,$num2) {

        $info = array("numero"=>99);
        $this->db->where('id_sequence', $idm);
        $this->db->where('numero', $num1);
        $this->db->update($this->table_seq, $info);
        $this->db->affected_rows();


        $info1 = array("numero"=>$num1);
        $this->db->where('id_sequence', $idm);
        $this->db->where('numero', 99);
        $this->db->update($this->table_seq, $info1);
        $this->db->affected_rows();


        $info2 = array("numero"=>$num2);
        $this->db->where('id_sequence', $idm);
        $this->db->where('numero', 99);
        $this->db->update($this->table_seq, $info2);
        $this->db->affected_rows();


        $info3 = array("chapitre_id"=>99);
        $this->db->where('chapitre_id', $num1);
        $this->db->where('sequence_id', $idm);
        $this->db->update($this->table_track, $info3);
        $this->db->affected_rows();



        $info4 = array("chapitre_id"=>$num1);
        $this->db->where('chapitre_id', 99);
        $this->db->where('sequence_id', $idm);
        $this->db->update($this->table_track, $info4);
        $this->db->affected_rows();

        $info5 = array("chapitre_id"=>$num2);
        $this->db->where('chapitre_id', $num2);
        $this->db->where('sequence_id', $idm);
        $this->db->update($this->table_track, $info5);
        $this->db->affected_rows();

    }

    public function getPavetComplementary($GROUPE) {

        $ret = array();

        $this->db->select('*');
        $this->db->from('formation as f');
        $this->db->join('list_sequence as ls', 'ls.sequence_id = f.sequence_id','left');
        $this->db->where('f.groupe_id', $GROUPE);
        $this->db->where('f.parcours_id', 0);   
        $i = 0 ;
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;

        foreach ($result as $res){            
            $ret['module'][]=array(
                'sequence_id'=>$res->sequence_id,
                'locs'=>$res->locs,
                'code'=>$res->code,
                'module_id'=>$res->module_id,
                'locm'=>$res->locm,
                'parcours_id'=>0,
                'locp'=>$res->locp,
                'sequence_url'=>HTTP_GANESHA.'sommaire/viewDetail/'.$this->session->userdata ('CNX').'/'.$res->sequence_id.'/'.$res->locs.'/0/'.$res->locm.'/0/'.$res->locp,
                'sequence_name'=>$res->sequence_titre,
                'parcours_name'=>"Parcours"
            );
            $i++ ;
        } 
        
        return($ret);
    }
    public function getPavetComplementaryThreeView($GROUPE) {

        $ret = array();

        $this->db->select('*');
        $this->db->from('formation as f');
        $this->db->join('list_module as l', 'l.module_id = f.module_id','inner');
        $this->db->where('f.groupe_id', $GROUPE);
        $this->db->where('f.parcours_id', 0); 
        $this->db->group_by('l.module_id');  
        $i = 0 ;
        $query = $this->db->get(); 
        $row = $query->num_rows();
        return $query->result()  ;

    } 
    public function getPavetSequenceComplementaryThreeView($module_id, $GROUPE) {

        $ret = array();

        $this->db->select('*');
        $this->db->from('formation as f');
        $this->db->join('list_sequence as ls', 'ls.sequence_id = f.sequence_id','left');
        $this->db->where('f.groupe_id', $GROUPE);
        $this->db->where('f.module_id', $module_id);
        $this->db->where('f.parcours_id', 0);   
        $i = 0 ;
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ;

        foreach ($result as $res){            
            $ret['module'][]=array(
                'sequence_id'=>$res->sequence_id,
                'locs'=>$res->locs,
                'code'=>$res->code,
                'module_id'=>$res->module_id,
                'locm'=>$res->locm,
                'parcours_id'=>0,
                'locp'=>$res->locp,
                'sequence_url'=>HTTP_GANESHA.'sommaire/viewDetail/'.$this->session->userdata ('CNX').'/'.$res->sequence_id.'/'.$res->locs.'/0/'.$res->locm.'/0/'.$res->locp,
                'sequence_name'=>$res->sequence_titre,
                'parcours_name'=>"Parcours"
            );
            $i++ ;
        } 
        
        
        return($ret);
    }


    public function getPavetHaut($GROUPE,$PAVESEQUENCE) {
        $ret = array();
        $i=0;
        $y = 0;

        $this->db->select('lm.module_id, lm.module_titre as MODULE');
        $this->db->from('formation as f');
        $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
        $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
        $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
        $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
        $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
        $this->db->where('groupe_id', $GROUPE);
        $this->db->where('domaine.domaine_id', $PAVESEQUENCE);        
        $this->db->group_by('lm.module_id', '');
        $this->db->order_by('f.ordre', '');
        $this->db->order_by('lp.parcours_titre', '');
        $this->db->order_by('lm.module_titre', '');
        $this->db->order_by('domaine.name', '');
        $this->db->order_by('matiere.name', '');
        
        $query = $this->db->get(); 
        $row = $query->num_rows();
        $result = $query->result()  ; 

        foreach ($result as $res){ 
            $module_name= $res->MODULE;
            $this->db->select('*,domaine.name as DOMAINE, matiere.name as MATIERE, lp.parcours_titre as PARCOURS, ls.sequence_titre as SEQUENCE');
            $this->db->from('formation as f');
            $this->db->join('list_module as lm', 'lm.module_id=f.module_id','left');
            $this->db->join('list_parcours as lp', 'lp.parcours_id=f.parcours_id','left');
            $this->db->join('matiere as matiere', 'matiere.matiere_id=lm.matiere_id','left');
            $this->db->join('domaine as domaine', 'domaine.domaine_id=lm.domaine_id','left');
            $this->db->join('list_sequence as ls', 'ls.sequence_id=f.sequence_id','left');
            $this->db->where('groupe_id', $GROUPE);
            $this->db->where('lm.module_id', $res->module_id);
            $this->db->group_by('ls.sequence_id', '');
            $this->db->order_by('f.ordre', '');
            $this->db->order_by('lp.parcours_titre', '');
            $this->db->order_by('lm.module_titre', '');
            $this->db->order_by('domaine.name', '');
            $this->db->order_by('matiere.name', '');

            $query0 = $this->db->get(); 
            $row0 = $query0->num_rows();
            $result0 = $query0->result()  ;
            foreach ($result0 as $res0){
                if ($res0->parcours_id=='') {
                    $parcours = "ANNY";
                }
                else{
                    $parcours = $res0->parcours_id;
                }
                $ret['module'][$module_name][]=array('
                sequence_id'=> $res0->sequence_id,
                'locs'=>$res0->locs,
                'module_id'=>$res0->module_id,
                'locm'=>$res0->locm,
                'parcours_id'=>$res0->parcours_id,
                'locp'=>$res0->locp,
                'sequence_url'=>HTTP_GANESHA.'sommaire/viewDetail/'.$this->session->userdata ('CNX').'/'.$res0->sequence_id.'/'.$res0->locs.'/'.$res0->module_id.'/'.$res0->locm.'/'.$parcours.'/'.$res0->locp,
                'sequence_name'=>$res0->SEQUENCE,
                'parcours_name'=>$res0->PARCOURS);
                $y++;
            }
          
            $ret['module'][$module_name]['count_sequence']=$row0;
            $i++;

        }       
   
        
        return $ret;
    }    


    public function delete_values_from_array_array (array &$arr, array $values) {
        $c = 0;
        foreach (array_intersect($arr, $values) as $key => $value) {
            $c++;
            unset($arr[$key]);
        }
        return $c;
    }


    public function updateSequence($info,$type,$id_sequence,$numero) {

        $this->db->where('type', $type);
        $this->db->where('id_sequence', $id_sequence);
        $this->db->where('numero', $numero);
        $this->db->update('sequence', $info);
        $this->db->affected_rows();
    }

    public function updateListSequence($sequence_id,$data) {
        $this->db->where('sequence_id', $sequence_id);
        $this->db->update($this->table, $data);
        $this->db->affected_rows();
    }

    public function delChapitre($idm,$numero) {        

        $this->db->where('id_sequence', $idm);
        $this->db->where('numero', $numero);
        $this->db->delete($this->table_seq);

        $info =array('numero' => '(numero-1)');
        $this->db->where('id_sequence', $idm);     
        $this->db->where('numero >', $idm);     
        $this->db->update($this->table_seq, $info);
        $this->db->affected_rows();

        $info1 =array('chapitre_id' => '(chapitre_id-1)');
        $this->db->where('sequence_id', $idm);     
        $this->db->where('chapitre_id >', $numero);     
        $this->db->where('chapitre_id ', $idm);     
        $this->db->update($this->table_track, $info1);
        $this->db->affected_rows();


    }
    public function readAll(){   
        $this->db->select("*");           
        $this->db->from($this->table);
        $this->db->order_by('sequence_titre');
        $query1 = $this->db->get(); 
        $cnt = $query1->num_rows();
        return $query1->result()  ;

    }

   

    public function getListLinkActivityByIdSequence($matiere,$domaines,$ArrayIdSequence,$nbconsult,$status,$page,$segment) {
        $title_array = array('Support', 'Feuille Blanche');
        $matiereArray = array();
        $this->db->select('s.*,(SELECT COUNT(id_tracking) FROM tracking WHERE chapitre_id = `s`.`numero` AND sequence_id = `s`.`id_sequence`) AS nbConsult');
        $this->db->from($this->table_seq.' as s');
        if ($matiere != '' || $domaines != '') {
            $this->db->join($this->table.' as ls', 's.id_sequence = ls.sequence_id', 'inner');
            $this->db->join($this->table_module.' as m', 'm.sequence_id = ls.sequence_id', 'inner');
            $this->db->join($this->table_mod.' as lm', 'lm.module_id = m.module_id', 'inner');
        }

        if (is_array($ArrayIdSequence) && !empty($ArrayIdSequence) >= 1) {
            $this->db->where_in('s.id_sequence', $ArrayIdSequence);
        }

        if (isset($status) && $status != '' && $status == 3) {
            $status_array = array(3, 7);
            $this->db->where_in('s.status_url', $status_array);
        }
        elseif (isset($status) && $status != '') {
            $this->db->where('s.status_url', $status);
        }


        if ($matiere != '') {
            switch ($matiere) {
                case 1:
                    $matiereArray = array(1,5,7,8);
                    break;
                case 2:
                    $matiereArray = array(12);
                    break;
                case 3:
                    $matiereArray = array(11,14,15,16);
                    break;
                case 4:
                    $matiereArray = array(13);
                    break;
                
                default:
                    // code...
                    break;
            }

            $this->db->where_in('lm.matiere_id', $matiereArray);
        }


        if ($domaines != '') {
            $this->db->where('lm.domaine_id', $domaines);
        }

        $this->db->where('s.type !=', 0);
        $this->db->where_not_in('s.titre', $title_array);
        if (isset($nbconsult) && $nbconsult == 1) {
            $this->db->order_by('nbConsult', 'ASC');
        }
        elseif (isset($nbconsult) && $nbconsult == 2) {
            $this->db->order_by('nbConsult', 'DESC');
        }
        else{
            $this->db->order_by('s.id_sequence', 'DESC');
        }
        $this->db->limit($page, $segment);
        $query = $this->db->get();        
        return $query->result();
    }

    public function getCountListLinkActivityByIdSequence($matiere,$domaines,$ArrayIdSequence,$status) {
        $title_array = array('Support', 'Feuille Blanche');
        $matiereArray = array();
        $this->db->select('s.*');
        $this->db->from($this->table_seq.' as s');
        if ($matiere != '' || $domaines != '') {
            $this->db->join($this->table.' as ls', 's.id_sequence = ls.sequence_id', 'inner');
            $this->db->join($this->table_module.' as m', 'm.sequence_id = ls.sequence_id', 'inner');
            $this->db->join($this->table_mod.' as lm', 'lm.module_id = m.module_id', 'inner');
        }

        if (is_array($ArrayIdSequence) && !empty($ArrayIdSequence) >= 1) {
            $this->db->where_in('s.id_sequence', $ArrayIdSequence);
        }

        if (isset($status) && $status != '' && $status == 3) {
            $status_array = array(3, 7);
            $this->db->where_in('s.status_url', $status_array);
        }
        elseif (isset($status) && $status != '') {
            $this->db->where('s.status_url', $status);
        }


        if ($matiere != '') {
            switch ($matiere) {
                case 1:
                    $matiereArray = array(1,5,7,8);
                    break;
                case 2:
                    $matiereArray = array(12);
                    break;
                case 3:
                    $matiereArray = array(11,14,15,16);
                    break;
                case 4:
                    $matiereArray = array(13);
                    break;
                
                default:
                    // code...
                    break;
            }

            $this->db->where_in('lm.matiere_id', $matiereArray);
        }


        if ($domaines != '') {
            $this->db->where('lm.domaine_id', $domaines);
        }

        $this->db->where('s.type !=', 0);
        $this->db->where_not_in('s.titre', $title_array);
        $this->db->order_by('s.id_sequence', 'DESC');
        $query = $this->db->get();        
        return $query->num_rows();
    }

    public function readByDomaineThreeView($idd,$loc, $searchText = ''){
        $cnt = 0;
        $i = 0 ;
        $ret[$i] = array() ; 
       
        if ( $idd > 0 ) {
            $this->db->select('sequence_id,sequence_titre,repertoire,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->where('matiere_id', 0);
            if(!empty($searchText)) {
                $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
                $this->db->where($likeCriteria);
            }
            $this->db->order_by('sequence_titre', 'asc');

            $query = $this->db->get(); 
            $cnt = $query->num_rows();
            
            $result = $query->result()  ;
            foreach ($result as $res){
                $ret[$i]['id']          = $res->sequence_id;
                $ret[$i]['titre']     = $res->sequence_titre;
                $ret[$i]['repertoire'] = $res->repertoire;
                $ret[$i]['nom']   = "???????????";
                $ret[$i]['code']  = $res->code;
                $ret[$i]['domaine_id']    = $res->domaine_id;
                $ret[$i]['matiere_id']    = $res->matiere_id;
                $i++ ;
            }        
            $ret['cnt'] = $cnt;

            $this->db->select('s.sequence_id,s.sequence_titre,s.repertoire,s.auteur_id,s.code,s.domaine_id,s.matiere_id,m.name');
            $this->db->from($this->table .'  AS s');
            $this->db->join($this->table_mat .' AS m','s.matiere_id=m.matiere_id AND s.domaine_id=m.domaine_id','inner');
            $this->db->where('s.domaine_id', $idd);
            $this->db->order_by('m.name,s.sequence_titre', 'asc');
        }
        else{
            $this->db->select('s.sequence_id,s.sequence_titre,s.repertoire,s.auteur_id,s.code,s.domaine_id,s.matiere_id');
            $this->db->from($this->table .' AS s');
            $this->db->where('s.domaine_id', $idd);
            $this->db->order_by('s.sequence_titre', 'asc');
        }
   
        if(!empty($searchText)) {
            $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }

        $query1 = $this->db->get(); 
        $cnt = $query1->num_rows();
        $ret['cnt'] = $cnt;
        $result1 = $query1->result()  ;

        foreach ($result1 as $res1){
            $ret[$i]['id']      = $res1->sequence_id;
            $ret[$i]['titre']   = $res1->sequence_titre;
            $ret[$i]['repertoire'] = $res1->repertoire;
            $ret[$i]['nom']     = "???????????";
            $ret[$i]['code']    = $res1->code;
            $ret[$i]['domaine_id']  = $res1->domaine_id;
            $ret[$i]['matiere_id']  = $res1->matiere_id;
            $i++ ;
        }
        return($ret);
    }
    public function readByDomaine($idd,$loc, $searchText = '', $page, $segment){
        global $TBL ;
        
        $cnt = 0;
        $i = 0 ;
        $ret[$i] = array() ;
        //die("loc :  ".$loc. 'NATIONAL : '.NATIONAL);
        if ( $loc==NATIONAL ) {
          return ($this->readByDomaineNat($idd, $searchText = '', $page, $segment));
        } 
        else {

            $table_mat = $TBL['matiere'].($this->table==$TBL['list_sequence']?'':$TBL['srv']);
            // chargement uniquement des sequences par domaine

            if ( $idd > 0 ) {

                $this->db->select('sequence_id,sequence_titre,repertoire,auteur_id,code,domaine_id,matiere_id');
                $this->db->from($this->table);
                $this->db->where('domaine_id', $idd);
                $this->db->where('matiere_id', 0);
                if(!empty($searchText)) {
                    $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
                    $this->db->where($likeCriteria);
                }
                $this->db->order_by('sequence_titre', 'asc');
                $this->db->limit($page, $segment);

                $query = $this->db->get(); 
                $cnt = $query->num_rows();
                
                $result = $query->result()  ;
                foreach ($result as $res){
                    $ret[$i]['id']          = $res->sequence_id;
                    $ret[$i]['titre']     = $res->sequence_titre;
                    $ret[$i]['repertoire'] = $res->repertoire;
                    $ret[$i]['nom']   = "???????????";
                    $ret[$i]['code']  = $res->code;
                    $ret[$i]['domaine_id']    = $res->domaine_id;
                    $ret[$i]['matiere_id']    = $res->matiere_id;
                    $i++ ;
                }        
                $ret['cnt'] = $cnt;

                $select = 's.sequence_id,s.sequence_titre,s.repertoire,s.auteur_id,s.code,s.domaine_id,s.matiere_id,m.name';

                $from    = $this->db->from($this->table .'  AS s');
                $from   .= $this->db->from($table_mat .' AS m');
                $where   = $this->db->where('s.domaine_id', $idd);
                $where  .= $this->db->where('s.matiere_id', "m.matiere_id");
                $where  .= $this->db->where('s.domaine_id', "m.domaine_id");
                
                $orderby = $this->db->order_by('m.name', 'asc');
                $orderby.= $this->db->order_by('s.sequence_titre', 'asc');
                
            } 
            else 
            {
                $select  = 's.sequence_id,s.sequence_titre,s.repertoire,s.auteur_id,s.code,s.domaine_id,s.matiere_id';
                $from    = $this->db->from($this->table .' AS s');
                $where   = '';
                //$where   = $this->db->where('s.domaine_id', $idd);
                
                $orderby = $this->db->order_by('s.sequence_titre', 'asc');
                


            }
       
            $this->db->select($select);           
            $from;
            $where;
            if(!empty($searchText)) {
                $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
                $this->db->where($likeCriteria);
            }
            $orderby;
            $this->db->limit($page, $segment);

            $query1 = $this->db->get(); 
            $cnt = $query1->num_rows();
            $ret['cnt'] = $cnt;
            $result1 = $query1->result()  ;

            foreach ($result1 as $res1){
                $ret[$i]['id']      = $res1->sequence_id;
                $ret[$i]['titre']   = $res1->sequence_titre;
                $ret[$i]['repertoire'] = $res1->repertoire;
                $ret[$i]['nom']     = "???????????";
                $ret[$i]['code']    = $res1->code;
                $ret[$i]['domaine_id']  = $res1->domaine_id;
                $ret[$i]['matiere_id']  = $res1->matiere_id;
                $i++ ;
            }
            


        }
        
        return($ret);
    }

    public function readByDomaineCount($searchText,$idd,$loc)
    {
        global $TBL ;
        $table_mat = $TBL['matiere'].($this->table==$TBL['list_sequence']?'':$TBL['srv']);
        if ( $idd > 0 ) {
            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->where('matiere_id', 0);
            if(!empty($searchText)) {
                $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
                $this->db->where($likeCriteria);
            }
            $this->db->order_by('sequence_titre', 'asc');
        }
        else{
            $this->db->select('*');
            $this->db->from($this->table .'  AS s');
            $this->db->where('s.domaine_id', $idd);
            if(!empty($searchText)) {
                $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
                $this->db->where($likeCriteria);
            }
            $this->db->order_by('s.sequence_titre', 'asc');

        }

        $query = $this->db->get(); 
        return count($query->result());
    }


    public function readByDomaineNat($idd, $searchText = '', $page, $segment) {
       
        $ret = array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        $table_mat = 'matiere';

        // chargement uniquement des sequences par domaine
        if ( $idd > 0) {

            // recuperer les matieres > 0

            $this->db->select('sequence_id,sequence_titre,repertoire,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->where('matiere_id', 0);
            if(!empty($searchText)) {
                $likeCriteria = "(sequence_titre  LIKE '%".$searchText."%')";
                $this->db->where($likeCriteria);
            }
            $this->db->limit($page, $segment);
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ;
            foreach ($result as $res){
                $ret[$i]['module']      = trim($this->readModuleNat($res->sequence_id));
                $ret[$i]['titre']   = $res->sequence_titre;
                $ret[$i]['id']          = $res->sequence_id;
                $ret[$i]['repertoire'] = $res->repertoire;
                $ret[$i]['nom']     = "???????????";
                $ret[$i]['code']    = $res->code;
                $ret[$i]['domaine_id']  = $res->domaine_id;
                $ret[$i]['matiere_id']  = 0;
                $ret[$i]['matiere_name']= ""; 
                $i++ ;
            }
            
            $select = "s.sequence_id,s.sequence_titre,s.repertoire,s.auteur_id,s.code,s.domaine_id,s.matiere_id,m.name "   ; 
            $select1 = "m.name AS namtierename"   ;                       
            $from    = $this->db->from($this->table .' AS s');
            $from   .= $this->db->from($table_mat .' AS m');
            $where   = $this->db->where('s.domaine_id', $idd);
            $where  .= $this->db->where('s.matiere_id', "m.matiere_id");
            $where  .= $this->db->where('s.domaine_id', "m.domaine_id");
            if(!empty($searchText)) {
                $likeCriteria = "(s.sequence_titre  LIKE '%".$searchText."%')";
                $where  .= $this->db->where($likeCriteria);
            }
            $orderby = "";
            $limit  = $this->db->limit($page, $segment);
           
          
        }
        else {

            $select  = 's.sequence_id,s.sequence_titre,s.repertoire,s.auteur_id,s.code,s.domaine_id,s.matiere_id ';
            $select1 = "'' AS namtierename"   ;   
            $from    = $this->db->from($this->table .' AS s');
            $where   = $this->db->where('s.domaine_id', $idd);
            if(!empty($searchText)) {
                $likeCriteria = "(s.sequence_titre  LIKE '%".$searchText."%')";
                $where  .= $this->db->where($likeCriteria);
            }
            $orderby = "";
            $limit   = $this->db->limit($page, $segment);
     
        }

        $this->db->select($select);
        $this->db->select($select1);
        $from;
        $where;
        $orderby;
        $limit;
        $query1 = $this->db->get(); 
        $ret['cnt'] = $query1->num_rows();
        $result1 = $query1->result()  ;

        foreach ($result1 as $res1){
        
            $ret[$i]['module']  = trim($this->readModuleNat($res1->sequence_id));
            $ret[$i]['titre']   = $res1->sequence_titre;
            $ret[$i]['id']      = $res1->sequence_id;
            $ret[$i]['repertoire'] = $res1->repertoire;
            $ret[$i]['nom']     = "???????????";
            $ret[$i]['code']    = $res1->code;
            $ret[$i]['domaine_id']  = $res1->domaine_id;
            $ret[$i]['matiere_id']  = $res1->matiere_id;
            $ret[$i]['namtierename']= $res1->namtierename;
            $i++ ;
        }

        foreach($ret as $res) {
             $sortAux1[] = strtolower($res['namtierename']);
             $sortAux2[] = strtolower($res['module']);
             $sortAux3[] = strtolower($res['titre']);
        }

        array_multisort($sortAux1, SORT_ASC, SORT_STRING,
                        $sortAux2, SORT_ASC, SORT_STRING,
                        $sortAux3, SORT_ASC, SORT_STRING,
                        $ret);

        return($ret);
    }

    public function readModuleNat($ids) {  
        $this->db->select('lm.module_titre');
        $this->db->from("module AS m");
        $this->db->from("list_module AS lm");
        $this->db->where('lm.module_id', "m.module_id");
        $this->db->where('m.sequence_id', $ids);
        $this->db->where('m.type', 0);
        $this->db->where('m.loc', 0);
        $query = $this->db->get(); 
        $row= $query->num_rows();
        $result = $query->result()  ;
        /*foreach ($result as $res){

        }*/
        switch ($row) {
            case 0 : 
                return("_"); 
            break;
            case array($result) : $result;
            //case 1 : $result;
                return($result); 
            break;
        default :
            return("!!!!"); 
            break;
        }
    }


    public function del($id) {
        $this->db->where('sequence_id', $id);
        $this->db->delete($this->table);

        $this->db->where('id_sequence', $id);
        $this->db->delete($this->table_seq);   

        return true;     
    }

    public function deleteActivityByIdSequenceNumero($idSequence,$numero){
        $this->db->where('id_sequence', $idSequence);
        $this->db->where('numero', $numero);
        $this->db->delete($this->table_seq);   

        return true;     
    }

    public function getInfoListSequenceById($sequence_id) {

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('sequence_id', $sequence_id);      
        $query = $this->db->get(); 
        $row= $query->num_rows();
        $result = $query->result()  ;
        foreach ($result as $res){
            $ret['sequence_id']          = $res->sequence_id;
            $ret['sequence_titre']       = $res->sequence_titre;
            $ret['sequence_objectifs']   = $res->sequence_objectifs;
            $ret['sequence_duree']       = $res->sequence_duree;
            $ret['auteur_id']            = $res->auteur_id   ;
            $ret['code']                 = $res->code     ;
            $ret['domaine_id']           = $res->domaine_id     ;
            $ret['matiere_id']           = $res->matiere_id     ;
        }
        return($ret);

    }


    public function Info($ids) {

        $this->db->select('sequence_id,sequence_titre,sequence_objectifs,sequence_duree,auteur_id,code,domaine_id,matiere_id');
        $this->db->from($this->table);
        $this->db->where('sequence_id', $ids);
      
        $query = $this->db->get(); 
        $row= $query->num_rows();
        $result = $query->result()  ;
        foreach ($result as $res){
            $ret['id']          = $res->sequence_id;
            $ret['titre']       = $res->sequence_titre;
            $ret['objectifs']   = $res->sequence_objectifs;
            $ret['duree']       = $res->sequence_duree;
            $ret['auteur']      = $res->auteur_id   ;
            $ret['code']        = $res->code     ;
            $ret['domaine_id']  = $res->domaine_id     ;
            $ret['matiere_id']  = $res->matiere_id     ;
        }
        return($ret);

    }

    public function listeTypeActivite(){
        $lgrp = array();
        $lgrp[] = array('name'=>$this->type(TITRE),         'id'=>TITRE);
        $lgrp[] = array('name'=>$this->type(DOCUMENT),      'id'=>DOCUMENT);
        $lgrp[] = array('name'=>$this->type(QUIZZ_GANESHA), 'id'=>QUIZZ_GANESHA);
        $lgrp[] = array('name'=>$this->type(CHAPITRE_LU),   'id'=>CHAPITRE_LU);
        $lgrp[] = array('name'=>$this->type(QUIZZ_AICC),    'id'=>QUIZZ_AICC);
        $lgrp[] = array('name'=>$this->type(QUIZZ_SCORM),   'id'=>QUIZZ_SCORM);
        $lgrp[] = array('name'=>$this->type(QUIZZ_SCORM_WS),'id'=>QUIZZ_SCORM_WS);
        $lgrp[] = array('name'=>$this->type(IMCOS_BI),'id'=>IMCOS_BI);  // 1.20.2 
        $lgrp[] = array('name'=>$this->type(STAGIAIRE_LINK),'id'=>STAGIAIRE_LINK);  // 1.20.5
        return($lgrp);
    }


    public function readSequence($ids,$loc='',$numero=NULL) {
        $this->load->model('tracking_model');
        $i = 0 ;
        $ret = Array() ;
        $this->db->select('id_sequence,titre,numero,link,type,id_scorm,mastery,max_time,description,keyword,prerequis,niveau,launch,regroupe,thumbnail_file,status');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $ids);
        if ($numero != NULL || $numero != "") {
            $this->db->where('numero', $numero);
        }
        $this->db->where('numero !=', 0);
        $this->db->where('titre !=', '');
        $this->db->group_by('numero');
        $this->db->order_by('numero', 'asc');
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;
        if ($ret['cnt'] >= 1) {
            
            foreach ($result as $res){
                $status_url = array();
                switch ($res->status) {
                  case 1:
                    $status_url = array(
                        'infos' => 'Normale',
                        'color' => 'text-green',
                    );
                    break;
                  case 2:
                    $status_url = array(
                        'infos' => 'Sécurisé',
                        'color' => 'text-bue',
                    );
                    break;
                  case 3:
                    $status_url = array(
                        'infos' => 'Introuvable',
                        'color' => 'text-pink',
                    );
                    break;
                  case 4:
                    $status_url = array(
                        'infos' => 'Insécurisé',
                        'color' => 'text-blue',
                    );
                    break;
                  case 5:
                    $status_url = array(
                        'infos' => 'Vide',
                        'color' => 'text-pink',
                    );
                    break;
                  case 6:
                    $status_url = array(
                        //'infos' => 'En-tête de réponse faux (possibilité de contenu mixte)',
                        'infos' => 'Introuvable',
                        'color' => 'text-pink',
                    );
                    break;
                  case 7:
                    $status_url = array(
                        'infos' => 'Introuvable',
                        'color' => 'text-pink',
                    );
                    break;
                  default:
                    # code...
                    break;
                }

                $ret[$i]['titre']           = $res->titre   ;
                $ret[$i]['numero']          = $res->numero ;
                $ret[$i]['link']            = $res->link   ;
                $ret[$i]['type']            = $res->type   ;
                $ret[$i]['id_scorm']        = $res->id_scorm  ;
                $ret[$i]['mastery']         = $res->mastery ;
                $ret[$i]['max_time']        = $res->max_time    ;
                $ret[$i]['description']     = $res->description ;
                $ret[$i]['keyword']         = $res->keyword ;
                $ret[$i]['prerequis']       = $res->prerequis  ;
                $ret[$i]['niveau']          = $res->niveau ;
                $ret[$i]['launch']          = $res->launch;
                $ret[$i]['regroupe']        = $res->regroupe ;
                $ret[$i]['id_sequence']     = $res->id_sequence ;
                $ret[$i]['thumbnail']       = $res->thumbnail_file ;
                $ret[$i]['status']          = $status_url ;
                $ret[$i]['dernierclick']    = $this->tracking_model->getDateLastConsultByIdSequenceAndNummero($res->id_sequence,$res->numero) == null ? 0 : $this->tracking_model->getDateLastConsultByIdSequenceAndNummero($res->id_sequence,$res->numero) ;
                $ret[$i]['nbconsult']       = $this->tracking_model->getNbConsultsByIdNum($res->id_sequence,$res->numero) == null ? 0 : $this->tracking_model->getNbConsultsByIdNum($res->id_sequence,$res->numero) ;
                $ret[$i]['thumbnailLink']   = ($res->thumbnail_file != '' && file_exists(REP_ACTIVITY_SEQUENCE.$res->thumbnail_file)) ? HTTP_ACTIVITY_SEQUENCE.$res->thumbnail_file : HTTP_MAIN.'groupes/default.png' ;
                $i++ ;
            }
        }
        return($ret);
    }

     public function addContentSequence($arrayData) {
        $this->db->trans_start();
        $this->db->insert($this->table_seq, $arrayData);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

    }

    public function addChapitre($idm,$additionalData) {
        $numero = $this->getMaxNum($idm);
        $this->db->where('id_sequence', $idm);
        $this->db->where('numero', $numero);
        $this->db->delete($this->table_seq); 
  
        $this->db->trans_start();
        $this->db->insert($this->table_seq, $additionalData);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

    }
    public function getMaxNum($idm){
        $this->db->select('MAX(numero) AS numMax');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idm);
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            return ($this->IsInt($res->numMax) ? $res->numMax+1 : 1 );
        }
    }

    public function IsInt($x) {
       return ( is_numeric ($x) ?  intval(0+$x ) ==  $x  :  false );
    }

    public function type($val) {
        global $NORME_TITRE ;
        return (isset($NORME_TITRE[$val])?$NORME_TITRE[$val]:'&nbsp;');
    }

    public function Title($ids,$loc='') {
        $this->db->select('sequence_titre');
        $this->db->from($this->table);
        $this->db->where('sequence_id', $ids);
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            return ($res->sequence_titre);
        }
    }

    public function addauthor($id,$info){    
        $this->db->where('sequence_id', $id);     
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function Support($idm) {
        $ret = "";
        $this->db->select('link');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idm);
        $this->db->where('numero', 0);      
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            $ret .= $res->link;
        }
        return($ret);

    }
    public function getNameById($idSequence) {
        $ret = "";
        $this->db->select('sequence_titre');
        $this->db->from($this->table);
        $this->db->where('sequence_id', $idSequence);      
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            $ret .= $res->sequence_titre;
        }
        return($ret);

    }

    public function update($idm,$titre,$code,$aut,$support,$objectifs,$duree) {
        if ( trim($code) == '' ) {
            $code = "S".($idm < 10 ? '0'.$idm : $idm) ;
        }

        $infoupdate = array("sequence_titre"=>$titre,"sequence_objectifs"=>$objectifs,"sequence_duree"=>$duree,"code"=>$code);
        //$infoupdate = array("sequence_titre"=>$titre,"sequence_objectifs"=>$objectifs,"sequence_duree"=>$duree,"auteur_id"=>$aut,"code"=>$code);
        $this->db->where('sequence_id', $idm);
        $this->db->update($this->table, $infoupdate);
        $this->db->affected_rows();

        $infoupdates = array("link"=>$support,"type"=>2);
        $this->db->where('numero', 0);
        $this->db->where('id_sequence', $idm);
        $this->db->update($this->table_seq, $infoupdates);
        $this->db->affected_rows();
        return ($idm);
    }

    public function add($titre,$code,$aut,$support,$objectifs,$duree) {
        global $db, $ad_texte ;

        $seqinfo = array("sequence_titre"=>$titre,"sequence_objectifs"=>$objectifs,"sequence_duree"=>$duree,"code"=>$code,'auteur_id'=>$aut);
        $this->db->trans_start();
        $this->db->insert($this->table, $seqinfo);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();


        $this->db->select('MAX(sequence_id) AS idMax');
        $this->db->from($this->table);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $idm  = $res->idMax ;
           
        }

        if (isset($idm)) {
            if ( trim($code) == '' ) {
                //$code = SEQ_CODE.($idm < 10 ? '0'.$idm : $idm) ;
                $code = "S".($idm < 10 ? '0'.$idm : $idm) ;

                $infoupdate = array("code"=>$code);
                $this->db->where('sequence_id', $idm);
                $this->db->update($this->table, $infoupdate);
                $this->db->affected_rows();
            }

            $this->db->where('id_sequence', $idm);
            $this->db->delete($this->table_seq);   

            $seqinfos = array("id_sequence"=>$idm,"titre"=>"Support","numero"=>0,"link"=>$support,'type'=>1);
           
            $this->db->trans_start();
            $this->db->insert($this->table_seq, $seqinfos);        
            $id = $this->db->insert_id();        
            $this->db->trans_complete();

            return $idm;
        }

    }

    public function addSequenceList($arrayData) {
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;

    }

    public function getNextCodeFormListSequence(){
        $ret = "S";
        $this->db->select('MAX(sequence_id) AS maxIdSequence');
        $this->db->from($this->table);
        $query = $this->db->get();
        $result = $query->result();      
        return ($result[0]->maxIdSequence + 1);
    }

    public function delDomaine($idd) {
        $info = array("matiere_id"=>0,"domaine_id"=>0);
        $this->db->where('domaine_id', $idd);
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function delMatiere($idm) {
        $info = array("matiere_id"=>0);
        $this->db->where('matiere_id', $idm);
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function updateMatiereDomaine($idm,$idd,$loc=-1) {

        $table = $this->table ;
        if ( $loc == -1 ) {
          $table = $loc==LOCAL?'list_sequence':'list_sequence_srv';
        }        
        $info = array("domaine_id"=>$idd);
        $this->db->where('matiere_id', $idm);
        $this->db->update($table, $info);
        $this->db->affected_rows();
    }

    public function updateChapitre($idSequence,$numero,$activityInfo){    
        $this->db->where('id_sequence', $idSequence);
        $this->db->where('numero', $numero);
        $this->db->update($this->table_seq, $activityInfo);
        $this->db->affected_rows();
    }

    public function getSequenceTitreById($idSequence) {
        $this->db->select('sequence_titre');
        $this->db->from($this->table);
        $this->db->where('sequence_id', $idSequence);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            return $res->sequence_titre ;
           
        }
    }
    public function getExerciceByChapitreSequence($idChapitre,$idSequence) {
        $this->db->select('titre');
        $this->db->from($this->table_seq);
        $this->db->where('numero', $idChapitre);
        $this->db->where('id_sequence', $idSequence);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            return $res->titre ;
           
        }
    }

    public function getThumbFromLastSequence($idSequence){
        $this->db->select('thumbnail_file');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idSequence);
        $this->db->where('thumbnail_file !=', '');
        $this->db->order_by('numero','desc');
        $this->db->limit(1);
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            return $res->thumbnail_file ;
        }
    }

    public function sequenceInfo($ids,$numero) {

        $this->db->select('*');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $ids);
        $this->db->where('numero', $numero);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllLink() {

        $this->db->select('*');
        $this->db->from($this->table_seq);
        $this->db->where('final_url !=', "");
        $this->db->group_by('id_sequence,numero');
        $this->db->order_by('id_sequence', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getListResults() {

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('sequence_titre','ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllById($idSequence) {

        $this->db->select('*');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idSequence);
        $this->db->where('titre !=', '');
        $this->db->where('link !=', '');
        $this->db->order_by('id_sequence', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllByIdToExport($idSequence) {
        $title_array = array('Support', 'Feuille Blanche');
        $this->db->select('*');
        $this->db->from($this->table_seq);
        $this->db->where('id_sequence', $idSequence);
        $this->db->where('link !=', '');
        $this->db->where('type !=', 0);
        $this->db->where_not_in('titre', $title_array);
        $this->db->order_by('id_sequence', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
}

?>
