$(document).ready(function(){
   

    var listExpression = $('#expressionDatabank').DataTable({
    });

    $('.statDate').datepicker({
        format: "dd/mm/yyyy",
    });
    $('.endDate').datepicker({
        format: "dd/mm/yyyy",
    });
    var normalizeDate = function(dateString) {

        //var correctFormat = dateString;
        var correctFormat = dateString.replace(/(\d+)\/(\d+)\/(\d+)/, "$3/$2/$1");
        var date = new Date(correctFormat);
        var normalized = date.getFullYear() + '' + (("0" + (date.getMonth() + 1)).slice(-2)) + '' + ("0" + date.getDate()).slice(-2);

        return normalized;
    }

    var filterByDate = function(column, startDate, endDate) {

        $.fn.dataTable.ext.search.push(
            function(oSettings, aData, iDataIndex) {
                var rowDate = normalizeDate(aData[column]);
                var start = normalizeDate(startDate);
                var end = normalizeDate(endDate);

                console.log('start : '+start + ' end ' + end + ' rowDate : ' + rowDate);

                // If our date from the row is between the start and end
                if (start <= rowDate && rowDate <= end) {
                    return true;
                } else if (rowDate >= start && end === '' && start !== '') {
                    return true;
                } else if (rowDate <= end && start === '' && end !== '') {
                    return true;
                } else {
                    return false;
                }
            }
        );
    };

    $('#filter').on('click', function(e) {
        e.preventDefault();
        var startDate = $('.statDate').val();
        var endDate = $('.endDate').val();
        var linkExport = $('#exportData').attr('href');
        $('#exportData').attr('href', linkExport + "&date_debut=" + startDate + "&date_fin=" + endDate);
        filterByDate(6, startDate, endDate);

        listExpression.draw();
    });
    $('#filterExpressionDatabank').on('click', function(e) {
        e.preventDefault();
        var startDate = $('.statDate').val();
        var endDate = $('.endDate').val();
        var linkExport = $('#export-expression').attr('href');
        $('#export-expression').attr('href', linkExport + "&date_debut=" + startDate + "&date_fin=" + endDate);
        filterByDate(7, startDate, endDate);

        listExpression.draw();
    });
    $('#clearFilter').on('click', function(e) {
        e.preventDefault();
        $.fn.dataTableExt.afnFiltering.length = 0;
        listExpression.draw();

    });

    $('.btn-add-expression').click(function(e){
        e.preventDefault();
        $('#form-new-expression').attr('action',$('#form-new-expression').attr('action').replace("addexpression", "addexpression"));
        $('.modal-title').text('New expression');
        $('#text_langage_origin').val("");
        $('#text_langage_cible').val("");
        $('.idExpression').val("");
        $('#target_langue_cible option').each(function(){
            $(this).removeAttr('selected');
        });
        $('#modal_elearning').modal();
    });
    $('.category_bddl').change(function() {
      $('.category_choice').val($(this).val());
      $('.category_choice').attr('data-exist','verif');
      $('.category_choice').attr('data-intitule',$(this).find(":selected").text());
    });

    $('.category_expression_el').change(function() {
      $('.category_choice').val($(this).val());
      $('.category_choice').attr('data-exist','exist');
      $('.category_choice').attr('data-intitule',$(this).find(":selected").text());
    });
    $('.btn-save-expression').click(function(e){
        e.preventDefault();
        var btn = $(this);
        $(".loader-nl").addClass('nl_action_loader');
        var dataExpression=$("#form-new-expression").serializeArray();
        var dataExpressionjson = {};
        var category_theme;
        var id_theme
        for (i in dataExpression) {
            dataExpressionjson[dataExpression[i].name] = dataExpression[i].value;
        }
        dataExpression=dataExpressionjson;  
        var notification = "";
        if ($('.idExpression').val() != '') {
            notification += "Edition succefule";
        }
        else{
            notification += "Expression add succefuly";
        }

        var intitle_theme   = $( ".category_choice").attr('data-intitule');
        var exist_theme     = $( ".category_choice").attr('data-exist');

        if (exist_theme == "") {
          id_theme        = $('.category_expression_el').find(":selected").val();
        }
        else{
          id_theme        = $( ".category_choice").val();
        }

        $.ajax({
          type: "POST",
          url: $("#form-new-expression").attr('action'),
          data:  {"dataExpression": dataExpression, 'id_theme' : id_theme, 'intitle_theme' : intitle_theme, 'exist_theme' : exist_theme},
          success: function( data ) {
            var ret = data.split('##');
            if ($('.idExpression').val() != '') {
              $('.expression_id').each(function(){
                if ($(this).val() == $('.idExpression').val()) {
                  console.log(dataExpression);
                  $(this).attr('data-owner',dataExpression['owner_expression']);
                  $(this).attr('data-origin',dataExpression['text_langage_origin']);
                  $(this).attr('data-cible',dataExpression['text_langage_cible']);
                  $(this).attr('data-lang-tr',$('#target_langue_cible').find("option:selected").text());
                  $(this).attr('data-theme-id',ret[1]);
                  $(this).attr('data-theme',ret[2]);
                  $(this).attr('data-env-id',dataExpression['environnement_usage']);
                  $(this).attr('data-env',$('#environnement_usage').find("option:selected").text());

                  $(this).parents('.class-action-checkbox').parents('.line_data_expr').find('.c_origin').text(dataExpression['text_langage_origin']);
                  $(this).parents('.class-action-checkbox').parents('.line_data_expr').find('.l_cible').text($('#target_langue_cible').find("option:selected").text());
                  $(this).parents('.class-action-checkbox').parents('.line_data_expr').find('.c_cible').text(dataExpression['text_langage_cible']);

                  btn.attr('data-env',$('#environnement_usage').find("option:selected").text());
                  btn.attr('data-theme-id',ret[1]);
                  btn.attr('data-owne',dataExpression['owner_expression']);
                }
              });
            }
            $('.btn-close-modal').click();
            $('.notification').html("<p class='notifyOwrner'>"+notification+"</p>");
            $('.notification').show('slow');
            setTimeout("$('.notification').hide('slow')",3000); 
            listExpression.draw(); 
            $(".loader-nl").removeClass('nl_action_loader');
          }
        });
    });

    $('.export-expression').on('click', function() {
        //number of filtered rows
        var datas = [];
        var result = listExpression.rows({ filter: 'applied' }).data();
        var i = 0;
        result.each(function(key, value) {
            datas[i] = key;
            i++;
        });
        var url = $('.baseURL').val()+'exportexpression';
        $(".loader-nl").addClass('nl_action_loader');
        $.ajax({
            type: "POST",
            url: url,
            data: { json: JSON.stringify(datas) },
            dataType: 'json',
            success: function(data, statut) {
                /*console.log(data);
                console.log(statut);*/
            },
            complete: function(data) {
                $(".loader-nl").removeClass('nl_action_loader');
                //console.log(data);
                var contentType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
                var csvFile = new Blob([data.responseText], { type: contentType });
                var downloadUrl = window.URL.createObjectURL(csvFile);
                var a = document.createElement("a");
                a.href = downloadUrl;
                a.download = "export_expression.xls";
                document.body.appendChild(a);
                a.click();

            },
            error: function(data, statut, erreur) {

                console.log(erreur);
            }
        });
    });
    var rows_selected = [];
    $('#expressionDatabank tbody').on('click', 'input[type="checkbox"]', function(e){
      var $row = $(this).closest('tr');

      // Get row data
      var data = listExpression.row($row).data();


      // Get row ID
      var rowId = data;

      // Determine whether row ID is in the list of selected row IDs
      var index = $.inArray(rowId, rows_selected);

      // If checkbox is checked and row ID is not in list of selected row IDs
      if(this.checked && index === -1){
         rows_selected.push(rowId);

      // Otherwise, if checkbox is not checked and row ID is in list of selected row IDs
      } else if (!this.checked && index !== -1){
         rows_selected.splice(index, 1);
      }

      if(this.checked){
         $row.addClass('selected');
      } else {
         $row.removeClass('selected');
      }

      // Update state of "Select all" control
      updateDataTableSelectAllCtrl(listExpression);

      // Prevent click event from propagating to parent
      e.stopPropagation();
    });
    $('thead input[name="select_all"]', listExpression.table().container()).on('click', function(e){
      if(this.checked){
         $('#expressionDatabank tbody input[type="checkbox"]:not(:checked)').trigger('click');
      } else {
         $('#expressionDatabank tbody input[type="checkbox"]:checked').trigger('click');
      }
      e.stopPropagation();
    });
    /*$('.expression_id').each(function(){
      var checkbox = $(this);
      var data_usage = {};
      $('#environnement_usage option').each(function(){
        data_usage['id'] = $(this).val();
        data_usage['libelle'] = $(this).text();
        if ($(this).val() === checkbox.attr('data-env-id')) {
          //console.log('text : ' + txt + 'id : ' + id + ' env id : ' + checkbox.attr('data-env-id'));
          //checkbox.attr('data-env',$(this).text());
        }
      });
      console.log(data_usage);
    });*/
    $('.validate').click(function(e){
        e.preventDefault();
        var ajax_url = $(this).attr('data-url');

        var data = {};
        
        $('.expression_id').each(function(index){
          var checkbox = $(this);
            if (checkbox.is(':checked')) {
                data[index]= {
                    "id_checkbox" : checkbox.attr('id'),
                    "owner" : checkbox.attr('data-owner'),
                    "origin" : checkbox.attr('data-origin'),
                    "cible": checkbox.attr('data-cible'),
                    "lang_tr" : checkbox.attr('data-lang-tr'),
                    "id"      : checkbox.val(),
                    "theme_id" : checkbox.attr('data-theme-id'),
                    "theme" :  checkbox.attr('data-theme'),
                    "theme_eng": "",
                    "environnement_usage": checkbox.attr('data-env'),
                    "environnement_usage_id": checkbox.attr('data-env-id'),
                    "nom_stagiaire" : checkbox.attr('data-trainee-name'),
                    "prototype" : "Prototype de "+checkbox.attr('data-trainee-name')
                };
           }

        });
        $.ajax({
            type: "POST",
            url: ajax_url+'/prototypes/insert-terme',
            data: {  json : JSON.stringify(data)} ,
            dataType: 'json',
            success: function(data) {
                //aprés retour WS , on met en dessous la function validateExpression(checkbox,data)
                $(".loader-nl").removeClass('nl_action_loader');
                //console.log(data);
                $.each(data,function(index){
                    console.log(index);
                      if(data[index].prototypes.status == 200 && data[index].prototypes.prototype == "ok"){
                         validateExpression(data[index].prototypes.checkbox,data[index].prototypes);
                     }
                });
            }
        });
    });


   // Handle table draw event
   listExpression.on('draw', function(){
      // Update state of "Select all" control
      updateDataTableSelectAllCtrl(listExpression);
   });

  /* $('#expressionDatabank').each(function(){
    $.ajax({
      url : $('.baseURL').val()+'get-theme-bddl',
      type : 'GET',  
      success : function(data){
        $('#theme_id').html(data);
      }
    });
   });*/
   $('.btn-add-theme-bddl').click(function(e){
    e.preventDefault();
    $(this).hide();
    $('.category_expression_el').hide();
    $('.category_bddl').show();
    $('.btn-cancel-category-bddl').show();
    $('.category_expression_el option').each(function(){
      $(this).removeAttr('selected');
    });
   });
   $('.btn-cancel-category-bddl').click(function(e){
    e.preventDefault();
    $(this).hide();
    $('.category_expression_el').show();
    $('.category_bddl').hide();
    $('.btn-add-theme-bddl').show();    
    $('.category_bddl option').each(function(){
      $(this).removeAttr('selected');
    });
   });
});

function validateExpression(checkboxchecked,jsondata){

  $.ajax({
      type: "POST",
      url: $('.baseURL').val()+'valide-expression',
      data: jsondata,
      dataType: 'json',
      success: function(data) {
          console.log('ato');
       /* checkboxchecked.parents('.class-action-checkbox').parents('.line_data_expr').find('.status_validate').html('<span class="valide-cls">'+data['status']+'</span>');
        checkboxchecked.parents('.class-action-checkbox').parents('.line_data_expr').find('.producer_validation').text(data['producteur']);
        checkboxchecked.parents('.class-action-checkbox').parents('.line_data_expr').find('.date_validation').text(data['date_validation']); */

       $('#'+checkboxchecked).parents('.class-action-checkbox').parents('.line_data_expr').find('.status_validate').html('<span class="valide-cls">'+data['status']+'</span>');
          $('#'+checkboxchecked).parents('.class-action-checkbox').parents('.line_data_expr').find('.producer_validation').text(data['producteur']);
          $('#'+checkboxchecked).parents('.class-action-checkbox').parents('.line_data_expr').find('.date_validation').text(data['date_validation']);
      }
  });
}

function deleteExpression(lien ,idExpression){
	var qst     = confirm("Are you sure to delete this");
	var url = $('.baseURL').val()+'deletedb';
   	if (qst) {
        $.ajax({
            url : url,
            type : 'POST',
            data : {"id" : idExpression},    
            success : function(data){
                $('.notification').html("<p class='notifyOwrner'>Data delete succefuly</p>");
                $('.notification').show('slow');
                setTimeout("$('.notification').hide('slow')",3000);  
                $(this).css("opacity","1");
                $(lien).parents('td').parents('.line_data_expr').remove();
            }
        });
    } 
}

function editExpression(lien ,idExpression){
    $('.category_expression_el').empty();
    var origin = $(lien).parents('td').parents('.line_data_expr').find('.c_origin').text();
    var cible  = $(lien).parents('td').parents('.line_data_expr').find('.c_cible').text();
    var l_cible= $(lien).parents('td').parents('.line_data_expr').find('.l_cible').text();
    var ownerId= $(lien).attr('data-owner');
    var theme= $(lien).attr('data-theme-id');
    var env= $(lien).attr('data-env');
    var ownerName= $(lien).parents('td').parents('.line_data_expr').find('.owner_name').text();
    $('#form-new-expression').attr('action',$('#form-new-expression').attr('action').replace("addexpression", "editexpressionAdmin"));
    $('.modal-title').text('Edition expression');
    $('#text_langage_origin').val(origin);
    $('#text_langage_cible').val(cible);
    $('.idExpression').val(idExpression);
    $('#target_langue_cible option').each(function(){
        $(this).removeAttr('selected');
        if (l_cible == $(this).text()) {
            $(this).attr('selected','selected');
        }
    });
    //console.log('env : ' + env);

    $('#environnement_usage option').each(function(){
        $(this).removeAttr('selected');
        if (env == $(this).text()) {
            $(this).attr('selected','selected');
        }
    });


    $('#owner_expression').val(ownerId);
    //$('#owner_expression').attr('data-id',ownerId);

    $.ajax({
        url : $('.baseURL').val()+'get-cat-expression',
        type : 'POST',
        data : {"id" : idExpression, 'theme_cuurent' : theme},    
        success : function(data){
            $('.category_expression_el').append(data);
        }
    });
    
    $('#modal_elearning').modal();
}
function updateDataTableSelectAllCtrl(table){
   var $table             = table.table().node();
   var $chkbox_all        = $('tbody input[type="checkbox"]', $table);
   var $chkbox_checked    = $('tbody input[type="checkbox"]:checked', $table);
   var chkbox_select_all  = $('thead input[name="select_all"]', $table).get(0);

   // If none of the checkboxes are checked
   if($chkbox_checked.length === 0){
      chkbox_select_all.checked = false;
      if('indeterminate' in chkbox_select_all){
         chkbox_select_all.indeterminate = false;
      }

         $('.translate').hide();
        $('.validate').hide();

   // If all of the checkboxes are checked
   } else if ($chkbox_checked.length === $chkbox_all.length){
      chkbox_select_all.checked = true;
      if('indeterminate' in chkbox_select_all){
         chkbox_select_all.indeterminate = false;
      }

   // If some of the checkboxes are checked
   } else {
      chkbox_select_all.checked = true;
      if('indeterminate' in chkbox_select_all){
         chkbox_select_all.indeterminate = true;
      }
        $('.translate').hide();
        $('.validate').show();
   }
}
