$(function () {
    $('#passwordAction').click(function(e){
        var btn = $(this);
        e.preventDefault();
        var action          = $('#passwordFonction').val();
        var decryptPassword = btn.attr('data-decrypt');
        var cryptPassword   = $('#password').val();
        $('#password').val('');
        console.log(action);
        if (action === 'off') {
            $('#password').attr('type','text');
            $('#password').val(decryptPassword);
            $('#passwordFonction').val('on');
            btn.html('<i class="glyphicon glyphicon-eye-open" style="font-size: 28px;"></i>');
        }
        else{
            $('#password').attr('type','password');
            $('#password').val(cryptPassword);
            $('#passwordFonction').val('off');
            btn.html('<i class="glyphicon glyphicon-eye-close" style="font-size: 28px;"></i>');
        }
    });
    $('.list-group-item').on('mouseover', function(event) {
      event.preventDefault();
      $(this).closest('li').addClass('open');
    });
    $('.list-group-item').on('mouseout', function(event) {
        event.preventDefault();
      $(this).closest('li').removeClass('open');
    });
    // Create the close button
    var closebtn = $('<button/>', {
        type:"button",
        text: 'x',
        id: 'close-preview',
        style: 'font-size: initial;',
    });
    closebtn.attr("class","close pull-right");
    // Set the popover default content
    $('.image-preview').popover({
        trigger:'manual',
        html:true,
        title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
        content: "There's no image",
        placement:'bottom'
    });
    // Clear event
    $('.image-preview-clear').click(function(){
        $('.image-preview').attr("data-content","").popover('hide');
        $('.image-preview-filename').val("");
        $('.image-preview-clear').hide();
        $('.image-preview-input input:file').val("");
        $(".image-preview-input-title").text("Browse"); 
    }); 
    // Create the preview image
    $(".image-preview-input input:file").change(function (){     
        var img = $('<img/>', {
            id: 'dynamic',
            width:250,
            height:200
        });      
        var file = this.files[0];
        var reader = new FileReader();
        // Set preview image into the popover data-content
        reader.onload = function (e) {
            $(".image-preview-input-title").text("Change");
            $(".image-preview-clear").show();
            $(".image-preview-filename").val(file.name);            
            img.attr('src', e.target.result);
            $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
        }        
        reader.readAsDataURL(file);
    });

    $('.choice_access').click(function(){
        if ($(this).val() == 1) {
            $('.container-date-choice').removeClass('bo-d-none');
        }
        else{
            $('.container-date-choice').addClass('bo-d-none');
        }
    });  

    $('#form-edit-user-groups').on('submit',function(e){
        e.preventDefault();
        $('.spinner').fadeIn('slow');
        $.ajax({
            type: $(this).attr('method'),
            url:  $(this).attr('action'),
            data:  new FormData(this),            
            contentType: false,
            cache: false,
            processData:false,
            dataType: 'json',
            success: function(data){
                $('.spinner').fadeOut('slow');
                $('#select-user-group').removeClass('open');
                toastr.success('Données enregister avec succés');
                location.reload();
            }
        });
    }); 
});
$(document).on('click', '#close-preview', function(){ 
  $('.image-preview').popover('hide');
  // Hover befor close the preview
  $('.image-preview').hover(
      function () {
         $('.image-preview').popover('show');
      }, 
       function () {
         $('.image-preview').popover('hide');
      }
  );    
});