<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Members extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('niveau_model');
        $this->load->model('admin_model');
        $this->load->model('Stag_individu_model');
        $this->isLoggedIn();   
    }
     
    /**
     * This function used to load the first screen of the user
     */
    public function index() {
        $this->global['pageTitle'] = 'E-learning : List members';
        $keySearch = array();
        $data['infosPage'] = 'Utilisateurs';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('utilisateur_type', 'Type d\'utilisateur', '');
        $this->form_validation->set_rules('utilisateur_nom', 'Nom ou prénom(s) de l\'utilisateur', 'required');
        if($this->form_validation->run() == TRUE){

            $keySearch = array(
                'utilisateur_type' => $this->input->post('utilisateur_type'),
                'utilisateur_nom'  => $this->input->post('utilisateur_nom'),
            );

            $data['allResults'] = $this->membres_model->filtrerAdmin($keySearch);
        }
        
        $this->loadViews("admin/members/list", $this->global, $data , NULL);
    }
  

    public function del(){
        if (isset($_GET['id']) && isset($_GET['type'])) {
           $this->membres_model->delete($_GET['id'],$_GET['type']); 
           redirect('members');
        }
    }

    public function edit(){
        $this->global['pageTitle'] = 'E-learning : Edition members';
        $timeNow = time();
        $utilisateur_data_update = array();
        if (isset($_GET['id'])) {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('utilisateur_photos_profil', 'Photos de profil', '');
            $this->form_validation->set_rules('utilisateur_login', 'Identifiant', 'required');
            $this->form_validation->set_rules('utilisateur_password', 'Mot de passe', 'required');
            $this->form_validation->set_rules('utilisateur_name', 'Nom', 'required');
            $this->form_validation->set_rules('utilisateur_firstname', 'Prénom(s)', '');
            $this->form_validation->set_rules('utilisateur_email', 'Adresse email', 'required');
            $this->form_validation->set_rules('utilisateur_telephone', 'Téléphone', '');
            $this->form_validation->set_rules('utilisateur_societe', 'Société', '');
            $this->form_validation->set_rules('utilisateur_ville', 'Ville', '');
            $this->form_validation->set_rules('utilisateur_adresse', 'Adresse', '');
            $this->form_validation->set_rules('utilisateur_cp', 'Code postal', '');
            $this->form_validation->set_rules('utilisateur_cv', 'Curriculum vitae', '');

            if ($_GET['type'] == 0 || $_GET['type'] == 3) {
                $this->form_validation->set_rules('utilisateur_access', 'Accéder à tout les ressources', '');
                $this->form_validation->set_rules('utilisateur_choice_access', 'Acces au compte', '');
                $this->form_validation->set_rules('utilisateur_debut_access', 'Début accés', '');
                $this->form_validation->set_rules('utilisateur_fin_access', 'Fin accés', '');
                if ($_GET['type'] == 0) {
                    $this->form_validation->set_rules('utilisateur_niveau_stage', 'Niveau de stage', 'required');
                }

                if ($_GET['type'] == 3) {
                    $this->form_validation->set_rules('utilisateur_trianee', 'Stagiaire', 'required');
                }

                $this->form_validation->set_rules('utilisateur_extranet_id', 'Identifiant extranet', 'required');
            }

            if($this->form_validation->run() == FALSE)
            {
                $data['groupesList']       = $this->groupes_model->filtrer('',NULL, NULL);
                $data['infoMembre']        = $this->membres_model->getInfoMembresAdmin($_GET['id']);           
                $data['parcours']          = $this->niveau_model->getAll()->result();
                $data['groupes']           = $this->groupes_model->readListGroupe($_GET['id']);
                $data['society']           = $this->societe_model->getAll();   
                $data['traineeResult']     = (isset($_GET['type']) && $_GET['type'] == 3) ? $this->membres_model->filtrer(0, STAGIAIRE, 2) : NULL;   
                $this->loadViews("admin/members/edit", $this->global, $data , NULL);                 
            }
            else{
                if (isset($_FILES['utilisateur_photos_profil']) && $_FILES['utilisateur_photos_profil']['error']==0) {
                    $photo= $_FILES['utilisateur_photos_profil'];
                }
                else{
                    $photo= '';
                }

                if ($_GET['type'] == 0 || $_GET['type'] == 3) {

                    if($_GET['type'] == 3){ // Mettre à jours le portefeuille stagiaire du professeur
                        //Réinitialiser le compteur
                        $stagiaire_selectionner = $this->input->post('utilisateur_trianee');
                        $dataListGroups = array();
                        for ($i=0; $i < count($stagiaire_selectionner) ; $i++) { 
                            $dataListGroups        = array(
                                'id_tuteur'        => $_GET['id'],
                                'id_groupe'        => $stagiaire_selectionner[$i],
                                'name'             => $this->membres_model->RequestByGrp('nom',$stagiaire_selectionner[$i]).' '.$this->membres_model->RequestByGrp('prenom',$stagiaire_selectionner[$i]),
                                'repertoire'       => 'GRP'.$stagiaire_selectionner[$i],
                                'code'             => 'G'.$stagiaire_selectionner[$i],
                                'glossaireenligne' => $this->groupes_model->Request('glossaireenligne',$stagiaire_selectionner[$i]),
                                'tuteur_principal' => $this->groupes_model->Request('tuteur_principal',$stagiaire_selectionner[$i])
                            );

                            $check_data_portefeuille = $this->groupes_model->RequestByParams($dataListGroups);
                            if (count($check_data_portefeuille) < 1) {
                               $dataListGroups['date_modif'] = $timeNow;

                               $this->groupes_model->addlistgrp($dataListGroups);
                            }
                        }
                    }

            
                    
                    $startDate = NULL;
                    $endDate   = NULL;

                    if ($this->input->post('utilisateur_choice_access') == 1) {
                        $accessDate = $this->getDateStartAndEndDate1($this->input->post('utilisateur_debut_access'), $this->input->post('utilisateur_fin_access'));
                        $startDate = $accessDate['start_date'];
                        $endDate   = $accessDate['end_date'];

                    }

                    $utilisateur_data_update = array(
                        'prenom'                      => $this->input->post('utilisateur_firstname'),
                        'nom'                         => $this->input->post('utilisateur_name'),
                        'login'                       => $this->input->post('utilisateur_login'),
                        'password'                    => $this->el_f2plus_auth->hash_password($this->input->post('utilisateur_password'),false),
                        'mode_acces'                  => $this->input->post('utilisateur_choice_access'),
                        'acces_bar'                   => $this->input->post('utilisateur_access'),
                        'email'                       => $this->input->post('utilisateur_email'),
                        'tel'                         => $this->input->post('utilisateur_telephone'),
                        'adresse'                     => $this->input->post('utilisateur_adresse'),
                        'cp'                          => $this->input->post('utilisateur_cp'),
                        'ville'                       => $this->input->post('utilisateur_ville'),
                        'StageSociete'                => $_GET['type'] == 0 ? $this->input->post('utilisateur_niveau_stage') : NULL,
                        'date_debut_acces'            => $startDate,
                        'date_fin_acces'              => $endDate,
                        'niveauStage'                 => $_GET['type'] == 0 ? $this->input->post('utilisateur_niveau_stage') : NULL,
                        'extranet_id'                 => $this->input->post('utilisateur_extranet_id'),
                        'date_modif'                  => $timeNow,
                        'register_remember_pwd_time'  => $timeNow.'_'.$this->input->post('utilisateur_password'),
                    );                    
                }
                else{
                    $utilisateur_data_update = array(
                        'prenom'        => $this->input->post('utilisateur_firstname'),
                        'nom'           => $this->input->post('utilisateur_name'),
                        'login'         => $this->input->post('utilisateur_login'),
                        'password'      => $this->el_f2plus_auth->hash_password($this->input->post('utilisateur_password'),false),                        
                        'email'         => $this->input->post('utilisateur_email'),
                        'tel'           => $this->input->post('utilisateur_telephone'),  
                        'id_societe'    => $this->input->post('utilisateur_societe'),                      
                        'adresse'       => $this->input->post('utilisateur_adresse'),
                        'cp'            => $this->input->post('utilisateur_cp'),
                        'ville'         => $this->input->post('utilisateur_ville'),                       
                        'date_modif'    => $timeNow,
                        'register_remember_pwd_time'  => $timeNow.'_'.$this->input->post('utilisateur_password'),
                    );
                }


                $res = (isset($utilisateur_data_update) && is_array($utilisateur_data_update)) ? $this->membres_model->update($_GET['id'],$utilisateur_data_update) : FALSE; 


                if ($res == OK || $res == TRUE) {
                    if ($_GET['type'] == 0 || $_GET['type'] == 3) {
                        $this->membres_model->addUserCreate($gpM == NULL ? $this->membres_model->Request('id_groupe',$_GET['id']) : $gpM ,$this->session->userdata ('GUSERID'));
                        $this->membres_model->addUserModif($gpM == NULL ? $this->membres_model->Request('id_groupe',$_GET['id']) : $gpM ,$this->session->userdata ('GUSERID'));
                    }
                    $this->CopyPhotoMembre($photo,$_GET['id']);
                    redirect('members');
                }
                else{
                    $data['groupesList']       = $this->groupes_model->filtrer('',NULL, NULL);
                    $data['infoMembre']= $this->membres_model->getInfoMembresAdmin($_GET['id']);
                    $data['parcours']          = $this->niveau_model->getAll()->result();
                    $data['groupes']           = $this->groupes_model->readListGroupe($_GET['id']);
                    $data['society']           = $this->societe_model->getAll(); 
                    $data['traineeResult']     = (isset($_GET['type']) && $_GET['type'] == 3) ? $this->membres_model->filtrer(0, STAGIAIRE, 2) : NULL;  
                    $data['errors']            = $res;
                    $this->loadViews("admin/members/edit", $this->global, $data , NULL);
                }
            }
        }
        else{

        }
    }

    public function updateGroups(){
        $return = array();
        if (isset($_POST['user-groups']) && $_POST['membre-id']) {
            //initialise groupe
            $this->groupes_model->deleteByMember($_POST['membre-id']);
            
            $groups = $_POST['user-groups'];
            for ($i=0; $i < count($groups) ; $i++) { 
                $this->admin_model->ajouterStagiaireGroupe($_POST['membre-id'], $groups[$i]);
                $this->membres_model->addUserCreate($_POST['membre-id'],$this->session->userdata ('GUSERID'));
                $this->membres_model->addUserModif($_POST['membre-id'],$this->session->userdata ('GUSERID'));
            }
        }
        echo json_encode($return);
    }

    public function objetcif(){
        
    }

    public function getAllIntegrator()
    {
        $return = array();
        $return['allIntegrator'] = $this->membres_model->filtrer('', TUTEUR_INTEGRATEUR, 0);
        return json_encode($return);
    }
   
}

?>