<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ConvertUtf8.php';
class ManageDataExtranet extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('groupes_model');
        $this->load->model('societe_model');
        $this->load->model('niveauCorrespondantElExtranet_model');
        $this->load->model('stag_individu_model');
        $this->load->model('parcours_model');
        $this->load->model('matieres_model');
        $this->load->model('admin_model');
        $this->load->model('formations_model');
        $this->load->model('sessions_model');
        $this->load->model('bno_model');
        
    }
  
    public function index(){
    }

    public function createProfilElearning(){
        $retour = array();
        if (isset($_POST['PostedXMLStagiaire'])) {
            $extranetData = $_POST['PostedXMLStagiaire'];
            //$MyData = $this->convert_utf8($extranetData);
            $this->addLog($extranetData);
            $xml = new SimpleXMLElement($extranetData);
            foreach ($xml->stagiaire as $oStagiaire)
            {   
                $num_stage =  $oStagiaire->stage;
                $num_profil =  $oStagiaire->numero;
                $civilite =  $oStagiaire->civilite;
                $nom =  $this->convert_utf8($oStagiaire->nom);
                $prenom =  $this->convert_utf8($oStagiaire->prenoms);
                $mail =  $this->convert_utf8($oStagiaire->mail);
                $fonction =  $this->convert_utf8($oStagiaire->fonction);
                $Profes_obj =  $this->convert_utf8($oStagiaire->observationdevis);  
                $Indiv_tr =  $this->convert_utf8($oStagiaire->observationpeda); 
                $glos =  $this->convert_utf8($oStagiaire->gel);
                $niveau =  mb_strtoupper(str_replace('&eacute;','e',$this->convert_utf8($oStagiaire->niveau)));
                $niveau12 =  $this->convert_utf8($oStagiaire->niveau);
                $langue =  $this->convert_utf8($oStagiaire->langue);
                $societe_idaccess =  $oStagiaire->societe->idaccess;
                $societe_codetiers =  $oStagiaire->societe->codetiers;
                $societe_denomination = $oStagiaire->societe->denomination;
                $societe_ville =  $this->convert_utf8($oStagiaire->societe->ville);
                $charrr = '"';
                $adr =  $this->convert_utf8($oStagiaire->societe->adresse);
                $societe_adresse =  str_replace('"', "'", $adr);

                $modeAccess =  $oStagiaire->modeAccess;
                $glossaireEnLigne =  $oStagiaire->Glossaire;
                $num_individu =  $oStagiaire->num_individu;
                $idstagiaire =  $this->convert_utf8($oStagiaire->idStagiaire);
                $telephone =  $oStagiaire->telephone;
                $portable =  $oStagiaire->portable;

                $char_find =  $this->convert_utf8($oStagiaire->rue_stage);
                $findme   = '"';
            
                $rue_stage =  str_replace('"', "'", $this->convert_utf8($char_find));

                $ville_stage = $this->convert_utf8($oStagiaire->ville_stage);
                $cp_stage = $this->convert_utf8($oStagiaire->Cp_stage);
                $prof_nom =  $this->convert_utf8($oStagiaire->prof->nom);
                $prof_prenom = $this->convert_utf8($oStagiaire->prof->prenom);
                $prof_num_individu = $this->convert_utf8($oStagiaire->prof->refindividu);
                $prof_email = $this->convert_utf8($oStagiaire->prof->email);
                $prof_telephone = $oStagiaire->prof->telephoneprof;
                $prof_mobilephone = $oStagiaire->prof->mobileprof;
                $cryptedmd5 = $oStagiaire->cryptedmd5;
                $principal =  $oStagiaire->principal;
                $tp = $oStagiaire->TP;
                $te = $oStagiaire->TE;
            }

            $dateNow = time();
            $date_fin = $dateNow + (((24 * 60) * 60) + ((24 * 364) * 60) * 60);
            $langue_1 = '';
            $villeS = '';
            $code_gr = '';
            $idSociete = 0;
            $matches = array();
            if (preg_match('/Anglais/i', $langue, $matches)) {  
                $langue_1 = $matches[0];
            } 
            else if (preg_match('/Espagnol/i', $langue, $matches)){
                $langue_1 = $matches[0];
            } 
            else if (preg_match('/Français/i', $langue, $matches)){
                $langue_1 = $matches[0];
            } 
            else{
                $langue_1 = $langue;
            }

            $this->addLog('modeAccess : '.$modeAccess);
            $this->addLog('num_individu : '.$num_individu);

            //1 - Traitement données professeur
            $resultProf = $this->membres_model->getByExtranetId($prof_num_individu);
            if (count($resultProf) >= 1) {
                // Mis à jours infos professeurs
                $dataProfUpdate = array(
                    'tel' => $prof_mobilephone,
                    'date_modif' => $dateNow
                );
                $this->membres_model->updateByExtranetId($prof_num_individu,$dataProfUpdate);

                $retour['idProfesseurEl'] = $this->membres_model->requestByIdExtranet('id',$prof_num_individu);
            }
            else{
                // Insertion nouvelle professeur
                $dataProf = array(
                    'prenom'                 => $prof_prenom,
                    'nom'                    => $prof_nom,
                    'login'                  => $prof_email,
                    'password'               => $this->el_f2plus_auth->hash_password($prof_num_individu,false),
                    'cv'                     => '',
                    'id_societe'             => 1,
                    'date_creation'          => $dateNow,
                    'date_connexion'         => '',
                    'date_debut_acces'       => $dateNow,
                    'date_fin_acces'         => $date_fin,
                    'type'                   => 3,
                    'email'                  => $prof_email,
                    'skin'                   => '',
                    'adresse'                => '',
                    'cp'                     => '',
                    'ville'                  => '',
                    'mode_auth'              => 1,
                    'nom_photo'              => 0,
                    'acces_bar'              => 0,
                    'acces_fonctions_admin'  => 1,
                    'tuteur_entreprise'      => 0,
                    'extranet_id'            => $prof_num_individu,
                    'extranet_nom'           => $prof_nom,
                    'date_modif'             => $dateNow,
                    'tel'                    => $prof_mobilephone,
                    'register_remember_pwd_time'               => time().'_'.$prof_num_individu,
                );
                $idNouveauProf = $this->membres_model->add($dataProf);
                $retour['idProfesseurEl'] = $idNouveauProf;
            }

            //2 - Traitement données stagiaire
            $resultTrainee = $this->membres_model->getByExtranetId($num_individu);


            if (count($resultTrainee) >= 1) {
                $retour['idStagiaireEl'] = $resultTrainee[0]->id;
                // Mis à jours infos stagiaire                
                $this->addLog('stageSociete : '.$this->niveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('niveau_stage_el',$niveau,$langue_1));

                $idSocieteRequest = $this->societe_model->RequestByCodeTiersAndName('id_societe',$societe_codetiers,$societe_denomination);

                if ($idSocieteRequest == '' || $idSocieteRequest == NULL) {
                    $dataNewSociety = array(
                        'description' => $societe_denomination,
                        'ville' => $societe_ville,
                        'adresse' => $societe_adresse,
                        'adresse_presentiel' => '',
                        'adresse_facturation' => '',
                        'codetiers' => $societe_codetiers,
                        'id_access' => $societe_idaccess,
                    );
                    $idSociete = $this->societe_model->add($dataNewSociety);
                }
                else{
                    $dataUpdateSociety = array(
                        'ville' => $societe_ville,
                        'adresse' => $societe_adresse,
                        'codetiers' => $societe_codetiers,
                        'id_access' => $societe_idaccess,
                    );
                    $this->societe_model->update($idSocieteRequest,$dataUpdateSociety);
                    $idSociete = $idSocieteRequest;
                }

                $this->addLog('id_societe : '.$idSociete);

                $dataTraineeUpdate = array(
                    'prenom'        => $prenom,
                    'nom'           => $nom,
                    'login'         => $mail,
                    'password'      => $this->el_f2plus_auth->hash_password($idstagiaire,false),
                    //'mode_acces'    => $mode_acces == NULL ? 1 : 3,
                    'mode_acces'    => $modeAccess,
                    'email'         => $mail,
                    'adresse'       => $rue_stage,
                    'cp'            => $cp_stage,
                    'ville'         => $ville_stage,
                    'id_societe'    => $idSociete,
                    'StageSociete'           => $this->niveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('niveau_stage_el',$niveau,$langue_1),
                    'date_fin_acces'=> $date_fin,
                    'niveauStage'   => $niveau,
                    'tel'           => $telephone,
                    'extranet_nom'  => $nom,
                    'date_modif'    => $dateNow,
                    'register_remember_pwd_time'               => time().'_'.$idstagiaire,
                    'num_profil'               => $num_profil
                );
                $this->addLog(json_encode($dataTraineeUpdate));
                $this->addLog(json_encode($this->membres_model->updateByExtranetId($num_individu,$dataTraineeUpdate)));

                $this->addLog('update infos trainee');
                //Request group data
                $groupeId = $this->membres_model->requestByIdExtranet('id_groupe',$num_individu);
                $membresId = $this->membres_model->requestByIdExtranet('id',$num_individu);

                $resultGroup = $this->groupes_model->getAllByTrainneIdGroupId($membresId,$groupeId);
                if (count($resultGroup) < 1) {
                    $dataGroups = array(
                        'id_groupe'  => $groupeId,
                        'id_membres' => $membresId,
                        'langue'     => $langue_1,
                        'prototype'  => 0,
                        'date_modif' => $dateNow
                    );
                    $this->addLog($this->groupes_model->addgrp($dataGroups));
                }
                else{
                    //Update groupes
                    $this->addLog('update 1');
                    $dataUpdateGroups = array(
                        'langue'     => $langue_1,
                        'prototype'  => 0,
                        'date_modif' => $dateNow
                    );
                    $this->addLog($this->groupes_model->updategrp($groupeId,$dataUpdateGroups));
                }


                $dataUpdateListGrp = array(
                    'glossaireenligne' => $glossaireEnLigne,
                    'date_modif'       => $dateNow,
                );
                $this->groupes_model->updatelistgrp($this->membres_model->requestByIdExtranet('id_groupe',$num_individu),$dataUpdateListGrp);
                $this->addLog('update 2');
                //Verification affectation professeur
                

                if($groupeId < 10) {
                    $code_gr = "0".$groupeId;
                } else {
                    $code_gr = $groupeId;
                }

                $professorId = $this->membres_model->requestByIdExtranet('id',$prof_num_individu);
                $this->addLog('prof_num_individu : '.$prof_num_individu);
                $this->addLog('groupeId : '.$groupeId);
                $this->addLog('professorId : '.$professorId);
                $existanceAffectationProf = $this->groupes_model->getByProfessorIdAndGroupId($professorId,$groupeId);
                $this->addLog('existanceAffectationProf : '.count($existanceAffectationProf));
                
                if (count($existanceAffectationProf) < 1) {
                    $this->addLog('prof nexiste pas');
                    /*$dataAffecationProf        = array(
                        'id_groupe'        => $groupeId,
                        'id_tuteur'        => $professorId,
                        'name'             => $nom.' '.$prenom,
                        'public'           => 0,
                        'date_debut'       => 0,
                        'date_fin'         => '',
                        'date_presentiel'  => '',
                        'id_forum'         => '',
                        'repertoire'       => 'GRP'.$groupeId,
                        'planning'         => '',
                        'code'             => 'G'.$groupeId,
                        'date_modif'       => $dateNow,
                        'glossaireenligne' => $glossaireEnLigne
                    );
                    
                    $this->addLog(json_encode($this->groupes_model->addlistgrp($dataAffecationProf)));*/
                    $sSQLGroup1 = 'INSERT INTO list_groupe (id_tuteur,glossaireenligne,id_groupe,name,repertoire,code,date_modif) VALUES ('.$professorId.','.$glossaireEnLigne.','.$groupeId.',"'.$nom.' '.$prenom.'","GRP'.$groupeId.'","G'.$groupeId.'","'.$dateNow.'")';
                    $this->addLog('sql new grp update : '.$sSQLGroup1);
                    $this->addLog(json_encode($this->groupes_model->addlistgrpPr($sSQLGroup1)));
                }

                //update parcours formation
                // Delete old all parcours from trainee
                $this->formations_model->delSessionUser($groupeId);
                //get all parcours
                $traineeId = $this->membres_model->RequestByGrp('id',$groupeId);
                $this->addLog('traineeIdUpdate : '.$traineeId);
                //$parcoursFormation = $this->formations_model->read($groupeId,$this->membres_model->RequestByGrp('id',$groupeId));
                $this->addLog('update 4');

                //if ($parcoursFormation['cnt'] < 1) {

                    $parcoursId = $this->niveauCorrespondantElExtranet_model->getByExtranetNomAndLangage($niveau,$langue_1);
                    $this->addLog('parcoursId : '.$parcoursId);
                    $this->admin_model->ajouterParcoursFormation($traineeId,0,1,0,1,$parcoursId,1,$groupeId,0);
                    
                    $this->addLog('te : '.$te.' langue_1 : '.$langue_1.' tp : '.$tp.' glos : '.$glos);
                    if($te == "Linguaskill" && $langue_1 == "Anglais") {
                        $this->admin_model->ajouterModuleFormation($traineeId,0,1,154,1,0,1,$groupeId,0);
                    }

                    if(($te == "D.C.L." || $te == 'aucun') && $langue_1 == "Français") {
                        $this->admin_model->ajouterModuleFormation($traineeId,0,1,154,1,0,1,$groupeId,0);
                    }

                    if($tp == 0  && $langue_1 == "Français") {  
                        $this->admin_model->ajouterTuteurGroupe(6997,$groupeId);
                    }

                    if($te == "TOEIC"  && $langue_1 == "Anglais") {
                        $this->addLog('premier cible TOEIC');
                        $this->admin_model->ajouterModuleFormation($traineeId,0,1,37,1,0,1,$groupeId,0);
                    }

                    if($tp == 1  && $langue_1 == "Anglais") {       
                        $this->admin_model->ajouterTuteurGroupe(6997,$groupeId);
                    }

                    if($tp == 0  && $langue_1 == "Anglais") {
                        $this->addLog('premier cible tp');
                        $this->admin_model->ajouterTuteurGroupe(6997,$groupeId);
                    }

                    if($glos == 0)  {
                        $this->formations_model->delItemByGroupAndModuleAndSequence($groupeId,36,144);
                        $this->sessions_model->delItemByGroupAndModuleAndSequence($groupeId,36,144);
                    }
                // }

                $retour['fin_execution'] = 1;
                $retour['mis_a_jours_infos_stagaire'] = $traineeId;
                $retour['creation_nouvelle_profil'] = 0;
            }
            else{
                $next_max_id_g = $this->membres_model->getMaxIdGroup() + 1 ;

                if ($ville_stage=='Immeuble "Le Villiers"') {
                    $villeS = "Immeuble 'Le Villiers'";
                }
                else{
                    $villeS = $ville_stage;
                }

                if($next_max_id_g < 10) {
                    $code_gr = "0".$next_max_id_g;
                } else {
                    $code_gr = $next_max_id_g;
                }

                $idSocieteRequest = $this->societe_model->RequestByCodeTiersAndName('id_societe',$societe_codetiers,$societe_denomination);

                if ($idSocieteRequest == '' || $idSocieteRequest == NULL) {
                    $dataNewSociety = array(
                        'description' => $societe_denomination,
                        'ville' => $societe_ville,
                        'adresse' => $societe_adresse,
                        'adresse_presentiel' => '',
                        'adresse_facturation' => '',
                        'codetiers' => $societe_codetiers,
                        'id_access' => $societe_idaccess,
                    );
                    $idSociete = $this->societe_model->add($dataNewSociety);
                }
                else{
                    $dataUpdateSociety = array(
                        'ville' => $societe_ville,
                        'adresse' => $societe_adresse,
                        'codetiers' => $societe_codetiers,
                        'id_access' => $societe_idaccess,
                    );
                    $this->societe_model->update($idSocieteRequest,$dataUpdateSociety);
                    $idSociete = $idSocieteRequest;
                }
                $dataTrainee = array(
                    'prenom'                 => $prenom,
                    'nom'                    => $nom,
                    'login'                  => $mail,
                    'password'               => $this->el_f2plus_auth->hash_password($idstagiaire,false),
                    'cv'                     => '',
                    'id_societe'             => $idSociete,
                    'date_creation'          => $dateNow,
                    'date_connexion'         => '',
                    'mode_acces'             => $modeAccess,
                    'date_debut_acces'       => $dateNow,
                    'date_fin_acces'         => $date_fin,
                    'type'                   => 0,
                    'email'                  => $mail,
                    'id_groupe'              => $next_max_id_g,
                    'skin'                   => 'EL2021',
                    'adresse'                => $rue_stage,
                    'cp'                     => $cp_stage,
                    'ville'                  => $villeS,
                    'mode_auth'              => 1,
                    'nom_photo'              => 0,
                    'acces_bar'              => 0,
                    'acces_fonctions_admin'  => 0,
                    'tuteur_entreprise'      => 0,
                    //'StageSociete'           => $this->niveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('niveau_stage_el',$niveau,$langue_1),
                    'niveauStage'            => $niveau,
                    'extranet_id'            => $num_individu,
                    'extranet_nom'           => $nom,
                    'date_modif'             => $dateNow,
                    'tel'                    => $telephone,
                    'register_remember_pwd_time'               => time().'_'.$idstagiaire,
                    'num_profil'               => $num_profil,
                );

                //$sSQL = 'INSERT INTO membres (prenom,nom,login,password,cv,id_societe,date_creation,date_connexion,mode_acces,date_debut_acces,date_fin_acces,type,email,id_groupe,skin,adresse,cp,ville,mode_auth,nom_photo,acces_bar,acces_fonctions_admin,tuteur_entreprise,StageSociete,niveauStage,extranet_id,extranet_nom,date_modif,tel) VALUES ("'.$prenom.'","'.$nom.'","'.$nom.'","'.$idstagiaire.'","","'.$idSociete.'","'.$dateNow.'","","'.$modeAccess.'","'.$dateNow.'","'.$date_fin.'",0,"'.$mail.'","'.$next_max_id_g.'","EL2021","'.$this->convert_utf8($rue_stage).'","'.$cp_stage.'","'.$villeS.'",1,0,0,0,0,"'.$this->niveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('niveau_stage_el',$niveau,$langue_1).'","'. $niveau.'","'.$num_individu.'","'.$nom.'","'.$dateNow.'","'.$telephone.'")';
              
                /*$this->addLog('mail : '.$mail);
                $this->addLog('modeAccess : '.$modeAccess);
                $this->addLog('idSociete : '.$idSociete);
                $this->addLog('prenom : '.$prenom);
                $this->addLog('idStagiaire : '.$idStagiaire);
                $this->addLog('dateNow : '.$dateNow);
                $this->addLog('telephone : '.$telephone);
                $this->addLog('num_individu : '.$num_individu);
                $this->addLog('nom : '.$nom);
                $this->addLog('niveau : '.$niveau);
                $this->addLog('StageSociete : '.$this->niveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('niveau_stage_el',$niveau,$langue_1));
                $this->addLog('villeS : '.$villeS);
                $this->addLog('cp_stage : '.$cp_stage);
                $this->addLog('rue_stage : '.$rue_stage);
                $this->addLog('next_max_id_g : '.$next_max_id_g);
                $this->addLog('date_fin : '.$date_fin);*/


                //$this->addLog($sSQL);
                $traineeId = $this->membres_model->add($dataTrainee);
                $retour['idStagiaireEl'] = $traineeId;
                //$this->addLog(print_r($traineeId));
                //$this->addLog(json_encode($traineeId));
                //$this->addLog('end');
                //Creation groupe

                $dataGroups = array(
                    'id_groupe'  => $next_max_id_g,
                    'id_membres' => $traineeId,
                    'langue'     => $langue_1,
                    'prototype'  => 0,
                    'date_modif' => $dateNow
                );
                $this->groupes_model->addgrp($dataGroups);
                //$this->addLog('aprés ajout group');
                //Travail personnel
                $dataListGroups        = array(
                    'id_tuteur'        => 0,
                    'id_groupe'        => $next_max_id_g,
                    'name'             => $nom.' '.$prenom,
                    'repertoire'       => 'GRP'.$next_max_id_g,
                    'code'             => 'G'.$code_gr,
                    'date_modif'       => $dateNow,
                    'glossaireenligne' => $glossaireenligne
                );
                $sSQLGroup = "INSERT INTO list_groupe (id_tuteur,glossaireenligne,id_groupe,name,repertoire,code,date_modif) VALUES (0,".$glossaireEnLigne.",".$next_max_id_g.",'".$nom." ".$prenom."','GRP".$next_max_id_g."','G".$code_gr."','".$dateNow."')";
                
                
                
                $this->addLog(json_encode($this->groupes_model->addlistgrpPr($sSQLGroup)));
                //Affecation professeur

                $this->addLog('prof_num_individu : '.$prof_num_individu);
                $professorId = $this->membres_model->requestByIdExtranet('id',$prof_num_individu);
                $existanceAffectationProf = $this->groupes_model->getByProfessorIdAndGroupId($professorId,$next_max_id_g);
                $this->addLog('prof exist : '.count($existanceAffectationProf));
                if (count($existanceAffectationProf) == 0) {
                    /*$dataAffecationProf        = array(
                        'id_groupe'        => $next_max_id_g,
                        'id_tuteur'        => $professorId,
                        'name'             => $nom.' '.$prenom,
                        'repertoire'       => 'GRP'.$next_max_id_g,
                        'code'             => 'G'.$code_gr,
                        'date_modif'       => $dateNow,
                        'glossaireenligne' => $glossaireEnLigne
                    );*/
                    $sSQLGroup1 = "INSERT INTO list_groupe (id_tuteur,glossaireenligne,id_groupe,name,repertoire,code,date_modif) VALUES (".$professorId.",".$glossaireEnLigne.",".$next_max_id_g.",'".$nom." ".$prenom."','GRP".$next_max_id_g."','G".$code_gr."','".$dateNow."')";
                    
                    $this->addLog('insertion prof : '.$sSQLGroup1);
                    $this->addLog(json_encode($this->groupes_model->addlistgrpPr($sSQLGroup1)));
                    $this->addLog('fin insertion prof');
                    mkdir(RP_GROUPES."GRP".$next_max_id_g, 0777,true);
                }
                
                //stag individu 
                $arrayDataStageIndividu = array(
                    'id_stagiare_el' => $traineeId,
                    'id_stage_ext' => $num_stage,
                    'id_individu_ext' => $num_individu
                );
                $this->stag_individu_model->add($arrayDataStageIndividu);

                //add parcours
                $parcoursId = $this->niveauCorrespondantElExtranet_model->getByExtranetNomAndLangage($niveau,$langue_1);
                $this->addLog('parcoursId : '.$parcoursId);
                $this->admin_model->ajouterParcoursFormation($traineeId,0,1,0,1,$parcoursId,1,$next_max_id_g,0);
                $this->addLog('traineeId1 : '.$traineeId);
                $this->addLog('te : '.$te.' langue_1 : '.$langue_1.' tp : '.$tp.' glos : '.$glos);

                //Add personnal link

                //Add linguistic tools
                
                if($te == "Linguaskill" && $langue_1 == "Anglais") {
                    $this->admin_model->ajouterModuleFormation($traineeId,0,1,154,1,0,1,$next_max_id_g,0);
                }

                if(($te == "D.C.L." || $te == 'aucun') && $langue_1 == "Français") {
                    $this->admin_model->ajouterModuleFormation($traineeId,0,1,154,1,0,1,$next_max_id_g,0);
                }

                if($tp == 0  && $langue_1 == "Français") {  
                    $this->admin_model->ajouterTuteurGroupe(6997,$next_max_id_g);
                }

                if($te == "TOEIC"  && $langue_1 == "Anglais") {
                    $this->addLog('premier cible TOEIC');
                    $this->admin_model->ajouterModuleFormation($traineeId,0,1,37,1,0,1,$next_max_id_g,0);
                }

                if($tp == 1  && $langue_1 == "Anglais") {       
                    $this->admin_model->ajouterTuteurGroupe(6997,$next_max_id_g);
                }

                if($tp == 0  && $langue_1 == "Anglais") {
                    $this->addLog('premier cible tp');
                    $this->admin_model->ajouterTuteurGroupe(6997,$next_max_id_g);
                }

                if($glos == 0)  {
                    $this->formations_model->delItemByGroupAndModuleAndSequence($next_max_id_g,36,144);
                    $this->sessions_model->delItemByGroupAndModuleAndSequence($next_max_id_g,36,144);
                }
                //$matiereId = $this->parcours_model->getMatiereIdByParcoursId($parcoursId);
                $this->addLog('debut bn0');
                $data_bno = array(
                    'type_outil' => 2,
                    'id_membre' => '',
                    'id_groupe' => $next_max_id_g,
                    'date_maj' => $dateNow,
                    'contenu' => $Profes_obj
                );
                

                $sSQLBno1 = "INSERT INTO bno (type_outil,id_membre,id_groupe,date_maj,contenu) VALUES (2,0,".$next_max_id_g.",'".$dateNow."','".$Profes_obj."')";
                $this->addLog('bn01 : '.$this->bno_model->addPr($sSQLBno1));
                $data_bno_1 = array(
                    'type_outil' => 2,
                    'id_membre' => $traineeId,
                    'id_groupe' => $next_max_id_g,
                    'date_maj' => $dateNow,
                    'contenu' => $Profes_obj
                );
                $sSQLBno2 = "INSERT INTO bno (type_outil,id_membre,id_groupe,date_maj,contenu) VALUES (2,".$traineeId.",".$next_max_id_g.",'".$dateNow."','".$Profes_obj."')";
                $this->addLog('bn02 : '.$this->bno_model->addPr($sSQLBno2));

                $this->addLog('end');

                $retour['fin_execution'] = 1;
                //$retour['mis_a_jours_infos_stagaire'] = 0;
                //$retour['creation_nouvelle_profil'] = $traineeId;

            }

            echo json_encode($retour);

        }
    }

    public function updateProfilByExtranetId(){
        $retour = array();
        if (isset($_POST['PostedXMLStagiaire'])) {
            $dataXml = new SimpleXMLElement($_POST['PostedXMLStagiaire']);
            $data = array(
                'nom'     =>  $this->convert_utf8($dataXml->stagiaire->nom),
                'prenom'  =>  $this->convert_utf8($dataXml->stagiaire->prenoms),
                'email'   =>  $this->convert_utf8($dataXml->stagiaire->mail),
                'tel'     =>  $this->convert_utf8($dataXml->stagiaire->portable),
                'adresse' =>  $this->convert_utf8($dataXml->stagiaire->rue_stage),
                'cp'      =>  $this->convert_utf8($dataXml->stagiaire->cp_stage),
                'ville'   =>  $this->convert_utf8($dataXml->stagiaire->ville_stage)
            );

            //$this->addLog($this->convert_utf8($dataXml->extranet_id));
            $this->addLog($_POST['PostedXMLStagiaire']);
            /*$this->addLog('1 : '.$dataXml->stagiaire->nom);
            $this->addLog('3 : '.$dataXml->stagiaires->stagiaire->nom);
            $this->addLog('2 : '.$dataXml->nom);*/

            return $this->membres_model->updateByExtranetId($this->convert_utf8($dataXml->stagiaire->extranet_id),$data);
        }
    }

    public  function convert_utf8($str) {
        $new2old = array(
          'á' => 'Ã¡',
          'À' => 'Ã€',
          'ä' => 'Ã¤',
          'Ä' => 'Ã„',
          'ã' => 'Ã£',
          'å' => 'Ã¥',
          'Å' => 'Ã…',
          'æ' => 'Ã¦',
          'Æ' => 'Ã†',
          'ç' => 'Ã§',
          'Ç' => 'Ã‡',
          'é' => 'Ã©',
          'É' => 'Ã‰',
          'è' => 'Ã¨',
          'È' => 'Ãˆ',
          'ê' => 'Ãª',
          'Ê' => 'ÃŠ',
          'ë' => 'Ã«',
          'Ë' => 'Ã‹',
          //'í' => 'Ã-',
          //'Í' => 'Ã',
          'ì' => 'Ã¬',
          'Ì' => 'ÃŒ',
          'î' => 'Ã®',
          'Î' => 'ÃŽ',
          'ï' => 'Ã¯',
          //'à' => 'Ã ',
          'ñ' => 'Ã±',
          'Ñ' => 'Ã‘',
          'ó' => 'Ã³',
          'Ó' => 'Ã“',
          'ò' => 'Ã²',
          'Ò' => 'Ã’',
          'ô' => 'Ã´',
          'Ô' => 'Ã”',
          'ö' => 'Ã¶',
          'Ö' => 'Ã–',
          'õ' => 'Ãµ',
          'Õ' => 'Ã•',
          'ø' => 'Ã¸',
          'Ø' => 'Ã˜',
          'œ' => 'Å“',
          'Œ' => 'Å’',
          'ß' => 'ÃŸ',
          'ú' => 'Ãº',
          'Ú' => 'Ãš',
          'ù' => 'Ã¹',
          'Ù' => 'Ã™',
          'û' => 'Ã»',
          'Û' => 'Ã›',
          'ü' => 'Ã¼',
          'Ü' => 'Ãœ',
          '€' => 'â‚¬',
          '’' => 'â€™',
          '‚' => 'â€š',
          'ƒ' => 'Æ’',
          '„' => 'â€ž',
          '…' => 'â€¦',
          '‡' => 'â€¡',
          'ˆ' => 'Ë†',
          '‰' => 'â€°',
          'Š' => 'Å ',
          '‹' => 'â€¹',
          'Ž' => 'Å½',
          '‘' => 'â€˜',
          '“' => 'â€œ',
          '•' => 'â€¢',
          '–' => 'â€“',
          '—' => 'â€”',
          '˜' => 'Ëœ',
          '™' => 'â„¢',
          'š' => 'Å¡',
          '›' => 'â€º',
          'ž' => 'Å¾',
          'Ÿ' => 'Å¸',
          '¡' => 'Â¡',
          '¢' => 'Â¢',
          '£' => 'Â£',
          '¤' => 'Â¤',
          '¥' => 'Â¥',
          '¦' => 'Â¦',
          '§' => 'Â§',
          '¨' => 'Â¨',
          '©' => 'Â©',
          'ª' => 'Âª',
          '«' => 'Â«',
          '¬' => 'Â¬',
          '®' => 'Â®',
          '¯' => 'Â¯',
          '°' => 'Â°',
          '±' => 'Â±',
          '²' => 'Â²',
          '³' => 'Â³',
          '´' => 'Â´',
          'µ' => 'Âµ',
          '¶' => 'Â¶',
          '·' => 'Â·',
          '¸' => 'Â¸',
          '¹' => 'Â¹',
          'º' => 'Âº',
          '»' => 'Â»',
          '¼' => 'Â¼',
          '½' => 'Â½',
          '¾' => 'Â¾',
          '¿' => 'Â¿',
          'à' => 'Ã',
          '†' => 'â€ ',
          '”' => 'â€',
          //'Á' => 'Ã',
          'â' => 'Ã¢',
          'Â' => 'Ã‚',
          'Ã' => 'Ãƒ',
          'â' => 'Ã¢',
          'ô' => 'Í´',
          'î' => 'Í®',
          'ù' => 'à¹',
          'oe' => 'Å"',
              '”' => 'â€',
        );
        $new = array();
        $old = array();
        foreach( $new2old as $key => $value ) {
          $new[] = $key;
          $old[] = $value;
        }
        return str_replace( $old, $new, $str );
    }

    public function addLog($content) {
        if (!is_dir(RP_MAIN."cron/logs")) {
            mkdir(RP_MAIN."cron/logs", 0755, false);
            if (!is_dir(RP_MAIN."cron/logs/affecationProf")) {
                mkdir(RP_MAIN."cron/logs/affecationProf", 0755, false);
            }
        }
        $logFileName = RP_MAIN."cron/logs/affecationProf/affecationProf_" . date('dmY') . ".log";

        if (!file_exists($logFileName)) file_put_contents($logFileName, "");
        file_put_contents($logFileName,date("[j/m/y H:i:s]")." - $content \r\n".file_get_contents($logFileName));
    }

    public function majDataEl(){
        $return = array();
        $allResults = $this->membres_model->filtrer('', STAGIAIRE, 2);
        for ($i=0; $i < count($allResults) ; $i++) { 
            if(isset($allResults[$i]['extranet_id']) && $allResults[$i]['extranet_id'] != 0 && $allResults[$i]['extranet_id'] != NULL){
                $jsonDecode = $this->getInfosMajInExtranet($allResults[$i]['extranet_id']);
                foreach ($jsonDecode as $res){
                    $dataVerifyInDb = $this->Stag_individu_model->getInfosByParams($allResults[$i]['id'], $res->Stage, $allResults[$i]['extranet_id']);
                    if (count($dataVerifyInDb) < 1) {
                        $dataInfosStage = array(
                            'id_stagiare_el'  => $allResults[$i]['id'],
                            'id_stage_ext'    => $res->Stage,
                            'id_individu_ext' => $allResults[$i]['extranet_id'],
                        );
                        $return['insert_last_id']      = $this->Stag_individu_model->add($dataInfosStage);
                    }                    

                    $dataInfosMembres = array(
                        'num_profil'    => $res->numero,
                        'date_modif'    => time()
                    );

                    $return['update_member_infos'] = $this->membres_model->update($allResults[$i]['id'],$dataInfosMembres);
                }

            }
        }
        echo json_encode($return);
    }

    public function getInfosMajInExtranet($extranetId){
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => $this->config->item("api_base_url_extranet").'Profil-el/home/maj_data_el?extranet_id='.$extranetId,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response);
       
    } 

}

?>