<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Sommaire extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('sequence_model');
        $this->load->model('chapitres_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the sequence
     */
  
    public function index()
    {
        
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("sequenceProgrameTr", $this->global, NULL , NULL);
    }

    public function viewDetail($CNX, $SEQUENCE, $LOC, $MODULE, $LOCM, $PARCOURS, $LOCP)
    //public function viewDetail($CNX, $SEQUENCE, $LOC, $MODULE, $LOCM, $PARCOURS, $LOCP)
    {

        $this->global['pageTitle'] = 'E-learning : Forma2+';


        $param = '?connexion='.$CNX.'&sequence='.$SEQUENCE.'&loc='.$LOC.'&groupe='.$this->session->userdata ('GROUPE');
 
        //$this->chapitres_model->init(LOC);
        $chapitre = $this->chapitres_model->read($SEQUENCE,$this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
        
        define('PAGE_TOP',  HTTP_SEQUENCE.'sommaire.php/viewDetail/'.$this->session->userdata ('CNX').'/'.$SEQUENCE.'/'.$LOC.'/0');
        define('PAGELOCALFORMATION',  base_url().'formation');
        //define('PAGELOCALFORMATION',  ' http://vps339112.ovh.net/elearning7/formation');

        $imgthumbnail = '';
        if (isset($chapitre['cnt'])) {
        
            for($i=0;$i<$chapitre['cnt'];$i++) {

                $type           = $chapitre[$i]['type']     ;
                $titre          = $chapitre[$i]['titre']    ;
                $numero         = $chapitre[$i]['numero']   ;
                $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                $linkUrl        = $chapitre[$i]['lienUrl']  ;
                $id_sequence    = $chapitre[$i]['id_sequence']  ;

                if ($thumbnail_file != "") {                 
                    $link_support = $linkUrl;
                    $thumbnailFile="";
                    $redir        = 'redir.php?url';
                    $support      = '';
                    $urlF         = "";
                    $date         = time();
                    if ($this->validate_url($link_support)){
                        $support      .= $redir.$link_support;
                        $urlF         .= $link_support;
                    }
                    else{
                        if (strpos($link_support, $redir) == false) { 
                            $filename      = $this->getFileName($link_support);
                            $ext            = explode(".", $filename);
                            if ($ext[1]=="pdf") {
                                $urlF         .= HTTP_FORMATIONS.$link_support;
                            }
                            elseif ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt"){
                                $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                            }
                            else{
                                $urlF  .= HTTP_FORMATIONS.$link_support;
                            }
                            $support      .= $link_support;
                        }                 
                        else { 
                            $support      .=$link_support;
                            $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                        } 
                    }
                    $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                    
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }   

                    $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 

                    $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);

                    if($thumb){
                        $thumbnailFile .=$thumbnailFiles;
                    }
                    else{
                        $thumbnailFile .="";
                    }
                    
                    $activityInfo = array(
                        "date_create" => $date,
                        "thumbnail_file" => $thumbnailFile
                    );            
                    $this->sequence_model->updateChapitre($id,$num,$activityInfo);
                }
                    
                $action = '';
                $prerequis  = $chapitre[$i]['prerequis']    ;
                
               
                if ($type==TITRE && $prerequis=='') {
                    $chapitre[$i]['status'] = COMPLETED;
                }
                else {
                    //$chapitre[$i]['status'] = $ClsTracking->GetStatusPreRequis($this->session->userdata ('GUSERID'),SEQUENCE,$chapitre[$i]['numero'],$this->session->userdata ('GROUPE'),LOC,$chapitre[$i]['prerequis']);
                }

                $lien  = strlen(trim($chapitre[$i]['lien']))>0?substr($chapitre[$i]['lien'],0):'';
                
                if ($numero == 0) {
                    if (strlen(trim($lien))==0) {
                        $lcours = "" ;
                    } else {
                        $lcours   = preg_match('/^http/',$lien)?$lien:HTTP_FORMATION.$lien ;
                        $rplcours = RP_FORMATION.$lien ;
                        $tcours   = CSS($ad_texte['support']);
                    }   
                } 
                else {
                    if ( preg_match('/^http/',$lien) && ($type==CHAPITRE_LU || $type==DOCUMENT) ) {
                        
                        if ( $type == CHAPITRE_LU ) {
                               $fichier = PAGE_TOP.'&chapitre='.$numero;
                               $fichier = $fichier.'&action=chapitrelu';
                               $cible = '_top';            
                        } 
                        else {
                            $fichier = $lien ;
                            $cible = '_blank';          
                        }       
                    } 
                    else {
                        
                        $fichier = PAGE_TOP.'&chapitre='.$numero;
                        $cible = '_top';
                        switch ($type) {
                            case QUIZZ_AICC :
                                $fichier = $fichier.'&action=aicc';
                                break;
                            case QUIZZ_SCORM :
                                $fichier = $fichier.'&action=scorm';
                                break;
                            case QUIZZ_SCORM_WS :
                                $fichier = $fichier.'&action=scorm_ws';
                                break;
                            case CHAPITRE_LU :
                                $fichier = $fichier.'&action=chapitrelu';
                                break;
                            case DOCUMENT :
                            case TITRE :
                            case QUIZZ_GANESHA :
                                $fichier = $fichier.'&action=document&idg='.$this->session->userdata ('GUSERID').'&groupe='.$this->session->userdata ('GROUPE');
                                break;
                            case IMCOS_BI :
                                $fichier = $fichier.'&action=contenuIntegre&idg='.$this->session->userdata ('GUSERID');
                                break;
                            case STAGIAIRE_LINK:                    
                                $fichier = $lien.'?action=lienNormal&connexion='.$CNX;
                                break;
                            default :
                                $fichier = $fichier.'&action=document';
                                break;
                        }
                    }
                    $url_track_window_open = "";
                    if ((!empty($chapitre[$i]['lien'])) && ($this->isRedirectLinks($chapitre[$i]['lien']))) {
                        $cible = '';
                        $imgSnap = '';
                        $linkNewWindow = "window.open('".$fichier."', 'ExerciceRedirection', 'resizable=yes, scrollbars=1, width=700, height=500');";  //toolbar=yes si on veut le back button
                        $fichier = '#';
                        $id="windowOpen";
                    }     
                    
                    else {
                        $linkNewWindow = '';
                        $cible = '_top';    
                    }
                    switch($type) {
                        case DOCUMENT :
                            
                            //$menu->addDocument(array('id'=>$id,'texte'=>$chapitre[$i]['titre'], 'url'=>$fichier . $imgSnap , 'onclick'=>$linkNewWindow ,'target'=>$cible , 'action'=>$action, 'image'=>$image));

                            break;
                        
                        case TITRE :
                            if ( strlen(trim($prerequis))>0 ) {
                               if (VerifRequis($prerequis,$chapitre)) {
                                 $titre = $chapitre[$i]['titre'];
                               }
                            } else {
                                 $titre = $chapitre[$i]['titre'];
                            }
                  
                            break ;

                        default :
                    }
                }
                if ($thumbnail_file !="") {
                    $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                    $scan = "";                
                }
                else{
                    $fileimg = base_url()."groupes/img_default.jpg";
                    $scan = '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan/'.$id_sequence.'/'.$thumbnail_file.'">';
                }

                if ($titre != "Support") {
                  
                    $imgthumbnail .='            
                    <div class="column sequenceActiviti" onclick="showdetailactivity(this);">
                        <input type="hidden" name="linkExterne" class="linkExterne" value="'.$this->VerifLien($linkUrl).'">
                
                       <input type="hidden" name="linkExternedetect" class="linkExternedetect" value="'.$chapitre[$i]['ifrmaccess'].'">

                      <input type="hidden" name="typeThumb" class="typeThumb" value="'.$chapitre[$i]['type'].'">

             
                      <input type="hidden" name="sequenceid" class="sequenceid" value="'.$chapitre[$i]['id_sequence'].'">

                      <input type="hidden" name="sequencenumero" class="sequencenumero" value="'.$chapitre[$i]['numero'].'">

                      <input type="hidden" name="nbvue" class="nbvue" value="">

                      '.$scan.'
                        <img class="image-timthumb " title="" alt="Avatar" src="'.$fileimg.'" style="width:100%">
                        <div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>
                        <div class="middle-action-folow">
                            <div class="text-img">
                                <div class="row">
                                    <div class="col-md-6 clstiltetxt"></div>
                                </div>
                            </div>
                        </div>
                    </div>';
                }
                       
            }
        }

        $this->global['thumbnailImg'] = $imgthumbnail; 
        echo $this->global['thumbnailImg']; 

      
    }
    public function VerifLien($link){
        $ViewUrl = str_replace("http://s371880604.onlinehome.fr/redir.php.url?url=","" ,$link);
        $ViewUrl = str_replace("http://s371880604.onlinehome.fr/redirect.php?url=","" ,$ViewUrl);
        $ViewUrl = str_replace("http://vps339112.ovh.net/elearning7/redirect.php.url?url=","" ,$ViewUrl);
        $ViewUrl = str_replace("/redir.php?ulr=","" ,$ViewUrl);
        $ViewUrl = str_replace("/redir.php.url?url=","" ,$ViewUrl);
        $ViewUrl = str_replace("/redir.php?url=","" ,$ViewUrl);//
        $ViewUrl = str_replace("/redir.php.url=","" ,$ViewUrl);
        $ViewUrl = str_replace("redir.php?url=","" ,$ViewUrl);
        $ViewUrl = str_replace("http:///redir.php?url=","" ,$ViewUrl);
        $ViewUrl = str_replace("/redir?url=","" ,$ViewUrl);
        $ViewUrl = str_replace("/redirect.php?url=","" ,$ViewUrl); 
        $ViewUrl= str_replace("/local/newsletter/","http://vps339112.ovh.net/elearning7/formation/local/newsletter/",$ViewUrl);
        $ViewUrl= str_replace("/local/course01/","http://vps339112.ovh.net/elearning7/formation/local/course01/",$ViewUrl);
        $ViewUrl = str_replace("/pages/newsletter","/elearning7/formation/local/newsletter", $ViewUrl);
        $ViewUrl = str_replace("# http:","http:", $ViewUrl);
        $ViewUrl = str_replace(".come",".com", $ViewUrl);
        $ViewUrl = str_replace("/http:","http:", $ViewUrl);
        $ViewUrl = str_replace("/ http://","http://",$ViewUrl);
        $ViewUrl = trim($ViewUrl);
        return $ViewUrl;
    }

    public function pageNotFound()
    {
        $this->global['pageTitle'] = 'CodeInsect : 404 - Page Not Found';
        
        $this->loadViews("404", $this->global, NULL, NULL);
    }

    public function isRedirectLinks($link) {
        $isRedirect = false;
        $redirectlinksArray = array("manythings.org", 
                                    "e-anglais.com", 
                                    "a4esl.org", 
                                    "iteslj.org", 
                                    "owl.english.purdue.edu", 
                                    "rottentomatoes.com", 
                                    "cdkitchen.com",
                                    "nytimes.com");
        foreach ($redirectlinksArray as $i => $value) {
            if((preg_match("#".$redirectlinksArray[$i]."#", $link))|| (preg_match("#https#", $link))) {
            //if(preg_match("https", $link)) {
                $isRedirect = true;
                break;
            }
        }
        return $isRedirect;
    }
}

?>