<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ElearningSupervisorForma2PlusController.php';
/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Members extends ElearningSupervisorForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Membres_model');      
        $this->load->model('Tracking_model');   
        $this->load->model('Stag_individu_model'); 
        $this->load->model('CoursPlannifier_model');        
        $this->isLoggedIn(); 
        $this->tracking_type = 55;  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }

    public function conncted()
    {

        $dateNow = date("Y-m-d");
        $this->global['pageTitle'] = 'E-learning : Connected users';
        
        $trackingid = $this->Tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');

        
        $data['creneauHoraire']  = $this->CoursPlannifier_model->getAllCreneau(); 
        $data['allResultsInfosCoursPlannifierNow']  = $this->CoursPlannifier_model->getAllNow(); 
        $data['test']  = ""; 
        $this->loadViews("supervisor/members/connected", $this->global, $data , NULL);
    }

    public function refreshdata(){
        $retour = array();
        if (isset($_POST['traineeId'])) {
            $idStagiaireEl         = $_POST['traineeId'];
            $referenceCnxNow       = '';
            $IdDernierCnx          = '';
            $dateDernierCnx        = '';
            
            $statusProfilEL = true;
            $dataEndCnx          = $this->connexion_model->getMaxDataEndConnexionByUser($idStagiaireEl);
            if (isset($dataEndCnx['count']) && $dataEndCnx['count'] >= 1) {
                //$retour['dernierCnx'] = $dataEndCnx['dateDebutCnx'].' '.$dataEndCnx['debutCnx'];
                if ($dataEndCnx['dateDebutCnx'] == date('Y-m-d')) {
                    $retour['dernierCnx'] = 'Aujourd\'hui';
                }
                else{
                    $retour['dernierCnx'] = $dataEndCnx['dateDebutCnx'];
                }
            }


            $allResultCnx       = $this->connexion_model->getAllCnxRestante($idStagiaireEl);
            if (isset($allResultCnx) && $allResultCnx['count'] >= 1) {
                $IdDernierCnx        .= $allResultCnx['id_connexion'];
                $dateDernierCnx      .= $allResultCnx['date_connexion'];
            }

            $retour['derniereClick'] = date('Y-m-d H:i:s',$this->Tracking_model->getLastClickForUser($idStagiaireEl));
            $dataCnxNow             = $this->connexion_model->getMaxDataEndConnexionNowByUser($idStagiaireEl);

            if (isset($dataCnxNow['count']) && $dataCnxNow['count'] >= 1) {
                $retour['debutConnexionEl']  = $dataCnxNow['debutCnx'];
                $retour['dureeConnexion']    = $dataCnxNow['dureeCnx'];
                $retour['dernierActivite']   = $this->Tracking_model->returnMAxLastActivityByCnx($dataCnxNow['idCnx']);

                $referenceCnxNow      .= $this->connexion_model->RequestByIdCnx('id_connexion',$dataCnxNow['idCnx']);

                if (isset($referenceCnxNow) && $referenceCnxNow  == '' && $dataCnxNow['finCnx'] != '') {
                    $retour['finConnexionEl']  = $dataCnxNow['finCnx'];
                }
                else{
                    $retour['finConnexionEl']  = '';
                }

                $retour['idCnx']             = $dataCnxNow['idCnx'];
                $retour['navigateur']        = $dataCnxNow['navigateur'];
                $retour['plateforme']        = $dataCnxNow['platform'];
                $retour['unixTimeCnx']       = $dataCnxNow['unixTimeCnx'];
            }
            


            if(isset($referenceCnxNow) && $referenceCnxNow != ''){ 
                $retour['actionNormalDeconnexion'] = '<a href="#" onclick="disconnect(this)" data-cnx="'.$referenceCnxNow.'" class="btn-deconnect-user-profil" title="Se déconnecter"><i class="fa fa-sign-out"></i></a>';
                $counterIsConnect = true;
              }

              if(isset($IdDernierCnx) && $IdDernierCnx != '' && isset($referenceCnxNow) && $referenceCnxNow != $IdDernierCnx){ 
                $retour['actionLastDeconnexion'] = '<a href="#" onclick="disconnect(this)" data-cnx="'.$IdDernierCnx.'" class="btn-deconnect-user-profil" title="Se déconnecter du '.date('Y-m-d H:i:s',$dateDernierCnx).'"><i class="fa fa-sign-out"></i></a>';
                //$retour['actionLastDeconnexion'] = '<a href="#" onclick="disconnect(this)" data-cnx="'.$IdDernierCnx.'" class="btn-deconnect-user-profil" title="Se déconnecter du '.date('Y-m-d H:i:s',$dateDernierCnx).'"><img scr="'.base_url().'assets/images/ACCUEIL/Logout.png"></a>';
              }

            if((isset($referenceCnxNow) && $referenceCnxNow != '') || (isset($IdDernierCnx) && $IdDernierCnx != '')){
                $retour['classSatusCnx'] = 'connecter';                  
                if ($IdDernierCnx !== $referenceCnxNow) {
                    //$retour['labeStatusCnx'] = 'Encore connecté depuis '.date('Y-m-d H:i:s',$dateDernierCnx);
                    $retour['labeStatusCnx'] = 'Problème de déconnexion';
                }
                else{
                    $retour['labeStatusCnx'] = 'En ligne';
                }
            }
            else{
                $retour['labeStatusCnx'] = 'Deconnecté';
                $retour['classSatusCnx'] = 'deconnecter';
            } 
        }
        echo json_encode($retour);
    }

    public function getInfosCnx(){
        $returns = array();
        $traikingInfosData = array();
        $i = 0;
        if (isset($_POST['traineeId'])) {
            $resultsCnx = $this->connexion_model->getAllCnxByUsers($_POST['traineeId']);
            foreach ($resultsCnx as $cnxInfos) {                
                $t = 0;
                $resultsTracking = $this->Tracking_model->getAllActivityByCnx($cnxInfos->idCnx);               
                foreach($resultsTracking as $trackingInfos){
                    $infosTrackingData = $this->getAllInfosByTracking($trackingInfos->module_id,$trackingInfos->sequence_id,$trackingInfos->chapitre_id,$trackingInfos->type);
                    $traikingInfosData[$t] = array(
                        'id'            => $trackingInfos->id_tracking,
                        'dateTracking'  => date('d-m-Y',$trackingInfos->date),
                        'debutTracking' => date('H:i:s', $trackingInfos->date),
                        'dureeTracking' => gmdate('H:i:s', $trackingInfos->time),
                        'Menu'          => $infosTrackingData['Menu'],
                        'SousMenu'      => $infosTrackingData['SousMenu'],
                        'Sequence'      => $infosTrackingData['Sequence'],
                        'Exercice'      => $infosTrackingData['Exercice'],
                        'idCnx'         => $trackingInfos->id_cnx
                    );
                    $t++;
                }
                $returns[$i]['connexionInfos'] = array(
                    'dateCnx'       => $cnxInfos->dateDebutCnx,
                    'debutCnx'      => $cnxInfos->debutCnx,
                    'dureeCnx'      => $cnxInfos->dureeCnx,
                    'idCnx'         => $cnxInfos->idCnx,
                    'Navigateur'    => $cnxInfos->navigateur,
                    'Plateforme'    => $cnxInfos->platform,
                    'nbActivite'    => count($resultsTracking),
                    'trackingInfos' => $traikingInfosData
                );
                $i++;

            }
            /*$returns['totalCnx'] = isset($i) ? $i : 0;
            $returns['totalAct'] = isset($t) ? $t : 0;*/
        }
        
        echo json_encode($returns);
    }
}

?>