<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/ElearningForma2PlusController.php';
/**
 * Class : DoctosignController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Doctosign extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('documentsign_model');
        $this->load->model('stat_model');
        
        $this->isLoggedIn();   
        $this->tracking_type = 16;  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->global['pageTitle'] = 'E-learning : Doctosign';
        $this->global['groupe'] = $this->session->userdata ('GROUPE');   
        $data['results']     = $this->documentsign_model->getListByTrainne($this->session->userdata ('GROUPE'))->result();
        $this->loadViews("trainee/documentsign/list", $this->global, $data , NULL);
    } 
}

?>