<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require APPPATH . '/libraries/ElearningForma2PlusController.php';
    require  APPPATH. '/libraries/ExportData.php';

    class Expression extends ElearningForma2PlusController
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct();
            $this->isLoggedIn();   
            $this->tracking_type = 39; 
        }
        
        /**
         * This function used to load the first screen of the user
         */
        public function index()
        {
            $this->load->library('user_agent');  
            $this->global['pageTitle'] = 'E-learning - Expression'; 
            $this->loadTrackingEl(0,0,$this->tracking_type);
            $this->global['groupe']    = $this->session->userdata ('STAGIAIREGRP');
            
            $data['allCategory']         = $this->databankExpression_model->getCategoryByIdGroup($this->session->userdata ('STAGIAIREGRP'));
            $data['allCategoryByTutor']   = $this->databankExpression_model->getCategoryByUserCreate($this->session->userdata ('GUSERID'));
            $data['allExpressionsResult']   = $this->databankExpression_model->getAllByTrainee($this->session->userdata('STAGIAIREID'));
            $data['langageList']         = $this->databankExpression_model->getLangageList();
            $data['userAgent']           = $this->agent->mobile();
            
            if ($this->agent->mobile()) {
                $this->loadViews("tutor/e-databank/mobilelist", $this->global, $data , NULL);
            }
            else{
                $this->loadViews("tutor/e-databank/pclist", $this->global, $data , NULL);
            }
        }


        public function add()
        {
            $additional_data = array();
            $category = NULL;
            if (isset($_POST)) {
                if (isset($_POST['dataExpression']['category_expression']) && is_numeric($_POST['dataExpression']['category_expression'])) {
                    $category =  $_POST['dataExpression']['category_expression'];
                }

                if (isset($_POST['dataExpression']['category_expression']) && !is_numeric($_POST['dataExpression']['category_expression'])) {
                    $dataCat = array(
                        'id_groupe' => $this->session->userdata ('STAGIAIREGRP'),
                        'intitule'  => $_POST['dataExpression']['category_expression']
                    );
                    $category = $this->databankExpression_Model->addCategory($dataCat);
                }
                $idTraineer = NULL;
                if($this->isTuteurConnet()){
                    $idTraineer = $this->session->userdata('GUSERID');
                }

                $additional_data = array(
                    'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                    'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                    'id_stagiaire'                    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                    'id_tuteur'                       => $this->session->userdata ('GUSERID'),
                    'id_category'                     => $category ,
                    'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible'],
                    'date_creation'                   => date("Y-m-d H:i:s"),
                    'user_create'                     => $this->session->userdata('GUSERID'),
                    'id_tuteur'                       => isset($idTraineer) ? $this->session->userdata('GUSERID') : NULL,
                );
                $this->databankExpression_Model->addExpression($additional_data);
                echo "OK";
            }
        }

        public function edit(){
            if (isset($_POST)) {
                $additional_data = array(
                    'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                    'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                    'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible']
                );
                $this->databankExpression_Model->editExpression($_POST['dataExpression']['idExpression'],$additional_data);
                echo "OK";
            }
        }

        public function delete(){
            if (isset($_POST['id'])) {
                $id   =  $_POST['id'];
                $this->databankExpression_Model->deleteExpression($id);
                echo $id;
            }
            
        }
        public function export(){
            if($_POST['json']){
                $data = json_decode($_POST['json']);             
                
                $exporter = new ExportDataExcel('browser', 'Export_expression.xls');
                $exporter->initialize();
                $exporter->addRow(array( "Origin", "Langage cible", "Cible", "Creation date")); 
               foreach($data as $keys => $value){
                    $rows[$keys] = $value;

                    foreach($rows as $key => $val){
                        $row[$key][0] = $val[0];
                        $row[$key][1] = $val[1];
                        $row[$key][2] = $val[2];
                        $row[$key][3] = $val[5];
                    }
                    $exporter->addRow($row[$keys]);
                }
                $exporter->finalize() ;
            } 
        }

        public function record(){
            $this->global['groupe']    = $this->session->userdata ('STAGIAIREGRP');
            $this->global['pageTitle'] = 'Record audio';
            if (isset($_GET) && $_GET['id'] != NULL) {
                $this->loadViews("tutor/e-databank/record", $this->global, NULL , NULL);
            }
        }
       
        public function uploadaudio(){
            if (isset($_GET) && $_GET['id'] != NULL) {
                $repgrp = RP_GROUPES."GRP".$this->session->userdata('STAGIAIREGRP')."/expression/";
                if ( ! is_dir($repgrp) ) {
                    mkdir($repgrp, 0777,true);
                }
                $size = $_FILES['audio_data']['size']; 
                $input = $_FILES['audio_data']['tmp_name'];

                $output = $this->session->userdata ('GUSERID')."_".time().".mp3";
                $destination = $repgrp.$output;
                if(@move_uploaded_file($input, $destination)){
                    $data = array('audio_langue_origine' => $output);
                    $this->databankExpression_model->addOriginAudio($_GET['id'],$data);
                    echo '###'.$destination;
                }
                else{
                    echo '###vvvvv'.$repgrp;
                }
            }
        }
    }

?>