<?php 
	class ElearningSupervisorForma2PlusController extends CI_Controller {
		protected $role = '';
		protected $vendorId = '';
		protected $name = '';
		protected $roleText = '';
		protected $GUSERID = '';
		protected $GEXTRANETID = '';
		protected $GUSER = '';
		protected $GUSERTYPE = '';
		protected $BAR = '';
		protected $MODE_ACCES = '';
		protected $GROUPE = '';
		protected $ACCES_FONCTIONS_ADMIN = '';
		protected $TUTEUR_ENTREPRISE = '';
		protected $TYPE = '';
		protected $ROLE = '';
		protected $CNX = '';
		protected $TRACKINGID = '';
		protected $STAGIAIREGRP = '';
		protected $SOCIETE = '';
		protected $IDSOCIETE = '';
		protected $PDP = '';
		protected $STAGIAIREEXTRANETID = '';
		protected $STAGIAIREID = '';
		protected $GUSERLOGIN;
		protected $STAGIAIRENAME;
		protected $GLOSSAIREONLINE;
		protected $IDSTAGE;
		protected $global = array ();

		public function __construct(){          
	        parent::__construct();
	        $this->load->model('connexion_model');

	    }
		/**
		 * Takes mixed data and optionally a status code, then creates the response
		 *
		 * @access public
		 * @param array|NULL $data
		 *        	Data to output to the user
		 *        	running the script; otherwise, exit
		 */
		public function response($data = NULL) {
			$this->output->set_status_header ( 200 )->set_content_type ( 'application/json', 'utf-8' )->set_output ( json_encode ( $data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES ) )->_display ();
			exit ();
		}
		
		/**
		 * This function used to check the user is logged in or not
		 */
		public function isLoggedIn() {
			$isLoggedIn = $this->session->userdata ( 'isLoggedIn' );
			$ncxExist   = $this->connexion_model->RequestByIdCnx ('id_connexion',$this->session->userdata ('CNX'));			
			if (! isset ( $isLoggedIn ) || $isLoggedIn != TRUE || $ncxExist == '') {
				$this->session->sess_destroy ();    
        		redirect ( 'login' );
			} else {
				$this->IDSTAGE                               = $this->session->userdata ( 'IDSTAGE' );
				$this->GUSERID                               = $this->session->userdata ( 'GUSERID' );
				$this->GUSERLOGIN                            = $this->session->userdata ( 'GUSERLOGIN' );			
				$this->ROLE                                  = $this->session->userdata ( 'ROLE' );			
				$this->GUSER                                 = $this->convert_utf8($this->session->userdata ( 'GUSER' ));
				$this->GEXTRANETID                           = $this->session->userdata ( 'GEXTRANETID' );
				$this->GUSERTYPE                             = $this->session->userdata ( 'GUSERTYPE' );
				$this->BAR                                   = $this->session->userdata ( 'BAR' );
				$this->MODE_ACCES                            = $this->session->userdata ( 'MODE_ACCES' );
				$this->GROUPE                                = $this->session->userdata ( 'GROUPE' );
				$this->ACCES_FONCTIONS_ADMIN                 = $this->session->userdata ( 'ACCES_FONCTIONS_ADMIN' );
				$this->TUTEUR_ENTREPRISE                     = $this->session->userdata ( 'TUTEUR_ENTREPRISE' );
				$this->TYPE                                  = $this->session->userdata ( 'TYPE' );
				$this->CNX                                   = $this->session->userdata ( 'CNX' );
				$this->IDSOCIETE                             = $this->session->userdata ( 'IDSOCIETE' );
				$this->SOCIETE                               = $this->session->userdata ( 'SOCIETE' );
				$this->PDP                                   = $this->session->userdata ( 'PDP' );
				$this->STAGIAIRENAME                         = $this->session->userdata ( 'STAGIAIRENAME' );
				$this->STAGIAIREID                           = $this->session->userdata ( 'STAGIAIREID' );
				$this->STAGIAIREGRP                          = $this->session->userdata ( 'STAGIAIREGRP' );
				$this->GLOSSAIREONLINE                       = $this->session->userdata ( 'GLOSSAIREONLINE' );
				
				$this->global ['IDSTAGE']                      = $this->convert_utf8($this->IDSTAGE);
				$this->global ['GUSER']                      = $this->convert_utf8($this->GUSER);
				$this->global ['ROLE']                       = $this->ROLE;
				$this->global ['GEXTRANETID']                = $this->GEXTRANETID;
				$this->global ['GUSERID']                    = $this->GUSERID;
				$this->global ['GUSERTYPE']                  = $this->GUSERTYPE;
				$this->global ['BAR']                        = $this->BAR;
				$this->global ['MODE_ACCES']                 = $this->MODE_ACCES;
				$this->global ['GROUPE']                     = $this->GROUPE;
				$this->global ['ACCES_FONCTIONS_ADMIN']      = $this->ACCES_FONCTIONS_ADMIN;
				$this->global ['TUTEUR_ENTREPRISE']          = $this->TUTEUR_ENTREPRISE;
				$this->global ['TYPE']                       = $this->TYPE;
				$this->global ['CNX']                        = $this->CNX;
				$this->global ['STAGIAIREGRP']               = $this->STAGIAIREGRP;
				$this->global ['STAGIAIREEXTRANETID']        = $this->STAGIAIREEXTRANETID;
				$this->global ['STAGIAIRENAME']              = $this->STAGIAIRENAME;
				$this->global ['IDSOCIETE']                  = $this->IDSOCIETE;
				$this->global ['SOCIETE']                    = $this->SOCIETE;
				$this->global ['PDP']                        = $this->PDP;
				$this->global ['STAGIAIREID']                = $this->STAGIAIREID;
				$this->global ['TRACKINGID']                 = $this->TRACKINGID;
				$this->global ['GUSERLOGIN']                 = $this->GUSERLOGIN;
				$this->global ['GLOSSAIREONLINE']            = $this->GLOSSAIREONLINE;

				if ($this->isTuteurConnet()) {
					$this->global ['LISTAUTO']               = $this->groupes_model->readGroupStagiaire($this->session->userdata ('GUSERID'));
				
				}

				if ($this->global['GUSERTYPE']==STAGIAIRE) {

					$this->global ['DATABANKEXPRESSIONS']               = $this->databankExpression_model->read($this->session->userdata ('GUSERID'));
				}
			}
		}
		
		/**
		 * This function is used to check the access
		 */
		public function isAdmin() {
			if ($this->TYPE == ADMIN) {
				return true;
			} 
			else {
				return false;
			}
		}

		public function isSupervisor() {
			if ($this->TYPE == SUPERVISEUR) {
				return true;
			} 
			else {
				return false;
			}
		}

		public function isTuteur() {
			if ($this->TYPE != TUTEUR) {
				$return = "";
			} 
			else {
				$return = $this->groupes_model->readGrpTutor($this->session->userdata ('GUSERID'));		
			}
			return $return;
		}
		
		/**
		 * This function is used to check the access
		 */
		public function isTicketter() {
			if ($this->TYPE != ADMIN || $this->TYPE != SUPERVISEUR) {
				return true;
			} else {
				return false;
			}
		}

		public function isTrainee() {
			if ($this->TYPE == STAGIAIRE && $this->MODE_ACCES != "3") {
				return true;
			} else {
				return false;
			}
		}

		public function isAdministratif() {
			if ($this->TYPE == STAGIAIRE && $this->MODE_ACCES == "3") {
				return true;
			} else {
				return false;
			}
		}

	    public function isTuteurConnet() {
			if ($this->TYPE == TUTEUR) {
				return true;
			} else {
				return false;
			}
		}
		
		
		/**
		 * This function is used to load the set of views
		 */
		public function loadThis() {
			$this->global ['pageTitle'] = 'Plateforme E-learning : Access Denied';	
			$this->load->view ( 'includes/header', $this->global );
			$this->load->view ( 'access' );
			$this->load->view ( 'includes/footer' );
		}
		
		/**
		 * This function is used to logged out user from system
		 */
		public function logout() {
			$this->session->sess_destroy ();	
			redirect ( 'login' );
		}

	    public function loadViews($viewName = "", $headerInfo = NULL, $pageInfo = NULL, $footerInfo = NULL){
	    	$this->load->library('Encodage_Library');
	    	if ($this->isTuteurConnet()) {

	    		$this->load->view('includes/templates/professor/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/professor/footer', $footerInfo);        	
	    	}
	    	elseif ($this->isAdmin()) {
				$this->load->view('includes/templates/admin/header', $headerInfo);
				$this->load->view($viewName, $pageInfo);

	    		$this->load->view('includes/templates/admin/footer', $footerInfo); 
	    	}
	    	elseif ($this->isSupervisor()) {
	    		$this->load->view('includes/templates/supervisor/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/supervisor/footer', $footerInfo); 
	    	}
	    	elseif ($this->isTrainee() || $this->isAdministratif()) {
	    		$this->load->view('includes/templates/trainee/trainee_header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/templates/trainee/trainee_footer', $footerInfo);
	    	}
	    	else{
	    		$this->load->view('includes/header', $headerInfo);
	    		$this->load->view($viewName, $pageInfo);
	    		$this->load->view('includes/footer', $footerInfo);        	
	    	}
	    	
	        
	    }
	    public  function convert_utf8($str) {
		    $new2old = array(
		      'á' => 'Ã¡',
		      'À' => 'Ã€',
		      'ä' => 'Ã¤',
		      'Ä' => 'Ã„',
		      'ã' => 'Ã£',
		      'å' => 'Ã¥',
		      'Å' => 'Ã…',
		      'æ' => 'Ã¦',
		      'Æ' => 'Ã†',
		      'ç' => 'Ã§',
		      'Ç' => 'Ã‡',
		      'é' => 'Ã©',
		      'É' => 'Ã‰',
		      'è' => 'Ã¨',
		      'È' => 'Ãˆ',
		      'ê' => 'Ãª',
		      'Ê' => 'ÃŠ',
		      'ë' => 'Ã«',
		      'Ë' => 'Ã‹',
		      //'í' => 'Ã-',
		      //'Í' => 'Ã',
		      'ì' => 'Ã¬',
		      'Ì' => 'ÃŒ',
		      'î' => 'Ã®',
		      'Î' => 'ÃŽ',
		      'ï' => 'Ã¯',
		      //'à' => 'Ã ',
		      'ñ' => 'Ã±',
		      'Ñ' => 'Ã‘',
		      'ó' => 'Ã³',
		      'Ó' => 'Ã“',
		      'ò' => 'Ã²',
		      'Ò' => 'Ã’',
		      'ô' => 'Ã´',
		      'Ô' => 'Ã”',
		      'ö' => 'Ã¶',
		      'Ö' => 'Ã–',
		      'õ' => 'Ãµ',
		      'Õ' => 'Ã•',
		      'ø' => 'Ã¸',
		      'Ø' => 'Ã˜',
		      'œ' => 'Å“',
		      'Œ' => 'Å’',
		      'ß' => 'ÃŸ',
		      'ú' => 'Ãº',
		      'Ú' => 'Ãš',
		      'ù' => 'Ã¹',
		      'Ù' => 'Ã™',
		      'û' => 'Ã»',
		      'Û' => 'Ã›',
		      'ü' => 'Ã¼',
		      'Ü' => 'Ãœ',
		      '€' => 'â‚¬',
		      '’' => 'â€™',
		      '‚' => 'â€š',
		      'ƒ' => 'Æ’',
		      '„' => 'â€ž',
		      '…' => 'â€¦',
		      '‡' => 'â€¡',
		      'ˆ' => 'Ë†',
		      '‰' => 'â€°',
		      'Š' => 'Å ',
		      '‹' => 'â€¹',
		      'Ž' => 'Å½',
		      '‘' => 'â€˜',
		      '“' => 'â€œ',
		      '•' => 'â€¢',
		      '–' => 'â€“',
		      '—' => 'â€”',
		      '˜' => 'Ëœ',
		      '™' => 'â„¢',
		      'š' => 'Å¡',
		      '›' => 'â€º',
		      'ž' => 'Å¾',
		      'Ÿ' => 'Å¸',
		      '¡' => 'Â¡',
		      '¢' => 'Â¢',
		      '£' => 'Â£',
		      '¤' => 'Â¤',
		      '¥' => 'Â¥',
		      '¦' => 'Â¦',
		      '§' => 'Â§',
		      '¨' => 'Â¨',
		      '©' => 'Â©',
		      'ª' => 'Âª',
		      '«' => 'Â«',
		      '¬' => 'Â¬',
		      '®' => 'Â®',
		      '¯' => 'Â¯',
		      '°' => 'Â°',
		      '±' => 'Â±',
		      '²' => 'Â²',
		      '³' => 'Â³',
		      '´' => 'Â´',
		      'µ' => 'Âµ',
		      '¶' => 'Â¶',
		      '·' => 'Â·',
		      '¸' => 'Â¸',
		      '¹' => 'Â¹',
		      'º' => 'Âº',
		      '»' => 'Â»',
		      '¼' => 'Â¼',
		      '½' => 'Â½',
		      '¾' => 'Â¾',
		      '¿' => 'Â¿',
		      'à' => 'Ã',
		      '†' => 'â€ ',
		      '”' => 'â€',
		      //'Á' => 'Ã',
		      'â' => 'Ã¢',
		      'Â' => 'Ã‚',
		      'Ã' => 'Ãƒ',
		      'â' => 'Ã¢',
		      'ô' => 'Í´',
		      'î' => 'Í®',
		      'ù' => 'à¹',
		      'oe' => 'Å"',
		          '”' => 'â€',
		    );
		    $new = array();
		    $old = array();
		    foreach( $new2old as $key => $value ) {
		      $new[] = $key;
		      $old[] = $value;
		    }
		    return str_replace( $old, $new, $str );
  		}

	    public function loadTrackingEl($sequence_id,$chapitre_id,$type,$module_id=''){
	    	$trackingid = $this->tracking_model->Add($sequence_id,$chapitre_id,$type,$module_id);
            $sessionArray = array('TRACKINGID'=>$trackingid);                                    
            $this->session->set_userdata($sessionArray);
            $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
            return $trackingid;
	    }

	}
