<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/metastore/v1alpha/metastore_federation.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Metastore\V1alpha\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Metastore\V1alpha\CreateFederationRequest;
use Google\Cloud\Metastore\V1alpha\DeleteFederationRequest;
use Google\Cloud\Metastore\V1alpha\Federation;
use Google\Cloud\Metastore\V1alpha\GetFederationRequest;
use Google\Cloud\Metastore\V1alpha\ListFederationsRequest;
use Google\Cloud\Metastore\V1alpha\ListFederationsResponse;
use Google\Cloud\Metastore\V1alpha\UpdateFederationRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Configures and manages metastore federation services.
 * Dataproc Metastore Federation Service allows federating a collection of
 * backend metastores like BigQuery, Dataplex Lakes, and other Dataproc
 * Metastores. The Federation Service exposes a gRPC URL through which metadata
 * from the backend metastores are served at query time.
 *
 * The Dataproc Metastore Federation API defines the following resource model:
 * * The service works with a collection of Google Cloud projects.
 * * Each project has a collection of available locations.
 * * Each location has a collection of federations.
 * * Dataproc Metastore Federations are resources with names of the
 * form:
 * `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataprocMetastoreFederationClient = new DataprocMetastoreFederationClient();
 * try {
 *     $formattedParent = $dataprocMetastoreFederationClient->locationName('[PROJECT]', '[LOCATION]');
 *     $federationId = 'federation_id';
 *     $federation = new Federation();
 *     $operationResponse = $dataprocMetastoreFederationClient->createFederation($formattedParent, $federationId, $federation);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $dataprocMetastoreFederationClient->createFederation($formattedParent, $federationId, $federation);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $dataprocMetastoreFederationClient->resumeOperation($operationName, 'createFederation');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $dataprocMetastoreFederationClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 */
class DataprocMetastoreFederationGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.metastore.v1alpha.DataprocMetastoreFederation';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'metastore.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $federationNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/dataproc_metastore_federation_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/dataproc_metastore_federation_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/dataproc_metastore_federation_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/dataproc_metastore_federation_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getFederationNameTemplate()
    {
        if (self::$federationNameTemplate == null) {
            self::$federationNameTemplate = new PathTemplate('projects/{project}/locations/{location}/federations/{federation}');
        }

        return self::$federationNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'federation' => self::getFederationNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a federation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $federation
     *
     * @return string The formatted federation resource.
     *
     * @experimental
     */
    public static function federationName($project, $location, $federation)
    {
        return self::getFederationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'federation' => $federation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     *
     * @experimental
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - federation: projects/{project}/locations/{location}/federations/{federation}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'metastore.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a metastore federation in a project and location.
     *
     * Sample code:
     * ```
     * $dataprocMetastoreFederationClient = new DataprocMetastoreFederationClient();
     * try {
     *     $formattedParent = $dataprocMetastoreFederationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $federationId = 'federation_id';
     *     $federation = new Federation();
     *     $operationResponse = $dataprocMetastoreFederationClient->createFederation($formattedParent, $federationId, $federation);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataprocMetastoreFederationClient->createFederation($formattedParent, $federationId, $federation);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataprocMetastoreFederationClient->resumeOperation($operationName, 'createFederation');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataprocMetastoreFederationClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The relative resource name of the location in which to create a
     *                                 federation service, in the following form:
     *
     *                                 `projects/{project_number}/locations/{location_id}`.
     * @param string     $federationId Required. The ID of the metastore federation, which is used as the final
     *                                 component of the metastore federation's name.
     *
     *                                 This value must be between 2 and 63 characters long inclusive, begin with a
     *                                 letter, end with a letter or number, and consist of alpha-numeric
     *                                 ASCII characters or hyphens.
     * @param Federation $federation   Required. The Metastore Federation to create. The `name` field is
     *                                 ignored. The ID of the created metastore federation must be
     *                                 provided in the request's `federation_id` field.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID. Specify a unique request ID to allow the server to
     *           ignore the request if it has completed. The server will ignore subsequent
     *           requests that provide a duplicate request ID for at least 60 minutes after
     *           the first request.
     *
     *           For example, if an initial request times out, followed by another request
     *           with the same request ID, the server ignores the second request to prevent
     *           the creation of duplicate commitments.
     *
     *           The request ID must be a valid
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     *           A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createFederation($parent, $federationId, $federation, array $optionalArgs = [])
    {
        $request = new CreateFederationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFederationId($federationId);
        $request->setFederation($federation);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateFederation', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single federation.
     *
     * Sample code:
     * ```
     * $dataprocMetastoreFederationClient = new DataprocMetastoreFederationClient();
     * try {
     *     $formattedName = $dataprocMetastoreFederationClient->federationName('[PROJECT]', '[LOCATION]', '[FEDERATION]');
     *     $operationResponse = $dataprocMetastoreFederationClient->deleteFederation($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataprocMetastoreFederationClient->deleteFederation($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataprocMetastoreFederationClient->resumeOperation($operationName, 'deleteFederation');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataprocMetastoreFederationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The relative resource name of the metastore federation to delete,
     *                             in the following form:
     *
     *                             `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID. Specify a unique request ID to allow the server to
     *           ignore the request if it has completed. The server will ignore subsequent
     *           requests that provide a duplicate request ID for at least 60 minutes after
     *           the first request.
     *
     *           For example, if an initial request times out, followed by another request
     *           with the same request ID, the server ignores the second request to prevent
     *           the creation of duplicate commitments.
     *
     *           The request ID must be a valid
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     *           A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteFederation($name, array $optionalArgs = [])
    {
        $request = new DeleteFederationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteFederation', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets the details of a single federation.
     *
     * Sample code:
     * ```
     * $dataprocMetastoreFederationClient = new DataprocMetastoreFederationClient();
     * try {
     *     $formattedName = $dataprocMetastoreFederationClient->federationName('[PROJECT]', '[LOCATION]', '[FEDERATION]');
     *     $response = $dataprocMetastoreFederationClient->getFederation($formattedName);
     * } finally {
     *     $dataprocMetastoreFederationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The relative resource name of the metastore federation to
     *                             retrieve, in the following form:
     *
     *                             `projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Metastore\V1alpha\Federation
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getFederation($name, array $optionalArgs = [])
    {
        $request = new GetFederationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetFederation', Federation::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists federations in a project and location.
     *
     * Sample code:
     * ```
     * $dataprocMetastoreFederationClient = new DataprocMetastoreFederationClient();
     * try {
     *     $formattedParent = $dataprocMetastoreFederationClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataprocMetastoreFederationClient->listFederations($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataprocMetastoreFederationClient->listFederations($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataprocMetastoreFederationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The relative resource name of the location of metastore
     *                             federations to list, in the following form:
     *                             `projects/{project_number}/locations/{location_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. The filter to apply to list results.
     *     @type string $orderBy
     *           Optional. Specify the ordering of results as described in [Sorting
     *           Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
     *           If not specified, the results will be sorted in the default order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listFederations($parent, array $optionalArgs = [])
    {
        $request = new ListFederationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListFederations', $optionalArgs, ListFederationsResponse::class, $request);
    }

    /**
     * Updates the fields of a federation.
     *
     * Sample code:
     * ```
     * $dataprocMetastoreFederationClient = new DataprocMetastoreFederationClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $federation = new Federation();
     *     $operationResponse = $dataprocMetastoreFederationClient->updateFederation($updateMask, $federation);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataprocMetastoreFederationClient->updateFederation($updateMask, $federation);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataprocMetastoreFederationClient->resumeOperation($operationName, 'updateFederation');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataprocMetastoreFederationClient->close();
     * }
     * ```
     *
     * @param FieldMask  $updateMask   Required. A field mask used to specify the fields to be overwritten in the
     *                                 metastore federation resource by the update.
     *                                 Fields specified in the `update_mask` are relative to the resource (not
     *                                 to the full request). A field is overwritten if it is in the mask.
     * @param Federation $federation   Required. The metastore federation to update. The server only merges fields
     *                                 in the service if they are specified in `update_mask`.
     *
     *                                 The metastore federation's `name` field is used to identify the
     *                                 metastore service to be updated.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID. Specify a unique request ID to allow the server to
     *           ignore the request if it has completed. The server will ignore subsequent
     *           requests that provide a duplicate request ID for at least 60 minutes after
     *           the first request.
     *
     *           For example, if an initial request times out, followed by another request
     *           with the same request ID, the server ignores the second request to prevent
     *           the creation of duplicate commitments.
     *
     *           The request ID must be a valid
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     *           A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateFederation($updateMask, $federation, array $optionalArgs = [])
    {
        $request = new UpdateFederationRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setFederation($federation);
        $requestParamHeaders['federation.name'] = $federation->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateFederation', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
