<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/conversation_event.proto

namespace Google\Cloud\Dialogflow\V2\ConversationEvent;

use UnexpectedValueException;

/**
 * Enumeration of the types of events available.
 *
 * Protobuf type <code>google.cloud.dialogflow.v2.ConversationEvent.Type</code>
 */
class Type
{
    /**
     * Type not set.
     *
     * Generated from protobuf enum <code>TYPE_UNSPECIFIED = 0;</code>
     */
    const TYPE_UNSPECIFIED = 0;
    /**
     * A new conversation has been opened. This is fired when a telephone call
     * is answered, or a conversation is created via the API.
     *
     * Generated from protobuf enum <code>CONVERSATION_STARTED = 1;</code>
     */
    const CONVERSATION_STARTED = 1;
    /**
     * An existing conversation has closed. This is fired when a telephone call
     * is terminated, or a conversation is closed via the API.
     *
     * Generated from protobuf enum <code>CONVERSATION_FINISHED = 2;</code>
     */
    const CONVERSATION_FINISHED = 2;
    /**
     * An existing conversation has received notification from Dialogflow that
     * human intervention is required.
     *
     * Generated from protobuf enum <code>HUMAN_INTERVENTION_NEEDED = 3;</code>
     */
    const HUMAN_INTERVENTION_NEEDED = 3;
    /**
     * An existing conversation has received a new message, either from API or
     * telephony. It is configured in
     * [ConversationProfile.new_message_event_notification_config][google.cloud.dialogflow.v2.ConversationProfile.new_message_event_notification_config]
     *
     * Generated from protobuf enum <code>NEW_MESSAGE = 5;</code>
     */
    const NEW_MESSAGE = 5;
    /**
     * Unrecoverable error during a telephone call.
     * In general non-recoverable errors only occur if something was
     * misconfigured in the ConversationProfile corresponding to the call. After
     * a non-recoverable error, Dialogflow may stop responding.
     * We don't fire this event:
     * * in an API call because we can directly return the error, or,
     * * when we can recover from an error.
     *
     * Generated from protobuf enum <code>UNRECOVERABLE_ERROR = 4;</code>
     */
    const UNRECOVERABLE_ERROR = 4;

    private static $valueToName = [
        self::TYPE_UNSPECIFIED => 'TYPE_UNSPECIFIED',
        self::CONVERSATION_STARTED => 'CONVERSATION_STARTED',
        self::CONVERSATION_FINISHED => 'CONVERSATION_FINISHED',
        self::HUMAN_INTERVENTION_NEEDED => 'HUMAN_INTERVENTION_NEEDED',
        self::NEW_MESSAGE => 'NEW_MESSAGE',
        self::UNRECOVERABLE_ERROR => 'UNRECOVERABLE_ERROR',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


