<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/kms/v1/ekm_service.proto

namespace Google\Cloud\Kms\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A [Certificate][google.cloud.kms.v1.Certificate] represents an X.509
 * certificate used to authenticate HTTPS connections to EKM replicas.
 *
 * Generated from protobuf message <code>google.cloud.kms.v1.Certificate</code>
 */
class Certificate extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The raw certificate bytes in DER format.
     *
     * Generated from protobuf field <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $raw_der = '';
    /**
     * Output only. True if the certificate was parsed successfully.
     *
     * Generated from protobuf field <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $parsed = false;
    /**
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $issuer = '';
    /**
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $subject = '';
    /**
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $subject_alternative_dns_names;
    /**
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $not_before_time = null;
    /**
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $not_after_time = null;
    /**
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $serial_number = '';
    /**
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $sha256_fingerprint = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $raw_der
     *           Required. The raw certificate bytes in DER format.
     *     @type bool $parsed
     *           Output only. True if the certificate was parsed successfully.
     *     @type string $issuer
     *           Output only. The issuer distinguished name in RFC 2253 format. Only present
     *           if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *     @type string $subject
     *           Output only. The subject distinguished name in RFC 2253 format. Only
     *           present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $subject_alternative_dns_names
     *           Output only. The subject Alternative DNS names. Only present if
     *           [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *     @type \Google\Protobuf\Timestamp $not_before_time
     *           Output only. The certificate is not valid before this time. Only present if
     *           [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *     @type \Google\Protobuf\Timestamp $not_after_time
     *           Output only. The certificate is not valid after this time. Only present if
     *           [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *     @type string $serial_number
     *           Output only. The certificate serial number as a hex string. Only present if
     *           [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *     @type string $sha256_fingerprint
     *           Output only. The SHA-256 certificate fingerprint as a hex string. Only
     *           present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Kms\V1\EkmService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The raw certificate bytes in DER format.
     *
     * Generated from protobuf field <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getRawDer()
    {
        return $this->raw_der;
    }

    /**
     * Required. The raw certificate bytes in DER format.
     *
     * Generated from protobuf field <code>bytes raw_der = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setRawDer($var)
    {
        GPBUtil::checkString($var, False);
        $this->raw_der = $var;

        return $this;
    }

    /**
     * Output only. True if the certificate was parsed successfully.
     *
     * Generated from protobuf field <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getParsed()
    {
        return $this->parsed;
    }

    /**
     * Output only. True if the certificate was parsed successfully.
     *
     * Generated from protobuf field <code>bool parsed = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setParsed($var)
    {
        GPBUtil::checkBool($var);
        $this->parsed = $var;

        return $this;
    }

    /**
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getIssuer()
    {
        return $this->issuer;
    }

    /**
     * Output only. The issuer distinguished name in RFC 2253 format. Only present
     * if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string issuer = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setIssuer($var)
    {
        GPBUtil::checkString($var, True);
        $this->issuer = $var;

        return $this;
    }

    /**
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * Output only. The subject distinguished name in RFC 2253 format. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string subject = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSubject($var)
    {
        GPBUtil::checkString($var, True);
        $this->subject = $var;

        return $this;
    }

    /**
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSubjectAlternativeDnsNames()
    {
        return $this->subject_alternative_dns_names;
    }

    /**
     * Output only. The subject Alternative DNS names. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>repeated string subject_alternative_dns_names = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSubjectAlternativeDnsNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->subject_alternative_dns_names = $arr;

        return $this;
    }

    /**
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getNotBeforeTime()
    {
        return $this->not_before_time;
    }

    public function hasNotBeforeTime()
    {
        return isset($this->not_before_time);
    }

    public function clearNotBeforeTime()
    {
        unset($this->not_before_time);
    }

    /**
     * Output only. The certificate is not valid before this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp not_before_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setNotBeforeTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->not_before_time = $var;

        return $this;
    }

    /**
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getNotAfterTime()
    {
        return $this->not_after_time;
    }

    public function hasNotAfterTime()
    {
        return isset($this->not_after_time);
    }

    public function clearNotAfterTime()
    {
        unset($this->not_after_time);
    }

    /**
     * Output only. The certificate is not valid after this time. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp not_after_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setNotAfterTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->not_after_time = $var;

        return $this;
    }

    /**
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->serial_number;
    }

    /**
     * Output only. The certificate serial number as a hex string. Only present if
     * [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string serial_number = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSerialNumber($var)
    {
        GPBUtil::checkString($var, True);
        $this->serial_number = $var;

        return $this;
    }

    /**
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSha256Fingerprint()
    {
        return $this->sha256_fingerprint;
    }

    /**
     * Output only. The SHA-256 certificate fingerprint as a hex string. Only
     * present if [parsed][google.cloud.kms.v1.Certificate.parsed] is true.
     *
     * Generated from protobuf field <code>string sha256_fingerprint = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSha256Fingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->sha256_fingerprint = $var;

        return $this;
    }

}

