<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/inventory.proto

namespace Google\Cloud\OsConfig\V1\Inventory;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details related to a Windows Update package.
 * Field data and names are taken from Windows Update API IUpdate Interface:
 * https://docs.microsoft.com/en-us/windows/win32/api/_wua/
 * Descriptive fields like title, and description are localized based on
 * the locale of the VM being updated.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.Inventory.WindowsUpdatePackage</code>
 */
class WindowsUpdatePackage extends \Google\Protobuf\Internal\Message
{
    /**
     * The localized title of the update package.
     *
     * Generated from protobuf field <code>string title = 1;</code>
     */
    private $title = '';
    /**
     * The localized description of the update package.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * The categories that are associated with this update package.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;</code>
     */
    private $categories;
    /**
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     *
     * Generated from protobuf field <code>repeated string kb_article_ids = 4;</code>
     */
    private $kb_article_ids;
    /**
     * A hyperlink to the language-specific support information for the update.
     *
     * Generated from protobuf field <code>string support_url = 11;</code>
     */
    private $support_url = '';
    /**
     * A collection of URLs that provide more information about the update
     * package.
     *
     * Generated from protobuf field <code>repeated string more_info_urls = 5;</code>
     */
    private $more_info_urls;
    /**
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     *
     * Generated from protobuf field <code>string update_id = 6;</code>
     */
    private $update_id = '';
    /**
     * The revision number of this update package.
     *
     * Generated from protobuf field <code>int32 revision_number = 7;</code>
     */
    private $revision_number = 0;
    /**
     * The last published date of the update, in (UTC) date and time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     */
    private $last_deployment_change_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $title
     *           The localized title of the update package.
     *     @type string $description
     *           The localized description of the update package.
     *     @type array<\Google\Cloud\OsConfig\V1\Inventory\WindowsUpdatePackage\WindowsUpdateCategory>|\Google\Protobuf\Internal\RepeatedField $categories
     *           The categories that are associated with this update package.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $kb_article_ids
     *           A collection of Microsoft Knowledge Base article IDs that are associated
     *           with the update package.
     *     @type string $support_url
     *           A hyperlink to the language-specific support information for the update.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $more_info_urls
     *           A collection of URLs that provide more information about the update
     *           package.
     *     @type string $update_id
     *           Gets the identifier of an update package.  Stays the same across
     *           revisions.
     *     @type int $revision_number
     *           The revision number of this update package.
     *     @type \Google\Protobuf\Timestamp $last_deployment_change_time
     *           The last published date of the update, in (UTC) date and time.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\Inventory::initOnce();
        parent::__construct($data);
    }

    /**
     * The localized title of the update package.
     *
     * Generated from protobuf field <code>string title = 1;</code>
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * The localized title of the update package.
     *
     * Generated from protobuf field <code>string title = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * The localized description of the update package.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The localized description of the update package.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The categories that are associated with this update package.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * The categories that are associated with this update package.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;</code>
     * @param array<\Google\Cloud\OsConfig\V1\Inventory\WindowsUpdatePackage\WindowsUpdateCategory>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\Inventory\WindowsUpdatePackage\WindowsUpdateCategory::class);
        $this->categories = $arr;

        return $this;
    }

    /**
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     *
     * Generated from protobuf field <code>repeated string kb_article_ids = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getKbArticleIds()
    {
        return $this->kb_article_ids;
    }

    /**
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     *
     * Generated from protobuf field <code>repeated string kb_article_ids = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setKbArticleIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->kb_article_ids = $arr;

        return $this;
    }

    /**
     * A hyperlink to the language-specific support information for the update.
     *
     * Generated from protobuf field <code>string support_url = 11;</code>
     * @return string
     */
    public function getSupportUrl()
    {
        return $this->support_url;
    }

    /**
     * A hyperlink to the language-specific support information for the update.
     *
     * Generated from protobuf field <code>string support_url = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setSupportUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->support_url = $var;

        return $this;
    }

    /**
     * A collection of URLs that provide more information about the update
     * package.
     *
     * Generated from protobuf field <code>repeated string more_info_urls = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMoreInfoUrls()
    {
        return $this->more_info_urls;
    }

    /**
     * A collection of URLs that provide more information about the update
     * package.
     *
     * Generated from protobuf field <code>repeated string more_info_urls = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMoreInfoUrls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->more_info_urls = $arr;

        return $this;
    }

    /**
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     *
     * Generated from protobuf field <code>string update_id = 6;</code>
     * @return string
     */
    public function getUpdateId()
    {
        return $this->update_id;
    }

    /**
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     *
     * Generated from protobuf field <code>string update_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setUpdateId($var)
    {
        GPBUtil::checkString($var, True);
        $this->update_id = $var;

        return $this;
    }

    /**
     * The revision number of this update package.
     *
     * Generated from protobuf field <code>int32 revision_number = 7;</code>
     * @return int
     */
    public function getRevisionNumber()
    {
        return $this->revision_number;
    }

    /**
     * The revision number of this update package.
     *
     * Generated from protobuf field <code>int32 revision_number = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setRevisionNumber($var)
    {
        GPBUtil::checkInt32($var);
        $this->revision_number = $var;

        return $this;
    }

    /**
     * The last published date of the update, in (UTC) date and time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastDeploymentChangeTime()
    {
        return $this->last_deployment_change_time;
    }

    public function hasLastDeploymentChangeTime()
    {
        return isset($this->last_deployment_change_time);
    }

    public function clearLastDeploymentChangeTime()
    {
        unset($this->last_deployment_change_time);
    }

    /**
     * The last published date of the update, in (UTC) date and time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastDeploymentChangeTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_deployment_change_time = $var;

        return $this;
    }

}


