<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/os_policy.proto

namespace Google\Cloud\OsConfig\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An OS policy defines the desired state configuration for a VM.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.OSPolicy</code>
 */
class OSPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The id of the OS policy with the following restrictions:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the assignment.
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $id = '';
    /**
     * Policy description.
     * Length of the description is limited to 1024 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * Required. Policy mode
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicy.Mode mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $mode = 0;
    /**
     * Required. List of resource groups for the policy.
     * For a particular VM, resource groups are evaluated in the order specified
     * and the first resource group that is applicable is selected and the rest
     * are ignored.
     * If none of the resource groups are applicable for a VM, the VM is
     * considered to be non-compliant w.r.t this policy. This behavior can be
     * toggled by the flag `allow_no_resource_group_match`
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $resource_groups;
    /**
     * This flag determines the OS policy compliance status when none of the
     * resource groups within the policy are applicable for a VM. Set this value
     * to `true` if the policy needs to be reported as compliant even if the
     * policy has nothing to validate or enforce.
     *
     * Generated from protobuf field <code>bool allow_no_resource_group_match = 5;</code>
     */
    private $allow_no_resource_group_match = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           Required. The id of the OS policy with the following restrictions:
     *           * Must contain only lowercase letters, numbers, and hyphens.
     *           * Must start with a letter.
     *           * Must be between 1-63 characters.
     *           * Must end with a number or a letter.
     *           * Must be unique within the assignment.
     *     @type string $description
     *           Policy description.
     *           Length of the description is limited to 1024 characters.
     *     @type int $mode
     *           Required. Policy mode
     *     @type array<\Google\Cloud\OsConfig\V1\OSPolicy\ResourceGroup>|\Google\Protobuf\Internal\RepeatedField $resource_groups
     *           Required. List of resource groups for the policy.
     *           For a particular VM, resource groups are evaluated in the order specified
     *           and the first resource group that is applicable is selected and the rest
     *           are ignored.
     *           If none of the resource groups are applicable for a VM, the VM is
     *           considered to be non-compliant w.r.t this policy. This behavior can be
     *           toggled by the flag `allow_no_resource_group_match`
     *     @type bool $allow_no_resource_group_match
     *           This flag determines the OS policy compliance status when none of the
     *           resource groups within the policy are applicable for a VM. Set this value
     *           to `true` if the policy needs to be reported as compliant even if the
     *           policy has nothing to validate or enforce.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\OsPolicy::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The id of the OS policy with the following restrictions:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the assignment.
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Required. The id of the OS policy with the following restrictions:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the assignment.
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Policy description.
     * Length of the description is limited to 1024 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Policy description.
     * Length of the description is limited to 1024 characters.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. Policy mode
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicy.Mode mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * Required. Policy mode
     *
     * Generated from protobuf field <code>.google.cloud.osconfig.v1.OSPolicy.Mode mode = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OsConfig\V1\OSPolicy\Mode::class);
        $this->mode = $var;

        return $this;
    }

    /**
     * Required. List of resource groups for the policy.
     * For a particular VM, resource groups are evaluated in the order specified
     * and the first resource group that is applicable is selected and the rest
     * are ignored.
     * If none of the resource groups are applicable for a VM, the VM is
     * considered to be non-compliant w.r.t this policy. This behavior can be
     * toggled by the flag `allow_no_resource_group_match`
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourceGroups()
    {
        return $this->resource_groups;
    }

    /**
     * Required. List of resource groups for the policy.
     * For a particular VM, resource groups are evaluated in the order specified
     * and the first resource group that is applicable is selected and the rest
     * are ignored.
     * If none of the resource groups are applicable for a VM, the VM is
     * considered to be non-compliant w.r.t this policy. This behavior can be
     * toggled by the flag `allow_no_resource_group_match`
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\OsConfig\V1\OSPolicy\ResourceGroup>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourceGroups($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\OSPolicy\ResourceGroup::class);
        $this->resource_groups = $arr;

        return $this;
    }

    /**
     * This flag determines the OS policy compliance status when none of the
     * resource groups within the policy are applicable for a VM. Set this value
     * to `true` if the policy needs to be reported as compliant even if the
     * policy has nothing to validate or enforce.
     *
     * Generated from protobuf field <code>bool allow_no_resource_group_match = 5;</code>
     * @return bool
     */
    public function getAllowNoResourceGroupMatch()
    {
        return $this->allow_no_resource_group_match;
    }

    /**
     * This flag determines the OS policy compliance status when none of the
     * resource groups within the policy are applicable for a VM. Set this value
     * to `true` if the policy needs to be reported as compliant even if the
     * policy has nothing to validate or enforce.
     *
     * Generated from protobuf field <code>bool allow_no_resource_group_match = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowNoResourceGroupMatch($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_no_resource_group_match = $var;

        return $this;
    }

}

