<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/search_service.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Response message for
 * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SearchResponse</code>
 */
class SearchResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * A list of matched items. The order represents the ranking.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     */
    private $results;
    /**
     * Results of facets requested by user.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     */
    private $facets;
    /**
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     * by pagination may be less than the
     * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     * matches.
     *
     * Generated from protobuf field <code>int32 total_size = 3;</code>
     */
    private $total_size = 0;
    /**
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     *
     * Generated from protobuf field <code>string corrected_query = 4;</code>
     */
    private $corrected_query = '';
    /**
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     */
    private $attribution_token = '';
    /**
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     *
     * Generated from protobuf field <code>string next_page_token = 6;</code>
     */
    private $next_page_token = '';
    /**
     * Query expansion information for the returned results.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;</code>
     */
    private $query_expansion_info = null;
    /**
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     *
     * Generated from protobuf field <code>string redirect_uri = 10;</code>
     */
    private $redirect_uri = '';
    /**
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     *
     * Generated from protobuf field <code>repeated string applied_controls = 12;</code>
     */
    private $applied_controls;
    /**
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;</code>
     */
    private $invalid_condition_boost_specs;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<\Google\Cloud\Retail\V2\SearchResponse\SearchResult>|\Google\Protobuf\Internal\RepeatedField $results
     *           A list of matched items. The order represents the ranking.
     *     @type array<\Google\Cloud\Retail\V2\SearchResponse\Facet>|\Google\Protobuf\Internal\RepeatedField $facets
     *           Results of facets requested by user.
     *     @type int $total_size
     *           The estimated total count of matched items irrespective of pagination. The
     *           count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     *           by pagination may be less than the
     *           [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     *           matches.
     *     @type string $corrected_query
     *           Contains the spell corrected query, if found. If the spell correction type
     *           is AUTOMATIC, then the search results are based on corrected_query.
     *           Otherwise the original query is used for search.
     *     @type string $attribution_token
     *           A unique search token. This should be included in the
     *           [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     *           search, which enables accurate attribution of search model performance.
     *     @type string $next_page_token
     *           A token that can be sent as
     *           [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     *           to retrieve the next page. If this field is omitted, there are no
     *           subsequent pages.
     *     @type \Google\Cloud\Retail\V2\SearchResponse\QueryExpansionInfo $query_expansion_info
     *           Query expansion information for the returned results.
     *     @type string $redirect_uri
     *           The URI of a customer-defined redirect page. If redirect action is
     *           triggered, no search is performed, and only
     *           [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     *           [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     *           are set in the response.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $applied_controls
     *           The fully qualified resource name of applied
     *           [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     *     @type array<\Google\Cloud\Retail\V2\SearchRequest\BoostSpec\ConditionBoostSpec>|\Google\Protobuf\Internal\RepeatedField $invalid_condition_boost_specs
     *           The invalid
     *           [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     *           that are not applied during serving.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * A list of matched items. The order represents the ranking.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResults()
    {
        return $this->results;
    }

    /**
     * A list of matched items. The order represents the ranking.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchResponse.SearchResult results = 1;</code>
     * @param array<\Google\Cloud\Retail\V2\SearchResponse\SearchResult>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\SearchResponse\SearchResult::class);
        $this->results = $arr;

        return $this;
    }

    /**
     * Results of facets requested by user.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFacets()
    {
        return $this->facets;
    }

    /**
     * Results of facets requested by user.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchResponse.Facet facets = 2;</code>
     * @param array<\Google\Cloud\Retail\V2\SearchResponse\Facet>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFacets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\SearchResponse\Facet::class);
        $this->facets = $arr;

        return $this;
    }

    /**
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     * by pagination may be less than the
     * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     * matches.
     *
     * Generated from protobuf field <code>int32 total_size = 3;</code>
     * @return int
     */
    public function getTotalSize()
    {
        return $this->total_size;
    }

    /**
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.retail.v2.SearchResponse.results] returned
     * by pagination may be less than the
     * [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
     * matches.
     *
     * Generated from protobuf field <code>int32 total_size = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setTotalSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->total_size = $var;

        return $this;
    }

    /**
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     *
     * Generated from protobuf field <code>string corrected_query = 4;</code>
     * @return string
     */
    public function getCorrectedQuery()
    {
        return $this->corrected_query;
    }

    /**
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     *
     * Generated from protobuf field <code>string corrected_query = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setCorrectedQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->corrected_query = $var;

        return $this;
    }

    /**
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     * @return string
     */
    public function getAttributionToken()
    {
        return $this->attribution_token;
    }

    /**
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
     * search, which enables accurate attribution of search model performance.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAttributionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->attribution_token = $var;

        return $this;
    }

    /**
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     *
     * Generated from protobuf field <code>string next_page_token = 6;</code>
     * @return string
     */
    public function getNextPageToken()
    {
        return $this->next_page_token;
    }

    /**
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     *
     * Generated from protobuf field <code>string next_page_token = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setNextPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->next_page_token = $var;

        return $this;
    }

    /**
     * Query expansion information for the returned results.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;</code>
     * @return \Google\Cloud\Retail\V2\SearchResponse\QueryExpansionInfo|null
     */
    public function getQueryExpansionInfo()
    {
        return $this->query_expansion_info;
    }

    public function hasQueryExpansionInfo()
    {
        return isset($this->query_expansion_info);
    }

    public function clearQueryExpansionInfo()
    {
        unset($this->query_expansion_info);
    }

    /**
     * Query expansion information for the returned results.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchResponse.QueryExpansionInfo query_expansion_info = 7;</code>
     * @param \Google\Cloud\Retail\V2\SearchResponse\QueryExpansionInfo $var
     * @return $this
     */
    public function setQueryExpansionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchResponse\QueryExpansionInfo::class);
        $this->query_expansion_info = $var;

        return $this;
    }

    /**
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     *
     * Generated from protobuf field <code>string redirect_uri = 10;</code>
     * @return string
     */
    public function getRedirectUri()
    {
        return $this->redirect_uri;
    }

    /**
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
     * [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
     * are set in the response.
     *
     * Generated from protobuf field <code>string redirect_uri = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setRedirectUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->redirect_uri = $var;

        return $this;
    }

    /**
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     *
     * Generated from protobuf field <code>repeated string applied_controls = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAppliedControls()
    {
        return $this->applied_controls;
    }

    /**
     * The fully qualified resource name of applied
     * [controls](https://cloud.google.com/retail/docs/serving-control-rules).
     *
     * Generated from protobuf field <code>repeated string applied_controls = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAppliedControls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->applied_controls = $arr;

        return $this;
    }

    /**
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInvalidConditionBoostSpecs()
    {
        return $this->invalid_condition_boost_specs;
    }

    /**
     * The invalid
     * [SearchRequest.BoostSpec.condition_boost_specs][google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs]
     * that are not applied during serving.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec invalid_condition_boost_specs = 14;</code>
     * @param array<\Google\Cloud\Retail\V2\SearchRequest\BoostSpec\ConditionBoostSpec>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInvalidConditionBoostSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\SearchRequest\BoostSpec\ConditionBoostSpec::class);
        $this->invalid_condition_boost_specs = $arr;

        return $this;
    }

}

