<?php

return [
    'interfaces' => [
        'google.cloud.workflows.v1beta.Workflows' => [
            'CreateWorkflow' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\Workflows\V1beta\Workflow',
                    'metadataReturnType' => '\Google\Cloud\Workflows\V1beta\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'DeleteWorkflow' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Protobuf\GPBEmpty',
                    'metadataReturnType' => '\Google\Cloud\Workflows\V1beta\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'UpdateWorkflow' => [
                'longRunning' => [
                    'operationReturnType' => '\Google\Cloud\Workflows\V1beta\Workflow',
                    'metadataReturnType' => '\Google\Cloud\Workflows\V1beta\OperationMetadata',
                    'initialPollDelayMillis' => '500',
                    'pollDelayMultiplier' => '1.5',
                    'maxPollDelayMillis' => '5000',
                    'totalPollTimeoutMillis' => '300000',
                ],
            ],
            'ListWorkflows' => [
                'pageStreaming' => [
                    'requestPageTokenGetMethod' => 'getPageToken',
                    'requestPageTokenSetMethod' => 'setPageToken',
                    'requestPageSizeGetMethod' => 'getPageSize',
                    'requestPageSizeSetMethod' => 'setPageSize',
                    'responsePageTokenGetMethod' => 'getNextPageToken',
                    'resourcesGetMethod' => 'getWorkflows',
                ],
            ],
        ],
    ],
];
