<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Audio_model extends CI_Model
{

    public function __construct(){        
        parent::__construct();
        $this->table = 'audio';        
        $this->table_list_grp = 'list_groupe';        
        $this->table_grp = 'groupe';        
        $this->table_category_expression = 'category_expression';        
        $this->table_expression = 'expressions_stagiaires'; 
        $this->table_file_stag = 'file_stag';            
    }

    public function insertAudio($data)
    {   
       if ($this->db->insert('audio', $data)){
        return true;
       }
       else
       {
            return false;
       }
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function countTutorlist($key,$groupe){
         $this->db->select('*');
        $this->db->from($this->table." as audio");
        $this->db->join($this->table_grp.' as groupe', 'audio.stagiaire_id = groupe.id_membres','inner');
        $this->db->join($this->table_list_grp.' as list_groupe', 'groupe.id_groupe = list_groupe.id_groupe','inner');
        $this->db->where('groupe.id_groupe', $groupe);
        if(!empty($key)) {
            $likeCriteria = "(audio.description LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        return $query->num_rows();
    }
    public function tutorlist($groupe,$key,$page,$segment){
        $this->db->select('audio.id as id, audio.titre as titre, audio.description as description, audio.stagiaire_id as stagiaire_id, audio.link_audio as link_audio, audio.link_audio_stag as link_audio_stag, audio.link_audio_mix as link_audio_mix, audio.link_transcpt as link_transcpt,audio.link_transcpt_2 as link_transcpt_2, audio.autoriser as autoriser, audio.lien_stat as lien_stat');
        $this->db->from($this->table." as audio");
        $this->db->join($this->table_grp.' as groupe', 'audio.stagiaire_id = groupe.id_membres','inner');
        $this->db->join($this->table_list_grp.' as list_groupe', 'groupe.id_groupe = list_groupe.id_groupe','inner');
        $this->db->where('groupe.id_groupe', $groupe);        
        if(!empty($key)) {
            $likeCriteria = "(audio.description LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->group_by('audio.id');
        //$this->db->limit($page, $segment); 
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        $seq['cnt'] = $query->num_rows();
        $i = 0 ;  
        foreach ($query->result() as $res) {
            $seq[$i]['id']                  = $res->id;
            $seq[$i]['titre']               = $res->titre;
            $seq[$i]['description']         = $res->description;
            $seq[$i]['stagiaire_id']        = $res->stagiaire_id;
            $seq[$i]['link_audio']          = $res->link_audio;
            $seq[$i]['link_audio_stag']     = $res->link_audio_stag;
            $seq[$i]['link_audio_mix']      = $res->link_audio_mix;
            $seq[$i]['link_transcpt']       = $res->link_transcpt;
            $seq[$i]['link_transcpt_2']     = $res->link_transcpt_2;
            $seq[$i]['autoriser']           = $res->autoriser;
            $seq[$i]['lien_stat']           = $res->lien_stat;
            $i++ ;
        }  
        return($seq);
    }
    //

    public function traineelist($group_id,$stagiaire_id){

        $this->db->select('*');
        $this->db->from($this->table);    
        $this->db->where('stagiaire_id', $stagiaire_id);   
        $this->db->where('groupe_id', $group_id); 
        //$this->db->where('autoriser', 1);         
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        $seq['cnt'] = $query->num_rows();
        $i = 0 ;  

        foreach ($query->result() as $res) {

            $seq[$i]['id']                  = $res->id;
            $seq[$i]['titre']               = $res->titre;
            $seq[$i]['description']         = $res->description;
            $seq[$i]['stagiaire_id']        = $res->stagiaire_id;
            $seq[$i]['link_audio']          = $res->link_audio;
            $seq[$i]['link_audio_stag']     = $res->link_audio_stag;
            $seq[$i]['link_audio_mix']      = $res->link_audio_mix;
            $seq[$i]['link_transcpt']       = $res->link_transcpt;
            $seq[$i]['link_transcpt_2']     = $res->link_transcpt_2;
            $seq[$i]['autoriser']           = $res->autoriser;
            $seq[$i]['lien_stat']           = $res->lien_stat;

            $i++ ;
        }  
        
        return($seq);
    }

    public function traineelistfirst($stagiaire_id, $group_id){

        $this->db->select('*');
        $this->db->from($this->table);    
        $this->db->where('stagiaire_id', $stagiaire_id);   
        $this->db->where('groupe_id', $group_id);         
        
        //$this->db->where('autoriser', 1);         
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $this->db->limit('1');
        $query = $this->db->get(); 
        $seq['cnt'] = $query->num_rows();
        $i = 0 ;  

        foreach ($query->result() as $res) {

            $seq[$i]['id']                  = $res->id;
            $seq[$i]['titre']               = $res->titre;
            $seq[$i]['description']         = $res->description;
            $seq[$i]['stagiaire_id']        = $res->stagiaire_id;
            $seq[$i]['link_audio']          = $res->link_audio;
            $seq[$i]['link_audio_stag']     = $res->link_audio_stag;
            $seq[$i]['link_audio_mix']      = $res->link_audio_mix;
            $seq[$i]['link_transcpt']       = $res->link_transcpt;
            $seq[$i]['link_transcpt_2']     = $res->link_transcpt_2;
            $seq[$i]['autoriser']           = $res->autoriser;
            $seq[$i]['lien_stat']           = $res->lien_stat;

            $i++ ;
        }  
        
        return($seq);
    }



    public function getAllDIstinctCategory($stagiaire_id){
        $this->db->select('e.id_category, c.intitule');
        $this->db->distinct('e.id_category');
        $this->db->from($this->table_category_expression. ' AS c');
        $this->db->join($this->table_expression. ' AS e', 'e.id_category = c.id AND type_exp = "audio"', 'INNER');     
        $this->db->join($this->table. ' AS a', 'a ON a.id_exp_audio = e.id_expression AND a.stagiaire_id = e.id_stagiaire', 'left'); 
        $this->db->where('e.id_stagiaire', $stagiaire_id);
        $this->db->order_by("c.intitule", "ASC"); 
        $this->db->order_by("e.date_creation", "DESC"); 
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getAllDIstinctDateCreate($stagiaire_id){
        $this->db->select('e.date_creation');
        $this->db->from($this->table_category_expression. ' AS c');
        $this->db->join($this->table_expression. ' AS e', 'e.id_category = c.id AND type_exp = "audio"', 'INNER');     
        $this->db->join($this->table. ' AS a', 'a ON a.id_exp_audio = e.id_expression AND a.stagiaire_id = e.id_stagiaire', 'left'); 
        $this->db->where('e.id_stagiaire', $stagiaire_id);
        $this->db->group_by('DATE_FORMAT(e.date_creation, "%Y-%m")');
        $this->db->order_by("e.date_creation", "DESC");
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        return $query->result();
    }


    public function getByGroupTraineId($stagiaire_id){
        $this->db->select('`c`.`id`, c.intitule, `e`.`id_expression`, `e`.`id_category`, `e`.`id_stagiaire`, `e`.`id_tuteur`, `e`.`langue`, `e`.`content_langue_origine`, `e`.`content_langue_cible`, `e`.`audio_langue_origine`, `e`.`audio_langue_cible`, `e`.`date_creation`, `a`.`id` AS `audioId`, `a`.`titre`, `a`.`link_audio`, `a`.`link_transcpt`, `e`.`date_creation` AS `dateCreationContent`, `e`.`revise_text`, `e`.`ia_reformulation`, `e`.`audio_legend`, `e`.`comment`');
        $this->db->from($this->table_category_expression. ' AS c');
        $this->db->join($this->table_expression. ' AS e', 'e.id_category = c.id AND type_exp = "audio"', 'INNER');     
        $this->db->join($this->table. ' AS a', 'a ON a.id_exp_audio = e.id_expression AND a.stagiaire_id = e.id_stagiaire', 'left'); 
        $this->db->where('e.id_stagiaire', $stagiaire_id);
        $this->db->order_by("c.intitule", "ASC"); 
        $this->db->order_by("e.date_creation", "DESC"); 
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getByExpressionId($expressionId){
        $this->db->select('`c`.`id`, c.intitule, `e`.`id_expression`, `e`.`id_category`, `e`.`id_stagiaire`, `e`.`id_tuteur`, `e`.`langue`, `e`.`content_langue_origine`, `e`.`content_langue_cible`, `e`.`audio_langue_origine`, `e`.`audio_langue_cible`, `e`.`date_creation`, `a`.`id` AS `audioId`, `a`.`titre`, `a`.`link_audio`, `a`.`link_transcpt`, `e`.`date_creation` AS `dateCreationContent`, `e`.`revise_text`, `e`.`ia_reformulation`, `e`.`audio_legend`, `e`.`comment`');
        $this->db->from($this->table_category_expression. ' AS c');
        $this->db->join($this->table_expression. ' AS e', 'e.id_category = c.id AND type_exp = "audio"', 'INNER');     
        $this->db->join($this->table. ' AS a', 'a ON a.id_exp_audio = e.id_expression AND a.stagiaire_id = e.id_stagiaire', 'left'); 
        $this->db->where('e.id_expression', $expressionId);
        $this->db->order_by("c.intitule", "ASC"); 
        $this->db->order_by("e.date_creation", "DESC"); 
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getByAudioId($audioId){
        $this->db->select('`c`.`id`, c.intitule, `e`.`id_expression`, `e`.`id_category`, `e`.`id_stagiaire`, `e`.`id_tuteur`, `e`.`langue`, `e`.`content_langue_origine`, `e`.`content_langue_cible`, `e`.`audio_langue_origine`, `e`.`audio_langue_cible`, `e`.`date_creation`, `a`.`id` AS `audioId`, `a`.`titre`, `a`.`link_audio`, `a`.`link_transcpt`, `e`.`date_creation` AS `dateCreationContent`, `e`.`revise_text`, `e`.`ia_reformulation`, `e`.`audio_legend`, `e`.`comment`');
        $this->db->from($this->table_category_expression. ' AS c');
        $this->db->join($this->table_expression. ' AS e', 'e.id_category = c.id AND type_exp = "audio"', 'INNER');     
        $this->db->join($this->table. ' AS a', 'a ON a.id_exp_audio = e.id_expression AND a.stagiaire_id = e.id_stagiaire', 'left'); 
        $this->db->where('a.id', $audioId);
        $this->db->order_by("c.intitule", "ASC"); 
        $this->db->order_by("e.date_creation", "DESC"); 
        $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
        $query = $this->db->get(); 
        return $query->result();
    }

    public function Request($field,$idc) {

        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
}

?>
