<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Commande_glossaire_papier_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table = 'commande_glossaire_papier';             
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function deleteByIdProtottypePapier($idPrototypePapier){
        $this->db->where('id_prototype_papier', $idPrototypePapier);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getAllById($id) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getByIdPrototype($idPrototype) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prototype', $idPrototype);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getByIdPrototypePapier($idPrototypePapier) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prototype_papier', $idPrototypePapier);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getByTraineeAndPrototypeId($idPrototype,$stagiaireId) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_prototype', $idPrototype);
        $this->db->where('id_stagiaire', $stagiaireId);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    
}

?>
