<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Document_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table = 'document';        
    }

    public function MesDocuments_($id){

        $this->db->select('d.lien,d.id,u.prenom,u.nom,d.titre,d.lien,d.comment,d.fichier,d.type,d.date,d.taille,d.nbcomment,d.prop');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.priv', 0);
        $this->db->where('d.prop', $id);
        $this->db->where('d.groupe', 0);
        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        return $query->result()  ; 
    }
    
    public function MesDocuments($id){

        $this->db->select('d.lien,d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.priv', 0);
        $this->db->where('d.prop', $id);
        $this->db->where('d.groupe', 0);
        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) { 
                $ret[$i]['id']      = $res->id              ;
                $ret[$i]['user']    = $res->prenom." ".$res->nom   ;
                $ret[$i]['titre']   = $res->titre;
                $ret[$i]['comment'] = $res->comment;
                $ret[$i]['date']    = $res->date            ;
                $ret[$i]['file']    = $res->fichier         ;
                $ret[$i]['size']    = $res->taille         ;
                $ret[$i]['nb']      = $res->nbcomment      ;
                $ret[$i]['lien']    = $res->lien     ;
                $i++ ;
            }
        }
        return($ret);
    }
    public function CountDocumentsByGroup($idg){
        $this->db->select('*');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where('d.priv', 0);
        $query = $this->db->get();         
        return $query->num_rows();        
    }
    public function CountDocumentsByUserCeate($prop,$idg){
        $this->db->select('*');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where('d.prop', $prop);
        $this->db->where('d.priv', 0);
        $query = $this->db->get();         
        return $query->num_rows();        
    }

    public function CountDocumentsByTraineeAndTuteu($tuteurId,$idg,$idTrainee){
        $author = array($tuteurId,$idTrainee);
        $this->db->select('*');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where_in('d.prop', $author);
        $this->db->where('d.priv', 0);
        $query = $this->db->get();         
        return $query->num_rows();        
    }
    public function ListerDocumentsByTraineeAndTuteur($tuteurId,$idg,$idTrainee){
        $author = array($tuteurId,$idTrainee);
        $this->db->select('d.prop,d.type,d.lien,d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where_in('d.prop', $author);
        $this->db->where('d.priv', 0);
        $this->db->where('d.id_repertory', NULL);
        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  
                $ret[$i]['id']      = $res->id              ;
                $ret[$i]['user']    = $res->prenom." ".$res->nom   ;
                $ret[$i]['titre']   = $res->titre;
                $ret[$i]['comment'] = $res->comment;
                $ret[$i]['date']    = $res->date            ;
                $ret[$i]['file']    = $res->fichier         ;
                $ret[$i]['size']    = $res->taille         ;
                $ret[$i]['nb']      = $res->nbcomment      ;
                $ret[$i]['prop']    = $res->prop      ;
                $ret[$i]['lien']    = $res->lien     ;
                $ret[$i]['type']    = $res->type     ;
                $i++ ;
            }
        }
        return($ret);
    }
    public function ListerDocumentsByUserCeate($prop,$idg,$id_repertory=NULL){
        $this->db->select('d.type,d.lien,d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where('d.prop', $prop);
        $this->db->where('d.priv', 0);
        $this->db->where('d.id_repertory', $id_repertory);
        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  
                $ret[$i]['id']      = $res->id              ;
                $ret[$i]['user']    = $res->prenom." ".$res->nom   ;
                $ret[$i]['titre']   = $res->titre;
                $ret[$i]['comment'] = $res->comment;
                $ret[$i]['date']    = $res->date            ;
                $ret[$i]['file']    = $res->fichier         ;
                $ret[$i]['size']    = $res->taille         ;
                $ret[$i]['nb']      = $res->nbcomment      ;
                $ret[$i]['lien']    = $res->lien     ;
                $ret[$i]['type']    = $res->type     ;
                $i++ ;
            }
        }
        return($ret);
    }
    public function ListerDocumentsByRepertory($id_repertory){
        $this->db->select('d.prop,d.type,d.lien,d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.priv', 0);
        $this->db->where('d.id_repertory', $id_repertory);
        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  
                $ret[$i]['id']      = $res->id              ;
                $ret[$i]['user']    = $res->prenom." ".$res->nom   ;
                $ret[$i]['titre']   = $res->titre;
                $ret[$i]['comment'] = $res->comment;
                $ret[$i]['date']    = $res->date            ;
                $ret[$i]['prop']    = $res->prop            ;
                $ret[$i]['file']    = $res->fichier         ;
                $ret[$i]['size']    = $res->taille         ;
                $ret[$i]['nb']      = $res->nbcomment      ;
                $ret[$i]['lien']    = $res->lien     ;
                $ret[$i]['type']    = $res->type     ;
                $i++ ;
            }
        }
        return($ret);
    }
    public function ListerDocumentsByGroup($idg,$id_repertory=NULL){
        $this->db->select('d.prop,d.type,d.lien,d.id AS idDocs,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.groupe', $idg);
        $this->db->where('d.priv', 0);
        $this->db->where('d.id_repertory', $id_repertory);
        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  
                $ret[$i]['id']      = $res->idDocs              ;
                $ret[$i]['user']    = $res->prenom." ".$res->nom   ;
                $ret[$i]['titre']   = $res->titre;
                $ret[$i]['comment'] = $res->comment;
                $ret[$i]['prop']    = $res->prop;
                $ret[$i]['date']    = $res->date            ;
                $ret[$i]['file']    = $res->fichier         ;
                $ret[$i]['size']    = $res->taille         ;
                $ret[$i]['nb']      = $res->nbcomment      ;
                $ret[$i]['lien']    = $res->lien     ;
                $ret[$i]['type']    = $res->type     ;
                $i++ ;
            }
        }
        return($ret);
    }
    public function ListerDocumentsByUserCeateByLimitAndKey($prop,$idg,$idRep,$rowperpage,$rowid){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('groupe', $idg);
        $this->db->where('prop', $prop);
        $this->db->where('priv', 0);
        $this->db->where('id_repertory !=', $idRep);
        $this->db->or_where('id_repertory',NULL);
        $this->db->limit($rowperpage,$rowid);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function ListerDocuments($idg){
        if($idg !=0 ){        

            $this->db->select('d.type,d.lien,d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
            $this->db->from($this->table." as d");
            $this->db->join('membres as u', 'd.prop=u.id','left');
            $this->db->where('d.groupe', $idg);
            $this->db->where('d.priv', 0);

        }else{

            $this->db->select('d.type,d.lien,d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
            $this->db->from($this->table." as d");
            $this->db->join('membres as u', 'd.prop=u.id','left');
            $this->db->where('d.priv', 0);
        }

        $query = $this->db->get();         
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  

                $ret[$i]['id']      = $res->id              ;
                $ret[$i]['user']    = $res->prenom." ".$res->nom   ;
                $ret[$i]['titre']   = $res->titre;
                $ret[$i]['comment'] = $res->comment;
                $ret[$i]['date']    = $res->date            ;
                $ret[$i]['file']    = $res->fichier         ;
                $ret[$i]['size']    = $res->taille         ;
                $ret[$i]['nb']      = $res->nbcomment      ;
                $ret[$i]['lien']    = $res->lien     ;
                $ret[$i]['type']    = $res->type     ;
                $i++ ;
            }
        }
        return($ret);
    }

    public function getByRepertory($id_repertory){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_repertory', $id_repertory);
        $query = $this->db->get();    
        return $query->result() ;
    }

    public function getAll(){
        $this->db->select('*');
        $this->db->from($this->table);
        $query = $this->db->get();    
        return $query->result() ;
    }

    public function getAllDocumentByIdGroup($idg){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('groupe', $idg);
        $this->db->group_by('id');
        $this->db->order_by('titre', 'ASC');
        $query = $this->db->get();    
        return $query->result() ;
    }


    public function ListDocumentTuteur($key = '', $author, $page, $segment)
    {
        $ret = array();
        $this->db->select('d.lien,d.type,d.id,u.prenom,u.nom,d.titre,d.groupe as stagiaireGrp,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','inner');
        $this->db->where('d.type', 3);      
        $this->db->where('d.priv', 0);      
        $this->db->where('d.groupe', 0);      
        if(!empty($key)) {
            $likeCriteria = "(d.titre  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        }   
        if(!empty($author)) {
            $this->db->where('d.prop', $author);
        } 
        $this->db->order_by('d.id', 'DESC');
        $this->db->limit($page, $segment);
    
  
        $query = $this->db->get(); 
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();     
        $result = $query->result()  ;
        foreach ($result as $res){     
            $ret[$i]['id']           = $res->id;
            $ret[$i]['user']         = $res->prenom." ".$res->nom;
            $ret[$i]['titre']        = $res->titre;
            $ret[$i]['comment']      = $res->comment;
            $ret[$i]['date']         = $res->date;
            $ret[$i]['file']         = $res->fichier;
            $ret[$i]['size']         = $res->taille;
            $ret[$i]['nb']           = $res->nbcomment;
            $ret[$i]['lien']         = $res->lien;
            $ret[$i]['type']         = $res->type;
            $ret[$i]['stagiaireGrp'] = $res->stagiaireGrp;
            $i++ ;
        }           
    
        return($ret);
    }
    public function ListerDocumentsFiltreAdmin($key = '', $author, $page, $segment)
    {
        $ret = array();
        $this->db->select('d.lien,d.type,d.id,u.prenom,u.nom,d.titre,d.groupe as stagiaireGrp,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','inner');
        $this->db->where('d.priv', 0);      
        $this->db->where('d.groupe !=', 0);      
        if(!empty($key)) {
            $likeCriteria = "(d.titre  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        }   
        if(!empty($author)) {
            $this->db->where('d.prop', $author);
        } 
        $this->db->order_by('d.id', 'DESC');
        $this->db->limit($page, $segment);
    
  
        $query = $this->db->get(); 
        $i = 0 ;
        $ret['cnt'] = $query->num_rows();     
        $result = $query->result()  ;
        foreach ($result as $res){     
            $ret[$i]['id']           = $res->id;
            $ret[$i]['user']         = $res->prenom." ".$res->nom;
            $ret[$i]['titre']        = $res->titre;
            $ret[$i]['comment']      = $res->comment;
            $ret[$i]['date']         = $res->date;
            $ret[$i]['file']         = $res->fichier;
            $ret[$i]['size']         = $res->taille;
            $ret[$i]['nb']           = $res->nbcomment;
            $ret[$i]['lien']         = $res->lien;
            $ret[$i]['type']         = $res->type;
            $ret[$i]['stagiaireGrp'] = $res->stagiaireGrp;
            $i++ ;
        }           
    
        return($ret);
    }
    public function CountDocumentsTutorFiltreAdmin($key,$author)
    {
        $ret = array();
        $this->db->select(' d.lien,d.type,d.id,u.prenom,u.nom,d.titre,d.groupe as stagiaireGrp,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','inner');
        $this->db->where('d.type', 3);      
        $this->db->where('d.priv', 0);      
        $this->db->where('d.groupe', 0);
        if(!empty($key)) {
            $likeCriteria = "(d.titre  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        } 
        if(!empty($author)) {
            $this->db->where('d.prop', $author);
        }        
        $this->db->order_by('d.id', 'DESC');
  
        $query = $this->db->get(); 
        return count($query->result());
    }

    public function CountDocumentsFiltreAdmin($key,$author)
    {
        $ret = array();
        $this->db->select(' d.lien,d.type,d.id,u.prenom,u.nom,d.titre,d.groupe as stagiaireGrp,d.comment,d.fichier,d.date,d.taille,d.nbcomment');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','inner');
        $this->db->where('d.priv', 0);
        if(!empty($key)) {
            $likeCriteria = "(d.titre  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        } 
        if(!empty($author)) {
            $this->db->where('d.prop', $author);
        }        
        $this->db->order_by('d.id', 'DESC');
  
        $query = $this->db->get(); 
        return count($query->result());
    }

    public function delete($id){

        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }
    public function deleteByIdRepertory($id_repertory){

        $this->db->where('id_repertory', $id_repertory);
        $this->db->delete($this->table);
    }

    public function Nb($idg) {
        $this->db->select('id');
        $this->db->from($this->table);
        $this->db->where('groupe', $idg);
        $query = $this->db->get();         
        return ($query->num_rows());
    }

    public function getDocumentById($id) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id', $id);
        return $this->db->get();     
    }

    public function Read($idd) {
        
        $this->db->select('d.id,d.prop,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment,d.groupe');
        $this->db->from($this->table." as d");
        $this->db->join('membres as u', 'd.prop=u.id','left');
        $this->db->where('d.id', $idd);
        $query = $this->db->get();         
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  

                $ret['user']    = $res->prenom." ".$res->nom;
                $ret['titre']   = $res->titre        ;
                $ret['comment'] = $res->comment      ;
                $ret['date']    = $res->date                    ;
                $ret['file']    = $res->fichier                 ;
                $ret['nb']      = $res->nbcomment               ;
                $ret['prop']    = $res->prop               ;
                $ret['groupe']  = $res->groupe              ;
                return($ret) ;
            }
        }
        return(false);
    }

    public function InsertComment($idD,$comment) {
        $ret  = $this->Read($idD)   ;
        $date = getdate()                           ;
        $date = date(FORMATDATETIME ,$date["0"])        ;
        $m_nb = ($ret['nb']==""?"0":$ret['nb']+1)   ;
      
        $finalComment = "<DEB>".$this->Replace($this->session->userdata ( 'GUSER' ))." a écrit le ".$date."<MID>".$this->Replace($comment)."<FIN>".addslashes($this->Replace($ret['comment']));

        $infoComment = array('comment'=>$finalComment, 'nbcomment'=>$m_nb);
        $this->db->where('id', $idD);
        $this->db->update($this->table, $infoComment);

    }

    public function update($idD,$data) {
        $this->db->where('id', $idD);
        $this->db->update($this->table, $data);

    }

    public function add($additional_data = array()){

        $this->db->trans_start();
        $this->db->insert('document', $additional_data);       
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;

    }

    public function Replace($txt) {
        $mytxt = trim($txt);
        return $mytxt ;
    }

    
    public function Request($field,$idc) {

        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }


}

?>
