<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Mail_box_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table = 'mail_box';           
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getByParams($arrayKeySearch) {
        $this->db->select('*');
        $this->db->from($this->table);
        if (isset($arrayKeySearch['expediteur_name']) && $arrayKeySearch['expediteur_name'] != '') {
            //$this->db->where_in('author', $arrayKeySearch['expediteur_name']);
            $this->db->where('author', $arrayKeySearch['expediteur_name']);
        }

        if (isset($arrayKeySearch['expediteur_date_d1']) && isset($arrayKeySearch['expediteur_date_d2']) && $arrayKeySearch['expediteur_date_d1'] != '' && $arrayKeySearch['expediteur_date_d2'] != '') {
            $this->db->where('DATE(date) BETWEEN "'.$arrayKeySearch['expediteur_date_d1'].'" AND "'.$arrayKeySearch['expediteur_date_d2'].'" ');
        }

        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    
}

?>
