<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Matieres_model extends CI_Model
{
    
    public function __construct(){    
        global $TBL ;    
        parent::__construct();
     
        $this->load->model('membres_model');
        $this->load->model('utilities_model');    
        $this->table = 'matiere';    
     
    }

    public function read($idm=-1) {
        $ret = Array() ;
        if ( $idm == -1 ) {
          
            $this->db->select('matiere_id,name');
            $this->db->from($this->table);
            $query = $this->db->get();   
            $ret['cnt'] = $query->num_rows();
            $i = 0 ;        
            foreach ($query->result() as $res) {
                $ret[$i]['id']  = $res->matiere_id;
                $ret[$i]['name']= $res->name;
                $i++ ;
            }
            
        } 
        else {
           
            $this->db->select('name');
            $this->db->from($this->table);
            $this->db->where('matiere_id', $idm);
            $query = $this->db->get();   
            $ret['name'] = '' ;
            if ( $query->num_rows() !=  0) {
                foreach ($query->result() as $res) {
                    $ret['name'] = $res->name;
                }
            }          

        }
        return($ret);
    }

    public function readAll($idd=-1) {
        $ret = Array() ;
        $i = 0 ;
        if ( $idd == -1 ) {           

            $this->db->select('matiere_id,name');
            $this->db->from($this->table);
            $this->db->order_by('name', 'asc');
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();            
            $result = $query->result()  ;
            if (is_array($result)) {
            
                foreach ($result as $res){
                    $ret[$i]['id'] = $res->matiere_id ;
                    $ret[$i]['name'] = $res->name ;
                    $i++ ;
                }
            }
        } 
        else {           

            $this->db->select('matiere_id,name');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);
            $this->db->order_by('name', 'asc');
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();            
            $result = $query->result()  ;
            if (is_array($result)) {
            
                foreach ($result as $res){
                    $ret[$i]['id'] = $res->matiere_id ;
                    $ret[$i]['name'] = $res->name ;
                    $i++ ;
                }
            }
        }
        return($ret);
    }

    public function del($idm) {
        $this->db->where('matiere_id', $idm);
        $this->db->delete($this->table); 
    }


    public function delAll($idd) {      
        $this->db->where('domaine_id', $idd);
        $this->db->delete($this->table);  
    }

    public function add($matiere,$idd) {     
        $ret = 0 ;
        $matinfos = array("name"=>$matiere,"domaine_id"=>$idd);           
        $this->db->trans_start();
        $this->db->insert($this->table, $matinfos);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();

        $this->db->select('matiere_id');
        $this->db->from($this->table);
        $this->db->order_by('matiere_id', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        $result = $query->result()  ;
        if (is_array($result)) {        
            foreach ($result as $res){
                $ret = $res->matiere_id ;
                
            }
        }


        return($ret);
    }

    public function update($idm,$matiere) {
        $info = array("name"=>$matiere);
        $this->db->where('matiere_id', $idm);
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function move($idm,$idd,$loc=-1) {
        $table = $this->table ;
        if ( $loc != -1 ) {
            $table = $loc==LOCAL?'matiere':'matiere_srv' ;
        }   
        $info = array("domaine_id"=>$idd);
        $this->db->where('matiere_id', $idm);
        $this->db->update($table, $info);
        $this->db->affected_rows();
    }

    public function Request($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('matiere_id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function getByDomaine($domaine_id) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('domaine_id', $domaine_id);
        $query = $this->db->get();
        return $query->result();
    }

   
}

?>
