
<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Modules_model extends CI_Model
{
    
    public function __construct(){    
        global $TBL ;    
        parent::__construct();
     
        $this->load->model('membres_model');
        $this->load->model('utilities_model');    
        $this->table     = 'list_module';
        $this->table_mod = 'module';  
        $this->table_seq = 'list_sequence';  
        $this->table_mat = 'matiere';  
        $this->table_for = 'formation';  
        $this->table_domaine = 'domaine';  
     
    }

    public function getByParams($arrayParams){
        $return = array();
        $i = 0;
        $this->db->select('*');
        $this->db->from($this->table);
        
        if (isset($arrayParams['domaine_id'])) {
            $this->db->where('domaine_id', $arrayParams['domaine_id']);
        }
        
        if (isset($arrayParams['matiere_id'])) {
            $this->db->where('matiere_id', $arrayParams['matiere_id']);
        }

        if (isset($arrayParams['key']) && $arrayParams['key'] != '') {
            $this->db->like('module_titre', $arrayParams['key']);
        }

        $query = $this->db->get();
        $result= $query->result()  ;
        foreach ($result as $res) {
            $return[$i] = array(
                'id'        => $res->module_id,
                'name'      => $res->module_titre,
                'objectif'  => $res->module_objectifs,
                'code'      => $res->code,
            );
            $i++;
        } 
        return $return;
    }


    public function readSequence($module_id, $exist) {
        $i = 0 ;
        $s = 0 ;
        $ret = Array() ;
        $sequenceNoSelect = Array() ;
        
        switch ($exist) {
            case false:
                $this->db->select('sequence_id');
                $this->db->from($this->table_mod);
                $this->db->where('module_id', $module_id);
                $querys = $this->db->get(); 
                if ($querys->num_rows() >= 1) {
                    foreach ($querys->result() as $seq) {
                        $sequenceNoSelect[$s] = $seq->sequence_id;
                        $s++;
                    }
                }
                



                $this->db->distinct('s.*');
                $this->db->from($this->table_seq.' AS s');
                if (count($sequenceNoSelect) >= 1) {
                    $this->db->where_not_in('s.sequence_id', $sequenceNoSelect);
                }
                break;
            case true:
                $this->db->distinct('s.*');
                $this->db->from($this->table_mod.' AS m');
                $this->db->join($this->table_seq.' AS s', 'm.sequence_id = s.sequence_id', 'INNER');
                $this->db->where('m.module_id', $module_id);
                break;
            default:
                // code...
                break;
        }
        
        $this->db->group_by('s.sequence_id');
        $this->db->order_by('s.sequence_titre', 'asc');
        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;
        if ($ret['cnt'] >= 1) {
            
            foreach ($result as $res){
                $ret[$i]['sequence_id']          = $res->sequence_id   ;
                $ret[$i]['sequence_titre']       = $res->sequence_titre ;
                $ret[$i]['sequence_objectifs']   = $res->sequence_objectifs   ;
                $ret[$i]['sequence_duree']       = $res->sequence_duree   ;
                $ret[$i]['repertoire']           = $res->repertoire  ;
                $ret[$i]['auteur_id']            = $res->auteur_id ;
                $ret[$i]['code']                 = $res->code    ;
                $ret[$i]['domaine_id']           = $res->domaine_id ;
                $ret[$i]['matiere_id']           = $res->matiere_id ;
                $ret[$i]['user_create']          = $res->user_create  ;
                $i++ ;
            }
        }
        return($ret);
    }

    public function getNextId() {

        $this->db->select('MAX(module_id) as maxId');
        $this->db->from($this->table);
        $query = $this->db->get();
        $result = $query->result();
        $ret = '';
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->maxId + 1;
            }
        }       
        return($ret);
    }

    public function getNextOrderFormModule($module_id){
        $this->db->select('MAX(ordre) AS maxOrder');
        $this->db->from($this->table_mod);
        $this->db->where('module_id', $module_id);
        $query = $this->db->get();
        $result = $query->result();
        return ($result[0]->maxOrder + 1);
    }

    public function getMaxModuleId(){
        $this->db->select('MAX(module_id) AS idMax');
        $this->db->from($this->table);
        $query = $this->db->get();
        $result = $query->result();
        $ret = '';
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->idMax;
            }
        }       
        return($ret);
    }


    public function addModule($data) {     
        $this->db->trans_start();
        $this->db->insert($this->table_mod, $data);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $id;
    }

    public function add($data) {     
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $module_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $module_id;
    }

    public function delSequence($idm=-1,$ids,$loc) {
        $ordre = -1 ;
        if ($idm == -1 ) {          

            $this->db->where('sequence_id', $ids);
            $this->db->where('loc', $loc);
            $this->db->delete($this->table_mod);

        }     

        $this->db->select('ordre');
        $this->db->from($this->table_mod);
        $this->db->where('module_id', $idm);
        $this->db->where('sequence_id', $ids);      
        $query = $this->db->get(); 
        $cnt = $query->num_rows();
        
        $result = $query->result()  ;
        foreach ($result as $res){
            $ordre = $res->ordre;
        }

     
        $this->db->where('module_id', $idm);
        $this->db->where('sequence_id', $ids);
        $this->db->where('loc', $loc);
        $this->db->delete($this->table_mod);

        if ( $ordre > 0 ) {
            $moduleinfo = array('ordre'=>'(ordre-1)');
            $this->db->where('module_id', $idm);
            $this->db->where('ordre > ', $ordre);
            $this->db->update($this->table_mod, $moduleinfo);
        }
    }
   
    public function deleteContentByModule($module_id) {
        $this->db->where('module_id', $module_id);
        $this->db->delete($this->table_mod);
    }

    public function deleteByModule($module_id) {
        $this->db->where('module_id', $module_id);
        $this->db->delete($this->table);
    }

    public function delDomaine($idd) {
        $info = array("matiere_id"=>0,"domaine_id"=>0);
        $this->db->where('domaine_id', $idd);
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function delMatiere($idm) {  
        $info = array("matiere_id"=>0);
        $this->db->where('matiere_id', $idm);
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function updateMatiereDomaine($idm,$idd,$loc=-1) {
        $info = array("domaine_id"=>$idd);
        $this->db->where('matiere_id', $idm);
        $this->db->update($this->table, $info);
        $this->db->affected_rows();
    }

    public function update($module_id, $arraydata) {
        $this->db->where('module_id', $module_id);
        $this->db->update($this->table, $arraydata);
        $this->db->affected_rows();
    }

    public function Title($idm,$loc='') {
        $this->db->select('module_titre');
        $this->db->from($this->table);
        $this->db->where('module_id', $idm);
        //$this->db->where('sequence_id', $ids);      
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            return $res->module_titre;
        }
    }

    public function getNameByIdSequence($ids){
        $this->db->select('l.module_titre');
        $this->db->from($this->table_mod.' as m');
        $this->db->join($this->table.' as l', 'l.module_id=m.module_id','inner');
        $this->db->where('m.sequence_id', $ids);      
        $query = $this->db->get(); 
        $result = $query->result()  ;
        foreach ($result as $res){
            return $res->module_titre;
        }
    }

    public function readIdSequence($idm,$loc) {
        $ret = array() ;
        $this->db->select('m.sequence_id, s.sequence_titre,m.loc');
        $this->db->from($this->table_mod.' as m');
        $this->db->join($this->table_seq.' as s', 's.sequence_id=m.sequence_id','inner');
        $this->db->where('m.module_id', $idm);      
        $this->db->where('m.loc', $loc); 
        $this->db->order_by('m.ordre', 'asc');       
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function readByDomaine($idd) {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        
        if ( $idd > 0 ) {
            $this->db->select('module_id,module_titre,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);    
            $this->db->order_by('module_titre', 'asc');      
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();        
            $result = $query->result()  ;
            if (is_array($result)) {
                foreach ($result as $res){
                    $ret[$i]['id']          = $res->module_id;
                    $ret[$i]['titre']       = $res->module_titre;
                    $ret[$i]['nom']         = "???????????";
                    $ret[$i]['code']        = $res->code;
                    $ret[$i]['domaine_id']  = $res->domaine_id;
                    $ret[$i]['matiere_id']  = $res->matiere_id;
                    $i++ ;
                }
            }
            $this->db->select('t.module_id,t.module_titre,t.auteur_id,t.code,t.domaine_id,t.matiere_id,m.name');
            $this->db->from($this->table.' as t');
            $this->db->join($this->table_mat.' as m','t.matiere_id=m.matiere_id AND t.domaine_id=m.domaine_id','inner');
            $this->db->where('t.domaine_id', $idd);    
            $this->db->order_by('m.name,t.module_titre', 'asc');
        }
        else{
            $this->db->select('module_id,module_titre,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);    
            $this->db->order_by('module_titre', 'asc');
        }

        $query = $this->db->get(); 
        $ret['cnt']+= $query->num_rows();        
        $result = $query->result()  ;
        if (is_array($result)) {
            foreach ($result as $res){
                $ret[$i]['id']          = $res->module_id;
                $ret[$i]['titre']       = $res->module_titre;
                $ret[$i]['nom']         = "???????????";
                $ret[$i]['code']        = $res->code;
                $ret[$i]['domaine_id']  = $res->domaine_id;
                $ret[$i]['matiere_id']  = $res->matiere_id;
                $i++ ;
            }
        }
        return($ret);
    }

    public function readByDomaineAjax($idd) {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        
        if ( $idd > 0 ) {
            $this->db->select('t.module_id,t.module_titre,t.auteur_id,t.code,t.domaine_id,t.matiere_id,m.name');
            $this->db->from($this->table.' as t');
            $this->db->join($this->table_mat.' as m','t.matiere_id=m.matiere_id AND t.domaine_id=m.domaine_id','inner');
            $this->db->where('t.domaine_id', $idd);    
            $this->db->order_by('m.name,t.module_titre', 'asc');
        }
        else{
            $this->db->select('module_id,module_titre,auteur_id,code,domaine_id,matiere_id');
            $this->db->from($this->table);
            $this->db->where('domaine_id', $idd);    
            $this->db->order_by('module_titre', 'asc');
        }

        $query1 = $this->db->get(); 
        $ret['cnt']+= $query1->num_rows();        
        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res){
                $ret[$i]['id']          = $res->module_id;
                $ret[$i]['titre']       = $res->module_titre;
                $ret[$i]['nom']         = "???????????";
                $ret[$i]['code']        = $res->code;
                $ret[$i]['domaine_id']  = $res->domaine_id;
                $ret[$i]['matiere_id']  = $res->matiere_id;
                $i++ ;
            }
        }
        return($ret);
    }

    public function getInfosMatiereByDomaine($domaine_id) {
        $ret = Array() ;
        $i = 0 ;    
        $this->db->from($this->table_mat);
        $this->db->where('domaine_id', $domaine_id);    
        $this->db->order_by('name', 'ASC');
        $queryM = $this->db->get(); 
        $resultM = $queryM->result();
        if (is_array($resultM)) {
            foreach ($resultM as $resM){

                $ret[$i] = array(
                    'matiere_id'   => $resM->matiere_id,
                    'matiere_name' => $resM->name,
                    'modulesInfos' => $this->getModulesByMatiere($resM->matiere_id),
                );

                $i++ ;
            }
        }
        return $ret;
    }

    public function getModulesByMatiere($matiere_id){
        $ret = Array() ;
        $i = 0 ;  
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('matiere_id', $matiere_id);    
        $this->db->order_by('module_titre', 'ASC');
        $queryMod = $this->db->get(); 
        $resultMod = $queryMod->result();
        if (is_array($resultMod)) {
            foreach ($resultMod as $resMod){
                $ret[$i] = array(
                    'module_id'         => $resMod->module_id,
                    'module_titre'      => $resMod->module_titre,
                    'module_objectifs'  => $resMod->module_objectifs,
                    'module_code'       => $resMod->code,
                );
                $i++;
            }
        }
        return $ret;
    }

    public function getModuleNotInMatiereAndDomaine(){
        $ret = array();
        $array_matiere_no_exist = array(0,2,3,4,6);
        for ($mnex=0; $mnex < count($array_matiere_no_exist) ; $mnex++) { 
            $ret[$mnex] = array(
                'matiere_id'   => $mnex,
                'matiere_name' => 'Non défini',
                'modulesInfos' => $this->getModulesByMatiere($array_matiere_no_exist[$mnex]),
            );
        }

        return $ret;
    }


    public function adminGetModuleList(){
        $i = 0;
        $ret = array();
        $this->db->select('m.*, d.name AS domaine_name, t.name AS matiere_name');
        $this->db->from($this->table.' as m');
        $this->db->join($this->table_domaine.' as d', 'd.domaine_id = m.domaine_id', 'LEFT');
        $this->db->join($this->table_mat.' as t', 't.matiere_id = m.matiere_id', 'LEFT');
        $this->db->order_by('m.module_titre', 'ASC');
        $queryMod = $this->db->get(); 
        $resultMod = $queryMod->result();
        if (is_array($resultMod)) {
            foreach ($resultMod as $resMod){
                $ret[$i] = array(
                    'module_id'         => $resMod->module_id,
                    'module_titre'      => $resMod->module_titre,
                    'module_objectifs'  => $resMod->module_objectifs,
                    'module_code'       => $resMod->code,
                    'domaine_id'        => $resMod->domaine_id,
                    'matiere_id'        => $resMod->matiere_id,
                    'domaine_name'      => $resMod->domaine_name,
                    'matiere_name'      => $resMod->matiere_name,
                );
                $i++;
            }
        }
        return $ret;              
    }

    public function adminGetModuleListNew(){
        $ret = Array() ;
        $i = 0 ;
        $m = 0 ;
        $mod = 0;

        $ia = 0 ;
        $ma = 0 ;
        $moda = 0;

        $this->db->select('*');
        $this->db->from($this->table_domaine);
        $this->db->order_by('name', 'ASC');
        $queryD = $this->db->get(); 
        $resultD = $queryD->result()  ;
        if (is_array($resultD)) {
            foreach ($resultD as $resD){
                $ret[$i]['domainesInfos'] = array(
                    'domaine_id'    => $resD->domaine_id,
                    'domaine_name'  => $resD->name,
                    'matieresInfos' => $this->getInfosMatiereByDomaine($resD->domaine_id),
                );

                /*$this->db->select('*');
                $this->db->from($this->table_mat);
                $this->db->where('domaine_id', $ret[$i]['domainesInfos']['domaine_id']);    
                $this->db->order_by('name', 'ASC');
                $queryM = $this->db->get(); 
                $resultM = $queryM->result();
                if (is_array($resultM)) {
                    foreach ($resultM as $resM){

                        $ret[$i][$m]['matieresInfos'] = array(
                            'matiere_id'   => $resM->matiere_id,
                            'matiere_name' => $resM->name,
                        );

                        $this->db->select('*');
                        $this->db->from($this->table);
                        $this->db->where('matiere_id', $ret[$i][$m]['matieresInfos']['matiere_id']);    
                        $this->db->order_by('module_titre', 'ASC');
                        $queryMod = $this->db->get(); 
                        $resultMod = $queryMod->result();
                        if (is_array($resultMod)) {
                            foreach ($resultMod as $resMod){
                                $ret[$i][$m][$mod]['modulesInfos'] = array(
                                    'module_id'         => $resMod->module_id,
                                    'module_titre'      => $resMod->module_titre,
                                    'module_objectifs'  => $resMod->module_objectifs,
                                    'module_code'       => $resMod->code,
                                );
                                $mod++;
                            }
                        }
                        $m++;

                    }
                }*/

                $i++ ;
            }
        }

        $ret[$i]['domainesInfos'] = array(
            'domaine_id'    => 0,
            'domaine_name'  => 'Aucun',
            'matieresInfos' => $this->getModuleNotInMatiereAndDomaine(),
        );

        /*$ret[$ia][$ma]['matieresInfos'] = array(
            'matiere_id'   => 0,
            'matiere_name' => 'Aucun',
        );
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('matiere_id', $ret[$ia][$ma]['matieresInfos']['matiere_id']);    
        $this->db->order_by('module_titre', 'ASC');
        $queryModA = $this->db->get(); 
        $resultModA = $queryModA->result();
        if (is_array($resultModA)) {
            foreach ($resultModA as $resModA){
                $ret[$ia][$ma][$moda]['modulesInfos'] = array(
                    'module_id'          => $resModA->module_id,
                    'module_titre'       => $resModA->module_titre,
                    'module_objectifs'   => $resModA->module_objectifs,
                    'module_code'        => $resModA->code,
                );
                $moda++;
            }
        }*/
        return $ret;
    }

    public function getAll() {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        $this->db->select('module_id,module_titre,auteur_id,code,domaine_id,matiere_id,module_objectifs');
        $this->db->from($this->table);
        $this->db->order_by('module_titre', 'asc');

        $query1 = $this->db->get(); 
        $ret['cnt']+= $query1->num_rows();        
        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res){
                $ret[$i]['id']          = $res->module_id;
                $ret[$i]['titre']       = $res->module_titre;
                $ret[$i]['objectif']    = $res->module_objectifs;
                $ret[$i]['nom']         = "???????????";
                $ret[$i]['code']        = $res->code;
                $ret[$i]['domaine_id']  = $res->domaine_id;
                $ret[$i]['matiere_id']  = $res->matiere_id;
                $i++ ;
            }
        }
        return($ret);
    }

     public function getAlls() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('module_titre', 'asc');
        $query = $this->db->get();        
        return $query->result()  ;
       
    }

    public function getByDomaineMatiere($idd,$idm) {
        $ret = Array() ;
        $ret['cnt'] = 0;
        $i = 0 ;
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('domaine_id', $idd);    
        $this->db->where('matiere_id', $idm);    
        $this->db->order_by('module_titre', 'asc');

        $query1 = $this->db->get(); 
        $ret['cnt']+= $query1->num_rows();        
        $result1 = $query1->result()  ;
        if (is_array($result1)) {
            foreach ($result1 as $res){
                $ret[$i]['id']          = $res->module_id;
                $ret[$i]['titre']       = $res->module_titre;
                $ret[$i]['nom']         = "???????????";
                $ret[$i]['code']        = $res->code;
                $ret[$i]['domaine_id']  = $res->domaine_id;
                $ret[$i]['matiere_id']  = $res->matiere_id;
                $i++ ;
            }
        }
        return($ret);
    }

    public function getByIGroupeIdDomaine($idGroup,$idDomaine) {
        $this->db->select('`lm`.`module_id`, `lm`.`module_titre`');
        $this->db->from($this->table_for.' as f');  
        $this->db->join($this->table.' as lm', 'lm.module_id=f.module_id','left');  
        $this->db->join($this->table_domaine.' as domaine', 'domaine.domaine_id=lm.domaine_id','left');  
        $this->db->where('f.groupe_id', $idGroup);  
        $this->db->where('domaine.domaine_id', $idDomaine);      
        $this->db->group_by('lm.module_id');
        $query = $this->db->get();        
        return $query->result()  ;
        
    }

    public function getByIdMariere($idm) {
        
        $this->db->select('*');
        $this->db->from($this->table);  
        $this->db->where('matiere_id', $idm);    
        $this->db->order_by('module_titre', 'asc');
        $query1 = $this->db->get();        
        return $query1->result()  ;
        
    }

    public function getAllSequenceByModuleId($module_id) {
        
        $this->db->select('*');
        $this->db->from($this->table_mod);  
        $this->db->where('module_id', $module_id);    
        $query1 = $this->db->get();        
        return $query1->result()  ;
        
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('module_id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestModuleBySequenceOrder($field,$idSequence,$ordre) {
        $this->db->select($field);
        $this->db->from($this->table_mod);
        $this->db->where('sequence_id', $idSequence);
        $this->db->where('ordre', $ordre);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
}

?>
