<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Notification_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table = 'notification';               
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function deleteByIdDataTypeAndGroupe($data_type,$id_groupe){
        $this->db->where('id_groupe', $id_groupe);
        $this->db->where('data_type', $data_type);
        $this->db->delete($this->table);
    }

    public function deleteByIdDataTypeIdData($data_type,$id_data){
        $this->db->where('id_data', $id_data);
        $this->db->where('data_type', $data_type);
        $this->db->delete($this->table);
    }

    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getByGroupe($id_groupe) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->where_not_in('data_type', 'newsletter');
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('id', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getMaxDataByCriteria($data_type,$id_groupe) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('data_type', $data_type);
        $this->db->where('id_groupe', $id_groupe);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    
}

?>
