<?php
    class Picture_model extends CI_Model
    {
        public function __construct(){        
            parent::__construct(); 
            $this->table_category        = 'category_expression';     
            $this->table_expression      = 'expressions_stagiaires';        
            $this->table_container       = 'file_stag';              
        }

        public function updateContent($id_expression,$data) {
            $this->db->where('id_expression', $id_expression);
            $this->db->update($this->table_expression, $data);

        }

        public function update($id_files,$data) {
            $this->db->where('id_files', $id_files);
            $this->db->update($this->table_container, $data);

        }


        public function delete($id_files){
            $this->db->where('id_files', $id_files);
            $this->db->delete($this->table_container);
        }


        public function getById($file_id)
        {
            $this->db->select('c.id, intitule, e.id_expression, id_category, id_stagiaire, id_tuteur, langue, content_langue_origine, content_langue_cible, audio_langue_origine, audio_langue_cible, e.date_creation, fs.id_files, id_exp, f_name, legende_f, type_file, date_creat, DATE_FORMAT(e.date_creation, "%Y-%m") AS creation_date');
            $this->db->from($this->table_category. ' AS c');
            $this->db->join($this->table_expression. ' AS e', 'e.id_category=c.id','right');
            $this->db->join($this->table_container. ' AS  fs', 'e.id_expression=fs.id_exp','left');
            $this->db->where('fs.id_files', $file_id);
            $this->db->where('fs.type_file', 'image');
            $this->db->order_by("e.date_creation", "DESC");
            $query = $this->db->get();
            return $query->result();
        }


        public function getAllDistinctByDateCreateAndTraineeFileDifferent($file_id,$creation_date, $traineeId)
        {
            $this->db->select('c.id, intitule, e.id_expression, id_category, id_stagiaire, id_tuteur, langue, content_langue_origine, content_langue_cible, audio_langue_origine, audio_langue_cible, e.date_creation, fs.id_files, id_exp, f_name, legende_f, type_file, date_creat, DATE_FORMAT(e.date_creation, "%Y-%m") AS creation_date');
            $this->db->from($this->table_category. ' AS c');
            $this->db->join($this->table_expression. ' AS e', 'e.id_category=c.id AND DATE_FORMAT(e.date_creation, "%Y-%m") = '.$creation_date.'','right');
            $this->db->join($this->table_container. ' AS  fs', 'e.id_expression=fs.id_exp','left');
            $this->db->where('e.id_stagiaire', $traineeId);
            $this->db->where('fs.type_file', 'image');
            $this->db->where_not_in('fs.id_files', $file_id);
            $query = $this->db->get();
            return $query->result();
        }

        public function getAllByTrainee($traineeId)
        {
            $this->db->select('c.id, intitule, e.id_expression, id_category, id_stagiaire, id_tuteur, langue, content_langue_origine, content_langue_cible, audio_langue_origine, audio_langue_cible, e.date_creation, fs.id_files, id_exp, f_name, legende_f, type_file, date_creat');
            $this->db->from($this->table_category. ' AS c');
            $this->db->join($this->table_expression. ' AS e', 'e.id_category=c.id','right');
            $this->db->join($this->table_container. ' AS  fs', 'e.id_expression=fs.id_exp','left');
            $this->db->where('e.id_stagiaire', $traineeId);
            $this->db->where('fs.type_file', 'image');
            $this->db->order_by("e.date_creation", "DESC");
            $query = $this->db->get();
            return $query->result();
        }


        public function getAllDistinctDateCreate($traineeId)
        {
            $this->db->select('e.date_creation');
            $this->db->from($this->table_category. ' AS c');
            $this->db->join($this->table_expression. ' AS e', 'e.id_category=c.id','right');
            $this->db->join($this->table_container. ' AS  fs', 'e.id_expression=fs.id_exp','left');
            $this->db->where('e.id_stagiaire', $traineeId);
            $this->db->where('fs.type_file', 'image');
            $this->db->group_by('DATE_FORMAT(e.date_creation, "%Y-%m")');
            $this->db->order_by("e.date_creation", "DESC");
            $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
            $query = $this->db->get();
            return $query->result();
        }

        public function getAllDistinctCategory($traineeId)
        {
            $this->db->select('e.id_category, c.intitule');
            $this->db->from($this->table_category. ' AS c');
            $this->db->join($this->table_expression. ' AS e', 'e.id_category=c.id','right');
            $this->db->join($this->table_container. ' AS  fs', 'e.id_expression=fs.id_exp','left');
            $this->db->where('e.id_stagiaire', $traineeId);
            $this->db->where('fs.type_file', 'image');
            $this->db->order_by("c.intitule", "ASC"); 
            $this->db->order_by("e.date_creation", "DESC"); 
            $this->db->group_by('c.id');
            $this->db->query("SET character_set_results = 'utf8', character_set_client = 'utf8', character_set_connection = 'utf8', character_set_database = 'utf8', character_set_server = 'utf8'");
            $query = $this->db->get();
            return $query->result();
        }
        
    }                                                
?>