<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    class QueryStat_model extends CI_Model
    {
        
        public function __construct(){        
            parent::__construct();
            $this->ret                      = array();
            $this->cat                      = array();    
            $this->table_list_grp           = 'list_groupe';        
            $this->table_grp                = 'groupe';  
            $this->table_stat_connexion     = 'stat_connexion';  
            $this->table_membres            = 'membres';  
            $this->table_list_societe       = 'list_societe';  
            $this->table_tracking           = 'tracking';  
            $this->table_course_history     = 'historique_cours';  
            $this->table_plan_de_travail    = 'plan_de_travail';  
            $this->table_document           = 'document';  
            $this->table_list_module        = 'list_module';  
            $this->table_document_repertory = 'document_repertory'; 
            $this->table_corporate_library_soc ='corporate_library_soc'; 
            $this->table_list_sequence ='list_sequence'; 
            $this->table_cours_plannifier ='cours_plannifier'; 
            $this->table_sequence ='sequence'; 

        }

        public function AllQueryOptions() {
            $this->ret[] = array(
                "c" => "Top 5 des requêtes utilisés",
                "s" => "suivi stagiaires",
                "q" => "Liste des exerices",
                "r" =>  $this->db->select('*')
                                 ->from($this->table_membres)
                                 ->get()
                                 ->result()
            );
            $this->ret[] = array(
                "c" => "Prototypes de relevés",
                "s" => "Top 5 des requêtes",
                "q" => "Suivi des exercices r&eacute;alis&eacute;s par les stagiaires",
                "r" =>  $this->db->select('*')
                                 ->from($this->table_membres)
                                 ->get()
                                 ->result()
            );
            $this->ret[] = array(
                "c" => "Prototypes de relevés",
                "s" => "Top 5 des requêtes",
                "q" => "Stagiaire non connectés mais qui sont censs&eacute;s etre connectés",
                "r" =>  $this->db->select('*')
                                 ->from($this->table_membres)
                                 ->get()
                                 ->result()
            );
            $this->ret[] = array(
                "c" => "Suivi des exercices",
                "s" => "suivi stagiaires",
                "q" => "Liste des exerices",
                "r" =>  $this->db->select('*')
                                 ->from($this->table_membres)
                                 ->get()
                                 ->result()
            );
            $this->ret[] = array(
                "c" => "Requêtes des données stagiaires",
                "s" => "suivi stagiaires",
                "q" => "Liste des exerices",
                "r" =>  $this->db->select('*')
                                 ->from($this->table_membres)
                                 ->get()
                                 ->result()
            );
            return $this->ret;

        }

        public function GetByQuery(){
            $allQuery = $this->AllQueryOptions();
            for ($i = 0; $i < count($allQuery); $i++) { 
                if (isset($allQuery[$i])) {
                    $this->cat[$i] = array(
                        'cat'   => $allQuery[$i]['c'],
                        'sub'   => $allQuery[$i]['s'],
                        'query' => $allQuery[$i]['q'],
                    );
                }
                
            }
            return $this->cat;
        }
        public function GetByQueryType($type){
            $allQuery = $this->AllQueryOptions();
            for ($i = 0; $i < count($allQuery); $i++) { 
                if (isset($allQuery[$i][$type])) {
                    $this->cat[$i] = $allQuery[$i][$type];
                }
                
            }
            return $this->cat;
        }
        public function GetSubCatByCategoryName($catName){
            $subcat = array();
            $allQuery = $this->AllQueryOptions();
            for ($i = 0; $i < count($allQuery); $i++) { 
                if (isset($allQuery[$i]['c']) && $allQuery[$i]['c'] == $catName) {
                    $subcat[$i] = $allQuery[$i]['s'];
                }
                
            }
            return $subcat;
        }
        public function GetRequestTitleBySubName($subName){
            $request = array();
            $allQuery = $this->AllQueryOptions();
            for ($i = 0; $i < count($allQuery); $i++) { 
                if (isset($allQuery[$i]['s']) && $allQuery[$i]['s'] == $subName) {
                    $request[$i] = $allQuery[$i]['r'];
                }
                
            }
            return $request;
        }

        public function monitoringTraineeTrackingDetail($array_data){

            $this->db->select("DATE(cpl.dateHeureCoursPlannifier) AS dateCoursPlannifier, TIME(cpl.dateHeureCoursPlannifier) AS creneauCoursPlannifier, CONCAT(cpl.nomProfCoursPlannifier,' ', cpl.prenomProfCoursPlannifier) AS professeur, t.type AS trackingType, t.id_tracking AS idTracking, CONCAT(m.nom,' ', m.prenom) AS stagiaire, DATE(FROM_UNIXTIME(st.date_cnx)) AS dateCnx, TIME(FROM_UNIXTIME(t.date)) AS debutTracking, SEC_TO_TIME(t.time) AS dureeTracking, 
                if(t.type = 2, 'Course history', 
                if (t.type = 4, 'My database documents',
                if (t.type = 6, 'Newsletter',
                if (t.type = 7, 'Pedagogical training',
                if (t.type = 8, 'Personal Interest',
                if (t.type = 9, 'Linguistic Tools',
                if (t.type = 10, 'Statistic connexion',
                if (t.type = 14, 'Training objectif',
                if (t.type = 16, 'My document to sign',
                if (t.type = 18, 'Tableau de bord',
                if (t.type = 20, 'My personal lexical corpus',
                if (t.type = 968, 'My personal lexical corpus',
                if (t.type = 99, 'Manual',
                if (t.type = 22, 'My glossary',
                if (t.type = 23, 'My audio',
                if (t.type = 24, 'My personal traning area',
                if (t.type = 25, 'My connexion speed',
                if (t.type = 26, 'White paper',
                if (t.type = 30, 'Conference call',
                if (t.type = 111, 'My profil',
                if (t.type = 105, 'Corporate library',
                if (t.type = 8888, 'My profil',
                    '')))))))))))))))))))))) as menu, 
                if(t.type = 2 and t.module_id != '', h.intitule,
                if(t.type = 4 and t.module_id != '', rp.name,
                if(t.type = 7 and t.module_id != '', l.module_titre,
                if(t.type = 8 and t.module_id != '', l.module_titre,
                if(t.type = 9 and t.module_id != '', l.module_titre,
                if(t.type = 10, 'Statistic connexion',
                if(t.type = 26, 'White paper',
                if(t.type = 30, 'Conference call',
                if(t.type = 105 and t.module_id != '', cp.name,
                    ''))))))))) as module,

                if(t.type = 2 and t.sequence_id != 0, p.sequence,
                if(t.type = 4 and t.module_id != '', dc.titre,
                if(t.type = 7 and t.module_id != '', ls.sequence_titre,
                if(t.type = 8 and t.module_id != '', ls.sequence_titre,
                if(t.type = 9 and t.module_id != '', ls.sequence_titre,
                if(t.type = 10, 'Statistic connexion',
                if(t.type = 26, 'White paper',
                if(t.type = 30, 'Conference call',
                if(t.type = 105 and t.module_id != '', cp.name,
                    ''))))))))) as sequence,

                if(t.type = 2 and t.sequence_id != 0, p.url,
                if(t.type = 4 and t.chapitre_id != '', dc.fichier,
                if(t.type = 7 and t.chapitre_id != '', seq.link,
                if(t.type = 8 and t.chapitre_id != '', seq.link,
                if(t.type = 9 and t.chapitre_id != '', seq.link,
                if(t.type = 10, '',
                if(t.type = 26, 'White paper',
                if(t.type = 30, 'Conference call',
                if(t.type = 105 and t.module_id != '', cp.name,
                    ''))))))))) as exerices");

            $this->db->from($this->table_tracking." AS t");

            $this->db->join($this->table_membres." AS m", 'm.id=t.user_id','INNER');

            $this->db->join($this->table_stat_connexion." AS st", 'st.id_membres=t.user_id AND st.cnx = t.id_cnx','INNER');

            $this->db->join($this->table_cours_plannifier." AS cpl", 'cpl.refIndividuStagiaireCoursPlannifier=m.extranet_id AND cpl.idStageCoursPlannifier = st.id_stage AND DATE(cpl.dateHeureCoursPlannifier) = DATE(FROM_UNIXTIME(st.date_cnx))','LEFT');

            $this->db->join($this->table_course_history." AS h", 'h.id=t.module_id AND h.id_groupe = m.id_groupe','LEFT');
            $this->db->join($this->table_plan_de_travail." AS p", 'p.historique_cours=t.module_id AND p.id_plan_de_travail = t.sequence_id','LEFT');

            $this->db->join($this->table_list_module." AS l", 'l.module_id=t.module_id','LEFT');
            $this->db->join($this->table_list_sequence." AS ls", 'ls.sequence_id=t.sequence_id','LEFT');
            $this->db->join($this->table_sequence." AS seq", 'seq.id_sequence = t.sequence_id AND seq.numero = t.chapitre_id','LEFT');

            $this->db->join($this->table_document_repertory." AS rp", 'rp.id=t.module_id','LEFT');
            $this->db->join($this->table_document." AS dc", 'dc.id=t.sequence_id','LEFT');

            $this->db->join($this->table_corporate_library_soc." AS cp", 'cp.id=t.module_id','LEFT');



            if (isset($array_data["prof"]) && !empty($array_data["prof"]) && isset($array_data["prof"][1])) {
                $this->db->where_in('cpl.refIndividuProfCoursPlannifier', $array_data["prof"]);
            }

            if (isset($array_data["connexion_date"][0]) && $array_data["connexion_date"][0] && isset($array_data["connexion_date"][1]) && $array_data["connexion_date"][1]) {
               //$this->db->where('DATE(FROM_UNIXTIME(t.date)) BETWEEN "'.$array_data["connexion_date"][0]. '" AND "'.$array_data["connexion_date"][1].'"');
               $this->db->where('DATE(FROM_UNIXTIME(st.date_cnx)) BETWEEN "'.$array_data["connexion_date"][0]. '" AND "'.$array_data["connexion_date"][1].'"');
               //$this->db->where('DATE(cp.dateHeureCoursPlannifier) BETWEEN "'.$arrayKeySearch['datePlannification'][0].'" AND "'.$arrayKeySearch['datePlannification'][1].'" ');
            }
            else{
                $this->db->where('DATE(FROM_UNIXTIME(st.date_cnx))',$array_data["connexion_date"][0]);
            }



            /*if (isset($array_data["trainee"]) && !empty($array_data["trainee"]) && isset($array_data["trainee"][1])) {
               $this->db->where_in('m.id', $array_data["trainee"]);
            }*/

            if (isset($array_data['crenneauHoraire'])) {
                $this->db->where_in('TIME(cpl.dateHeureCoursPlannifier)', $array_data['crenneauHoraire']);
            }

            $this->db->where('m.type', 0);
            $this->db->group_by('t.id_tracking');
            $query = $this->db->get();
            return $query->result();
        }

        public function monitoringtraineecnx($array_data){
            $this->db->select("CONCAT(m.nom,' ', m.prenom) AS stagiaire, DATE(FROM_UNIXTIME(s.date_cnx)) AS dateCnx, TIME(FROM_UNIXTIME(s.date_cnx)) AS debutCnx, SEC_TO_TIME(s.time_cnx) AS dureeCnx, s.navigateur, s.platform, soc.description AS societe");
            $this->db->from($this->table_stat_connexion." as s");
            $this->db->join($this->table_membres." as m", 's.id_membres=m.id','inner');
            $this->db->join($this->table_list_societe." as soc", 'soc.id_societe=m.id_societe','inner');

            if (isset($array_data["trainee"]) && !empty($array_data["trainee"]) && isset($array_data["trainee"][1])) {
                $this->db->where_in('m.id', $array_data["trainee"]);
            }

            if (isset($array_data["societe"]) && !empty($array_data["societe"]) && isset($array_data["societe"][1])) {
                $this->db->where_in('soc.id_societe', $array_data["societe"]);
            }

            if (isset($array_data["connexion_date"][0]) && $array_data["connexion_date"][0] && isset($array_data["connexion_date"][1]) && $array_data["connexion_date"][1]) {
               $this->db->where('DATE(FROM_UNIXTIME(s.date_cnx)) BETWEEN "'.$array_data["connexion_date"][0]. '" AND "'.$array_data["connexion_date"][1].'"');
            }
            else{
                $this->db->where('DATE(FROM_UNIXTIME(s.date_cnx))',$array_data["connexion_date"][0]);
            }

            $this->db->where('m.type', 0);
            $query = $this->db->get();
            return $query->result();
        }

        public function monitoringtraineetracking($array_data){
            $this->db->select("s.platform, s.cnx, DATE(FROM_UNIXTIME(s.date_cnx)) AS dateCnx, TIME(FROM_UNIXTIME(s.date_cnx)) AS debutCnx, TIME(FROM_UNIXTIME(s.date_logout)) AS finCnx, tr.id_tracking, TIME(FROM_UNIXTIME(tr.date)) AS debutTracking, TIME(FROM_UNIXTIME(tr.date_logout)) AS finTracking, SEC_TO_TIME(tr.time) AS dureeTracking, CONCAT(m.nom,' ', m.prenom) AS stagiaire, m.niveauStage, soc.description AS societe, CONCAT(cpl.nomProfCoursPlannifier,' ', cpl.prenomProfCoursPlannifier) AS tuteur, s.navigateur, DATE(cpl.dateHeureCoursPlannifier) AS dateCoursPlannifier, TIME(cpl.dateHeureCoursPlannifier) AS creneauCoursPlannifier,  
                if(tr.type = 2, 'Course history', 
                if (tr.type = 4, 'My database documents',
                if (tr.type = 6, 'Newsletter',
                if (tr.type = 7, 'Pedagogical training',
                if (tr.type = 8, 'Personal Interest',
                if (tr.type = 9, 'Linguistic Tools',
                if (tr.type = 10, 'Statistic connexion',
                if (tr.type = 14, 'Training objectif',
                if (tr.type = 16, 'My document to sign',
                if (tr.type = 18, 'Tableau de bord',
                if (tr.type = 20, 'My personal lexical corpus',
                if (tr.type = 968, 'My personal lexical corpus',
                if (tr.type = 99, 'Manual',
                if (tr.type = 22, 'My glossary',
                if (tr.type = 23, 'My audio',
                if (tr.type = 24, 'My personal traning area',
                if (tr.type = 25, 'My connexion speed',
                if (tr.type = 26, 'White paper',
                if (tr.type = 30, 'Conference call',
                if (tr.type = 111, 'My profil',
                if (tr.type = 105, 'Corporate library',
                if (tr.type = 8888, 'My profil',
                    '')))))))))))))))))))))) as menu, 
                if(tr.type = 2 and tr.module_id != '', h.intitule,
                if(tr.type = 4 and tr.module_id != '', rp.name,
                if(tr.type = 7 and tr.module_id != '', l.module_titre,
                if(tr.type = 8 and tr.module_id != '', l.module_titre,
                if(tr.type = 9 and tr.module_id != '', l.module_titre,
                if(tr.type = 10, 'Statistic connexion',
                if(tr.type = 26, 'White paper',
                if(tr.type = 30, 'Conference call',
                if(tr.type = 105 and tr.module_id != '', cp.name,
                    ''))))))))) as module,

                if(tr.type = 2 and tr.sequence_id != 0, p.sequence,
                if(tr.type = 4 and tr.module_id != '', dc.titre,
                if(tr.type = 7 and tr.module_id != '', ls.sequence_titre,
                if(tr.type = 8 and tr.module_id != '', ls.sequence_titre,
                if(tr.type = 9 and tr.module_id != '', ls.sequence_titre,
                if(tr.type = 10, 'Statistic connexion',
                if(tr.type = 26, 'White paper',
                if(tr.type = 30, 'Conference call',
                if(tr.type = 105 and tr.module_id != '', cp.name,
                    ''))))))))) as sequence,

                if(tr.type = 2 and tr.sequence_id != 0, p.url,
                if(tr.type = 4 and tr.chapitre_id != '', dc.fichier,
                if(tr.type = 7 and tr.chapitre_id != '', seq.link,
                if(tr.type = 8 and tr.chapitre_id != '', seq.link,
                if(tr.type = 9 and tr.chapitre_id != '', seq.link,
                if(tr.type = 10, '',
                if(tr.type = 26, 'White paper',
                if(tr.type = 30, 'Conference call',
                if(tr.type = 105 and tr.module_id != '', cp.name,
                    ''))))))))) as exerices");
            $this->db->from($this->table_tracking." as tr");
            $this->db->join($this->table_membres." as m", 'tr.groupe_id=m.id_groupe','INNER');
            $this->db->join($this->table_stat_connexion." as s",'s.cnx = tr.id_cnx', 'INNER');
            $this->db->join($this->table_list_societe." as soc",'soc.id_societe = m.id_societe', 'INNER');

            $this->db->join($this->table_cours_plannifier." AS cpl", 'cpl.refIndividuStagiaireCoursPlannifier=m.extranet_id AND cpl.idStageCoursPlannifier = s.id_stage AND DATE(cpl.dateHeureCoursPlannifier) = DATE(FROM_UNIXTIME(s.date_cnx))','LEFT');

            $this->db->join($this->table_course_history." AS h", 'h.id=tr.module_id AND h.id_groupe = m.id_groupe','LEFT');
            $this->db->join($this->table_plan_de_travail." AS p", 'p.historique_cours=tr.module_id AND p.id_plan_de_travail = tr.sequence_id','LEFT');

            $this->db->join($this->table_list_module." AS l", 'l.module_id=tr.module_id','LEFT');
            $this->db->join($this->table_list_sequence." AS ls", 'ls.sequence_id=tr.sequence_id','LEFT');
            $this->db->join($this->table_sequence." AS seq", 'seq.id_sequence = tr.sequence_id AND seq.numero = tr.chapitre_id','LEFT');

            $this->db->join($this->table_document_repertory." AS rp", 'rp.id=tr.module_id','LEFT');
            $this->db->join($this->table_document." AS dc", 'dc.id=tr.sequence_id','LEFT');

            $this->db->join($this->table_corporate_library_soc." AS cp", 'cp.id=tr.module_id','LEFT');


            if (isset($array_data["trainee"]) && !empty($array_data["trainee"]) && isset($array_data["trainee"][1])) {
                $this->db->where_in('m.id', $array_data["trainee"]);
            }

            if (isset($array_data["societe"]) && !empty($array_data["societe"]) && isset($array_data["societe"][1])) {
                $this->db->where_in('m.id_societe', $array_data["societe"]);
            }

            if (isset($array_data["connexion_date"][0]) && $array_data["connexion_date"][0] && isset($array_data["connexion_date"][1]) && $array_data["connexion_date"][1]) {
               $this->db->where('DATE(FROM_UNIXTIME(s.date_cnx)) BETWEEN "'.$array_data["connexion_date"][0]. '" AND "'.$array_data["connexion_date"][1].'"');
            }
            else{
                $this->db->where('DATE(FROM_UNIXTIME(s.date_cnx))',$array_data["connexion_date"][0]);
            }

            $this->db->where('m.type', 0);
            $this->db->order_by('tr.id_tracking','desc');
            $query = $this->db->get();
            return $query->result();
        }
    }

?>
