<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Teacher_link_and_document_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct(); 
        $this->table        = 'professor_library';     
        $this->table_doc    = 'professor_library_content';        
    }

    public function add($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function getByAuthor($user_create,$Order) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $user_create);
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('name', 'asc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getContentByUserCreate($user_create) {
        $this->db->select('content.*');
        $this->db->from($this->table_doc.' as content');
        $this->db->join($this->table.' as lib', 'lib.id = content.id_repertory', 'LEFT');
        $this->db->where('content.user_create', $user_create);
        $this->db->where('content.titre !=', null);
        $this->db->group_by('content.id');
        $this->db->order_by('content.titre', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getAllByOthor($prop,$idRep,$rowperpage,$rowid){
        $this->db->select('*');
        $this->db->from($this->table_doc);
        $this->db->where('user_create', $prop);
        $this->db->where('id_repertory !=', $idRep);
        $this->db->or_where('id_repertory',NULL);
        $this->db->limit($rowperpage,$rowid);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function getInfosByRep($id_repertory){
        $this->db->select('*');
        $this->db->from($this->table_doc);
        $this->db->where('id_repertory', $id_repertory);
        $query = $this->db->get(); 
        $result = $query->result();
        return $result;
    }

    public function getAll(){
        $this->db->select('*');
        $this->db->from($this->table);
        $query = $this->db->get(); 
        $result = $query->result();
        return $result;
    }

    public function updateContent($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table_doc, $data);

    }

    public function getContentById($id){
        $this->db->select('*');
        $this->db->from($this->table_doc);
        $this->db->where('id', $id);
        $query = $this->db->get(); 
        $result = $query->result();
        return $result;
    }


    public function getByAuthorAndName($idUserCreate,$libname) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('name', $libname);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function Request($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestContent($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table_doc);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    

    public function addContent($data){
        $this->db->trans_start();
        $this->db->insert($this->table_doc, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function getAllDataNotInLibrary($user_create)
    {
        $this->db->select('*');
        $this->db->from($this->table_doc);
        $this->db->where('user_create', $user_create);
        $this->db->where('id_repertory', NULL);
        $this->db->group_by('titre');
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    } 

    public function checkData($data){
        $this->db->select('*');
        $this->db->from($this->table_doc);

        if (isset($data['titre'])) {
            $this->db->where('titre', $data['titre']);
        }

        if (isset($data['link'])) {
            $this->db->where('link', $data['link']);
        }

        if (isset($data['type'])) {
            $this->db->where('type', $data['type']);
        }

        if (isset($data['user_create'])) {
            $this->db->where('user_create', $data['user_create']);
        }

        if (isset($data['id_repertory'])) {
            $this->db->where('id_repertory', $data['id_repertory']);
        }

        $query = $this->db->get(); 
        return $query->result();
    }

    public function deleteContent($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table_doc);
    }

    public function deleteContentByLib($id_repertory){
        $this->db->where('id_repertory', $id_repertory);
        $this->db->delete($this->table_doc);
    }


    public function getSequenceMaxOrder()
    {
        $idSequence = 'NL';
        $this->db->select('MAX(id) as maxId');
        $this->db->from($this->table_doc);
        $query = $this->db->get(); 
        foreach ($query->result() as $res) {
            $idSequence .= ($res->maxId + 1);
        }
        return $idSequence;
    } 

}

?>
