$(document).ready(function(){
   

    var listExpression = $('#expressionDatabank').DataTable({
    });

    $('.statDate').datepicker({
        dateFormat: "dd/mm/yy",
    });
    $('.endDate').datepicker({
        dateFormat: "dd/mm/yy",
    });
    var normalizeDate = function(dateString) {

        //var correctFormat = dateString;
        var correctFormat = dateString.replace(/(\d+)\/(\d+)\/(\d+)/, "$3/$2/$1");
        var date = new Date(correctFormat);
        var normalized = date.getFullYear() + '' + (("0" + (date.getMonth() + 1)).slice(-2)) + '' + ("0" + date.getDate()).slice(-2);

        return normalized;
    }

    var filterByDate = function(column, startDate, endDate) {

        $.fn.dataTable.ext.search.push(
            function(oSettings, aData, iDataIndex) {
                var rowDate = normalizeDate(aData[column]);
                var start = normalizeDate(startDate);
                var end = normalizeDate(endDate);

                console.log('start : '+start + ' end ' + end + ' rowDate : ' + rowDate);

                // If our date from the row is between the start and end
                if (start <= rowDate && rowDate <= end) {
                    return true;
                } else if (rowDate >= start && end === '' && start !== '') {
                    return true;
                } else if (rowDate <= end && start === '' && end !== '') {
                    return true;
                } else {
                    return false;
                }
            }
        );
    };

    $('#filter').on('click', function(e) {
        e.preventDefault();
        var startDate = $('.statDate').val();
        var endDate = $('.endDate').val();
        var linkExport = $('#exportData').attr('href');
        $('#exportData').attr('href', linkExport + "&date_debut=" + startDate + "&date_fin=" + endDate);
        filterByDate(5, startDate, endDate);

        listExpression.draw();
    });
    $('#clearFilter').on('click', function(e) {
        e.preventDefault();
        $.fn.dataTableExt.afnFiltering.length = 0;
        listExpression.draw();

    });

    $('.btn-add-expression').click(function(e){
        e.preventDefault();
        $('#form-new-expression').attr('action',$('#form-new-expression').attr('action').replace("addexpression", "addexpression"));
        $('.modal-title').text('New expression');
        $('#text_langage_origin').val("");
        $('#text_langage_cible').val("");
        $('.idExpression').val("");
        $('#target_langue_cible option').each(function(){
            $(this).removeAttr('selected');
        });
        $('#modal_elearning').modal();
    });
    $('.btn-save-expression').click(function(e){
        e.preventDefault();
        $(".loader-nl").addClass('nl_action_loader');
        var dataExpression=$("#form-new-expression").serializeArray();
        var dataExpressionjson = {};
        for (i in dataExpression) {
            dataExpressionjson[dataExpression[i].name] = dataExpression[i].value;
        }
        dataExpression=dataExpressionjson;  
        var notification = "";
        if ($('.idExpression').val() != '') {
            notification += "Edition success";
        }
        else{
            notification += "Expression add succefuly";
        }

        $.ajax({
          type: "POST",
          url: $("#form-new-expression").attr('action'),
          data:  {"dataExpression":dataExpression},
          success: function( response ) {
            console.log(response);
            $('.btn-close-modal').click();
            $('.notification').html("<p class='notifyOwrner'>"+notification+"</p>");
            $('.notification').show('slow');
            setTimeout("$('.notification').hide('slow')",3000); 
            listExpression.draw(); 
            $(".loader-nl").removeClass('nl_action_loader');
          },
          error:function(err){
            console.log(err);
          }
        });
    });

    $('.export-expression').on('click', function() {
        //number of filtered rows
        var datas = [];
        var result = listExpression.rows({ filter: 'applied' }).data();
        var i = 0;
        result.each(function(key, value) {
            datas[i] = key;
            i++;
        });
        var url = $('.baseURL').val()+'exportexpressiontut';
        $(".loader-nl").addClass('nl_action_loader');
        $.ajax({
            type: "POST",
            url: url,
            data: { json: JSON.stringify(datas) },
            dataType: 'json',
            success: function(data, statut) {
                console.log(data);
                console.log(statut);
            },
            complete: function(data) {
                $(".loader-nl").removeClass('nl_action_loader');
                console.log(data);
                var contentType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
                var csvFile = new Blob([data.responseText], { type: contentType });
                var downloadUrl = window.URL.createObjectURL(csvFile);
                var a = document.createElement("a");
                a.href = downloadUrl;
                a.download = "export_expression.xls";
                document.body.appendChild(a);
                a.click();

            },
            error: function(data, statut, erreur) {

                console.log(erreur);
            }
        });


    });

    $('.button_speak_text').click(function(e){
        e.preventDefault();
        var text  = $('.textvalue').val();
        var voice = $('.voice_cible').val();
        responsiveVoice.speak(text,voice);
        return false;
    });
});

function deleteExpression(lien ,idExpression){
	var qst     = confirm("Are you sure to delete this");
	var url = $('.baseURL').val()+'deletedbtut';
   	if (qst) {
        $.ajax({
            url : url,
            type : 'POST',
            data : {"id" : idExpression},    
            success : function(data){
                $('.notification').html("<p class='notifyOwrner'>Data delete succefuly</p>");
                $('.notification').show('slow');
                setTimeout("$('.notification').hide('slow')",3000);  
                $(this).css("opacity","1");
                $(lien).parents('td').parents('.line_data_expr').remove();
            }
        });
    } 
}

function editExpression(lien ,idExpression){
    var origin = $(lien).parents('td').parents('.line_data_expr').find('.c_origin').text();
    var cible  = $(lien).parents('td').parents('.line_data_expr').find('.c_cible').text();
    var l_cible= $(lien).parents('td').parents('.line_data_expr').find('.l_cible').text();
    $('#form-new-expression').attr('action',$('#form-new-expression').attr('action').replace("addexpressiontut", "editexpressiontut"));
    $('.modal-title').text('Edition expression');
    $('#text_langage_origin').val(origin);
    $('#text_langage_cible').val(cible);
    $('.idExpression').val(idExpression);
    $('#target_langue_cible option').each(function(){
        $(this).removeAttr('selected');
        if (l_cible == $(this).text()) {
            $(this).attr('selected','selected');
        }
    });
    
    $('#modal_elearning').modal();
}

function textToSpeach(link){
    $('.textvalue').val($(link).attr('data-text'));
    $('#modal_text_to_speach').modal();
}