<?php    
    require '/var/www/html/elearning2020/application/libraries/vendor/autoload.php';
    function generateThumbnail($url,$width,$height,$dest){
        $thumb = new Screen\Capture($url);

        if (!isset($url)) {
            exit;
        }

        if (isset($width)) { // Width
            $thumb->setWidth(intval($width));
        }

        if (isset($height)) { // Height
            $thumb->setHeight(intval($height));
        }

        if (isset($width)) { // Clip Width
            $thumb->setClipWidth(intval($width));
        }

        if (isset($height)) { // Clip Height
            $thumb->setClipHeight(intval($height));
        }

        if (isset($_GET['user-agent'])) { // User Agent String
            $thumb->setUserAgentString($_GET['user-agent']);
        }

        if (isset($_GET['bg-color'])) { // Background Color
            $thumb->setBackgroundColor($_GET['bg-color']);
        }

        if (isset($_GET['format'])) { // Format
            $thumb->setImageType($_GET['format']);
        }
        if($thumb->save($dest)){
            return true;
        }
        else{
            return false;
        }
        exit;
    }

    function getFileName($url){
        $path = parse_url($url, PHP_URL_PATH);
        return basename($path);
    }
    function getAllHeaderResponses($url){
        $response = array();
        $header = @get_headers($url);
        return $header;
    }
    function findStatusUrlFinal($urlF){
        $ret = array();
        $headerResponses = getAllHeaderResponses($urlF);       
        if (strrpos($urlF, "https") !== false) {
            if ($headerResponses == false) {
                $ret['status'] = 1;
                $ret['urlF'] = $urlF;
            }
            else{
                for ($i=0; $i < count($headerResponses); $i++) { 

                    if ((strrpos($headerResponses[$i], "403 Forbidden") !== false) || (strrpos($headerResponses[$i], "404 Not Found") !== false)) {
                        $ret['status'] = 3;
                        $ret['urlF'] = $urlF;

                    }

                    if ((strrpos($headerResponses[$i], "X-Content-Security-Policy: frame-ancestors") !== false) || (strrpos($headerResponses[$i], "X-Frame-Options: SAMEORIGIN") !== false) || (strrpos($headerResponses[$i], "X-Frame-Options: DENY") !== false) || (strrpos($headerResponses[$i], "X-Frame-Options: deny") !== false)) {
                        $ret['status'] = 2;
                        $ret['urlF'] = $urlF;

                    }

                    if ((strrpos($headerResponses[$i], "403 Forbidden") === false) && (strrpos($headerResponses[$i], "404 Not Found") === false) && (strrpos($headerResponses[$i], "X-Content-Security-Policy: frame-ancestors") === false) && (strrpos($headerResponses[$i], "X-Frame-Options: SAMEORIGIN") === false) && (strrpos($headerResponses[$i], "X-Frame-Options: DENY") === false) && (strrpos($headerResponses[$i], "X-Frame-Options: deny") === false)) {
                        $ret['status'] = 1;
                        $ret['urlF'] = $urlF;
                    }
                }
            }
        }
        else {
            if ($headerResponses == false) {
                $ret['status'] = 7;
                $ret['urlF'] = $urlF;
            }
            else{
                $urlRedirect  = '';
                for ($i=0; $i < count($headerResponses); $i++) { 
                    //Check lins a redirect
                    if (strrpos($headerResponses[$i], "Location:") !== false) {
                        $urlRedirect = str_replace("Location: ", "", $headerResponses[$i]);
                    }
                }

                if (isset($urlRedirect) && $urlRedirect !== '') {
                    addLog('redirect url : '.$urlRedirect);
                    $headerResponses1 = getAllHeaderResponses($urlRedirect);
                    if ($headerResponses1 == false) {
                        $ret['status'] = 6;
                        $ret['urlF'] = $urlRedirect;
                    }
                    else{
                        for ($i=0; $i < count($headerResponses1); $i++) { 
                            
                            if ((strrpos($headerResponses1[$i], "403 Forbidden") !== false) || (strrpos($headerResponses1[$i], "404 Not Found") !== false)) {
                                $ret['status'] = 3;
                                $ret['urlF'] = $urlRedirect;
                            }

                            if ((strrpos($headerResponses1[$i], "X-Content-Security-Policy: frame-ancestors") !== false) || (strrpos($headerResponses1[$i], "X-Frame-Options: SAMEORIGIN") !== false) || (strrpos($headerResponses1[$i], "X-Frame-Options: DENY") !== false) || (strrpos($headerResponses1[$i], "X-Frame-Options: deny") !== false)) {
                                $ret['status'] = 2;
                                $ret['urlF'] = $urlRedirect;

                            }

                            if ((strrpos($headerResponses1[$i], "403 Forbidden") === false) && (strrpos($headerResponses1[$i], "404 Not Found") === false) && (strrpos($headerResponses1[$i], "X-Content-Security-Policy: frame-ancestors") === false) && (strrpos($headerResponses1[$i], "X-Frame-Options: SAMEORIGIN") === false) && (strrpos($headerResponses1[$i], "X-Frame-Options: DENY") === false) && (strrpos($headerResponses1[$i], "X-Frame-Options: deny") === false)) {
                                $ret['status'] = 1;
                                $ret['urlF'] = $urlRedirect;
                            }
                        }
                    }
                }
                else{   
                    $headerResponses2 = getAllHeaderResponses($urlF);  
                    for ($i=0; $i < count($headerResponses2); $i++) { 
                    
                        if ((strrpos($headerResponses2[$i], "403 Forbidden") !== false) || (strrpos($headerResponses2[$i], "404 Not Found") !== false)) {
                            $ret['status'] = 3;
                            $ret['urlF'] = $urlF;

                        }
                        else{                                                   
                            $ret['status'] = 4;
                            $ret['urlF'] = $urlF;
                        }
                    }
                }
            }
        }

        return $ret;
    }
    function getEmbedUrl($url) {
        // function for generating an embed link
        $finalUrl = '';

        if (strpos($url, 'facebook.com/') !== false) {
          // Facebook Video
          $finalUrl.='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';

        } 
        else if(strpos($url, 'vimeo.com/') !== false) {
          // Vimeo video
          $videoId = isset(explode("vimeo.com/",$url)[1]) ? explode("vimeo.com/",$url)[1] : null;
          if (strpos($videoId, '&') !== false){

          }
          $finalUrl.='https://player.vimeo.com/video/'.$videoId;

        } 
        else if (strpos($url, 'youtube.com/') !== false) {
          // Youtube video
          $videoId = isset(explode("v=",$url)[1]) ? explode("v=",$url)[1] : null;
          if (strpos($videoId, '&') !== false){
              $videoId = explode("&",$videoId)[0];
          }
          $finalUrl.='https://www.youtube.com/embed/'.$videoId;

        } 
        else if(strpos($url, 'youtu.be/') !== false) {
          // Youtube  video
          $videoId = isset(explode("youtu.be/",$url)[1]) ? explode("youtu.be/",$url)[1] : null;
          if (strpos($videoId, '&') !== false) {
              $videoId = explode("&",$videoId)[0];
          }
          $finalUrl.='https://www.youtube.com/embed/'.$videoId;

        } 
        else if (strpos($url, 'dailymotion.com/') !== false) {
          // Dailymotion Video
          $videoId = isset(explode("dailymotion.com/",$url)[1]) ? explode("dailymotion.com/",$url)[1] : null;
          if (strpos($videoId, '&') !== false) {
              $videoId = explode("&",$videoId)[0];
          }
          $finalUrl.='https://www.dailymotion.com/embed/'.$videoId;

        } 
        else{
          $finalUrl.=$url;
        }
        return $finalUrl;
    }
