<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Audio extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Rework_audio_model');
        $this->load->model('DatabankExpression_Model');
        $this->isLoggedIn();  
        $this->tracking_type = 88;  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }

    public function list(){   
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('training_my_audio');
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $idStagiaire = '';
        $idGroupe = '';

        if($this->isTuteurConnet()){
            $idStagiaire = $this->session->userdata('STAGIAIREID');
            $idGroupe    = $this->session->userdata('STAGIAIREGRP');
            $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        }   
        else{
            $idStagiaire = $this->session->userdata('GUSERID');
            $idGroupe    = $this->session->userdata('GROUPE');
        }

        $data['idGroupe']                    = $idGroupe;
        $data['idStagiaire']                 = $idStagiaire;
        $data['allThemeForAudio']            = $this->categoryExpression_model->getCategoryByIdGroup($idGroupe);
        $data['allResutlDistinctDateCreate'] = $this->Audio_model->getAllDIstinctDateCreate($idStagiaire);
        $data['allResutlDistinctCategory']   = $this->Audio_model->getAllDIstinctCategory($idStagiaire);
        $data['audioResultApi']              = $this->Audio_model->getByGroupTraineId($idStagiaire);
        $this->loadViews("trainee/audio/list", $this->global,$data, NULL );
    }

    public function deleteRecord(){
        $return = array();
        $return['data'] = $_POST;
        if (isset($_POST['contentOrigin'])) {
            $table = $_POST['contentOrigin'];
            $fileName = '';
            switch ($table) {
                case 'audio':
                    //$audioFile = $this->Audio_model->Request('link_audio',$_POST['audioId']) != '' ? str_replace('/elearning2023',$this->Audio_model->Request('link_audio',$_POST['audioId'])) : '';
                    $audioFile = $this->Audio_model->Request('link_audio',$_POST['audioId']);

                    if (isset($audioFile) && $audioFile != '' && file_exists(RP_GROUPES.$audioFile)) {
                        unlink(RP_GROUPES.$audioFile);
                    }
                    else{
                        if(file_exists(RP_GROUPES.'GRP'.$this->Audio_model->Request('groupe_id',$_POST['audioId']).'/'.$audioFile)){
                            unlink(RP_GROUPES.'GRP'.$this->Audio_model->Request('groupe_id',$_POST['audioId']).'/'.$audioFile);
                        }
                    } 

                    $return = array(
                        'status'   => true,
                        'content' => 'audio'
                    );                  

                    break;
                case 'expressions_stagiaires':
                    $audioFile = $this->DatabankExpression_Model->Request('audio_langue_origine',$_POST['audioId']);

                    if (isset($audioFile) && $audioFile != '' && file_exists(RP_GROUPES.'GRP'.$this->membres_model->Request('id_groupe',$this->DatabankExpression_Model->Request('id_stagiaire',$_POST['audioId'])).'/'.$audioFile)) {
                        unlink(RP_GROUPES.'GRP'.$this->membres_model->Request('id_groupe',$this->DatabankExpression_Model->Request('id_stagiaire',$_POST['audioId'])).'/'.$audioFile);
                    }
                    $this->DatabankExpression_Model->deleteExpression($_POST['audioId']);
                    $return = array(
                        'status'   => true,
                        'content' => 'expression'
                    );  
                    break;
                default:
                    // code...
                    break;
            }
        }
        echo json_encode($return);
    }

    public function list2(){      
        $id_group = $this->session->userdata('GROUPE');
        $id_tuteur = $this->session->userdata('GUSERID');
        $id_stag = $this->session->userdata('GUSERID');
        // ["STAGIAIREID"]=> string(4) "4626" ["STAGIAIREGRP"]
        if ($this->session->userdata('STAGIAIREID')){
            $id_group = $this->session->userdata('STAGIAIREGRP');
            $id_tuteur = $this->session->userdata('GUSERID');
            $id_stag = $this->session->userdata('STAGIAIREID');
        }
        //echo "111111";
        //var_dump($this->session->userdata);
        //var_dump($id_stag);

        
        $this->loadTrackingEl(0,0,$tracking_type);

        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : Audio List';
        $this->global['groupe'] = $this->session->userdata ('GROUPE');
        // echo "AAAAAAAAAAAAA";
        // var_dump($this->session->userdata);
        // echo "idstag = ".$id_stag;
        // echo "id_group = ".$id_group;


        // $data = array(
        //     'videoResult' => $this->Audio_model->traineelist($id_stag, $id_group),
        //     'videoFirstResult' => $this->Audio_model->traineelistfirst($id_stag, $id_group),
        //     'groupeid' => $id_group,
        //     'IDstag' => $id_stag,
        //     'grps' => $id_group,
        // );

        $data['audioResult'] = $this->Audio_model->traineelist($id_stag, $id_group);


        //$data['audioResult'] = $this->Audio_model->traineelist($id_stag, $id_group);
        // echo "<pre>";
        // print_r($data['audioResult']);
        // echo "</pre>";
     


        $this->loadViews("trainee/audio/listslider2", $this->global,$data, NULL );
    }

    public function getByExpressionId(){
        $return = array();
        $html   = '';
        
        $idGroupe  = $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') : $this->session->userdata ('GROUPE');
        if (isset($_POST['id'])) {
            if (isset($_POST['origin']) && $_POST['origin'] == 'expressions_stagiaires') {
                $allResult = $this->Audio_model->getByExpressionId($_POST['id']);
            }
            else{
                $allResult = $this->Audio_model->getByAudioId($_POST['id']);
            }

            if (isset($allResult)) {
                foreach($allResult as $res) {
                    $mediaContent = ''; 
                    if (isset($res->link_audio) && $res->link_audio != '' && file_exists(RP_GROUPES.'GRP'.$idGroupe.'/'.$res->link_audio)) {
                        $mediaContent = HTTP_MAIN.'groupes/GRP'.$idGroupe.'/'.$res->link_audio;
                    }
                    elseif (isset($res->audio_langue_origine) && $res->audio_langue_origine != '' && file_exists(RP_GROUPES.'GRP'.$idGroupe.'/'.$res->audio_langue_origine)) {
                        $mediaContent = HTTP_MAIN.'groupes/GRP'.$idGroupe.'/'.$res->audio_langue_origine;
                    }
                    else{
                        $mediaContent = ''; 
                    }

                    $audioTitle = '';
                    if (isset($res->link_audio) && $res->link_audio != '') { $audioTitle = $this->convert_utf8($res->titre); } else{ if (isset($res->audio_legend) && $res->audio_legend != '') { $audioTitle = $this->convert_utf8($res->audio_legend); } else{ $audioTitle = $this->convert_utf8($res->audio_langue_origine); } }
                    //$id_origin = (isset($_POST['origin']) && $_POST['origin'] != 'expressions_stagiaires') ? $res->audioId : $res->id_expression;
                    $id_origin = $_POST['id'];
                    $fileRef = (isset($_POST['origin']) && $_POST['origin'] != 'expressions_stagiaires') ? $res->link_audio : $res->audio_langue_origine;
                    $content_origin = (isset($_POST['origin']) && $_POST['origin'] != 'expressions_stagiaires') ? 'audio' : 'expressions_stagiaires';
                    $content_lang_origin = (isset($res->langue) && $res->langue != null && $res->langue == 'fr') ? $res->content_langue_cible : $res->content_langue_origine;
                    $content_lang_cible = (isset($res->langue) && $res->langue != null && $res->langue == 'fr') ? $res->content_langue_origine : $res->content_langue_cible;
                    $allRework = $this->Rework_audio_model->getAllByAudioAndOrigin($id_origin,$content_origin);

                    $return['idExpression'] = $res->id_expression;
                    $return['originalTexto'] = $this->convert_utf8($content_lang_origin);
                    $return['comment'] = $this->convert_utf8($res->comment);
                    $html   .= '
                    <!-- video-principal -->
                    <div class="col-md-6 mb-3">

                        <div class="audio-container">
                            <div class="media-meta">
                                <div class="select-audio">
                                    <select name="" id="" class="choose-audio el-form-select" onchange="loadAudioRewordContent(this)">
                                        <option data-request="origin" value="'.$mediaContent.'" data-id-expression="'.$res->id_expression.'" data-file-ref="'.$fileRef.'" data-content-lang-origin="'.$content_lang_origin.'" data-content-lang-cible="'.$content_lang_cible.'" data-intitule="'.$audioTitle.'" data-revise-text="'.$res->revise_text.'" data-ia-reformulation="'.$this->convert_utf8($res->ia_reformulation).'">'.$this->lang->line('audio_original').'</option>';
                                        if(isset($allRework) && count($allRework) >= 1){ 
                                            foreach($allRework as $rework) { 
                                                $mediaRework = ''; 
                                                if (isset($rework->name_audio) && $rework->name_audio != '' && file_exists(RP_GROUPES.'GRP'.$idGroupe.'/'.$rework->name_audio)) {
                                                    $mediaRework = HTTP_MAIN.'groupes/GRP'.$idGroupe.'/'.$rework->name_audio;
                                                }
                                                else{
                                                    $mediaRework = ''; 
                                                }

                                                $contentTextLangeOrigin = (isset($rework->langage) && $rework->langage == 'fr-FR') ? $this->convert_utf8($rework->transcription_fr) : $this->convert_utf8($rework->transcription_en);
                                                $contentTextLangeCible = (isset($rework->langage) && $rework->langage == 'fr-FR') ? $this->convert_utf8($rework->transcription_en) : $this->convert_utf8($rework->transcription_fr);
                                        
                                                $html   .= '<option data-request="rework" value="'.$mediaRework.'" data-id-expression="'.$rework->id.'" data-file-ref="'.$rework->name_audio.'" data-content-lang-origin="'.$contentTextLangeOrigin.'" data-content-lang-cible="'.$contentTextLangeCible.'" data-intitule="'.$this->convert_utf8($rework->legend_audio).'" data-revise-text="'.$this->convert_utf8($rework->revise_text).'" data-ia-reformulation="'.$this->convert_utf8($rework->ia_reformulation).'">'.$this->convert_utf8($rework->legend_audio).'</option>';
                                        } }
                                    $html   .= '</select>
                                    
                                </div>
                                <button class="el-btn-icon el-btn-pink rework-audio" onclick="rework(this)" data-expression-id="'.$res->id_expression.'" data-audio-id="'.$id_origin.'" data-content-origin="'.$content_origin.'" data-media="'.$mediaContent.'" data-media-name="'.$this->convert_utf8($audioTitle).'" data-course = "'.$mediaContent.'">
                                    <i class="bx bxs-microphone"></i>'.$this->lang->line('reword_audio').'
                                </button>

                            </div>
                            <div class="media-audio">
                                <audio class="main-audio audio-control-main" controls>
                                    <source class="audio-link-read" data-course = "'.$mediaContent.'" src="'.$mediaContent.'" type="audio/mpeg"/>
                                </audio>
                            </div>                        
                            <div class="main-video-meta">
                                <h4>'.$audioTitle.'</h4>
                                <div class="video-date">
                                    <i class="bx bxs-calendar-alt"></i>'.explode(' ', $res->date_creation)[0].'
                                </div>
                            </div>
                        </div>                
                    </div>
                    <!-- /video-principal -->
                    <!-- rework audio / statistique -->
                    <div class="col-md-6 d-flex mb-3">
                        
                        <div class="audio-container lexical-analysis">
                            <div class="media-meta">

                                <h3>'.$this->lang->line('analyse_lexicate').'</h3>
                                <div class="select-audio">
                                    <select name="" id="" class="choose-audio el-form-select stat-other-data-expression" onchange="loadStatOtherData(this)">
                                        <option data-cible="origin" data-audio-id="'.$id_origin.'" value="'.$this->convert_utf8($content_lang_origin).'">'.$this->lang->line('transcription_origin_text').'</option>
                                        <option data-cible="revise_text" data-audio-id="'.$id_origin.'" value="'.$this->convert_utf8($res->revise_text).'">'.$this->lang->line('transcription_text_rework').'</option>
                                        <option data-cible="ia_reformulation" data-audio-id="'.$id_origin.'" value="'.$this->convert_utf8($res->ia_reformulation).'">'.$this->lang->line('transcription_reformule_ia').'</option>
                                    </select>                                
                                </div>
                            </div>
                            
                            <div class="audio-statistics" data-expression-id="'.$res->id_expression.'" data-expression-origin="'.$this->convert_utf8($content_lang_origin).'">
                                <div class="bs-stat-container">
                                    <div class="bs-stat">
                                        <span class="stat_words" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_words').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat">
                                        <span class="stat_happaxes" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_hapaxes').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat">
                                        <span class="stat_duration" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_duration').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat">
                                        <span class="stat_debit" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_debit').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="bs-stat-container">
                                    <div class="bs-stat bs-bg-green">
                                        <span class="stat_verbs" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_verbs').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat bs-bg-blue">
                                        <span class="stat_adjectif" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_adjectifs').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat bs-bg-pink">
                                        <span class="stat_active_voice" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_active_voice').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    <div class="bs-stat bs-bg-orange">
                                        <span class="stat_passive_voice" data-id-expression="'.$res->id_expression.'"></span>
                                        <span>'.$this->lang->line('media_passive_voice').'</span>
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                </div>                        
                            </div>

                            <button class="el-btn el-btn-blue btn-open-stat-modal" onclick="openStatModal(this);" data-toggle="modal" data-target="stat-analyse-lexicales" data-expression-id="'.$res->id_expression.'" data-expression-origin="'.$this->convert_utf8($content_lang_origin).'">'.$this->lang->line('track_your_progress').'</button>

                        </div>
                    </div>
                    <!-- /rework audio / statistique -->

                    <!-- transcription -->
                    <div class="col-md-6 mb-3 mb-md-0">
                        
                        <div class="transcription">
                            <div class="transcription-header">
                                <!--h4>My speech</h4-->
                                <h4>'.$this->lang->line('transcription_origin_text').'</h4>
                                <div class="transcription-btn">
                                    <button onclick="copyTextContent(this);" class="btn-copy btn-copy-content-origin"
                                        data-btn-id="'.$res->id_expression.'"><i class="bx bx-copy-alt"></i></button>
                                    <button class="btn-edit btn-edit-content-origin btn-save-data"
                                        onclick="registerMediaContentOrigin(this);" data-btn-id="'.$res->id_expression.'"><i class="bx bx-save"></i></button>
                                </div>
                            </div>
                            <div class="transcription-txt">
                                <textarea name="" data-request="origin" data-content-id="'.$res->id_expression.'" id="content-origin" class="el-textarea content-origin" data-langage="'.$res->langue.'">'.$this->convert_utf8($content_lang_origin).'</textarea>
                            </div>
                        </div>

                    </div>
                    <!-- transcription -->

                    <!-- translate -->
                    <div class="col-md-6">
                        <div class="translate reworked-container">
                            <div class="translate-header">
                                <div class="nav">
                                    <a href="#text-reworked" class="media-tab-item active show" id="reworked-menu-1" data-toggle="tab" role="tab" aria-controls="festival-content" aria-selected="true">
                                        <span>'.$this->lang->line('transcription_text_rework').'</span>    
                                    </a>
                                    <a href="#ia-version" class="media-tab-item" id="reworked-menu-2" data-toggle="tab" role="tab" aria-controls="transcription-vanessa-zoom-2023-09-19" aria-selected="false">
                                        <span>'.$this->lang->line('transcription_reformule_ia').'</span>    
                                    </a>  
                                </div>
                                  
                                <div class="transcription-btn">
                                    <button onclick="copyTextContentOther(this);" class="btn-copy btn-copy-content-cible"
                                        data-btn-id="'.$res->id_expression.'"><i class="bx bx-copy-alt"></i></button>
                                    <button class="btn-edit btn-save-data btn-save-data-content" onclick="saveContentOtherAudio(this)" data-btn-id="'.$res->id_expression.'"><i
                                            class="bx bx-save"></i></button>
                                    
                                </div>
                                                
                            </div>

                            <div class="tab-content" id="nav-tabContent">

                                <div id="text-reworked" class="tab-pane fade show active" role="tabpanel" aria-labelledby="reworked-menu-1">
                                    <div class="translate-txt">
                                        <textarea name="revise_text" data-request="origin" data-content-id="'.$res->id_expression.'" id="content-cible"
                                            class="el-textarea content-cible revise_text" data-label="'.$this->lang->line('transcription_text_rework').'" placeholder="'.$this->lang->line('transcription_text_rework').'" data-cible="revise_text">'.$this->convert_utf8($res->revise_text).'</textarea>
                                    </div>
                                </div>

                                <div id="ia-version" class="tab-pane fade" role="tabpanel" aria-labelledby="reworked-menu-2">
                                    <div class="translate-txt">
                                        <textarea name="ia_reformulation" data-request="origin" data-content-id="'.$res->id_expression.'" id="content-cible"
                                            class="el-textarea content-cible ia_reformulation" data-label="'.$this->lang->line('transcription_reformule_ia').'" placeholder="'.$this->lang->line('transcription_reformule_ia').'" data-cible="ia_reformulation">'.$this->convert_utf8($res->ia_reformulation).'</textarea>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </div>


                    </div>
                    <!-- translate -->';
                }
            }
        }
        $return['status'] = true;
        $return['htmlContent'] = $html;
        echo json_encode($return);
    }

    public function addRework(){
        $return = array();
        $transcriptionLinkF = '';
        if (isset($_POST)) {
            $audioFile = $_FILES['fileUpload'];
            $fileName = "audio_rework"."_".time().".wav";
            $fullpath = RP_GROUPES."GRP".$_POST['id_groupe'];
            if ( ! is_dir($fullpath) ) {
                mkdir($fullpath, 0777,true);
            }  

            try{
                move_uploaded_file($audioFile['tmp_name'], $fullpath.'/'.$fileName);
                if (isset($_POST['infolangue']) && $_POST['infolangue'] == "en-US") {
                    $transcriptionLinkF = 'transcription';
                }
                else{
                    $transcriptionLinkF = 'transcription_fr';
                }

                $audioLink = base_url().'groupes/GRP'.$_POST['id_groupe'].'/'.$fileName;

                $transcription = (isset($audioLink) && isset($transcriptionLinkF)) ? $this->getInfosTranscript($transcriptionLinkF.'?audio_link='.$audioLink) : '';
                $transcriptionFinal = isset($transcription) ? str_replace('\n','<br>',$transcription);
                $transcriptionFinal1 = str_replace('"','',$transcriptionFinal);

                $data = array(
                    'id_audio_original' => $_POST['audio_id'],
                    'legend_audio'      => $this->convert_utf8($_POST['legende_f']),
                    'name_audio'        => $fileName,
                    'langage'           => $_POST['infolangue'],
                    'transcription_fr'  => (isset($transcriptionFinal1) && $_POST['infolangue'] == "fr-FR") ? $transcriptionFinal1 : '',
                    'transcription_en'  => (isset($transcriptionFinal1) && $_POST['infolangue'] == "en-US") ? $transcriptionFinal1 : '',
                    'user_create'       => $this->session->userdata('GUSERID'),
                    'content_origin'    => $_POST['content_origin'],
                    'date'              => time()
                );

                //$transcript = $this->config->item("myodb_url_api").'portail-stagiaire/api-transcription-audio.php'
                $return = array(
                    'status' => true,
                    'message' => $this->Rework_audio_model->add($data),
                    'audioLink' => $audioLink,
                    'transcription' => $transcriptionFinal1,
                );
            }
            catch (Exception $e) {
                $return = array(
                    'status' => false,
                    'message' => $e->getMessage(),
                );
            }
        }
        echo json_encode($return);
    }

    public function ajaxAddNewReworkAudio(){
        $return = array();
        if (isset($_POST)) {
            $return['post'] = $_POST;
            $return['file'] = $_FILES['record_audio_file'];
            $audioFile = $_FILES['record_audio_file'];
            //$fileName = 'Audio '.$this->lang->line('course_history_of').' '.date('d/m/Y').' : '.$_POST['record_audio_file_name'];                                                    
            //$fileName = 'Audio '.$this->lang->line('course_history_of').' '.date('d/m/Y').' : '.$_POST['newLegend'].'.mp3';
            $fileName = $_POST['record_audio_file_name'];
            $fullpath = RP_GROUPES."GRP".$_POST['idGroupe'];
            if ( ! is_dir($fullpath) ) {
                mkdir($fullpath, 0777,true);
            }  

            try{
                $upload = move_uploaded_file($audioFile['tmp_name'], $fullpath.'/'.$fileName);
                $data = array(
                    'user_create'                => $this->session->userdata('GUSERID'),
                    'id_category'                => $_POST['theme'],
                    'id_stagiaire'               => $_POST['traineeId'],
                    'id_tuteur'                  => $this->isTuteurConnet() ? $this->session->userdata('GUSERID') : NULL,
                    'langue'                     => NULL,
                    'content_langue_origine'     => NULL,
                    'target_langue_cible'        => 1,
                    'audio_legend'               => (isset($_POST['newLegend']) && $_POST['newLegend'] != '') ? 'Audio '.$this->lang->line('course_history_of').' '.date('d/m/Y').' : '.$_POST['newLegend'].'' : '',
                    'content_langue_cible'       => NULL,
                    'audio_langue_origine'       => $fileName,
                    'audio_langue_cible'         => NULL,
                    'date_creation'              => date('Y-m-d H:i:s'),
                    'environnement_usage'        => NULL,
                    'producer_validation'        => NULL,
                    'valide'                     => 0,
                    'date_validation'            => NULL,
                    'duree_audio'                => NULL,
                    'type_exp'                   => $_POST['typeExp']
                );

                $return = array(
                    'status'  => true,
                    'message' => $this->DatabankExpression_Model->addExpression($data),
                    'upload'  => $upload,
                );
            }
            catch (Exception $e) {
                $return = array(
                    'status' => false,
                    'message' => $e->getMessage(),
                );
            }
        }
        echo json_encode($return);
    }

    public function modifContent(){
        $return        = array();
        $cible         = '';
        $audioLabel    = '';
        $navItemActive = '';
        if (isset($_POST)) {
            $cible         = $_POST['audioIdModif'];
            $navItemActive = $_POST['navItemActive'];
            if ($_POST['contentOrigin'] == 'audio') { // modification label in audio table
                $audioLabel = 'Audio n° '.$_POST['num_audio'].' '.$this->lang->line('course_history_of').' '.$_POST['audioLabelDate'].' : '.$_POST['inputItem'];
                $data = array(
                    'titre' => $this->convert_utf8($audioLabel)
                );
                $this->Audio_model->update($_POST['audioIdModif'],$data);
            }
            else{ // modification label in explression table
                $extension = explode('.',$_POST['inputItemOrigin'])[1];
                $audioLabel = 'Audio n° '.$_POST['num_audio'].' '.$this->lang->line('course_history_of').' '.$_POST['audioLabelDate'].' : '.$_POST['inputItem'];
                //$oldFile = $this->isTuteurConnet() ? RP_GROUPES.'GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$_POST['inputItemOrigin'] : RP_GROUPES.'GRP'.$this->session->userdata('GROUPE').'/'.$_POST['inputItemOrigin'];
                //$newFile = $this->isTuteurConnet() ? RP_GROUPES.'GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$audioLabel : RP_GROUPES.'GRP'.$this->session->userdata('GROUPE').'/'.$audioLabel;
                $data = array(
                    'audio_legend' => $this->convert_utf8($audioLabel)
                );
                $this->DatabankExpression_Model->editExpression($_POST['audioIdModif'],$data);
                /*if(file_exists($oldFile)) {
                    rename($oldFile , $newFile);
                }*/
            }
        }
        $return = array(
            'title'          => $this->convert_utf8($audioLabel),
            'cible'         => $cible,
            'navItemActive' => $navItemActive,
            'data'          => $data
        );
        echo json_encode($return);
    }

    public function updateOtherContent(){
        $return = array();
        if (isset($_POST['expressionId'])) {
            if (isset($_POST['request']) && $_POST['request'] == "origin") {                
                $data = array(
                    $_POST['cible'] => $_POST['contents']
                );
                $this->DatabankExpression_Model->editExpression($_POST['expressionId'], $data);
                $return['status'] = true;
            }
            else{                
                $data = array(
                    $_POST['cible'] => $_POST['contents']
                );
                $this->Rework_audio_model->update($_POST['expressionId'],$data);
                $return['status'] = true;
            }
        }
        else{
            $return['status'] = false;
        }
        echo json_encode($return);
    }

     public function registerComment(){
        $return = array();
        if (isset($_POST['value'])) {
            $data = array(
                'comment' => $_POST['value']
            );
            $this->DatabankExpression_Model->editExpression($_POST['idExpression'], $data);
            $return['status'] = true;
        }
        else{
            $return['status'] = false;
        }
        echo json_encode($return);
    }

}

?>