<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class FolderGroup extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        $this->isLoggedIn();   
        $this->load->model('membres_model');
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

        $this->global['pageTitle']  = 'E-learning : Directory management';
        $data = array();
        $this->load->library('form_validation');
        $this->form_validation->set_rules('startDate', 'Début de connexion', 'required');
        $this->form_validation->set_rules('endDate', 'Fin de connexion', 'required');

        if($this->form_validation->run() == TRUE){
            $s =  explode('/', $this->input->post('startDate'));
            $startDate = $s[2]."-".$s[1]."-".$s[0];

            $e =  explode('/', $this->input->post('endDate'));
            $endDate = $e[2]."-".$e[1]."-".$e[0];

            //date("Y-m-d", filemtime(RP_GROUPES."GRPT6613"))
            $data['allResults'] = $this->membres_model->getInfosByDate($startDate, $endDate, RP_GROUPES);
        }

        $this->loadViews("admin/folderGroup/list", $this->global,$data, NULL );
    }

    public function delete(){
        $return = array();

        if (isset($_POST['folderInfos'])) {            
            $folderInfos = $_POST['folderInfos'];
            if (isset($_POST['backup']) && $_POST['backup'] == '1') {
                //$this->load->library('zip');
                //$this->zip->compression_level = 0;
                for ($i=0; $i < count($folderInfos); $i++) { 
                    $return[$i]['status'] = $this->deleteDir($folderInfos[$i]);
                    //chmod($folderInfos[$i], 0777);
                    //chown($folderInfos[$i], 'apache');
                    //exec("chown -R ".$owner.":".$group." ".$folder);
                    //$return[$i]['infoszip'] = $this->zip->read_file($folderInfos[$i]);
                }
                //$this->zip->archive(RP_GROUPES.'backup_'.time().'.zip');
            }
            else{
                for ($i=0; $i < count($folderInfos); $i++) { 
                    $return[$i]['status'] = $this->deleteDir($folderInfos[$i]);
                }
            }
        }
        echo json_encode($return);
    }

    public function deleteDir($dir) {
        $files = array_diff(scandir($dir), array('.', '..')); 

        foreach ($files as $file) { 
            (is_dir("$dir/$file")) ? deleteDir("$dir/$file") : unlink("$dir/$file"); 
        }

        return rmdir($dir); 
    }
}

?>