<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class IncidentTechnic extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Incident_technique_model');
        $this->load->model('Stat_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }
    
    public function add(){
        $return = array();
        if (isset($_POST['dataIncident'])) {
            require_once(APPPATH.'models/Browser.php');
            $browser = new Browser(); 
            $data = array(
                'id_professeur' => $this->session->userdata ('GUSERID'),
                'plaform_prof' => $browser->getPlatform(),
                'navigateur_prof' => $browser->getBrowser()." ".$browser->getVersion(), 
                'id_stagiaire' => $this->session->userdata ('STAGIAIREID'),
                'plateform_stagiaire' => $this->Stat_model->RequestByIdMembres('platform',$this->session->userdata ('STAGIAIREID')),
                'navigateur_stagiaire' => $this->Stat_model->RequestByIdMembres('navigateur',$this->session->userdata ('STAGIAIREID')),
                'description' => $this->convert_utf8($_POST['dataIncident']['incident-sescription']),
                'date' => time()
            );
            $return['data'] = $data;
            $return['incident'] = $this->Incident_technique_model->add($data);             
        }  
        echo json_encode($return);      
    }
    
   
}

?>