<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Document
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Glossaire extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('bddl_model');
        $this->load->model('commande_glossaire_papier_model');
        $this->isLoggedIn(); 
        $this->tracking_type = 22;  
        if (isset($_GET['dl'])) {
            $sessionArray = array('LANGAGETXTSP'=>str_replace('_', ' ', $_GET['dl']));
            $this->session->set_userdata($sessionArray);      
        }

        if($this->isTuteurConnet()){
            $this->idGroupe       = $this->session->userdata('STAGIAIREGRP');
            $this->idStagiaire       = $this->session->userdata('STAGIAIREID');
        }
        else{
            $this->idGroupe       = $this->session->userdata('GROUPE');
            $this->idStagiaire       = $this->session->userdata('GUSERID');
        }
    }
    
    /**
     * This function used to load the first screen of the user
     */
   
    public function index()
    {
        ini_set('memory_limit', '-1');  
        $arrayPrototypeId = array();
        $arrayprotptypeReturn       = array();
        $idPrototypeAccess      = array();
        $dateCreation       = array();
        $allResultsLexiqueElementary       = array();
        $allResultsLexiqueGenerique       = array();
        $arrayprot       = array();
        $idGroupe       = '';
        $idStagiaire       = '';
        
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('educational_library_glossary'); 


        if (isset($_POST['term'])) {
            $data['term'] = $this->input->post('term');
        }
        else{
            $data['term'] = '';
        }

        $this->loadTrackingEl(0,0,$this->tracking_type);

        $prototypeGrp = $this->groupes_model->readPrototypeGroupe($this->idGroupe);       
        if(!empty($prototypeGrp['prototype'])) {
            $prx = explode(",", $prototypeGrp['prototype']);
            for ($i=0; $i < count($prx); $i++) { 
                $arrayprot[$i] = $this->getGlossaireDigitalByPrototype((int)($prx[$i]));
            }
        }


        if (isset($_GET['theme']) && isset($_GET['pr']) && isset($_GET['soc'])) {
            $arrayprotptypeReturn =  $this->bddl_model->getAllVocabByIdPrototypeAccessAndIdLexiqueAndIdTheme($_GET['theme'],$_GET['pr'],$_GET['soc']); ///api-bddl-el/get-vocabulaire-prototype/{id_prototype}/{id_societe}/{id_theme}
        }
        else{
            $arrayprotptypeReturn = $arrayprot;
        }
        $data['allDataResults'] = $arrayprotptypeReturn;
        if ($this->isTuteurConnet()) {
            $this->loadViews("tutor/glossary/list", $this->global, $data , NULL);
        }
        else{
            $this->loadViews("trainee/glossary/list", $this->global, $data , NULL);
        }
        
    }

    public function getAllPrototype()
    {
        $view = '';
        $arrayprot = array();
        $arrayprot1 = array();
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('educational_library_glossary_label'); 

        if ($this->isTuteurConnet()) {
            $view = 'tutor/glossary/allcontent';
        }
        else{
            $view = 'trainee/glossary/allcontent';
        }
        $prototypeGrp = $this->groupes_model->readPrototypeGroupe($this->idGroupe);       
        if(!empty($prototypeGrp['prototype'])) {
            if (strpos($prototypeGrp['prototype'], ',')) {                
                $prx = explode(",", $prototypeGrp['prototype']);
                for ($i=0; $i < count($prx); $i++) { 
                    $arrayprot[$i] = $this->getGlossaireDigitalByPrototype((int)($prx[$i]));
                }
            }
            else{
                $arrayprot[0] = $this->getGlossaireDigitalByPrototype((int)($prototypeGrp['prototype']));
            }
        }


        if (isset($_GET['theme']) && isset($_GET['pr']) && isset($_GET['soc'])) {
            //$arrayprotptypeReturn =  $this->bddl_model->getAllVocabByIdPrototypeAccessAndIdLexiqueAndIdTheme($_GET['theme'],$_GET['pr'],$_GET['soc']); ///api-bddl-el/get-vocabulaire-prototype/{id_prototype}/{id_societe}/{id_theme}
        }
        else{
            $arrayprotptypeReturn = $arrayprot;
        }

        $data['allDataResults'] = $arrayprotptypeReturn;

        $this->loadViews($view, $this->global, $data , NULL);
        
    }

    public function updateLexique(){
        $response = array();
        if (isset($_POST['id_lexique'])) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => "".$this->config->item('bddl_api_glossaire_papier')."stagiaire/prototypes/update?id_lexique_stagiaire=".$_POST['id_lexique']."&active=".$_POST['active']."&selected_expr=".$_POST['expressionSelect']."&nb_lx_soc=".$_POST['nbLexiqueS']."&nb_lx_gen=".$_POST['nbLexiqueG']."",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "GET",
            ));

            $response['result'] = curl_exec($curl);
            curl_close($curl);  

            echo json_encode($response);
        }
    }

    public function commanderGlossairePapier(){
        $response = array();
        if (isset($_GET['prototype'])) {
            $response['url_envoie'] = "".$this->config->item('bddl_api_glossaire_papier')."create?id_prototype=".$_GET['prototype']."&stagiaire=".$this->idStagiaire."";
            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => "".$this->config->item('bddl_api_glossaire_papier')."create?id_prototype=".$_GET['prototype']."&stagiaire=".$this->idStagiaire."",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "GET",
            ));

            $exec = curl_exec($curl);

            curl_close($curl);
            $response['result'] = $exec;
            $decodeJson = json_decode($exec);
            $dataCommandeGlossairePapier = array(
                'id_stagiaire' => $this->idStagiaire,
                'id_prototype' => $_GET['prototype'],
                'id_prototype_papier' => $decodeJson->id_prototype_papier,
                'date_commande' => time()
            );
            $response['id_commande_el'] = $this->commande_glossaire_papier_model->add($dataCommandeGlossairePapier);
            echo json_encode($response);
        }
    }

    public function listExpressionByCat(){
        $arrayprot = array();
        $this->global['pageTitle'] = 'E-learning - Expression list'; 
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $idCat = isset($_GET['id']) && $_GET['id'] != '' ? $_GET['id'] : NULL;
        $data['expressionCategoryResult'] = $this->databankExpression_Model->getListByCat($this->idStagiaire,$idCat);
        $this->loadViews("trainee/glossary/listExpByCat", $this->global, $data , NULL);
    }
    public function getLeByIdPrototypeAccess(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $this->global['pageTitle'] = 'E-learning : Lexique list'; 


        if (isset($_GET['id'])) {
            $data['allLexique'] = $this->bddl_model->getLeByIdPrototypeAccess($_GET['id']);
        }

        $this->loadViews("trainee/glossary/listLe", $this->global, $data , NULL);
    }
    public function getAllByKey(){
        $prototypeGrp = $this->groupes_model->readPrototypeGroupe($this->idGroupe);
        if(!empty($prototypeGrp['prototype'])) {
            $prx = explode(",", $prototypeGrp['prototype']);
            for ($i=0; $i < count($prx); $i++) { 
                $arrayprot[$i] = (int)($prx[$i]);
            }
            
        }
        if (isset($_POST['key']) && isset($arrayprot)) {
            $vocalbularyTermsByAllPrototype = $this->bddl_model->getAllVocabByArrayPrototype($arrayprot,$_POST['key'],NULL);
        }
    }

    public function personalise(){
        $idPrototype;
        if (isset($_GET['id'])) {
            $idPrototype = $_GET['id'];
        }
        
        $nbLexique = 0;
        $nbLexiqueGenberique = 0;
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $arrContextOptions=array(
            "ssl"=>array(
                "verify_peer"=>false,
                "verify_peer_name"=>false,
            ),
        );  


        $data['urlBddlGlossairePapierStagiaire'] = $this->config->item('bddl_api_glossaire_papier').'stagiaire/';
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('glossary_btn_personalise'); 
        
        $resultsJson = json_decode(file_get_contents($data['urlBddlGlossairePapierStagiaire'].$this->idStagiaire.'/prototypes/edit/'.$idPrototype, false, stream_context_create($arrContextOptions)));
        $data['resultsJson'] = $resultsJson;

        if (isset($resultsJson) && count($resultsJson) >= 1) {
            foreach($resultsJson->lexiquesStagiaire as $l) {
                if($l->active == true){
                    $nbLexique++;
                }
            }
            foreach($resultsJson->lexiquesStagiaireGen as $l) {
                if($l->active == true){
                    $nbLexiqueGenberique++;
                }
            }
        }
        $data['nbLexique'] = $nbLexique;
        $data['nbLexiqueGenberique'] = $nbLexiqueGenberique;

        $this->loadViews("trainee/glossary/personalise", $this->global, $data , NULL);

    }

    public function finaliseCommand(){
        $retour = array();
        $i = 0;
        if (isset($_POST['id']) && !empty($_POST['id'])) {
            

            $allResult = $this->commande_glossaire_papier_model->getAllById($_POST['id']);
            foreach($allResult as $c){
                $retour['id_stagiaire']                 = $c->id_stagiaire;
                $retour['id_prototype']                 = $c->id_prototype;
                $retour['id_prototype_papier']          = $c->id_prototype_papier;
                $retour['date_commande']                = isset($c->date_commande) && $c->date_commande != '' ? date('Y-m-d H:i:s', $c->date_commande) : '';
                $retour['status_finalisation_commande'] = $c->status_finalisation_commande;
                $retour['date_finalisation_commande']   = isset($c->date_finalisation_commande) && $c->date_finalisation_commande != '' ? date('Y-m-d H:i:s', $c->date_finalisation_commande) : '';
            }

            $validationCommand = $this->sendDataFinalisationCommandToBddl(json_encode($retour));
            $retour['response'] = $validationCommand;
            $dataValidationCommandDecodeJson = json_decode($validationCommand);
            if ($dataValidationCommandDecodeJson->status == 200) {                    
                $data_update = array(
                    'status_finalisation_commande' => 1,
                    'id_commande_bddl'             => $dataValidationCommandDecodeJson->data->id_commande,
                    'date_finalisation_commande'   => time()
                );
                $this->commande_glossaire_papier_model->update($_POST['id'],$data_update);
                $retour['error'] = 0;
                
            }
            else{
                $retour['error'] = 1;
            }

            echo json_encode($retour);
        }
    }

    public function sendDataFinalisationCommandToBddl($json_data){
        $data = json_decode($json_data, true);
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "".$this->config->item('bddl_api_glossaire_papier')."valider-commande?id_prototype_stagiaire=".$data['id_prototype_papier']."&stagiaire=".$data['id_stagiaire']."&status_finalistation=1",
          //CURLOPT_URL => "".$this->config->item('bddl_api_glossaire_papier')."valider-commande?id_prototype_stagiaire=".$this->bddl_model->getDataByStagiaireElAndPrototype($data['id_stagiaire'],$data['id_prototype'])['idPrototypePrototypeStagiaire']."&stagiaire=".$data['id_stagiaire']."&status_finalistation=1",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }
}

?>