<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
require APPPATH . '/libraries/google/vendor/autoload.php';  // Load Google Cloud Text-to-Speech package

use Google\Cloud\TextToSpeech\V1\TextToSpeechClient;
use Google\Cloud\TextToSpeech\V1\AudioConfig;
use Google\Cloud\TextToSpeech\V1\SynthesisInput;
use Google\Cloud\TextToSpeech\V1\VoiceSelectionParams;

//header('Content-Type: audio/mpeg');  // Set output header to audio/mpeg

//putenv('GOOGLE_APPLICATION_CREDENTIALS='.APPPATH.'/libraries/GOOGLE_APPLICATION_CREDENTIALS.json');

class GoogleApi extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();        
        $this->isLoggedIn();   
    }

    public function index(){

    }

    /*public function textToSpeach(){
        $return = array();
        if (isset($_POST['text'])) {
            $text = $_POST['text'];
            $languageCode = $_POST['languageCode'];
            $voiceName = $_POST['voiceName'];

            $client = new TextToSpeechClient();

            $input = new SynthesisInput();
            $input->setText($text);

            $voice = new VoiceSelectionParams();
            $voice->setLanguageCode($languageCode);
            $voice->setName($voiceName);

            $audioConfig = new AudioConfig();
            $audioConfig->setAudioEncoding(AudioConfig\AudioEncoding::MP3);

            $response = $client->synthesizeSpeech($input, $voice, $audioConfig);
            $audioContent = $response->getAudioContent();

            //echo $audioContent;  // Return the audio binary data
            $return = array(
                'status' => true,
                'data'   => $audioContent
            );

            $client->close();
        } 
        else {
            //echo 'Invalid request method!';
            $return = array(
                'status' => false,
                'data'   => null
            );
        }

        echo json_encode($return);
    }*/

    function detectLanguage() {
        $return = array();
        if (isset($_POST['SENTENCE'])) {
            $url = 'https://translation.googleapis.com/language/translate/v2/detect?key=' . $this->config->item('google_api_key');

            $data = array(
                'q' => $_POST['SENTENCE']
            );

            // Configuration de la requête
            $options = array(
                'http' => array(
                    'header'  => "Content-Type: application/json\r\n",
                    'method'  => 'POST',
                    'content' => json_encode($data),
                ),
            );

            $context  = stream_context_create($options);
            $result = file_get_contents($url, false, $context);

            if ($result === FALSE) {
                $return = array(
                    'status'  => false,
                    'message' => 'Erreur lors de la détection de la langue.',
                );
            }

            // Décodage de la réponse JSON
            $response = json_decode($result, true);
            if (isset($response['data']['detections'][0][0]['language'])) {
                //return $response['data']['detections'][0][0]['language'];
                $optionVoiceLanguage = '';
                switch ($response['data']['detections'][0][0]['language']) {
                    case 'fr':
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_fr_fr_fm').'">'.$this->lang->line('footer_js_modal_infos_fr_fr_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_fr_fr_ml').'">'.$this->lang->line('footer_js_modal_infos_fr_fr_ml').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_fr_cn_fr').'">'.$this->lang->line('footer_js_modal_infos_fr_cn_fr').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_fr_cn_ml').'">'.$this->lang->line('footer_js_modal_infos_fr_cn_ml').'</option>';
                        break;

                    case 'en':
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_uk_en_fm').'">'.$this->lang->line('footer_js_modal_infos_uk_en_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_uk_en_ml').'">'.$this->lang->line('footer_js_modal_infos_uk_en_ml').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_us_en_fm').'">'.$this->lang->line('footer_js_modal_infos_us_en_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_us_en_ml').'">'.$this->lang->line('footer_js_modal_infos_us_en_ml').'</option>';
                        break;

                    case 'fon':
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ch_fm').'">'.$this->lang->line('footer_js_modal_infos_ch_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ch_ml').'">'.$this->lang->line('footer_js_modal_infos_ch_ml').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ch_hk_fm').'">'.$this->lang->line('footer_js_modal_infos_ch_hk_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ch_hk_ml').'">'.$this->lang->line('footer_js_modal_infos_ch_hk_ml').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ch_tw_fm').'">'.$this->lang->line('footer_js_modal_infos_ch_tw_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ch_tw_ml').'">'.$this->lang->line('footer_js_modal_infos_ch_tw_ml').'</option>';
                        break;

                    case 'es':
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_sp_fm').'">'.$this->lang->line('footer_js_modal_infos_sp_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_sp_lat_am_fm').'">'.$this->lang->line('footer_js_modal_infos_sp_lat_am_fm').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_sp_lat_am_ml').'">'.$this->lang->line('footer_js_modal_infos_sp_lat_am_ml').'</option>';
                        break;

                    case 'ar':
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ar_ml').'">'.$this->lang->line('footer_js_modal_infos_ar_ml').'</option>';
                        $optionVoiceLanguage .= '<option value="'.$this->lang->line('footer_js_modal_infos_ar_fm').'">'.$this->lang->line('footer_js_modal_infos_ar_fm').'</option>';
                        break;
                    
                    default:
                        // code...
                        break;
                }
                $return = array(
                    'status'  => true,
                    'language'=> $response['data']['detections'][0][0]['language'],
                    'message' => $optionVoiceLanguage,
                );
            } else {
                //return 'Langue non détectée.';
                $return = array(
                    'status'  => false,
                    'message' => 'Langue non détectée.',
                );
            }
        }
        else{
            $return = array(
                'status'  => false,
                'message' => 'NO SENTENCE',
            );
        }

        echo json_encode($return);
    }

}

?>
