<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : BaseController
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class CoursPlanifier extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('connexion_model');
        $this->load->model('Membres_model');      
        $this->load->model('Tracking_model');   
        $this->load->model('Stag_individu_model'); 
        $this->load->model('CoursPlannifier_model');
        $this->load->model('CoursHistorik_model');           
        $this->isLoggedIn(); 
        $this->tracking_type = 11111;  
    }
    

    public function index()
    {

        $dateNow = date("Y-m-d");
        $this->global['pageTitle'] = 'E-learning : Cours planifier';
        $trackingid = $this->tracking_model->Add(0,0,$this->tracking_type);
        $sessionArray = array('TRACKINGID'=>$trackingid);                                    
        $this->session->set_userdata($sessionArray);
        $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');        
        $data['creneauHoraire']  = $this->CoursPlannifier_model->getAllCrenauRes(); 
        $data['trainerResult']   = $this->CoursPlannifier_model->getAllTrainer(); 
        $this->loadViews("supervisor/courseplan/list", $this->global, $data , NULL);
    }

    public function getTutorConnectByDate(){
        $retour = array();
        $date = date('Y-m-d');
        $i = 0;
        if (isset($_POST['datecoursplanifier'])) {
            $dateConnexion = '';
            switch ($_POST['datecoursplanifier']) {
                case 'jm1':
                    $dateConnexion .= date('Y-m-d', strtotime("-1 day"));
                    break;
                case 'j':
                    $dateConnexion .= $date;
                    break;
                case 'jp1':
                    $dateConnexion .= date('Y-m-d', strtotime("+1 day"));
                    break;
                
                default:
                    // code...
                    break;
            }

            $resultTutor = $this->CoursPlannifier_model->getTutorConnectByDate($dateConnexion);
            foreach ($resultTutor as $res) {
                $retour[$i]['trainer'] = $res->trainer;
                $i++;
            }
        }

        echo json_encode($retour);
    }

    public function search(){
        $retour                     = array();
        $referenceCnxNow            = '';
        $IdDernierCnx               = '';
        $dateDernierCnx             = '';            
        $statusProfilEL             = true;
        $cp                         = 0;
        $HtmlReturn                 = '';
        if (isset($_POST['dataFilter'])) {
            $criteriaFilter = array(
                'datecoursplanifier'    => $_POST['dataFilter']['datecoursplanifier'],
                'creneauHoraire'        => $_POST['dataFilter']['creneauhoraire'],
                'statusConnexion'       => $_POST['dataFilter']['statusconnexion'],
                'traineeFilter'         => $_POST['dataFilter']['trainee_filter'],
                'trainer'               => $_POST['dataFilter']['trainer'],
                'globalFilter'          => $_POST['dataFilter']['global_filter'],
                'allTraineeConnected'   => isset($_POST['dataFilter']['statusconnexion']) ? $this->connexion_model->getAllTraineeConnecter() : NULL
                //'allTraineeConnected'   => isset($_POST['dataFilter']['statusconnexion']) && $_POST['dataFilter']['statusconnexion'] == 'Deconnecté' ? $this->connexion_model->getAllTraineeConnecter() : NULL
            );

            $allResults = $this->CoursPlannifier_model->search($criteriaFilter);
            if (count($allResults) >= 1) {
                foreach($allResults as $value) {
                    $IdDernierCnx = '';
                    $dateDernierCnx = '';
                    $referenceCnxNow = '';
                    $finConnexionEl = ''; 
                    $debutConnexionEl = '';
                    $counterIsConnect = false; 
                    $dernierCnx = ''; 
                    $navigateur = ''; 
                    $historiqueDeCours = ''; 
                    $dernierActivite = ''; 
                    $dernierPlateforme = ''; 
                    $unixTimeCnx = ''; 
                    $statusProfilEL = false; 
                    $plateforme = ''; 
                    $cnxStatus; 
                    $idCnx = ''; 
                    $dureeConnexion = ''; 
                    $actionNormalDeconnexion = '';
                    $actionLastDeconnexion = '';
                    $labeStatusCnx = '';
                    $classSatusCnx = '';
                    $nbTracking = '';
                    $attribClassTimeCnx = '';
                    $attribIdTimeCnx = '';
                    $dureeDeCours = '';
                    $dureeLimitDuCours = '';
                    $derniereClick = '';
                    $statusProfilEL = false;

                    $DateHeureSaisie   = $value->dateHeureSaisieCoursPlannifier;
                    $DateHeureDebut    = $value->dateHeureCoursPlannifier;
                    $DureeCours        = $value->dureeCoursPlannifier;
                    $typeDureeCours    = $value->typeDureeCoursPlannifier;
                    $IdStage           = $value->idStageCoursPlannifier;
                    $loginProf         = $value->loginProfCOursPlannifier;
                    $refIndividuProf   = $value->refIndividuProfCoursPlannifier;
                    $nomProf           = $value->nomProfCoursPlannifier;
                    $prenomProf        = $value->prenomProfCoursPlannifier;
                    $idStagiaireEl     = $this->Stag_individu_model->getMaxIdMembresByStage($IdStage);
                    //$idStagiaireEl     = $this->Stag_individu_model->Request('id_stagiare_el',$IdStage);
                    $crenneauHoraire   = explode(" ", $value->dateHeureCoursPlannifier);
                    $dureeCours        = $value->dureeCoursPlannifier;            

                    if ($typeDureeCours == 2 && $DureeCours == 30) {
                        $dureeDeCours .= '30 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +30 minutes')). ' +60 minutes');
                    }
                    elseif ($typeDureeCours == 2 && $DureeCours == null) {
                        $dureeDeCours .= '30 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +30 minutes')). ' +60 minutes');
                    }
                    elseif($typeDureeCours == 1 && $DureeCours == 3){
                        $dureeDeCours .= '180 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +180 minutes')). ' +60 minutes');
                    }
                    elseif($typeDureeCours == 1 && $DureeCours == 0.5){
                        $dureeDeCours .= '30 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +30 minutes')). ' +60 minutes');
                    }
                    elseif($typeDureeCours == 1 && $DureeCours == 1.5){
                        $dureeDeCours .= '90 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +90 minutes')). ' +60 minutes');
                    }
                    elseif($typeDureeCours == 1 && $DureeCours == 30){
                        $dureeDeCours .= '30 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +30 minutes')). ' +60 minutes');
                    }
                    elseif($typeDureeCours == 1 && $DureeCours == 0){
                        $dureeDeCours .= '0 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +0 minutes')). ' +60 minutes');
                    }
                    elseif($typeDureeCours == 1 && $DureeCours == 1){
                        $dureeDeCours .= '60 Min';
                        $dureeLimitDuCours .= strtotime(date('Y-m-d H:i:s', strtotime($value->dateHeureCoursPlannifier. ' +60 minutes')). ' +60 minutes');
                    }

                    if (!empty($idStagiaireEl)) {

                        /*$dateDebutCoursUnixTime = strtotime($DateHeureDebut.' + 2 hours');
                        $dateFinCoursUnixTime   = strtotime($DateHeureDebut.' + '. str_replace('Min', 'minute', $dureeDeCours.' + 2 hours'));*/
                        $dateDebutCoursUnixTime = strtotime($DateHeureDebut. ' +60 minutes');
                        $dateFinCoursUnixTime   = strtotime(strtotime($DateHeureDebut.' + '. str_replace('Min', 'minute', $dureeDeCours)). ' +60 minutes');
                        $nbTracking .= $this->tracking_model->getCountByDureeCours($dateDebutCoursUnixTime,$dateFinCoursUnixTime);
                        $statusProfilEL = true;
                        $dataEndCnx          = $this->connexion_model->getMaxDataEndConnexionByUser($idStagiaireEl);
                        if (isset($dataEndCnx['count']) && $dataEndCnx['count'] >= 1) {
                            if ($dataEndCnx['dateDebutCnx'] == date('Y-m-d')) {
                                $dernierCnx .= 'Aujourd\'hui';
                            }
                            else{
                                $dernierCnx .= $dataEndCnx['dateDebutCnx'];
                            }
                            $dernierPlateforme .= ($dataEndCnx['app_active'] == 'EL') ? 'V3' : 'V1'; 
                          
                        }


                        $allResultCnx       = $this->connexion_model->getAllCnxRestante($idStagiaireEl);
                        if (isset($allResultCnx) && $allResultCnx['count'] >= 1) {
                            $IdDernierCnx        .= $allResultCnx['id_connexion'];
                            $dateDernierCnx      .= $allResultCnx['date_connexion'];
                        }

                        $derniereClick .= $this->tracking_model->getLastClickForUser($idStagiaireEl);
                        $dataCnxNow             = $this->connexion_model->getMaxDataEndConnexionNowByUser($idStagiaireEl);

                        if (isset($dataCnxNow['count']) && $dataCnxNow['count'] >= 1) {
                            $debutConnexionEl  .= $dataCnxNow['debutCnx'];
                            $dureeConnexion    .= $dataCnxNow['dureeCnx'];
                            $dernierActivite   .= $this->tracking_model->returnMAxLastActivityByCnx($dataCnxNow['idCnx']);

                            $referenceCnxNow      .= $this->connexion_model->RequestByIdCnx('id_connexion',$dataCnxNow['idCnx']);

                            if (isset($referenceCnxNow) && $referenceCnxNow  == '' && $dataCnxNow['finCnx'] != '') {
                                $finConnexionEl  .= $this->convert_utf8($dataCnxNow['finCnx']);
                            }
                            else{
                                $finConnexionEl  .= '';
                            }

                            $idCnx             .= $dataCnxNow['idCnx'];
                            $navigateur        .= $dataCnxNow['navigateur'];
                            $plateforme        .= $dataCnxNow['platform'];
                            $unixTimeCnx       .= $dataCnxNow['unixTimeCnx'];
                        }
                        else{
                            //$statusProfilEL = false;
                        }


                        if(isset($referenceCnxNow) && $referenceCnxNow != ''){ 
                            $actionNormalDeconnexion .= '<a href="#" onclick="disconnect(this)" data-cnx="'.$referenceCnxNow.'" class="btn-deconnect-user-profil" title="Se déconnecter"><i class="fa fa-sign-out"></i></a>';
                            $counterIsConnect = true;
                        }

                        if(isset($IdDernierCnx) && $IdDernierCnx != '' && isset($referenceCnxNow) && $referenceCnxNow != $IdDernierCnx){ 
                            $actionLastDeconnexion .= '<a href="#" onclick="disconnect(this)" data-cnx="'.$IdDernierCnx.'" class="btn-deconnect-user-profil" title="Se déconnecter du '.date('Y-m-d H:i:s',$dateDernierCnx).'"><i class="fa fa-sign-out"></i></a>';
                        }

                        if((isset($referenceCnxNow) && $referenceCnxNow != '') || (isset($IdDernierCnx) && $IdDernierCnx != '')){ 
                            $classSatusCnx .= 'connecter';                  
                            if ($IdDernierCnx !== $referenceCnxNow) {
                                //$labeStatusCnx .= 'Encore connecté depuis '.date('Y-m-d H:i:s',$dateDernierCnx);
                                $labeStatusCnx .= 'Problème de déconnexion';
                            }
                            else{
                                $labeStatusCnx .= 'En ligne';
                            }
                        }
                        else{
                            $labeStatusCnx .= 'Deconnecté';
                            $classSatusCnx .= 'deconnecter';
                        } 

                        $HtmlReturn .= '<tr class="line-connexion-detail" onclick="showDetailCnx(this);" data-class-info-cnx="'.$classSatusCnx .'" data-trainee-name = "'.$this->convert_utf8($this->membres_model->Request('prenom',$idStagiaireEl).' '.$this->membres_model->Request('nom',$idStagiaireEl)).'" data-trainee-id='.$idStagiaireEl.'>';
                            $HtmlReturn .= '<td>'.$this->convert_utf8($crenneauHoraire[1]).'</td>';
                            $HtmlReturn .= '<td class="duree-cours">'.$this->convert_utf8($dureeDeCours).'</td>';
                            $HtmlReturn .= '<td class="nb-tracking">'.$this->convert_utf8($nbTracking).'</td>';

                            if (isset($dernierCnx) && $dernierCnx != '') {
                                $HtmlReturn .= '<td class="last-connex-el">'.$this->convert_utf8($dernierCnx).'</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="last-connex-el"></td>';
                            }

                            if (isset($derniereClick) && $derniereClick != '') {
                                /*if (date('Y-m-d',$derniereClick) == date('Y-m-d')) {
                                    $HtmlReturn .= '<td class="endClick">'.date('H:i:s',$derniereClick).'</td>';
                                }
                                else{
                                    $HtmlReturn .= '<td class="endClick">'.date('Y-m-d H:i:s',$derniereClick).'</td>';
                                }*/
                                $HtmlReturn .= '<td class="endClick">'.date('H:i:s',$derniereClick).'</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="endClick"></td>';
                            }

                            if (isset($labeStatusCnx) && $statusProfilEL) {
                                $HtmlReturn .= '<td class="status-connexion"><span class="'.$classSatusCnx.'">'.$labeStatusCnx.'</span></td>';
                            }
                            elseif (!$statusProfilEL && $dernierCnx != '') {
                                $HtmlReturn .= '<td class="status-connexion"><span class="deconnecter">Deconnecté</span></td>';
                            }
                            else{
                               $HtmlReturn .= '<td class="status-connexion"><span class="deconnecter">Jamais connecté</span></td>'; 
                            }


                            if (isset($debutConnexionEl) && $debutConnexionEl != '') {
                                $HtmlReturn .= '<td class="startConnexion">'.$this->convert_utf8($debutConnexionEl).'</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="startConnexion"></td>';
                            }
                            
                            if (isset($finConnexionEl) && $finConnexionEl != '') {
                                $HtmlReturn .= '<td class="end-connexion">'.$this->convert_utf8($finConnexionEl).'</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="end-connexion"></td>';
                            }

                            $HtmlReturn .= '<td class="trainee-name">'.$this->convert_utf8($this->membres_model->Request('prenom',$idStagiaireEl).' '.$this->membres_model->Request('nom',$idStagiaireEl)).'</td>';
                            

                            /*if (isset($statusProfilEL) && $statusProfilEL) {
                                $HtmlReturn .= '<td class="creationProfilEl"><span class="connecter">Créer</span></td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="creationProfilEl"><span class="deconnecter">Non créer</span></td>';
                            }*/

                            $HtmlReturn .= '<td class="trainerTrainee">'.$this->convert_utf8($prenomProf.' '.$nomProf).'</td>';
                            $HtmlReturn .= '<td class="stageId">'.$this->convert_utf8($IdStage).'</td>';                            

                            $dateTimeCnxIs = '';
                            $attribClassTimeCnxIs = '';
                            $attribIdTimeCnxIs = '';
                            $dureeConnexionIs = '';
                            if (isset($attribClassTimeCnx)) {
                                $attribClassTimeCnxIs .= $attribClassTimeCnx;
                            }

                            if (isset($attribIdTimeCnx)) {
                                $attribIdTimeCnxIs .= $attribIdTimeCnx;
                            }

                            if (isset($unixTimeCnx) && isset($counterIsConnect) && $counterIsConnect == true) {
                                $dateTimeCnxIs .= strtotime('-2 hours', $unixTimeCnx);
                            }

                            if (isset($dureeConnexion)) {
                                $dureeConnexionIs .= $dureeConnexion;
                            }


                            $HtmlReturn .= '<td class="time-cnx '.$attribClassTimeCnxIs.'" id="'.$attribIdTimeCnxIs.'"  data-time-cnx="'.$dateTimeCnxIs.'">'.$this->convert_utf8($dureeConnexionIs).'</td>';

                            $dateCoursPlannifier = explode('-', $crenneauHoraire[0]);
                            $dateCoursPlannifierModif = $dateCoursPlannifier[2].'/'.$dateCoursPlannifier[1].'/'.$dateCoursPlannifier[0];
                            $trainerResult = $this->CoursPlannifier_model->getTrainerByStage($IdStage,$nomProf,$prenomProf);
                            $historiqueDeCours = count($trainerResult) >= 1 ? $this->CoursHistorik_model->getByGroupAndDateAndTuteur($this->membres_model->Request('id_groupe',$idStagiaireEl),$dateCoursPlannifierModif,$trainerResult[0]->id) : 0;

                            if (count($historiqueDeCours) >= 1) {
                                $HtmlReturn .= isset($historiqueDeCours[0]->intitule)  ? '<td class="course-history">'.$this->convert_utf8($historiqueDeCours[0]->intitule).'</td>' : '<td class="course-history">Aucun</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="course-history">Aucun</td>';
                            }

                            

                            if (isset($dernierActivite) && $dernierActivite != '') {
                                $HtmlReturn .= '<td class="endActivity">'.$this->convert_utf8($dernierActivite).'</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="endActivity"></td>';
                            }

                            $HtmlReturn .= '<td class="navigatorTrainee">'.$this->convert_utf8($navigateur).'</td>';
                            $HtmlReturn .= '<td class="platformTrainee">'.$this->convert_utf8($plateforme).'</td>';
                            $HtmlReturn .= '<td class="platformTraineeEl">'.$this->convert_utf8($dernierPlateforme).'</td>';

                            if (isset($actionNormalDeconnexion) && isset($actionLastDeconnexion)) {
                                $HtmlReturn .= '<td class="case-btn-action">'.$actionNormalDeconnexion.' '.$actionLastDeconnexion.'</td>';
                            }
                            else{
                                $HtmlReturn .= '<td class="case-btn-action"></td>';
                            }

                            
                        $HtmlReturn .= '</tr>';
                    }
                    $cp ++;
                }
            }
        }
        $retour = array(
            'Responses'     => 'OK', 
            'countResult'   => count($allResults), 
            'HtmlReturn'    => $HtmlReturn, 
        );
        echo json_encode($retour);
    }

    public function getInfosCnx(){
        $returns = array();
        $traikingInfosData = array();
        $i = 0;
        if (isset($_POST['traineeId'])) {
            $resultsCnx = $this->connexion_model->getAllCnxByUsers($_POST['traineeId']);
            foreach ($resultsCnx as $cnxInfos) {                
                $t = 0;
                $resultsTracking = $this->tracking_model->getAllActivityByCnx($cnxInfos->idCnx);               
                foreach($resultsTracking as $trackingInfos){
                    $infosTrackingData = $this->getAllInfosByTracking($trackingInfos->module_id,$trackingInfos->sequence_id,$trackingInfos->chapitre_id,$trackingInfos->type);
                    $traikingInfosData[$t] = array(
                        'id'            => $trackingInfos->id_tracking,
                        'dateTracking'  => date('d-m-Y',$trackingInfos->date),
                        'debutTracking' => date('H:i:s', $trackingInfos->date),
                        'dureeTracking' => gmdate('H:i:s', $trackingInfos->time),
                        'Menu'          => $infosTrackingData['Menu'],
                        'SousMenu'      => $infosTrackingData['SousMenu'],
                        'Sequence'      => $infosTrackingData['Sequence'],
                        'Exercice'      => $infosTrackingData['Exercice'],
                        'idCnx'         => $trackingInfos->id_cnx
                    );
                    $t++;
                }
                $returns[$i]['connexionInfos'] = array(
                    'dateCnx'       => $cnxInfos->dateDebutCnx,
                    'debutCnx'      => $cnxInfos->debutCnx,
                    'dureeCnx'      => $cnxInfos->dureeCnx,
                    'idCnx'         => $cnxInfos->idCnx,
                    'Navigateur'    => $cnxInfos->navigateur,
                    'Plateforme'    => $cnxInfos->platform,
                    'nbActivite'    => count($resultsTracking),
                    'trackingInfos' => $traikingInfosData
                );
                $i++;

            }
        }
        
        echo json_encode($returns);
    }
}

?>